Print ''                
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' View          : [PLMPerfSummaryView]'
Print ' Creation Date : 27.02.2020'
Print ' Autor         : S.Gth'
Print '-------------------------------------------------------------------------'

use [#DB_N#]
GO

Create View PLMPerfSummaryView as
(SELECT mess.groupAction as ACTION,
perf.DateTimeStamp as TIMESTAMPSTART,
NULL as TIMESTAMPEND,
mess.GroupWorldregion as WORLDREGION,
mess.GroupCountry as COUNTRY,
mess.GroupSite as SITE,
mess.GroupDepartement as DEPARTEMENT,
CONVERT(DECIMAL,perf.LoadUpdCpuReal) as DURATIONSEC,
'' as WHERECONDITION
  FROM tblPerfMess perf inner join tblMesslinien mess on perf.MesslinieID = mess.MesslinieID
  WHERE mess.Visible = 1)
UNION ALL
(  SELECT 'Ping' as ACTION,
Min(ping.DateTimeStamp) as TIMESTAMPSTART,
Max(ping.DateTimeStamp) as TIMESTAMPEND,
mess.GroupWorldregion as WORLDREGION,
mess.GroupCountry as COUNTRY,
mess.GroupSite as SITE,
mess.GroupDepartement as DEPARTEMENT,
CONVERT(DECIMAL,Avg(ping.PingAvg))/1000 as DURATIONSEC,
'' as WHERECONDITION
  FROM tblPingMess ping inner join tblMesslinien mess on ping.MesslinieID = mess.MesslinieID
  WHERE mess.Visible = 1
  Group By ping.DateStamp, mess.GroupWorldregion, mess.GroupCountry, mess.GroupSite, mess.GroupDepartement)

GO
