Print ''                
Print '-------------------------------------------------------------------------'
Print ' using Database: PLMPerfAnalyse_tcpord'
Print ' Table         : [tblPingMessGroupedByDay]'
Print ' Creation Date : 18.10.2019'
Print ' Autor         : S.G?th'
Print '-------------------------------------------------------------------------'

use [PLMPerfAnalyse_tcpord]

Declare @MyActionMsg1 nvarchar (max)
Declare @MyTableName nvarchar (max)
set @MyTableName='tblPingMessGroupedByDay'
DECLARE @ExecuteSQLstr nvarchar(max)

declare @indexNrCur  int
declare @indexNrEnd  int
declare @indexNrStr       varchar(32)
declare @IndexName        varchar(max)
declare @ProcStateColName varchar(max)
set @indexNrEnd = 10


--------------------------------------------------------------------------------
-- verzweigen auf TableCreate: oder TableUpdate:
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tblPingMessGroupedByDay]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
  BEGIN
   goto TableUpdate
  END
ELSE
  BEGIN
   goto TableCreate
  END

--------------------------------------------------------------------------------
TableCreate:
  set @MyActionMsg1=
      '-- Table: [tblPingMessGroupedByDay] dose not exist and will be created new'

  Print (@MyActionMsg1)


  CREATE TABLE tblPingMessGroupedByDay
  (
          [MessAnzahl]        int ,
		  [TimeStampGroup]    nvarchar(10),
          [DateTimeStamp]     datetime2 NOT NULL,
          [MesslinieID]       int NOT NULL,
          [PingAvg_Min]       int NOT NULL,
          [PingAvg_Max]       int NOT NULL,
          [PingAvg_Avg]       int NOT NULL
  )

  INSERT INTO tblPingMessGroupedByDay (MessAnzahl, TimeStampGroup, DateTimeStamp, MesslinieID,PingAvg_Min,PingAvg_Max,PingAvg_Avg)
  SELECT 
	Count(PingMessID) AS MessAnzahl, 
	DateStamp AS TimeStampGroup, 
	Min(DateTimeStamp) AS DateTimeStamp, 
	MesslinieID, 
	ROUND(MIN(PingAvg),3) AS PingAvg_Min, 
	ROUND(MAX(PingAvg),3) AS PingAvg_Max, 
	ROUND(AVG(PingAvg),3) AS PingAvg_Avg
  FROM tblPingMess
  GROUP BY 
	DateStamp, 
	MesslinieID 
  ORDER BY 
	DateTimeStamp


GO
CREATE TRIGGER PingMessDaily_Insert
ON tblPingMess
AFTER INSERT
AS
BEGIN

 if EXISTS (SELECT 1 FROM tblPingMessGroupedByDay Where tblPingMessGroupedByDay.TimeStampGroup = (SELECT TOP 1  inserted.DateStamp FROM inserted) and tblPingMessGroupedByDay.MesslinieID = (SELECT TOP 1  inserted.MesslinieID FROM inserted))
   BEGIN    
		UPDATE tblPingMessGroupedByDay
		SET MessAnzahl = MessAnzahl + 1
		   ,PingAvg_Min = CASE WHEN PingAvg_Min > (SELECT TOP 1  inserted.PingAvg FROM inserted) THEN (SELECT TOP 1  inserted.PingAvg FROM inserted) ELSE PingAvg_Min END
		   ,PingAvg_Max = CASE WHEN PingAvg_Max < (SELECT TOP 1  inserted.PingAvg FROM inserted) THEN (SELECT TOP 1  inserted.PingAvg FROM inserted) ELSE PingAvg_Max END
		   ,PingAvg_Avg = ROUND((PingAvg_Avg + (SELECT TOP 1  inserted.PingAvg FROM inserted)) / 2, 3)
		WHERE 
		  tblPingMessGroupedByDay.TimeStampGroup = (SELECT TOP 1  inserted.DateStamp FROM inserted) AND 
		  tblPingMessGroupedByDay.MesslinieID = (SELECT TOP 1  inserted.MesslinieID FROM inserted)
   END
ELSE
  BEGIN
    INSERT INTO tblPingMessGroupedByDay
           ([MessAnzahl]
           ,[TimeStampGroup]
           ,[DateTimeStamp]
           ,[MesslinieID]
           ,[PingAvg_Min]
           ,[PingAvg_Max]
           ,[PingAvg_Avg])
     VALUES
           (1
           ,(SELECT TOP 1  inserted.DateStamp FROM inserted)
           ,(SELECT TOP 1  inserted.DateTimeStamp FROM inserted)
           ,(SELECT TOP 1  inserted.MesslinieID FROM inserted)
           ,(SELECT TOP 1  inserted.PingAvg FROM inserted)
           ,(SELECT TOP 1  inserted.PingAvg FROM inserted)
           ,(SELECT TOP 1  inserted.PingAvg FROM inserted))
  END
END


GO
CREATE TRIGGER PingMessDaily_Delete
ON tblPingMess
AFTER DELETE
AS
BEGIN

 if EXISTS (SELECT 1 FROM tblPingMessGroupedByDay Where tblPingMessGroupedByDay.TimeStampGroup = (SELECT TOP 1  deleted.DateStamp FROM deleted) and tblPingMessGroupedByDay.MesslinieID = (SELECT TOP 1  deleted.MesslinieID FROM deleted) and tblPingMessGroupedByDay.MessAnzahl > 1)
   BEGIN    
		UPDATE tblPingMessGroupedByDay
		SET MessAnzahl = MessAnzahl - 1
		   ,PingAvg_Avg = ROUND(PingAvg_Avg * 2 - (SELECT TOP 1  deleted.PingAvg FROM deleted), 3)
		WHERE 
		  tblPingMessGroupedByDay.TimeStampGroup = (SELECT TOP 1  deleted.DateStamp FROM deleted) AND 
		  tblPingMessGroupedByDay.MesslinieID = (SELECT TOP 1  deleted.MesslinieID FROM deleted)
   END
ELSE
  BEGIN
    DELETE FROM 
	  tblPingMessGroupedByDay
    WHERE  
	  tblPingMessGroupedByDay.TimeStampGroup = (SELECT TOP 1  deleted.DateStamp FROM deleted) 
	  and tblPingMessGroupedByDay.MesslinieID = (SELECT TOP 1  deleted.MesslinieID FROM deleted)
  END
END

  goto CheckCreateIndex

--------------------------------------------------------------------------------
TableUpdate:

  set @MyActionMsg1=
       '-- Table: [' + @MyTableName + '] exist and will be updated'
  Print (@MyActionMsg1)

  Declare @ColumeName nvarchar (256)
  Declare @ColumeNameOld nvarchar (256)
  Declare @ColumeNameNew nvarchar (256)
  Declare @ExecuteStr nvarchar (max)


  --set @ColumeName='DateStamp'
  --if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  --  begin
  --    print ('Create Column:' + @ColumeName +  ' DateStamp (new 10.10.2019 S.Gueth)')
  --    set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(10) COLLATE Latin1_General_CS_AS NULL'
  --    execute (@ExecuteStr)
	 -- set @ExecuteStr='Update [dbo].[' + @MyTableName + '] set [DateStamp] = CAST(DATEPART(yyyy, [DateTimeStamp]) as nvarchar) + ''-'' + CAST(DATEPART(mm, [DateTimeStamp]) as nvarchar)+ ''-'' +CAST(DATEPART(dd, [DateTimeStamp]) as nvarchar)'
  --    execute (@ExecuteStr)
  --  end




goto CheckCreateIndex

--------------------------------------------------------------------------------
CheckCreateIndex:

  EXECUTE JF_IndexCheckCreateDef   'tblPingMessGroupedByDay_IDX_TimeStampGroup',               @MyTableName, 'TimeStampGroup'
  EXECUTE JF_IndexCheckCreateDef   'tblPingMessGroupedByDay_IDX_MesslinieID',				   @MyTableName, 'MesslinieID' 
  EXECUTE JF_IndexCheckCreateDef   'tblPingMessGroupedByDay_IDX_DateTimeStamp',				   @MyTableName, 'DateTimeStamp' 
  EXECUTE JF_IndexCheckCreateDef   'tblPingMessGroupedByDay_IDX_TimeStampGroup_MesslinieID',   @MyTableName, 'TimeStampGroup, MesslinieID'
  
--------------------------------------------------------------------------------
EndeExit:
 Print ('   |-> Done on Database: PLMPerfAnalyse_tcpord')
 Print '------------------------------------------------------------------------'

GO
