Print ''                
Print '-------------------------------------------------------------------------'
Print ' using Database: PLMPerfAnalyse'
Print ' Table         : [tblImportTypes]'
Print ' Creation Date : 13.11.2012'
Print ' Autor         : S.G?th'
Print '-------------------------------------------------------------------------'

use [PLMPerfAnalyse]

Declare @MyActionMsg1 nvarchar (max)
Declare @MyTableName nvarchar (max)
set @MyTableName='tblImportTypes'
DECLARE @ExecuteSQLstr nvarchar(max)

declare @indexNrCur  int
declare @indexNrEnd  int
declare @indexNrStr       varchar(32)
declare @IndexName        varchar(max)
declare @ProcStateColName varchar(max)
set @indexNrEnd = 10


--------------------------------------------------------------------------------
-- verzweigen auf TableCreate: oder TableUpdate:
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tblImportTypes]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
  BEGIN
   goto TableUpdate
  END
ELSE
  BEGIN
   goto TableCreate
  END

--------------------------------------------------------------------------------
TableCreate:
  set @MyActionMsg1=
      '-- Table: [tblImportTypes] dose not exist and will be created new'

  Print (@MyActionMsg1)


  CREATE TABLE tblImportTypes
  (
        [ImportTypeID]      int NOT NULL,
        [ImportType]        nvarchar(50) NOT NULL,
        CONSTRAINT tblImportTypes_PK PRIMARY KEY ([ImportTypeID])
  )
  ON [PRIMARY]

  INSERT INTO dbo.tblImportTypes (ImportTypeID, ImportType) VALUES (0, 'deaktiviert')
  INSERT INTO dbo.tblImportTypes (ImportTypeID, ImportType) VALUES (1, 'PerformanceLog')
  INSERT INTO dbo.tblImportTypes (ImportTypeID, ImportType) VALUES (2, 'PerformanceLog mit UserCount')
  INSERT INTO dbo.tblImportTypes (ImportTypeID, ImportType) VALUES (3, 'PING-Statistik')
  INSERT INTO dbo.tblImportTypes (ImportTypeID, ImportType) VALUES (4, 'SysLogs')
  INSERT INTO dbo.tblImportTypes (ImportTypeID, ImportType) VALUES (6, 'Startzeiten')                    -- input Startzeiten (#New: 20.03.2013 S.Gueth)
  INSERT INTO dbo.tblImportTypes (ImportTypeID, ImportType) VALUES (7, 'Workflow')  

  goto CheckCreateIndex

--------------------------------------------------------------------------------
TableUpdate:

  set @MyActionMsg1=
       '-- Table: [' + @MyTableName + '] exist and will be updated'
  Print (@MyActionMsg1)

  Declare @ColumeName nvarchar (256)
  Declare @ColumeNameOld nvarchar (256)
  Declare @ColumeNameNew nvarchar (256)
  Declare @ExecuteStr nvarchar (max)


 --- input Startzeiten
  if (Select [ImportTypeID] From [dbo].[tblImportTypes] Where [ImportTypeID] = 6) is null
    begin
      print ('input Startzeiten (#New: 20.03.2013 S.Gueth)')
      set @ExecuteStr='INSERT INTO dbo.tblImportTypes (ImportTypeID, ImportType) VALUES (6, ''Startzeiten'')'
      execute (@ExecuteStr)
    end

 --- input Workflow
  if (Select [ImportTypeID] From [dbo].[tblImportTypes] Where [ImportTypeID] = 7) is null
    begin
      print ('input Workflow (#New: 19.01.2018 S.Gueth)')
      set @ExecuteStr='INSERT INTO dbo.tblImportTypes (ImportTypeID, ImportType) VALUES (7, ''Workflow'')'
      execute (@ExecuteStr)
    end



goto CheckCreateIndex

--------------------------------------------------------------------------------
CheckCreateIndex:

  EXECUTE JF_PrimKeyCheckCreateDef 'tblImportTypes_pk',           @MyTableName, 'ImportTypeID' 

--------------------------------------------------------------------------------
EndeExit:
 Print ('   |-> Done on Database: PLMPerfAnalyse')
 Print '------------------------------------------------------------------------'

GO
