 REM -- #Doc: Inits all Basics of Job
 REM -- #New: 14.11.2024/J.Fes           first version

 REM -- #Doc: all Parameter P1..P5 must be set
 REM    P1 JobTitel                   sets JobTitel for cmd window
 REM    P2 DoUpdate BinL              YES/NO
 REM    P3 DoUpdate BinL inc. Oracle  YES/NO
 REM    P4 Start WatchDog             YES/NO
 REM    P5 Start TaskMgr              YES/NO
 REM    P6 Start SysInt procexp64.exe YES/NO
 REM    #Doc: Do not set for P5=YES + P6=YES at the same time because then TaskMgr and procexp64.exe is excuting at the same time
 REM -- Usage: Call "%~dp0_JobInitial.cmd" "#Titel#" "YES" "YES" "YES" "NO" "YES"

 REM -- set root path ---------------------------------------------------------
REM  CHCP 65001

 rem #New:06.09.2024 contains latest Version info
 set JobMgrDefaultScriptsVer=2025-11-05-01
 set JobMgr_EchoLog_DPNE=
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 Call Echo2 "****"
 Call Echo2 "*" "Excuting %~nx0 #LUp:05.11.2025"
 Call Echo2 "****"

 REM -- #Step: set color Init
 call "%CmdCurRoot_DP%\ColorSet" "Init"

 if "%~5" equ "" (
   call %~dp0ColorSet ERR
   Call %~dp0Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
   Call %~dp0Echo "Missing required Para5 in.......: '%~0'"
   Call %~dp0Echo "please check....................: calling script"
   Call %~dp0Echo "END.............................: script stops Job via EXIT"
   Pause
   Exit
 )

 set robocopy_opt=/R:5 /W:1
 set JobTitleB=%~1
 set JobMgr_JobInitial_DoUpdBinL=%~2
 set JobMgr_JobInitial_DoUpdORABinL=%~3
 set JobMgr_start_PLMJobManagerWatchDog=%~4
 set JobMgr_start_TaskMgr=%~5
 set JobMgr_start_ProcExp=%~6

 REM -- temp dir Organisieren -------------------------------------------------
 set tempOrig_DP=%temp%
 set temp=%CmdCurRoot_DP%
 set tmp=%temp%

 REM -- JobServer Variablen ----------------------------------------------------
 set BinPublic_DP=%PPA_Root_DP%\03-BinPublic
 set BinPublic_ClientServer_DP=%JobClient_ServerProvidedResources_DP%\03-BinPublic.ClientServer
 set BinL_DP=%JobClient_ServerProvidedResources_DP%\BinL_DP

 set JobMgr_JobCreationDT=#DateTimeNow_DDMMYYYYHMS#
 set JobMgr_JobCreationDT_ForFileExtend1=#DateTimeNow_ForFileExtend#
 set JobMgr_JobCreationDT_ForFileExtend2=#DateTimeNow_yyyy-MM-dd-HH-mm#
 set JobMgr_JobCreationDT_ForFileExtend3=#DateTimeNow_yyyyMMdd-HHmmss#
 set $DateTimeNowFileExt=#DateTimeNow_yyyy-MM-dd-HH-mm#

 REM -- JobData ----------------------------------------------------------------
 set JobName=#JobName#
 set JobRuleName=#JobRule.JobName#

 rem -- Defaults TC Prompt Data root
 if exist "%CmdCurRoot_DP%\TcPrompt_Custom.cmd" set TcPrompt_Custom_DPNE=%CmdCurRoot_DP%\TcPrompt_Custom.cmd
 if exist "%CmdCurRoot_DP%\NxPrompt_Custom.cmd" set NxPrompt_Custom_DPNE=%CmdCurRoot_DP%\NxPrompt_Custom.cmd

 REM -- uebergabe SiteDef ------------------------------------------------------
 set TcSiteId=#TcSiteId#

 REM -- default Debug and Test
 set JobMgr_Debug=OFF
 set JobMgr_Test=OFF

 REM --------## add JC.script(cmd).ParmaExt Start ##----------------------------
#JobScriptParametersExtended#

if not defined ObjectItemId set ObjectItemId=BgStruk01-AGG-Mod-01
if not defined ObjectRevId set ObjectRevId=A
if not defined PLMPerf_cmdScript_NE                 set PLMPerf_cmdScript_NE=PLMPerf_Generic6_ExecutePLMxmlExport.cmd
if not defined PLMPerf_PLMXmlExpo_Para_transfermode set PLMPerf_PLMXmlExpo_Para_transfermode=ConfiguredDataFilesExportDefault
if not defined PLMPerf_PLMXmlExpo_Para_Export_BOM   set PLMPerf_PLMXmlExpo_Para_Export_BOM=no
if not defined JobMgr_fccCacheClear_DO              set JobMgr_fccCacheClear_DO=true

 REM --------## add JC.script(cmd).ParmaExt End ##------------------------------

 set RunLoggedL_DPNE=%BinPublic_ClientServer_DP%\RunLogged.exe
 set JFProcessMonitorL_DPNE=%BinPublic_ClientServer_DP%\JFProcessMonitor.exe
 set PLMJobManagerWatchDogL_DPNE=%BinPublic_ClientServer_DP%\PLMJobManagerWatchDog.exe
 set BannerL_DPNE=%BinPublic_ClientServer_DP%\Banner.exe
 set JobMgrCMDHelper_L=%BinPublic_ClientServer_DP%\JobMgrCMDHelper.exe
 set JobManagerCmdTools_L=%BinPublic_ClientServer_DP%\JobManagerCmdTools.exe

 rem -- #Doc: get if exist JobMgr_TcPwFile_DPNE
if "%JobMgr_TcPwFile_NE%" equ "" goto :Next
 if exist "%CmdCurRoot_DP%\%JobMgr_TcPwFile_NE%" set JobMgr_TcPwFile_DPNE=%CmdCurRoot_DP%\%JobMgr_TcPwFile_NE%
 Call Echo "#Debug JobMgr_TcPwFile..........: %JobMgr_TcPwFile_DPNE%"
 Call Echo "#Debug JobMgr_TcPwFile_DPNE.....: %JobMgr_TcPwFile_DPNE%"
 goto :Next
:Next

 REM -- PathVariable erweitern
 Call "%CmdCurRoot_DP%\PathEnvAddPath.cmd" "%BinPublic_DP%"
 Call "%CmdCurRoot_DP%\PathEnvAddPath.cmd" "%BinPublic_ClientServer_DP%"
 Call "%CmdCurRoot_DP%\PathEnvAddPath.cmd" "%CmdCurRoot_DP%"
 Call "%CmdCurRoot_DP%\PathEnvAddPath.cmd" "%BinL_DP%"

 if /i "%JobMgr_Test%" neq "ON" goto :JumbOverTest
  set JobTitleB=%JobTitleB%[Test:%JobMgr_Test%]
  call Echo2 "---- " " ----"
  Call Banner Test:%JobMgr_Test%
  call Echo2 "---- " " ----"
:JumbOverTest

 REM -- set JobTitle -----------------------------------------------------------
 set JobTitleB=%JobTitleB%[%JobName%]
 set JobTitle=%JobTitleB%[%Date% %time:~0,5%][\\%ComputerName%]
 title %JobTitle%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
  call Echo2 "---- " " ----"
  Banner Debug:%JobMgr_Debug%
  call Echo2 "---- " " ----"
  set >>"%CmdCurRoot_DP%\zz#DebugEnv_PLMPerfJobInitial.txt"
  Call Echo2 "#PLPerf_JobInitial"                      "Basics"
  Call Echo2 "#D:JobClient_ServerProvidedResources_DP" "%JobClient_ServerProvidedResources_DP%"
  Call Echo2 "#D:BinL_DP"                              "%BinL_DP%"
  Call Echo2 "#D:BinPublic_ClientServer_DP"            "%BinPublic_ClientServer_DP%"
  Call Echo2 "#D:JobManagerCmdTools_L"                 "%JobManagerCmdTools_L%"
  call Echo2 "---- " " ----"
  Call Echo2 "#PLPerf_JobInitial" "List of parameters"
  Call Echo2 "#P1 JobTitleB"                           "%JobTitleB%"
  Call Echo2 "#P2 Do update BinL"                      "%JobMgr_JobInitial_DoUpdBinL%"
  Call Echo2 "#P3 Do update ORA BinL"                  "%JobMgr_JobInitial_DoUpdORABinL%"
  Call Echo2 "#P4 Start WatchDog"                      "%JobMgr_start_PLMJobManagerWatchDog%"
  Call Echo2 "#P5 JobMgr_start_TaskMgr"                "%JobMgr_start_TaskMgr%"
  Call Echo2 "#A1 Start Explorer"                      "%CmdCurRoot_DP%"
  call Echo2 "---- " " ----"
  pause
:JumbOver

 call Echo2 "----" "----"
 Call Echo2 "Job Initial for" "%JobTitle%"
 Call Echo2 "Job BinL_DP"     "%BinL_DP%"
 Call Echo2 "Job settings"    "[BinL:%JobMgr_JobInitial_DoUpdBinL%][Ora:%JobMgr_JobInitial_DoUpdORABinL%][Debug:%JobMgr_Debug%][Test:%JobMgr_Test%]"

 if /I "%JobMgr_JobInitial_DoUpdBinL%" neq "YES" goto :JobMgr_JobInitial_DoUpdBinL_NO



 REM -- #NEW:08.02.2017/J.Fes Check if Update ORA Client ---------
if /I "%JobMgr_JobInitial_DoUpdORABinL%" neq "YES" goto :JobMgr_JobInitial_DoUpdORABinL_NO
 rem  -- OraClient  to:[%BinL_DP%\OraClient] ----
 set OraClient_DP=%BinL_DP%\OraClient
 set OraClient_S_DP=%BinPublic_DP%\OraClient\64Bit
 if exist "%BinPublic_Custom_DP%\OraClient" set OraClient_S_DP=%BinPublic_Custom_DP%\OraClient
REM  Call Echo2 "Oracle Client .dlls from" "%OraClient_S_DP%"
REM  robocopy %robocopy_opt% /S /NP /NJS /NJH /NDL /NFL "%OraClient_S_DP%" "%OraClient_DP%\64Bit">nul 2>nul
 Call CopyFromTo.cmd "Oracle Client .dlls from" "%OraClient_S_DP%" "*.*" "%OraClient_DP%\64Bit" "*.*"  "/S /NP /NJS /NJH /NDL /NFL"

:JobMgr_JobInitial_DoUpdORABinL_NO
:JobMgr_JobInitial_DoUpdBinL_NO

 REM -- Option: Control software starten ---------------------------------------
 REM -- #Doc:25.11.2025/J.Fes allways deactivated
 set JobMgr_start_PLMJobManagerWatchDog=NO
 if /I "%JobMgr_start_PLMJobManagerWatchDog%" neq "YES" goto :JumbOver
   pushd "%BinPublic_ClientServer_DP%"
   call "ProgStart_If_NotRuning.cmd" "PLMJobManagerWatchDog" "%PLMJobManagerWatchDogL_DPNE%"
   popd
:JumbOver

 rem -- #Doc: Check Start: TaskMgr.exe #LUp: 10.02.2021
 if /I "%JobMgr_start_TaskMgr%" neq "YES" goto :JumbOver
  pushd "%BinL_DP%"
  call "ProgStart_If_NotRuning.cmd" "TaskMgr" "taskmgr.exe"
  popd
:JumbOver

 rem -- #Doc: Check Start: Sysinternals procexp64.exe #New:29.06.2023/J.Fes
 if /I "%JobMgr_start_ProcExp%" neq "YES" goto :JumbOver
  robocopy /R:5 /W:1 /S /NP /NJS /NJH /NDL /NFL "%BinPublic_DP%\Sysinternals" "%BinL_DP%" procexp64.exe >nul 2>nul
  pushd "%BinL_DP%"
  call "ProgStart_If_NotRuning.cmd" "procexp64" "%BinL_DP%\procexp64.exe"
  popd
:JumbOver

 REM #New: 10.08.2022/J.Fes
 set JobMgrProcessIcon_DPNE=%CmdCurRoot_DP%\zzProcess.ico
 if exist "%JobMgrProcessIcon_DPNE%" call "%JobMgrCMDHelper_L%" -Quiet -SetConsoleIcon_DPNE "%JobMgrProcessIcon_DPNE%"

if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
 call Echo "---------------------------------------------------------------------------"
 Call Echo "#Debug Start Explorer in JobRoot: %CmdCurRoot_DP%"
 start "" Explorer "%CmdCurRoot_DP%"
 timeout /T:2
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Debug End of ..................: %~0"
 pause
:JumbOverDebug

