
rem #Doc: --------------------------------------------------------------------
rem #Description: checks fcc status
rem #Doc: --------------------------------------------------------------------
rem #EXA: call fccCheck.cmd
rem #Doc: --------------------------------------------------------------------
rem #Doc: enable via:
rem #Doc: uses %JobMgr_fccCheck_USE%        true  set fccCheck=ON
rem #Doc: uses %JobMgr_fccCacheClear_DO%    true  set fccCacheClear=ON
rem #Doc: uses %JobMgr_fccCheck_parentfsc_address%
rem #Doc: uses %JobMgr_fccCheck_parentfsc_address_tryRestart% = true activate tryRestart for change between sides
rem #Doc: uses %JobTemp_DP%%
rem #Doc: uses %JobMgrCMDHelper_L%
rem #Doc: returns JobMgr_fccCHKParentfsc_Res
rem #Doc: --------------------------------------------------------------------
rem #Doc:
rem #New: 21.08.2017/J.Fes
rem #LUp: 10.05.2019/J.Fes add tryRestart
rem #LUp: 10.08.2022/J.Fes add JobMgrCMDHelper.exe ensure update
rem #LUp: 05.02.2024/J.Fes cleanUp and improved reorg "%TC_fccCheck_Log_DP%\zzfcc*.log"
rem #LUp: 15.11.2024/J.Fes improved check methodes
rem #LUp: 31.03.2025/J.Fes integrate JobMgr_fccCacheClear_DO=YES/NO
rem #LUp: 26.06.2025/J.Fes solve Issue via :JumpOverTryRestart


 rem --#Doc: TC_fccCheck_Log_DP defines dir where to place fcc.log files
 set TC_fccCheck_Log_DP=
 if "%~1" neq "" set TC_fccCheck_Log_DP=%~1
 if not defined TC_fccCheck_Log_DP if defined JobTemp_DP set TC_fccCheck_Log_DP=%JobTemp_DP%
 if not defined TC_fccCheck_Log_DP set TC_fccCheck_Log_DP=%temp%

 if not exist "%TC_fccCheck_Log_DP%" md "%TC_fccCheck_Log_DP%"

 set zzfcc1StatusLog_DPNE=%TC_fccCheck_Log_DP%\zzfcc01Status.log
 set zzfcc2StartandStatusLog_DPNE=%TC_fccCheck_Log_DP%\zzfcc02StartAndStatus.log
 set zzfcc2StartJobMgrCMHelperLog_DPNE=%TC_fccCheck_Log_DP%\zzfcc02StartAndStatus_CMHelper.log
 set zzfcc4Chk_parentfscLog_DPNE=%TC_fccCheck_Log_DP%\zzfcc4Chk_parentfsc.log
 set zzfcc5tryRestart_DPNE=%TC_fccCheck_Log_DP%\zzfcc5tryRestart.log
 set zzfcc6tryRetartAfterResartLog_DPNE=%TC_fccCheck_Log_DP%\zzfcc6StatusAfterRestart.log
 set zzfcc7tryRetartCHKAfterResartLog_DPNE=%TC_fccCheck_Log_DP%\zzfcc7Chk_AfterRestart.log
 set JobMgr_fccCacheClearlog_DPNE=%TC_fccCheck_Log_DP%\zzfcc10CacheClear.log


 Call Echo2 "****"
 Call Echo2 "fccCheck/Clear" "Start V26.06.2025"
 Call Echo2 "fccCheck DO"      "%JobMgr_fccCheck_USE%"
 Call Echo2 "fccCacheClear DO" "%JobMgr_fccCacheClear_DO%"

 if /I "%JobMgr_fccCheck_USE%" equ "true" goto :Next1
 Call Echo2 "fcc check" "is disabled"
 Call Echo2 "Enable fcc check at to Scripts" "set JobMgr_fccCheck_USE=true"
 goto :Next2

 :Next1
 call :fccCheckBase
 call :fccCheck_parentfsc_address
 Call Echo2 "fccCHK result tc_fccstatus" "%tc_fccstatus%"

 :Next2
 if /i "%JobMgr_fccCacheClear_DO%" equ "true" call :JobMgr_fccCacheClear_DO

 Call Echo2 "fccCheck/Clear" "END V31.03.2025"
 Call Echo2 "****"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  pause
 :JumbOverDebug


goto :eof

rem -------------------------- fccCheckBase ----------------------------------------------------------------------------
:fccCheckBase

 REM #New:22.08.2017/J.Fes CHK:FMS_HOME
 if not exist "%FMS_HOME%" (
   call ErrorHandel "C" "fcc.ERR:FMS_HOME dnf" "FMS_HOME not defined -or- FMS_HOME dir not found:[%FMS_HOME%]"
   call ErrorHandel "PS" "#ToDo" "Please check installation and fcc configuration"
   goto :eof
 )

 if exist "%TC_fccCheck_Log_DP%\zzfcc*.log" del "%TC_fccCheck_Log_DP%\zzfcc*.log"
 REM :CHK if fcc is started
 set tc_fccstatus=CHK if fcc is started

 call "%fms_home%\bin\fccstat.exe" -status>"%zzfcc1StatusLog_DPNE%"
 if "%errorlevel%" neq "0" goto :fccCheckBaseStart
 set tc_fccstatus=OK already active
 goto :MyExit


:fccCheckBaseStart
 rem fcc try start #LUp:10.08.2022/J.Fes
 call Echo2 "----" "----"
 Call Echo2 "fccstat.exe -start" "in process"

  rem 10.02.2021/J.Fes add Parse_Absolut_DP.cmd
  call Parse_Absolut_DP.cmd TC_TMP_DIR "%CmdCurRoot_DP%\..\zzTCtmpfcctmp\"

  if not exist "%TC_TMP_DIR%" md "%TC_TMP_DIR%"
  set temp=%TC_TMP_DIR%
  set tmp=%TC_TMP_DIR%
  set log_DP=%TC_fccCheck_Log_DP%
  pushd "%TC_TMP_DIR%"

  if not exist "%JobMgrCMDHelper_L%" goto :StartLegacy
  rem 10.08.2022/J.Fes add JobMgrCMDHelper.exe
  set toRun="%JobMgrCMDHelper_L%"^
  -Start_Prg_DPNE "%fms_home%\bin\fccstat.exe"^
  -Start_Prg_Args " -start -status"^
  -Start_Prg_StdOutputLog_DPNE "%zzfcc2StartandStatusLog_DPNE%"^
  -Chk_Prg_NE "fccstat.exe"^
  -Chk_Prg_Args "*start*"^
  -Chk_Prg_WaitForEnd_Milliseconds " -1"^
  -ExecutePrgIf_ChkProcessNotFound "YES"^
  -ExecutePrgIf_ChkProcessFound "NO"^
  -Log "%zzfcc2StartJobMgrCMHelperLog_DPNE%"
  Call %toRun%
  popd
  goto :MyExit

:StartLegacy
  pushd "%TC_TMP_DIR%"
  Call "%fms_home%\bin\fccstat.exe" -start -status>>"%zzfcc2StartandStatusLog_DPNE%"
  popd
  goto :MyExit

:MyExit

goto :eof

rem -------------------------- fccCheckBase ----------------------------------------------------------------------------
:fccStartERR
 rem #Doc: Now we have an ISSUE fcc canot be started
 Call Echo2 "####" "####"
 call ColorSet ERR
 call ErrorHandel "C" "fcc.ERR" "fcc cannot be started"
 call ErrorHandel "C" "fcc Status/Start Returns" "[errorlevel:%tc_fccstatus%]"
 call ErrorHandel "C" "please look at 1 Status"  "[%zzfcc1StatusLog_DPNE%]"
 call ErrorHandel "C" "please look at 2 Start"   "[%zzfcc2StartandStatusLog_DPNE%]"
REM  call ErrorHandel "C" "please look at 3 Status"  "[%zzfcc3StatusLog_DPNE%]"
 call ErrorHandel "C" "#ToDo" "Please check installation and fcc configuration"
 call ErrorHandel "PS" "fcc.ERR" "fcc cannot be started"
 Call Echo2 "####" "####"
goto :eof

rem -------------------------- fccCheckBase ----------------------------------------------------------------------------
:JobMgr_fccCacheClear_DO

 Call Echo2 "fccCacheClear excute"  "start at \\%ComputerName%"

 call fccstat -status>>"%JobMgr_fccCacheClearlog_DPNE%"
 call fccstat -clear>>"%JobMgr_fccCacheClearlog_DPNE%"
 call fccstat -purge>>"%JobMgr_fccCacheClearlog_DPNE%"
 call fccstat -status>>"%JobMgr_fccCacheClearlog_DPNE%"

 Call Echo2 "fccCacheClear excute"  "end at \\%ComputerName%"
 call Echo2 "see fccCacheClearlog_DPNE" "%JobMgr_fccCacheClearlog_DPNE%"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  pause
 :JumbOverDebug

goto :eof


rem -------------------------- :fccCheck_parentfsc_address ---------------------
:fccCheck_parentfsc_address
 rem CHK if fcc uses correct parentfsc_address
 if defined JobMgr_fccCheck_parentfsc_address goto :Next
  Call Echo2 "fccCHK:Parentfsc check" "!!! - is disabled - !!!"
  Call Echo2 "fccCHK:Parentfsc enable CHK" "via.: set JobMgr_fccCheck_parentfsc_address=https://Customserver.dotx.doty:10010/..."
 goto :MyEnd

:Next
 set JobMgr_fccCHKParentfsc_Res=ERR
 rem #Doc: check if custom JobMgr_fccCheck_parentfsc_address is contained in %zzfcc3StatusLog_DPNE%
 if not exist "%zzfcc2StartandStatusLog_DPNE%" goto :Next
 find /i "%JobMgr_fccCheck_parentfsc_address%" "%zzfcc2StartandStatusLog_DPNE%">"%zzfcc4Chk_parentfscLog_DPNE%"
 if "%errorlevel%" equ "0" goto :fccChkOK

:Next
 find /i "%JobMgr_fccCheck_parentfsc_address%" "%zzfcc1StatusLog_DPNE%">"%zzfcc4Chk_parentfscLog_DPNE%"
 if "%errorlevel%" equ "0" goto :fccChkOK

 rem #New: 10.05.2019/J.Fes check if restart is activ
 REM -- #LUp:26.06.2025/J.Fes add :JumpOverTryRestart
 if /I "%JobMgr_fccCheck_parentfsc_address_tryRestart%" neq "true" goto :JumpOverTryRestart
 Call Echo2 "fccCHK:Parentfsc check" "restart is activ do: -clear + -purge"
 call "%fms_home%\bin\fccstat.exe" -clear>"%zzfcc5tryRestart_DPNE%"
 call "%fms_home%\bin\fccstat.exe" -purge>>"%zzfcc5tryRestart_DPNE%"
 timeout /T 3
 Call Echo2 "fccCHK:Parentfsc check" "restart do: -kill"
 call "%fms_home%\bin\fccstat.exe" -kill>>"%zzfcc5tryRestart_DPNE%"
 timeout /T 3
 Call Echo2 "fccCHK:Parentfsc check" "restart do: -start"
 call "%fms_home%\bin\fccstat.exe" -start>>"%zzfcc5tryRestart_DPNE%"
 timeout /T 3
 Call Echo2 "fccCHK:Parentfsc check" "restart get status again do: -status"
 call "%fms_home%\bin\fccstat.exe" -status>"%zzfcc6tryRetartAfterResartLog_DPNE%"
 rem #Doc: check if custom JobMgr_fccCheck_parentfsc_address is contained in %zzfcc3StatusLog_DPNE%
 find /i "%JobMgr_fccCheck_parentfsc_address%" "%zzfcc6tryRetartAfterResartLog_DPNE%">"%zzfcc7tryRetartCHKAfterResartLog_DPNE%"
 if "%errorlevel%" equ "0" goto :fccChkOK
:JumpOverTryRestart

:fccChkERR
  call ErrorHandel "C" "fcc.ERR:ParentFscAdr"  "fcc is using wrong parend fsc adress"
  call ErrorHandel "C" "fcc.ERR:ParentFscAdr"  "fcc should use ParentFsc Adress %JobMgr_fccCheck_parentfsc_address%"
  call ErrorHandel "C" "ParentFsc chk returns" "%JobMgr_fccCHKParentfsc_Res%"
  call ErrorHandel "C" "Please look at file"   "%zzfcc4Chk_parentfscLog_DPNE%"
  call ErrorHandel "PS" "fcc.ERR:ParentFscAdr'%JobMgr_fccCheck_parentfsc_address%' is wrong please check fcc at:\\%Computername%" "#toDo: Please check parentfsc adress settings in fcc.xml and restart fcc"
  goto :MyEnd

:fccChkOK
 set JobMgr_fccCHKParentfsc_Res=OK
 Call Echo2 "fccCHK:fcc should use ParentFsc" "%JobMgr_fccCheck_parentfsc_address%"
 Call Echo2 "fccCHK:ParentfscAdr CHK result" "%JobMgr_fccCHKParentfsc_Res%"
 goto :MyEnd

:MyEnd
goto :eof

