 REM -- #Doc: do all actions at end of Job
 REM -- Usage: Call "_JobFinish.cmd"
 REM -- #New: 27.12.2017 J.Fes        first version
 REM    #LUp: 26.04.2018 J.Fes        Optimice
 REM    #LUp: 20.07.2022 J.Fes        Optimice end and JobDir cleanup via Robocopy
 REM    #LUp: 02.08.2022 J.Fes        use "%BinL_DP%\delage64.exe"
 REM    #LUp: 29.03.2023 J.Fes        use %CmdCurRoot_DP%\Parse_Absolut_DP.cmd + add setting JobLogNotSendToJobServerByteSize

 REM -- #Step: Farbe setzen IsIdel
 call "%CmdCurRoot_DP%\ColorSet" "END"

 Call Echo "--------------------------------------------------------------------------"
 rem #New 20.07.2022 get full path
 call "%CmdCurRoot_DP%\Parse_Absolut_DP.cmd" JobLogNotSendToJobServer_DP "%CmdCurRoot_DP%\..\_JobLogNotSendToJobServer\"

 rem #New: 24.11.2014 J.Fes preventing sending big logfies to JobServer
 rem #LUp: 20.07.2022 set /MIN: to: 30 MB
 rem #LUp: 20.07.2022 use Opt /MOV
 rem #LUp: 29.03.2023 check if is to be done
 if /I "%JobLogNotSendToJobServerByteSize%" equ "-1" goto :JobLogNotSendToJobServerCleanDeactivated
 if /I "%JobLogNotSendToJobServer_DP:~-25%" neq "_JobLogNotSendToJobServer" goto :JobLogNotSendToJobServerCleanNo
 if not defined JobLogNotSendToJobServerByteSize set /a JobLogNotSendToJobServerByteSize=30*1048576
 rem #Doc: 11.03.2024 move all log files gt then JobLogNotSendToJobServerByteSize to subdir 'JobLogNotSendToJobServer_DP'
 call robocopy "%CmdCurRoot_DP%" "%JobLogNotSendToJobServer_DP%\%JobName%" "*.*log*" /MOV /S /MIN:%JobLogNotSendToJobServerByteSize% /R:1 /W:1 /NJS /NJH /NP /NFL /NDL

 rem #New: 21.07.2017 J.Fes Cleanup dir JobLogNotSendToJobServer_DP
 if exist "%BinL_DP%\delage64.exe" call "%BinL_DP%\delage64.exe" "%JobLogNotSendToJobServer_DP%\*.*log*" 2 /modified /recurse /rd /includeRHS
 Call Echo "JobLog Not SendToJobServer.......: Clean:Done using: ByteSize %JobLogNotSendToJobServerByteSize% Bytes"
 goto :Next

:JobLogNotSendToJobServerCleanDeactivated
 Call Echo "JobLog Not SendToJobServer.......: Clean:Deactivated"
 goto :Next

:JobLogNotSendToJobServerCleanNo
 Call Echo "JobLog Not SendToJobServer.......: Clean:NO"
 goto :Next

:Next
 cd /d "%tempOrig_DP%"
 Call Echo "--------------------------------------------------------------------------"
 Call Echo "JobEnd all Jobfiles in directory.: %temp%"
 Call Echo "will be zipt by JobClient........: and send to JobServer"

 REM 12.03.2020/J.Fes add CleanUp
 set SubActionSettingsXml=%CmdCurRoot_DP%\SubActionSettings\90-JobFinishClean_#SystemTools_2017_07_#CleanJobFilesDefault.xml
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "SystemTools_2017_07"
 set toRun=%toRun% -SubAction "CleanJobFilesDefault"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 if exist "%SubActionSettingsXml%" set toRun=%toRun% -SubActionSettingsXml "%SubActionSettingsXml%"

 if /i "%JobMgr_Test%" equ "ON" if /i "%JobMgr_Debug%" equ "ON" Call :EndDebugAndTest& goto :Next
 if /i "%JobMgr_Test%" neq "ON" if /i "%JobMgr_Debug%" equ "ON" Call :EndDebug& goto :Next
 if /i "%JobMgr_Test%" equ "ON" if /i "%JobMgr_Debug%" neq "ON" Call :EndTest&  goto :Next

 goto :myExit

:EndDebugAndTest
 Call Banner Test+Debug:P.End
 set toRun=%toRun% -pauseOnEnd -verbose -test
 goto :eof

:EndDebug
 Call Banner Debug:P.End
 set toRun=%toRun% -pauseOnEnd -verbose -test
 goto :eof

:EndTest
 Call Banner Test:P.End
 set toRun=%toRun% -pauseOnEnd -verbose
 goto :eof

:Next
 call Echo "#End of Job.....................: %JobName%"
 call Echo "#DebugMode......................: %JobMgr_Debug%"
 call Echo "#TestMode.......................: %JobMgr_Test%"
 call Echo "---------------------------------------------------------------------------"
 pause
goto :myExit

:myExit
 call %toRun%& exit /B

