REM -------------------------------------------------------------------------
REM  #Description.............: organices TcPrompt_Custom.cmd
REM  #New.....................: 05.09.2024/J.Fes
REM  #LUp.....................: 05.09.2024/J.Fes
REM  #LUp.....................: 24.09.2024/J.Fes add :TcAndNx
REM  #LUp.....................: 06.11.2024/J.Fes remove TcSharedMemoryDirOrg.cmd
REM  #LUp.....................: 17.10.2025/J.Fes add call PathView.cmd
REM  #LUp.....................: 26.10.2025/J.Fes remove path print JobMgr_TCCustom_Path JobMgr_NXCustom_Path
REM  #LUp.....................: 28.10.2025/J.Fes Echo to Echo2

REM -------------------------------------------------------------------------
REM  #EXA.....................: Call TcPrompt_CustomOrg.cmd :Initial
REM  #EXA.....................: Call TcPrompt_CustomOrg.cmd ":SetPath" ":PrintStatus"
rem  #Doc.....................: posible values for envVar: TcPrompt_Custom_Opt TcOnly/NxOnly or custom value like TC14

REM
:Start
 REM   Echo "%~1" Echo #Debug LI:14:Call %~1 %~nx0&Pause
 if "%~1" neq "" call %~1
 shift
 if "%~1" neq "" goto :Start

goto :eof

:Initial
 rem if not defined CmdCurRoot_DP set CmdCurRoot_DP=%~dp0
 if not defined CmdCurRoot_DP set CmdCurRoot_DP$x=%~dp0
 if not defined CmdCurRoot_DP set CmdCurRoot_DP=%CmdCurRoot_DP$x:~0,-1%
 set CmdCurRoot_DP$x=

 rem Echo #Debug LI:24# %~nx0  CmdCurRoot_DP=%CmdCurRoot_DP% &Pause

 set JobMgr_TcPromptGet_ResCode=-1
 set JobMgr_TcPromptGet_ResMsg=Unknown

 set JobMgr_NxPromptGet_ResCode=-10
 set JobMgr_NxPromptGet_ResMsg=Unknown

 set JobMgr_TcCustom_Path=
 set JobMgr_NxCustom_Path=

 Call Echo2 "----" "----"
 if defined TcPrompt_Custom_Opt (
 Call Echo2 "Executing TcPrompt_Custom.cmd" "%TcSiteId%/%TcPrompt_Custom_Opt%"
 ) else (
 Call Echo2 "Executing TcPrompt_Custom.cmd" "%TcSiteId%"
 )
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:SetPath
rem -- #Doc: set the pathVariable

set Path$temp=

if /I "%TcPrompt_Custom_Opt%" equ "NxOnly" goto :NxOnly
if /I "%TcPrompt_Custom_Opt%" equ "TcOnly" goto :TcOnly

:TcAndNx
 set Path$temp=%JobMgr_NxCustom_Path%;%JobMgr_TcCustom_Path%
 goto :Next

:NxOnly
 set Path$temp=%JobMgr_NxCustom_Path%
 goto :Next

:TcOnly
 set Path$temp=%JobMgr_TcCustom_Path%
 goto :Next

:Next
set Path$temp=^
%Path$temp%;^
%CmdCurRoot_DP%;^
%BinL_DP%;^
%BinPublic_DP%;^
%BinPublic_ClientServer_DP%;^
;^
%WINDIR%\system32;^
%WINDIR%;^
%WINDIR%\System32\Wbem

REM -- #Doc:replace ';;' by: ';'
set Path=%Path$temp:;;=;%

REM -- #Doc:remove ";" at begin and at end
if "%Path$temp:~0,1%" equ ";" set %Path$temp="%Path$temp:~1%"
if "%Path$temp:~0,-1%" equ ";" set %Path$temp="%Path$temp:~0,-1%"

set Path_OrgPrompt=%path%
if "%Path$temp%" neq "" set Path=%Path$temp%

:MyEnd
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:EvaluateRes
 REM -- #Doc: evaluates the entire Result via TCOnly/NxOnly
 if /I "%TcPrompt_Custom_Opt%" equ "TcOnly" goto :TcOnly
 if /I "%TcPrompt_Custom_Opt%" equ "NxOnly" goto :NxOnly

 REM -- #Doc: Result is from JobMgr_TcPromptGet + JobMgr_NxPromptGet
 set /A JobMgr_TcPromptGet_ResCode=%JobMgr_TcPromptGet_ResCode% + %JobMgr_NxPromptGet_ResCode%
 set JobMgr_TcPromptGet_ResMsg=TC:%JobMgr_TcPromptGet_ResMsg%-//-NX:%JobMgr_NxPromptGet_ResMsg%
 goto :MyEnd

:TcOnly
 REM -- #Doc: Result is only from JobMgr_TcPromptGet
 set JobMgr_TcPromptGet_ResCode=%JobMgr_TcPromptGet_ResCode%
 set JobMgr_TcPromptGet_ResMsg=TC:%JobMgr_TcPromptGet_ResMsg%
 goto :MyEnd


:NxOnly
 REM -- #Doc: Result is only from JobMgr_NxPromptGet
 set JobMgr_TcPromptGet_ResCode=%JobMgr_NxPromptGet_ResCode%
 set JobMgr_TcPromptGet_ResMsg=NX:%JobMgr_NxPromptGet_ResMsg%
 goto :MyEnd

:MyEnd
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PrintTcEnv
REM   Echo #Debug LI:86 %~nx0&Pause

 if /I "%TcPrompt_Custom_Opt%" neq "NxOnly" goto :PrintTcEnvDo
 goto :PrintTcEnvNo

:PrintTcEnvDo
  rem Echo #Debug LI:85 %~nx0&Pause
  Call Echo2 "----" "----"
  Call Echo2 "TcSideId" "%TcSiteId%"
  Call Echo2 "TC_DATA" "%TC_DATA%"
  Call Echo2 "TC_ROOT" "%TC_ROOT%"
  Call Echo2 "FMS_HOME" "%FMS_HOME%"
REM   Call Echo2 "JobMgr_TcCustom_Path" "%JobMgr_TcCustom_Path%"
  Call Echo2 "----" "----"
  if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   Echo "-- #Debug:ENV TC ---------------------------------------------------------"
   set TC
   pause
  :JumbOverDebug
 goto :MyEnd

:PrintTcEnvNo
  rem Echo #Debug LI:101 %~nx0&Pause
  Call Echo2 "Info TC Env Data Do print:NO....: because TcPrompt_Custom_Opt is set to:%TcPrompt_Custom_Opt%"
  goto :MyEnd

:MyEnd
  rem Echo #Debug LI:106 %~nx0&Pause
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PrintNXEnv
 if /I "%TcPrompt_Custom_Opt%" neq "TCOnly" goto :PrintNXEnvDo
 goto :PrintNXEnvNo

:PrintNXEnvDo
  Call Echo2 "----" "----"
  Call Echo2 "UGII_BASE_DIR" "%UGII_BASE_DIR%"
  if defined UGII_NXBIN_DIR Call Echo2 "UGII_NXBIN_DIR" "%UGII_NXBIN_DIR%"
  if defined UGII_ROOT_DIR  Call Echo2 "UGII_ROOT_DIR" "%UGII_ROOT_DIR%"
  Call Echo2 "----" "----"
REM   Call Echo2 "JobMgr_NXCustom_Path" "%JobMgr_NXCustom_Path%"
  if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   Echo "-- #Debug:ENV UG+NX ------------------------------------------------------"
   set UG
   set NX
   pause
  :JumbOverDebug
 goto :MyEnd

:PrintNXEnvNo
  Call Echo2 "Info NX Env Data Do print:NO" "because TcPrompt_Custom_Opt is set to:%TcPrompt_Custom_Opt%"
 goto :MyEnd

:MyEnd

goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PrintStatus
 Call Echo2 "----" "----"
 call Echo2 "TcPrompt_Custom_Opt" "%TcPrompt_Custom_Opt%"
 call Echo2 "NxPrompt_Custom_Opt" "%NxPrompt_Custom_Opt%"
 call Echo2 "JobMgr_TcPromptGet_ResCode" "%JobMgr_TcPromptGet_ResCode%"
 call Echo2 "JobMgr_TcPromptGet_ResMsg" "%JobMgr_TcPromptGet_ResMsg%"
 call "PathView.cmd"
goto :eof
