@Echo off
REM #Doc: In this script you define customer TcSiteId settings
REM #Doc: This script is used by JobMgr JobScripts parameters
REM       for getting TcSiteId specific environment
REM       for getting NX specific environment

REM #toDo: please setup Customer TcPrompt settings
REM #New: 01.08.2016 J.Fes first version
REM #LUp: 19.09.2016 J.Fes add TcPrompt_Custom_Opt
REM #LUp: 26.01.2017 J.Fes add 4tier doc
REM #LUp: 29.03.2017 J.Fes add PathEnvAddPath.cmd
REM #LUp: 26.02.2023 J.Fes add env JobMgr_TC_tier_ModeUse
REM #LUp: 01.11.2023 J.Fes add env TcOnly Option
REM #LUp: 25.01.2024 J.Fes/A.Stein add env JobMgr_TcCustom_Path, JobMgr_NXCustom_Path, JobMgr_NXTCCustom_Path, JobMgr_NXNativCustom_Path
REM #LUp: 05.09.2024 J.Fes add reorg set environment TCOnly/NXOnly please update JobMgrDefaultScriptsVer=2024-09-05-01
rem #LUp: 09.09.2024 J.Fes posible vaues for envVar: TcPrompt_Custom_Opt TcOnly/NxOnly or custom value like TC14

if "%~1" neq "" set TcSiteId=%~1

Call Echo2 "****"
Call Echo2 "*" "Excuting %~nx0 #Ver:05.11.2025 // #LUp:05.11.2025"
Call Echo2 "****"


if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Debug:..........................: %~nx0"
 pause
:JumbOverDebug

 REM  #toDo check JobMgrDiskConnect ON/OFF (default=OFF)
 Call "%CmdCurRoot_DP%\TcPrompt_CustomOrg.cmd" ":Initial"
 Call :JobMgrDiskConnect "OFF"
 Call :TCEnvSet
 Call "%CmdCurRoot_DP%\TcPrompt_CustomOrg.cmd" ":PrintTcEnv"
 Call :NXEnvSet
 Call "%CmdCurRoot_DP%\TcPrompt_CustomOrg.cmd" ":PrintNXEnv" ":EvaluateRes" ":SetPath" ":PrintStatus"
goto :eof


REM -- #ToDo: Setup TC Environment -------------------------------------------------------------------------------------
:TCEnvSet
rem Echo #Debug LI:46 %~nx0&Pause
 set TcPromptCmd=
 set TcPromptCmdOpt=
 if /I "%TcPrompt_Custom_Opt%" equ "NXOnly" goto :MyEnd

 REM -- #Dco: 26.01.2017/J.Fes add Info 4tier prompt
 REM -- #Doc: 4tier:
 REM -- #Doc: check JobMgr_TC_tier_ModeUse=4tier / 2tier
 REM     set UGII_UGMGR_COMMUNICATION=HTTP
 REM     set UGII_UGMGR_HTTP_URL=http://10.145.0.203:10070/tc/aiws/aiwebservice
 REM     please if TC 4tier settings for max concurrent 4tier-Server processes is sufficent
 REM     count for pre running 4tier-processes should be: RfClient*1,25

 REM #New 26.02.2023/J.Fes set default TC_tier Mode = 2tier
 if not defined JobMgr_TC_tier_ModeUse set JobMgr_TC_tier_ModeUse=2tier
 if /i "%TcSiteId%" neq "TC11ADDPLM" goto :Next
  set TcPromptCmd=C:\splm\tc11\tc_menu\TC11ADDPLM_TC11.bat
  set TcPromptCmdOpt=
  if not defined UGII_SITE_DIR set UGII_SITE_DIR=V:\JobManager\ProgEntw\Ver03\JobManagerV3\03-BinPublic.Custom\NX_Custom\NX120.Custom
  set JobMgr_fccCheck_parentfsc_address=addPLM-VS01:4544
  call TcSharedMemoryDirOrg.cmd "ON"
 :Next

 rem -- #Doc: Example addPLM TC14
 if /i "%TcSiteId%" neq "TC14ADDPLM" goto :Next
  set TC_ROOT=D:\SPLM\TC14
  set TC_DATA=\\addPLM-12\PLMShare\SPLM\TC14data
REM   dir "%TC_DATA%\tns*.ora"
  REM   set TcPromptCmd=C:\splm\tc11\tc_menu\TC11ADDPLM_TC11.bat
  set TcPromptCmd=%TC_DATA%\tc_profilevars.bat
  set JobMgr_fccCheck_parentfsc_address=http://addPLM-12.jf-do2.local:4544
  call TcSharedMemoryDirOrg.cmd "ON"
 :Next


 REM -- #Doc: Example:  Generic: fuer TC10
 if /i "%TcSiteId%" neq "#Generic_Example1#" goto :Next
  REM SET TC_ROOT=d:\ugs\tc10
  REM SET TC_DATA=\\SRV_XXX\PLMShare\tc10data\windows
  set TcPromptCmd=%TC_DATA%\tc_profilevars.bat
  set TcPromptCmdOpt=
  set JobMgr_fccCheck_parentfsc_address=https://Customserver.dotx.doty:10010/
 :Next

 REM -- #Doc: Example: SIDT Standard:
 if /i "%TcSiteId%" neq "#SIDT_Example1#" goto :Next
   set SIDT_DEBUG=0
   set TcPromptCmd=%UGS_SHR_DIR%\start_apps\windows\start_nx12.bat
   set TcPromptCmdOpt=de tc_prompt %TcSiteId% tc14
   REM #New:17.08.2017 /J:fes Check parentfsc_address please see fcc.xml
   set JobMgr_fccCheck_parentfsc_address=https://Customserver.dotx.doty:10010/
 :Next

 REM -- #Doc: Example: BCT-1 Prompt (preferred to use)
 if /i "%TcSiteId%" neq "#BCT_Example1#" goto :Next
   REM -- #ToDo: Check bctsi_progressbar.exe
   REM -- #Doc: search for start %BCTSI_BIN%\bctsi_progressbar.exe -on -text="%BCTSI_MSG_002%"
   set TcPromptCmd=\\SRV_XXX\bctsi_custom\scripts\bctsi_env.bat
   REM -- #CHK: Parmater3: NX10 oder NX100 --
   set TcPromptCmdOpt=env bct_v161 NX120 - tc101 plm1 de
   set JobMgr_fccCheck_parentfsc_address=https://Customserver.dotx.doty:10010/
 :Next

 REM -- #Doc: Example: addPLM - Nativ Test
 if /i "%TcSiteId%" neq "NativNX" goto :Next
   set TcPromptCmd=C:\NX_Custom\SetUp_NxEnviron.cmd
   set TcPromptCmdOpt=NX2306 BATCH
   set JobMgr_TcUser=
   set JobMgr_TcPw=
   set CB_Integration=Nativ
 :Next

REM -- #Doc: check start TcPrompt
 if exist "%TcPromptCmd%" goto :TcPromptCmdFoundYES
 goto :TcPromptCmdFoundNO

:TcPromptCmdFoundNO
 REM -- #Doc: ERR Custom TC-Prompt not found
 set JobMgr_TcPromptGet_ResCode=1
 set JobMgr_TcPromptGet_ResMsg=TcPrompt:fnf
 call ErrorHandel "S" "%JobMgr_TcPromptGet_ResMsg%" "[ERR:Missing:%TcPromptCmd%]"
 goto :MyEnd

:TcPromptCmdFoundYES
 REM -- #Doc: OK Now execute get Custom TC-Prompt
 call "%TcPromptCmd%" %TcPromptCmdOpt%

REM --#Doc: set TCPath  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
REM -- Check FMS_HOME
if not defined FMS_HOME if exist "%tc_root%\tccs" set FMS_HOME=%tc_root%\tccs
REM -- #New: 18.03.2021/J.Fes set min path please check Usage
REM -- #CHK: 21.03.2021/J.Fes %TC_ROOT%\bin\tcperl\bin; %TC_ROOT%\bin\perl\bin;
REM -- #Doc: if using PLMEasy tools like TCPB_Data_Import.exe or plmxml_export.exe then uses Call TCPrompt_FSCPathAdd.cmd
rem set FSC_HOME=%tc_root%\fsc
rem %FSC_HOME%\lib;
rem %FMS_HOME%\bin
set JAVA_HOME=%JRE_HOME%

Call PathaddEnv.cmd^
 JobMgr_TcCustom_Path^
 %TC_ROOT%\bin;^
 %TC_ROOT%\lib;^
 %JAVA_HOME%\bin\client;^
 %JAVA_HOME%\bin;^
 %JAVA_HOME%\bin\server;^
 %JAVA_HOME%\bin\portal;^
 ;^
 %TC_ROOT%\bin\perl\bin;^
 %FMS_HOME%;^
 %FMS_HOME%\bin;^
 %FMS_HOME%\lib

REM --#Doc:replace ';;' by: ';'
set JobMgr_TcCustom_Path=%JobMgr_TcCustom_Path:;;=;%

set JobMgr_TcPromptGet_ResCode=0
set JobMgr_TcPromptGet_ResMsg=OK

:MyEnd
goto :eof

REM -- #ToDo: Setup NX Environment -------------------------------------------------------------------------------------
:NXEnvSet

 if /I "%TcPrompt_Custom_Opt%" equ "TCOnly" goto :MyEnd

 if /I "%NXPrompt_Custom_Opt%" neq "NX12" goto :Next
  Call SetEnvFirstFound UGII_BASE_DIR "C:\splm\nx12" "C:\Program Files\Siemens\NX12"
  set UGII_ROOT_DIR=
:Next

 if /I "%NXPrompt_Custom_Opt%" neq "NX2212" goto :Next
  set UGII_BASE_DIR=C:\Program Files\Siemens\NX2212
  Call SetEnvFirstFound UGII_BASE_DIR "C:\Program Files\Siemens\NX2212"
  set UGII_ROOT_DIR=
:Next

 if /I "%NXPrompt_Custom_Opt%" neq "NX2312" goto :Next
  Call SetEnvFirstFound UGII_BASE_DIR "C:\Program Files\Siemens\NX2312"
  set UGII_ROOT_DIR=
:Next

 rem -- Check NX Envionment
 if not defined UGII_BASE_DIR goto :MyEndErr1
 REM -- am Ende "\"  abschneiden
 if "%UGII_BASE_DIR:~-1%" equ "\" set UGII_BASE_DIR=%UGII_BASE_DIR:~0,-1%
 if not exist "%UGII_BASE_DIR%" goto :MyEndErr2

 if not defined UGII_ROOT_DIR goto :Next
 if "%UGII_ROOT_DIR:~-1%" equ "\" set UGII_ROOT_DIR=%UGII_ROOT_DIR:~0,-1%
:Next

 if not exist "%UGII_BASE_DIR%\nxbin" goto :Next
 REM -- #New: 30.01.2017/J.Fes add tp path .\nxbin since NX11
 set UGII_NXBIN_DIR=%UGII_BASE_DIR%\nxbin
:Next

Call PathaddEnv.cmd^
 JobMgr_NXCustom_Path^
 "%UGII_NXBIN_DIR%"^
 "%UGII_BASE_DIR%"^
 "%UGII_ROOT_DIR%"

 REM --#Doc:replace ';;' by: ';'
 set JobMgr_NXCustom_Path=%JobMgr_NXCustom_Path:;;=;%

 REM --#Doc:Set JobMgr_NXPromptGet check  OK
 set JobMgr_NXPromptGet_ResCode=0
 set JobMgr_NXPromptGet_ResMsg=OK
 goto :MyEnd

:MyEndErr1
  REM --#Doc:Set JobMgr_NXPromptERR = 10 because UGII_BASE_DIR not defined
  set JobMgr_NXPromptGet_ResCode=10
  set JobMgr_NXPromptGet_ResMsg=Req. EnvVar:UGII_BASE_DIR not defined
  call ErrorHandel "S" "EnvVar:UGII_BASE_DIR not defined" "[ERR:Missing:UGII_BASE_DIR]"
 goto :MyEnd

:MyEndErr2
  REM --#Doc:Set JobMgr_NXPromptERR = 11 because UGII_BASE_DIR dnf
  set JobMgr_NXPromptGet_ResCode=11
  set JobMgr_NXPromptGet_ResMsg=dnf Req.Dir UGII_BASE_DIR:'%UGII_BASE_DIR%' not exist
  call ErrorHandel "S" "UGII_BASE_DIR:dnf" "[ERR:dnf:%UGII_BASE_DIR%]"
 goto :MyEnd


:MyEnd

goto :eof


REM -- #ToDo: Setup Conncet Network drives [#Optional  ] ---------------------------------------------------------------
:JobMgrDiskConnect
   set JobMgr_use_DiskConnect=%~1
   if /I "%JobMgr_use_DiskConnect%" neq "ON" goto :Next
    set PLMShare_DiskConnectInfo=S: \\MyServer\ugsshare
    call ConnectNetUnc.cmd "PLMShare" S: \\MySerrver\PLMShare . . PLMshare_DiskConnectStatus
    Call Echo "Connect Disk....................: %PLMShare_DiskConnectInfo% Status:%PLMshare_DiskConnectStatus%"
    if /I not "%PLMshare_DiskConnectStatus%" equ "OK" (
     call ErrorHandel "S" "ERR:PLMShare" "[%PLMShare_DiskConnectInfo% Status:%PLMshare_DiskConnectStatus%]"
    )
:Next




