@Echo off

 Call Echo2 "****"
 Call Echo2 "*" "Excuting %~nx0 #LUp:05.11.2025"
 Call Echo2 "****"

 call Echo2 "-- #Step" "-- Get Custom NX-TC Environment --"
 Call "%TCPrompt_Custom_DPNE%"

 rem -- #LUp: 19.11.2024/Get first Custom env
 Call PLMPerf_NXLoad2_CustomSetEnv.cmd
 Call PLMPerf_NXLoad3_DefaultsSetEnv.cmd


 REM -- #New: 14.11.2024/J.Fes Disable/Enable usage of: fccCheck
 set JobTemp_TP=JobT_P01
 set JobTemp_DP=%JobRoot_DP%\%JobTemp_TP%

 call Echo2 "----" "----"
 Call Echo2 "NXLoad " "%JobTitle%"
 Call Echo2 "setting fccCache_Clear_DO"       "%fccCache_Clear_DO%"
 Call Echo2 "setting PLMPerfKey"              "%PLMPerfKey%"
 Call Echo2 "setting WaitBeforeJobStart"      "%PLMPerf_WaitBeforeJobStart% (sec)"
 Call Echo2 "setting WaitAfterJobDone"        "%PLMPerf_WaitAfterJobDone% (sec)"
 Call Echo2 "setting TcPrompt_Custom_Opt"     "%TcPrompt_Custom_Opt%"
 Call Echo2 "setting NXPrompt_Custom_Opt"     "%NXPrompt_Custom_Opt%"
 Call Echo2 "setting UGII_LOAD_OPTIONS_NE"    "%UGII_LOAD_OPTIONS_NE%"
 Call Echo2 "setting UGII_LOAD_OPTIONS"       "%UGII_LOAD_OPTIONS%"
 Call Echo2 "setting JobMgr_TC_tier_ModeUse"  "%JobMgr_TC_tier_ModeUse%"
 call Echo2 "---- " " ----"
 Call Echo2 "setting JobTemp_DP"              "%JobTemp_DP%"
 Call Echo2 "setting NXJournalTemplate_NE"    "%NXJournalTemplate_NE%"
 Call Echo2 "setting NXJournalTemplate_DPNE"  "%NXJournalTemplate_DPNE%"
 Call Echo2 "setting ObjectCliName"           "%ObjectCliName%"

 rem --#Doc: wait time before PerfJobStart
 call Echo2 "----" "----"
 timeout /T:%PLMPerf_WaitBeforeJobStart%
 call Echo2 "----" "----"

 Call :PLMPerfExecute

 rem --#Doc: wait time after PerfJobDone
 call Echo2 "----" "----"
 timeout /T:%PLMPerf_WaitAfterJobDone%
 call Echo2 "----" "----"

goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfExecute
 setlocal
 rem -- #Doc: check if TCPrompt.cmd is available
 if not exist "%TCPrompt_Custom_DPNE%" goto :TcPromtCmdError

 rem -- #Doc: set TC Prompt for Custom %1 = NX Version
 if not defined TcSiteIdTarget set TcSiteIdTarget=%TcSiteId%

REM  call Clearlocks -verbose -node_names
REM  pause

 call Echo2 "-- #Step" "-- fcc check --"
 call TC_tempSet.cmd "%CmdCurRoot_DP%\..\zzTCtmpfcctmp"
 call fccCheck.cmd "%JobTemp_DP%"


 call TC_tempSet.cmd "%JobTemp_DP%"
 if /I "%fccCache_Clear_DO%" equ "YES" (
  call Echo2 "-- #Step" "fccCache_Clear:YES"
  call :fccCache_Clear_DO
 ) else (
  call Echo2 "-- #Step" "fccCache_Clear:NO"
 )
 call "PLMPerf_NXLoad5_ExecuteViaJournal.cmd" "%NXJournalTemplate_DPNE%"

REM  set JobMgr_Debug=ON
REM  Echo #Debug LI:68 %~nx0&Pause
 Call PLMPerf_NXLoad6_EvaluatePerfData.cmd "%JobTemp_DP%"

 call Echo2 "----" "----"
 call Echo2 "End %~nx0" "PLMPerfKey:%PLMPerfKey%"
 goto :MyEnd

:JumbOverTest

:MyEnd
 goto :eof


rem ---------------------------------------------------------------------------
:SetPmon
 set temp=%~1
 set tmp=%temp%
 if not exist "%temp%" md "%temp%"

 set PMon_exeL_DPNE=%BinL_DP%\JFProcessMonitor.exe
 set PMon_SysLog_DPNE=%temp%\zzPLMPerf1_PMon_Sys.log
 set PMon_ResultXml_DPNE=%temp%\zzPLMPerf2_PMon_Result.xml

	set toMon=%PMon_exeL_DPNE%
 set toMon=%toMon% --titlePrefix "JobMon:[%JobName%][Step:%JobMgr_PLMPerfStepNo%][Start:%Date%/%time:~0,8%]"
 set toMon=%toMon% --processName run_journal
 set toMon=%toMon% --waitForProcess 150000
 set toMon=%toMon% --parentProcessId 0
	set toMon=%toMon% --killChildProcesses
REM 	set toMon=%toMon% --killChildProcesses
 set toMon=%toMon% --fileLastWriteTime "%temp%\*.*;600"
 set toMon=%toMon% --tailTextFile "%temp%\%username%*.syslog"
 set toMon=%toMon% --duraTimeSpanIfGreaterThen 1000
 set toMon=%toMon% --tailForceMilliseconds "500"
 set toMon=%toMon% --tailTextFile_log "%PMon_SysLog_DPNE%"
	set toMon=%toMon% --saveResultsTo "%PMon_ResultXml_DPNE%"
 rem set toMon=%toMon% --runtimeLimitSeconds 600
 Call Echo "Perf.P.Mon use setting..........: 29.08.2023"
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:fccCache_Clear_DO

rem #Exa call :fccCache_Clear_DO


  set fccCache_Clear_log_DPNE=%temp%\zzfcc10CacheClear.log

  Call Echo2 "do fccCache clear on"    "\\%ComputerName%"
  call Echo2 "fccCache_Clear_log_DPNE" "%fccCache_Clear_log_DPNE%"
  REM call fccstat -restart
  call fccstat -status>>"%fccCache_Clear_log_DPNE%"
  call fccstat -clear>>"%fccCache_Clear_log_DPNE%"
  call fccstat -purge>>"%fccCache_Clear_log_DPNE%"
  call fccstat -status>>"%fccCache_Clear_log_DPNE%"

  if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   REM set toRun=%toRun% -verbose -pauseOnEnd
   call Echo2 "****"
   call Echo2 "#Debug" "fccCache_Clear done"
   call Echo2 "****"
   pause
  :JumbOverDebug

goto :eof


REM ###### ------------ Standard Subroutines ---------------------- ##########
REM ============================================================================
:TcPromtCmdError
 Call ColorSet ERR
 set ErrLog_DPNE=%temp%\__Err_MissingTcPromtCmd_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start Job on:\\%ComputerName% missing TcPromptCmd [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo TcPromtCmd:=%TcPromtCmd%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite
 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /i "%JobMgr_Debug%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo type exit script continues
 cmd
goto :end


REM ============================================================================
:ErrLogHeaderWrite
REM schreibt die erweiterten Infos an einen ErrLogFile
REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
Echo JobClient Error Report  created %date% %time%>>"%ErrLog_DPNE%"
Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
Echo User:     %UserName% >>"%ErrLog_DPNE%"
Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
goto :eof

REM ============================================================================
:ErrLogFooterWrite
REM schreibt die erweiterten Infos an einen ErrLogFile
REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
Echo.>>"%ErrLog_DPNE%"
Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
Echo Environ Info of:\\%ComputerName%>>"%ErrLog_DPNE%"
Echo.>>"%ErrLog_DPNE%"
Echo -- Path Environ ---------------------------------------------------------->>"%ErrLog_DPNE%"
set PATH>>"%ErrLog_DPNE%"

Echo -- UG* Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
set UG>>"%ErrLog_DPNE%"
Echo -- IMAN* Environ --------------------------------------------------------->>"%ErrLog_DPNE%"
set IMAN>>"%ErrLog_DPNE%"
Echo -- All Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
set>>"%ErrLog_DPNE%"
goto :eof

