#Step1: Init.cmd
#Step2: Merke    Start Zeit
#Step3: Machwas  get Parameter Timeout /T:3
#Step2: Evaluate End time

# Lup: 26.03.2025/J.Fes

# Set Path
# clear
# cd\


# param(
#Script to execute
# [string]$PLMPerf_cmdScriptToExecute_DPNE = ""
#)


# -------------- allways at top
# function FName([String] $P1 ,$P2) {
# }

# set JobMgr_Debug to on at environment
# $env:JobMgr_Debug="ON"
[string]$JobMgr_Debug = $env:JobMgr_Debug
[string]$PLMPerf_cmdScriptToExecute_DPNE = $env:PLMPerf_cmdScriptToExecute_DPNE

# Write-Output "#D27: JobMgr_Debug $($JobMgr_Debug)"

if ($env:JobMgr_Debug -eq "ON") {
    Write-Output "#D30: $($PSCommandPath)"
    Write-Output "#D31: $($PSScriptRoot)"
    # Write-Output "#D31: $($MyInvocation.ScriptName)"
    # $Env:JobClient_ServerProvidedResources_DP = "D:\addplm\JobManager\ProgEntw\Ver03\PLMPerfV4\02-PLMPerf.ServerProvidedResources"
    Write-Output "#D34: JobClient_ServerProvidedResources_DP=$($Env:JobClient_ServerProvidedResources_DP)"
    Write-Output "#D35: PLMPerf_cmdScriptToExecute_DPNE = $($PLMPerf_cmdScriptToExecute_DPNE)"
}


# Load MeasureJobResults.dll
$assemblyNE = "JobManagerContract.MeasureJobResults.dll"
$assemblyPath1 = Join-Path $PSScriptRoot $assemblyNE
$assemblyPath2 = Join-Path $Env:JobClient_ServerProvidedResources_DP $assemblyNE
Write-Output "AssemblyPath 1: $assemblyPath1"
Write-Output "AssemblyPath 2: $assemblyPath2"

$assemblyPath = $assemblyPath1
if (-not (Test-Path $assemblyPath)) { $assemblyPath = $assemblyPath2 }
if (-not $assemblyPath -or -not (Test-Path $assemblyPath)) {
   Write-Error "Assembly JobManagerContract.MeasureJobResults.dll not found."
   if ($psISE) { Return }
   return
}

Write-Output "Loading assembly: $assemblyPath"
[Reflection.Assembly]::LoadFile($assemblyPath) | Out-Null

# Report header
$measureJobResults = New-Object -TypeName "JF.PlmJobManager.JobServer.MeasureJobResults_cls"
# Example use addition PLMPerf Data only used for Ping
# $measureJobResults.AdditionalData.AddString("SourceInterface", $Var1)
$measuredResult = [PSCustomObject]@{
    PerfValue = 0.0
}

#if ($env:JobMgr_Debug -eq "ON"){
#  Write-Output "#D74: Call CMD Script $($PLMPerf_cmdScriptToExecute_DPNE)"
#  # start-sleep 1000
#  # read-host -prompt "Pause ... enter any key to continue"
# }
# set JobName=#JobName#

#-- #Doc: Start Stopwatch
$processTimer = [System.Diagnostics.Stopwatch]::StartNew()
#-- #Step: Excute cmd script '%PLMPerf_cmdScriptToExecute_DPNE%'
& $PLMPerf_cmdScriptToExecute_DPNE

#-- Doc: Stop Stopwatch
$processTimer.Stop()

$measureJobResults.JobResultCode = 0
$measureJobResults.JobResultMessage = "OK"
$measureJobResults.JobResultReport = ""

# -- #Exa: set Perf Results $measuredResult.PerfValue = 3.14159 * 2
$measuredResult.PerfValue = $processTimer.Elapsed.TotalSeconds

# -- #Doc: add evaluated PerfData
$measureResult = $measureJobResults.AddNewMeasureResult([System.DateTime]::UtcNow, $measuredResult.PerfValue)

Write-Output "*********************************************************************"
Write-Output " Result.PerfValue...............: $($measuredResult.PerfValue) (sec)"
Write-Output " Saving Results to..............: $($PSScriptRoot)"
Write-Output "*********************************************************************"
$xml = $measureJobResults.SaveAsXmlFile($PSScriptRoot)
#$xml | Out-Host
