@Echo off
 rem -----------------------------------------------------------------------------------------
 rem #Doc: create PLPerfV4 Application Toolbar with all required application links
 rem #New: 21.10.2024  J.Fes
 REM LUp:07.08.2025/J.Fes
 cls
 set ThisScript_DPNE=%~0
 set Quiet=false
 if /I "%1"=="/Quiet" set Quiet=true
 REM  disable writing data to JobMgr_EchoLog_DPNE when using Call Echo Call Echo2
 set JobMgr_EchoLog_DPNE=.

rem --------------------------------------------------------------------------------------------------------------------
:Main_Menu
REM  set PPA_Debug=ON

 Call "%~dp0PLMPerf03-EnvSet.cmd"
REM  Call Echo2 "#D:18 PPA_AppVerBuild_S" "%PPA_AppVerBuild_S%
REM  Call Echo2 "#D:18 PPA_AppVerBuild_L" "%PPA_AppVerBuild_L%

 set PPA_ToolInfo=Dialog
 Title Config:%PPA_Title%

 call ColorSet Dialog
 call :PPACustomSetting_Check

REM   set PPA_ProfileCustomBaseAdmRoot_DP=%PPA_ProfileCustomBaseRoot_DP%\_AdminSettings
REM  set PPA_ProfileCustomBaseAdmRoot_DPNE=%PPA_ProfileCustomBaseAdmRoot_DP%\01-PPA_CustomAdmSettings.cmd

REM  Call Echo2 "#D:30 PPA_ProfileCustomBaseAdmRoot_DP" "%PPA_ProfileCustomBaseAdmRoot_DP%"
REM  Call Echo2 "#D:30 PPA_ProfileCustomBaseAdmRoot_DPNE" "%PPA_ProfileCustomBaseAdmRoot_DPNE%"
REM  Call Echo2 "#D:30 PPA_AdmSettS_DP" "%PPA_AdmSettS_DP%"
REM  Call Echo2 "#D:30 PPA_AdmSettL_DP" "%PPA_AdmSettL_DP%"
REM  Call Echo2 "#D:30 PPA_RootS_DP" "%PPA_RootS_DP%"
REM  Call Echo2 "#D:30 PPA_RootL_DP" "%PPA_RootL_DP%"
REM  Call Echo2 "#D:30 PPA_StartFrom" "%PPA_StartFrom%"
REM  Pause

 Call Echo2 "."
 Call Echo2 "."
 Call Echo2 " ---" "----"
 Call Echo2 " PLMPerfAnalyse Info"              "%PPA_Title%"
 Call Echo2 " PLMPerfAnalyse Setup"              "Menue Version:%PPA_VerMnu%"
 Call Echo2 " PLMPerfAnalyse Application"        "Build Version:%PPA_AppVerBuild%"
 Call Echo2 " ---" "----"
REM  if defined PPA_CustomProfile_N Call Banner "PPA:%PPA_CustomProfile_N%"
 Call Echo2 " Setup PLMPerfAnalyse for"         "Profile: '%PPA_CustomProfile_N%' PLMPerfServer: '\\%PPA_CustomPLMPerfServer_N%'"
 Call Echo2 " ---" "----"
 Call Echo2 "."
 Call Echo2 " I  = List Setup"                  "Custom Profile Setting Details"
 Call Echo2 " T  = Call Tools Menue"            "PLMPerfAnalyse Tools Dialog"
 Call Echo2 " ES = Explore Appl Root-S Dir"     "%PPA_RootS_DP%"
 Call Echo2 " EL = Explore Appl Root-L Dir"     "%PPA_RootL_DP%"
 Call Echo2 " EC = Explore Custom Profile DIR"  "%PPA_ProfileCustomRoot_DP%"
 Call Echo2 "."
 Call Echo2 " PS = Custom Profile Settings"     "SetUp -or- Edit Profile: '%PPA_CustomProfile_N%'"
 Call Echo2 " PR = Custom Profile Setting"      "Reset"
REM  Call Echo2 " CE = Custom Start Script Edit"    "%PPA_CustomStartScript_DPNE%"
 Call Echo2 "."
 rem Call Echo2 "----" "----"
 Call Echo2 " CP = Create Custom JobProfile"   "for Profile:(%PPA_CustomProfile_N%)"
 Call Echo2 "       Custom JobProfile dir"      "%PPA_ToolBarStartProfile_DP%"
 Call Echo2 "       Custom JobProfile Status"   "%PPA_ProfileCustomRoot_DP_Status%"
 Call Echo2 "."
 Call Echo2 " CT = Create Custom Toolbar"      "for Profile:(%PPA_CustomProfile_N%)"

 Call Echo2 "       Custom Toolbar"            "%PPA_ToolBarStartProfile_DP%"
 Call Echo2 "       Custom Toolbar Status"     "%PPA_ToolBarStartProfile_DP_Status%"
 Call Echo2 "."
 Call Echo2 " ----- PLMPerf do Distrip"         "for Profile:(%PPA_CustomProfile_N%) ----"
 Call Echo2 " 01 = PPA.Appl+Setting to"         "Comp:%ComputerName% to '%PPA_RootL_DP%\..'"
 Call Echo2 " 02 = PPA.Setting Only to"         "Comp:%ComputerName% to '%PPA_RootL_DP%\..'"
 Call Echo2 " RE = PPA.Appl+Setting Remove"     "Comp:%ComputerName% from Local Dir:'%PPA_RootL_DP%\..'"
 Call Echo2 "."
 Call Echo2 " ----- PLMPerf do Setup"           "for Profile:(%PPA_CustomProfile_N%) ----"
 Call Echo2 " 21 = PLMPerf-Setup Settings+DB"   "Interactive Application to Config Basics"
 Call Echo2 "."
 Call Echo2 " ----- PLMPerf do Start"           "for Profile:(%PPA_CustomProfile_N%) ----"
 Call Echo2 " 22 = PLMPerf-Service Start"       "Interactive as Shell (not as Service)"
 Call Echo2 " 23 = PLMPerf-Application Start"   "Intercative for View Data and Settings"
 Call Echo2 " 24 = PLMPerf-Client Start"        "Interactive as Shell (not as Service)"
 Call Echo2 "."
 Call Echo2 " ----- PLMPerf do set Service"     "for Profile:(%PPA_CustomProfile_N%) ----"
 Call Echo2 " 31 = PLMPerf-Server Service"      "Install/Config PPA Server-Service (Need Admin rights)"
 Call Echo2 " 32 = PLMPerf-Client Service"      "Install/Config PPA Clinet-Service (Need Admin rights)"
 Call Echo2 "."
 Call Echo2 " Q  = Quit"                        "End %PPA_ToolInfo%"
 Call Echo2 "."

 if not exist "%PPA_ProfileCustomRoot_DP%" (
  Call ColorSet WRN
  Call Echo2 " Please first DO" "Creeate Custom JobProfile via command 'CP'"
  Call Echo2 "."
 )


 set Action=
 set /P Action="... please select Command: "
 Call Echo2 "."

 if /I "%Action%" equ "CE"   call :PPACustomSetting_ScriptEdit
 if /I "%Action%" equ "PS"   call :PPACustomSetting_SetupAndSave
 if /I "%Action%" equ "PR"   call :PPACustomSetting_Reset
 if /I "%Action%" equ "CT"   call :PLMPerfAnalyseCreateToolbar
 if /I "%Action%" equ "I"    call :PLMPerfAnalyseInfo

 if /I "%Action%" equ "01"  Call "%PPA_StartScript_DPNE%" "/PLMPerfDistributeSoftwareAndSettingsToLocalComputer"
 if /I "%Action%" equ "02"  Call "%PPA_StartScript_DPNE%" "/PLMPerfDistributeSettingsOnlyToLocalComputer"
 if /I "%Action%" equ "RE"  Call "%PPA_StartScript_DPNE%" "/PLMPerfSoftwareRemoveFromLocalComputer"

REM  if /I "%Action%" equ "12"   call :PLMPerfSetupConfigAndDataBaseDatabase
 if /I "%Action%" equ "21"   call :PLMPerfSetupConfigAndDataBase

 if /I "%Action%" equ "22"   call :PLMPerfServiceStartWithCheck GetStartInfo
 if /I "%Action%" equ "23"   call :PLMPerfApplicationStart
 if /I "%Action%" equ "24"   call :PLMPerfClientStart

 rem --#Doc: possible values for PPA_SetupTypeS "PPAService" "PPAJobClient"
 if /I "%Action%" equ "31"   call ApplicationSetup04-ServicesMenu.cmd "PLMPerf-Service"   "PPAService"
 if /I "%Action%" equ "32"   call ApplicationSetup04-ServicesMenu.cmd "PLMPerf-Client"    "PPAJobClient"

 if /I "%Action%" equ "CP"   call ApplicationSetup03-CreateJobProfileCustom.cmd
REM  if /I "%Action%" equ "R"    Call PLMPerf90-Tools.cmd :StartExplorer "%PPA_Root_DP%" "PPA Root Server Dir"
 if /I "%Action%" equ "ES"   Call PLMPerf90-Tools.cmd :StartExplorer "%PPA_RootS_DP%" "PPA Root Server Dir"
 if /I "%Action%" equ "EL"   Call PLMPerf90-Tools.cmd :StartExplorer "%PPA_RootL_DP%" "PPA Root Local Dir"
 if /I "%Action%" equ "EC"   Call PLMPerf90-Tools.cmd :StartExplorer "%PPA_ProfileCustomRoot_DP%" "PPA Custom Profile Root Dir"

 if /I "%Action%" equ "T"    Call :PLMPerfAnalyseTools
 if /I "%Action%" equ "PV"   Call :PathViewShow
 if /I "%Action%" equ "PI"   Call :PathViewShow

 if /I "%Action%" equ "Q" (
   Call Echo2 "----" "----"
   Call Echo2 "End with" "Quit"
   Call Echo2 "----" "----"
   timeout /T:10
   exit
 )

goto :Main_Menu

rem --------------------------------------------------------------------------
:PathViewShow
 REM -- #Doc:25.11.2025/J.Fes shows currend path settings
 call PathView
 pause
 goto :eof

rem --------------------------------------------------------------------------
:PLMPerfServiceStartWithCheck
 REM -- #New:24.02.2025/J.Fes start PLMPerf Service
 setlocal
  call "ProgIs_Running.cmd" "PLMPerformanceAnalytics.S" PPA_PLMPerfService_isRunning EchoOff
  set StartInfo=%~1
REM   Echo #Debug LI: 129 StartInfo:%StartInfo%
  Echo #Debug LI: 130 PPA_PLMPerfService_isRunning:%PPA_PLMPerfService_isRunning%&Pause

  if "%PPA_PLMPerfService_isRunning%" equ "0" goto :Next
    call Echo2 "####" "####"
    Call Echo2 "%PPA_PLMPerfService_NE%" "Info:is already started"
    call Echo2 "####" "####"
    timeout /T:10
  goto :myEnd

:Next
  set toRun="%PPA_StartScript_DPNE%" /PPAServer -p %PPA_CustomProfile_N%
  set toRunForPrint=%toRun:"='%
  call Echo2 "####" "####"
  Call Echo2 "PLMPerf Start Service via" "%toRunForPrint%"
  Call %toRun%
  timeout /T:2
  call Echo2 "####" "####"
:myEnd
 endlocal
goto :eof

rem --------------------------------------------------------------------------
:PLMPerfSetupConfigAndDataBase
 REM -- #New:24.02.2025/J.Fes Setup PLMPerf Service
 setlocal
  rem call :PLMPerfServiceStartWithCheck

REM   set toRun="%PPA_StartScript_DPNE%" /PLMPerfSetupServices -p %PPA_CustomProfile_N%
  set toRun="%PPA_StartScript_DPNE%" /PLMPerfSetup -p %PPA_CustomProfile_N%
  set toRunForPrint=%toRun:"='%
  call Echo2 "####" "####"
  Call Echo2 "PLMPerf Setup Service via" "%toRunForPrint%"
  Call %toRun%
  timeout /T:2
  call Echo2 "####" "####"
 endlocal
goto :eof


rem --------------------------------------------------------------------------
:PLMPerfApplicationStart
 setlocal
  set toRun="%PPA_StartScript_DPNE%" /PLMPerfApp -p %PPA_CustomProfile_N%
  set toRunForPrint=%toRun:"='%
  call Echo2 "####" "####"
  Call Echo2 "PLMPerf Application Start via" "%toRunForPrint%"
  Call %toRun%
  timeout /T:2
  call Echo2 "####" "####"
 endlocal
goto :eof

rem --------------------------------------------------------------------------
:PLMPerfClientStart
 setlocal
  set toRun="%PPA_StartScript_DPNE%" /JobClient /PLMPerf_ProfileName %PPA_CustomProfile_N%
  set toRunForPrint=%toRun:"='%
  call Echo2 "####" "####"
  Call Echo2 "PLMPerf Client Start via" "%toRunForPrint%"
  Call %toRun%
  timeout /T:2
  call Echo2 "####" "####"
 endlocal
goto :eof




rem --------------------------------------------------------------------------------------------------------------------
:PPACustomSetting_Check

 :PPACustomSetting_CheckDoMark
 Call :PPACustomSetting_Read
 if not defined PPA_CustomProfileAdm_N goto :PPACustomSetting_CheckDoSetup
 if defined PPA_CustomProfileAdm_N goto :PPACustomSetting_Done

:PPACustomSetting_CheckDoSetup
 Call Echo2 "#--#" "#--#"
 Call Echo2 "Please Setup first" "Custom-Profile-Name for:%PPA_ToolInfo%"
 Call Echo2 "After push return" "Dialog for Setup Custom-Profile-Name is starting"
 timeout /T:50
 Call Echo2 "#--#" "#--#"

 Call :PPACustomSetting_SetupAndSave
 goto :PPACustomSetting_CheckDoMark

:PPACustomSetting_Done

REM  set PPA_CustomProfile_N=%PPA_CustomProfileAdm_N%
 Call :PPACustomSetting_Read
 set PPA_ToolBarStartProfile_TP=02-Start Profile (%PPA_CustomProfile_N%)
 set PPA_ToolBarStartProfile_DP=%PPA_ToolBar_DP%\%PPA_ToolBarStartProfile_TP%

 set PPA_ToolBarStartProfile_DP_Status=WRN:Not Exist
 if exist "%PPA_ToolBarStartProfile_DP%" set PPA_ToolBarStartProfile_DP_Status=OK:Exist

 set PPA_ProfileCustomRoot_DP_Status=WRN:Not Exist
 if exist "%PPA_ProfileCustomRoot_DP%\10-JobScripts" set PPA_ProfileCustomRoot_DP_Status=OK:Exist
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PPACustomSetting_Reset
  Call Echo2 "----" "----"
  Call Echo2 "PLMPerfAnalyse custom settings" "is reset to default"
  Call Echo2 "Reset is done via delete"       "Custom setting file:'%PPA_ProfileCustomBaseAdmRoot_DPNE%'"
  if exist "%PPA_ProfileCustomBaseAdmRoot_DPNE%" del "%PPA_ProfileCustomBaseAdmRoot_DPNE%"
  set PPA_CustomProfile_N=
  Call timeout /T:10
  Call Echo2 "----" "----"
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PPACustomSetting_Read
 rem -- #Doc: read settings stored in PPA_ProfileCustomBaseAdmRoot_DPNE
REM  Echo #D:260 PPA_ProfileCustomBaseAdmRoot_DPNE:%PPA_ProfileCustomBaseAdmRoot_DPNE%
REM  Echo #D:261 PPA_RootS_DP:%PPA_RootS_DP%
REM  set PPA_RootS_DP=
REM  if not defined PPA_RootS_DP Call :PPACustomSetting_Save
 if exist "%PPA_ProfileCustomBaseAdmRoot_DPNE%" call "%PPA_ProfileCustomBaseAdmRoot_DPNE%"
REM  Call "%~dp0PLMPerf03-EnvSet.cmd" ":PPA_EnvSet"
REM  pause
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PPACustomSetting_ScriptEdit

 Call Echo2 "----" "----"
 Call Echo2 "Edit Custom Start Script"  "%PPA_CustomStartScript_DPNE%"

 if not exist "%PPA_CustomStartScript_DPNE%" (
  Call Echo2 "Create new" "CustomStartScript"
  Call Echo2 "from Source" "%PPA_CustomStartScriptTemplate_DPNE%"
  Call Echo2 "to Target"   "%PPA_CustomStartScript_DPNE%"
  copy "%PPA_CustomStartScriptTemplate_DPNE%" "%PPA_CustomStartScript_DPNE%"
  Call Echo2 "Please Edit new Script" "%PPA_CustomStartScript_DPNE%"
  timeout /T:4
 )
 Call Echo2 "----" "----"
 start "TxtEditor" "%PPA_TxtEditor_exe_DPNE%" "%PPA_CustomStartScriptTemplate_DPNE%" "%PPA_CustomStartScript_DPNE%"
 timeout /T:4

goto :eof


rem --------------------------------------------------------------------------------------------------------------------
Rem "PS" :PPACustomSetting_SetupAndSave"
:PPACustomSetting_SetupAndSave
 Echo.
 Call Echo2 "----" "----"
 Call Banner "PPA settings"
REM  Call Echo2 "----" "----"
 Call Echo2 "PPA Root-S" "%PPA_RootS_DP%"
 Call Echo2 "PPA Root-L"  "%PPA_RootL_DP%"
 Call Echo2 "PPA settings stored in" "%PPA_CustomProfileSett_DPNE%"
 Call Echo2 "----" "----"
 Call Echo2 "."
 Call Echo2 "Please Setup" "Custom PPA settings"

 rem -- #Doc: set PPA_CustomProfile_N
 Call Echo2 "#Doc:Custom-Profile-Name" "is required to organice the global custom settings for:%PPA_NameS%"
 Call Echo2 "Hint:For Profile-Name"    "you can use your company Short-Name"
 if defined PPA_CustomProfileAdm_N Call Echo2 "Please set Profile-Name" "push Return to use current Profile-Name.: '%PPA_CustomProfileAdm_N%'"
 set /P PPA_CustomProfileAdm_N="Please set PPA Profile-Name.....: "

 rem set PPA_ProfileCustomRoot_DP=\
 set PPA_ProfileCustomRoot_DP=
 Call DirChkCreate.cmd "%PPA_ProfileCustomBaseRoot_DP%" "%PPA_CustomProfileAdm_N%" PPA_ProfileCustomRoot_DP

 rem -- #Doc: set PPA_CustomPLMPerfServer_N
 REM  set PPA_CustomProfileSett_DPNE=%PPA_ProfileCustomRoot_DP%\02-PPA_CustomProfileSetting.cmd
 if exist "%PPA_CustomProfileSett_DPNE%" call "%PPA_CustomProfileSett_DPNE%"

 if not defined PPA_CustomPLMPerfServer_N set PPA_CustomPLMPerfServer_N=%ComputerName%
 Call Echo2 "Please set PPA-Server Name" "push Return to use current PPA-Server Name: '%PPA_CustomPLMPerfServer_N%'"
 set /P PPA_CustomPLMPerfServer_N="Please set PPA-Server Name......: "

 Call :PPACustomSetting_Save

 Call Echo2 " ---" "----"
 Call Echo2 "PPA Profile Name"  "is set to:'%PPA_CustomProfile_N%'"
 Call Echo2 "PPA Server"        "is set to:'%PPA_CustomPLMPerfServer_N%'"
 Call Echo2 "PPA Root-S"        "is set to:'%PPA_RootS_DP%'"
 Call Echo2 "PPA Root-L"        "is set to:'%PPA_RootL_DP%'"
 Call Echo2 "PPA settings"      "stored in: %PPA_CustomProfileSett_DPNE%"
 Call timeout /T:20
 Call Echo2 " ---" "----"
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PPACustomSetting_Save

 rem -- #Doc: create PPA_ProfileCustomBaseAdmRoot_DP dir
 if not exist "%PPA_ProfileCustomBaseAdmRoot_DP%" md "%PPA_ProfileCustomBaseAdmRoot_DP%"

 set PPA_CustomSetupLastUpdate=REM #LUp:'Done:%Date% %time% at:%ComputerName% by:%UserName%'
 REM -- #Doc:24.11.2025/J.Fes save settings to PPA_ProfileCustomBaseAdmRoot_DPNE
 Echo @Echo off>"%PPA_ProfileCustomBaseAdmRoot_DPNE%"
 Echo %PPA_CustomSetupLastUpdate%>>"%PPA_ProfileCustomBaseAdmRoot_DPNE%"
 Echo set PPA_CustomProfileAdm_N=%PPA_CustomProfileAdm_N%>>"%PPA_ProfileCustomBaseAdmRoot_DPNE%"
 Echo set PPA_RootS_DP=%PPA_RootS_DP%>>"%PPA_ProfileCustomBaseAdmRoot_DPNE%"

 REM -- #Doc:21.02.2025/J.Fes save settings to PPA_CustomProfileSett_DPNE
 set PPA_CustomProfile_N=%PPA_CustomProfileAdm_N%
 Echo @Echo off>"%PPA_CustomProfileSett_DPNE%"
 Echo %PPA_CustomSetupLastUpdate%>>"%PPA_CustomProfileSett_DPNE%"
 Echo set PPA_CustomProfile_N=%PPA_CustomProfile_N%>>"%PPA_CustomProfileSett_DPNE%"
 Echo set PPA_CustomPLMPerfServer_N=%PPA_CustomPLMPerfServer_N%>>"%PPA_CustomProfileSett_DPNE%"
 Echo set PPA_RootS_DP=%PPA_RootS_DP%>>"%PPA_CustomProfileSett_DPNE%"

REM  Call Echo2 "PPA_AdmSettS_DP"  "is set to:'%PPA_AdmSettS_DP%'"
REM  Call Echo2 "PPA_AdmSettL_DP"  "is set to:'%PPA_AdmSettL_DP%'"
REM  Pause
 Call "%PPA_BinPublicL_DP%\CopyFromTo.cmd" "PPA ..\_AdminSettings to local" "%PPA_AdmSettS_DP%"  "*.*" "%PPA_AdmSettL_DP%" "*.*"  "/MIR /XF *.bak *.tmp ~*.*" "PrintYes"

REM  pause

goto :eof



rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfAnalyseCreateToolbar
 Call "%PPA_StartScript_DPNE%" "/PLMPerfDistributeSoftwareAndSettingsToLocalComputer"
 Call :Toolbar_Backup
REM  Call :BaseLinksCreate
 rem Call :PLMPerfCreateStartLinks 91-PLMPerfAnalyseStart "%PPA_CustomProfile_N%" %JobPlanerLinkDoCreate%
 Call "ApplicationSetup02-CreateToolbar.cmd"
 Call :StartMenuCreateDone
 goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:Toolbar_Backup
 rem #New 17.03.2023
REM  Call Echo2 "#D:31.10.24 %~0" "Not Activ because under development"
REM  goto :eof
 if not exist "%PPA_ToolBar_DP%" goto :Toolbar_Backup_end
 set toRun=robocopy "%PPA_ToolBar_DP%" "%PPA_ToolBar_Backup_DP%" "*.*" /xf *.tmp ~*.* *.bak /NP /TBD /TEE /R:4 /W:1 /MIR
 Call Echo2 "----" "----"
 Call Echo2 "Backup Toolbar from dir" "%PPA_ToolBar_DP%"
 Call Echo2 "Backup Toolbar to dir" "%PPA_ToolBar_Backup_DP%"
 Call %toRun% >nul
 Call Echo2 "Backup Toolbar" "Done"
 timeout /T:5
 :Toolbar_Backup_end
 goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfAnalyseInfo
 Call :PLMPerfDialogHeader "Settings"
 Call Echo2 "#--#" "#--#"
 Call Echo2 " PLMPerfAnalyse Profile Template"  "%PPA_ProfileTemplates_DP%"
 Call Echo2 " PLMPerfAnalyse Root"              "%PPA_Root_DP%"
 Call Echo2 " PLMPerfAnalyse Using Icon Dir"    "%PPA_ResIcons_DP%"
 Call Echo2 " PLMPerfAnalyse Toolbar"           "%PPA_ToolBar_DP%"
 Call Echo2 " PLMPerfAnalyse Toolbar Backup"    "%PPA_ToolBar_Backup_DP%"
 Call Echo2 "#--#" "#--#"
 pause
 goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfAnalyseTools

:PLMPerfAnalyseTools_Dialog
 Call :PLMPerfDialogHeader "Tools Dialog"
 Call Echo2 "."
 Call Echo2 " 7zC = Clean 7z" "History Entries from Regestrie"
 Call Echo2 "."

 Call Echo2 " Q  = Quit"                       "End %PPA_ToolInfo%"
 set ToolSelect=
 Call Echo2 "."
 set /P ToolSelect="... please select tool: "
 Call Echo2 "."

 if /I "%ToolSelect%" equ "7zc" Call PLMPerf90-Tools.cmd :7zClean
 if /I "%ToolSelect%" equ "Q" goto :MyEnd

 goto :PLMPerfAnalyseTools_Dialog
:MyEnd
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfDialogHeader
 Call Echo2 "."
 Call Echo2 "."
 Call Echo2 "."
 Call Echo2 " ---" "----"
 Call Banner Profile:%PPA_CustomProfile_N%
 Call Echo2 " ---" "----"
 Call Echo2 " PLMPerfAnalyse Custom Profile" "%PPA_CustomProfile_N%"
 Call Echo2 " PLMPerfAnalyse PLMPerfServer"  "%PPA_CustomPLMPerfServer_N%"
 Call Echo2 " ---" "----"
 Call Echo2 " PLMPerfAnalyse"                "%~1"
 Call Echo2 " PLMPerfAnalyse Version"        "%PPA_VerInfo%"
 Call Echo2 " PLMPerfAnalyse Build"          "%PPA_AppVerBuild%"
 Call Echo2 " ---" "----"
 goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:StartMenuCreateDone
 Call :DesktopRefresh
 if /I "%Quiet%" equ "true"  goto :eof
 Call ColorSet OK
 Echo.
 Call Echo2 "----" "----"
 Call Echo2 "Result created Toolbar" "%PPA_ToolBar_DP%"
 Call Echo2 "----" "----"
 Call Echo2 "."
 Call Echo2 "Info next" "Do Explorer the created startmenu?"
 Call Echo2 "."
 Call Echo2 " Y = Start Explorer"  "Explore:Yes the created startmenu"
 Call Echo2 " N = Start Explorer"  "Explore:Not the created startmenu"
 Call Echo2 "."

 set Action=Y
 set /P Action="... please select Command: "
 Call Echo2 "."

 if /I "%Action%" equ "Y" start "" explorer.exe /e,%PPA_ToolBar_DP%
 set Action=

 Call Echo2 "----" "----"
 goto :eof


rem ============================================================================
:DesktopRefresh
 rem #New:22.02.2016/J.Fes
 Rem #Doc:refeshes the desktop
 Call Echo2 "----" "----"
 Call Echo2 "DesktopRefresh Do" "via %PPA_BinPublic_DP%\DesktopRefresh.exe"
 Call "%PPA_BinPublic_DP%\DesktopRefresh.exe"
 Call Echo2 "DesktopRefresh Done" "via %PPA_BinPublic_DP%\DesktopRefresh.exe"
goto :eof


rem ============================================================================
:Ende

 exit /B

