REM -------------------------------------------------------------------------
REM  #Description.............: Methodes to Org:PLMPerf Tools
REM  #New.....................: 25.10.2024/jopp
REM  #LUp.....................: 08.11.2024/jopp
REM -------------------------------------------------------------------------
REM #EXA: Call PLMPerf90-Tools.cmd ":LinkCreate" %*
REM #EXA: Call PLMPerf90-Tools.cmd ":LinkCreate_URL" %*
REM #EXA: Call PLMPerf90-Tools.cmd ":PathCutLastDir" %*
REM #EXA: Call PLMPerf90-Tools.cmd ":PathRootDirTP" %*
REM #EXA: Call PLMPerf90-Tools.cmd ":PathRootDirAbs" %*
REM #EXA: Call PLMPerf90-Tools.cmd ":DirDefineAndCreateIfNotExist" %*
REM #EXA: Call PLMPerf90-Tools.cmd :7zClean
REM #EXA: Call PLMPerf90-Tools.cmd :DelFilesIfExist %*
REM #EXA: Call PLMPerf90-Tools.cmd :DelDirIfExist %*
REM #EXA: Call PLMPerf90-Tools.cmd :CleanDirIfExist %*
set JobMgr_EchoLog_DPNE=.
if "%~1" neq "" call %~1 %*
goto :eof

rem --------------------------------------------------------------------------------------------------------------------

:LinkCreate
 rem #Doc: Create the Link via
 rem #New: 01.03.2021/J.Fes
 rem #LUp: 17.03.2023/J.Fes P9 = delete link
 setlocal
 shift

 set Description=%~1
 set LinkDest_DPNE=%~2
 set LinkFile_DPNE=%~3
 set LinkFile_DP=%~dp3
 set LinkFile_DP=%LinkFile_DP:~0,-1%
 set LinkFile_NE=%~nx3
 set IconFile_DPNE=%~4
 set Arguments=%~5
 set DisplayMode=%~6
 set DisplayMode=
 set WorkDir=%~7
 set FolderLink=%~8
 set LinkFileCopyTo_DP=%~9

:Next
 rem set /p= - Check File exist .............: %~1 <nul
 Call Echo2 "."
 Call Echo2 " - Create Link for"  "%Description%"
 Call Echo2 " - Link file"        "%LinkFile_DPNE%"
 Call Echo2 " - Link points to"   "%LinkDest_DPNE%"
 if defined IconFile_DPNE (
  Call Echo2 " - Using IconFile"   "%IconFile_DPNE%"
 ) else (
  Call Echo2 " - Using IconFile"   "NO"
 )

 if not exist "%LinkDest_DPNE%" goto :ErrExit

 set toRun=jfShellLinkCreate.exe
 if /i "%JobMgr_Debug%" neq "ON" set toRun=%toRun% /Quiet
 set toRun=%toRun% /LinkFile="%LinkFile_DPNE%"
 set toRun=%toRun% /LinkDest="%LinkDest_DPNE%"

 if "%IconFile_DPNE%" neq "" set toRun=%toRun% /IconFile="%IconFile_DPNE%"
 if "%Arguments%"     neq "" set toRun=%toRun% /Arguments="%Arguments%"
 if "%DisplayMode%"   neq "" set toRun=%toRun% /DisplayMode="%DisplayMode%"

 if "%WorkDir%"       equ "" goto :next
 if "%WorkDir:~0,1%"  equ "#" Call :WorkDirSetValue
 if "%WorkDir%"       neq "" set toRun=%toRun% /WorkDir="%WorkDir%"
 :Next
 if "%Description%"   neq "" set toRun=%toRun% /Description="%Description%"
 if "%FolderLink%"    neq "" set toRun=%toRun% /FolderLink

 Call %toRun%

 if defined LinkFileCopyTo_DP Call CopyFromTo.cmd "" "%LinkFile_DP%" "%LinkFile_NE%" "%LinkFileCopyTo_DP%" "%LinkFile_NE%"  "" "PrintNo"

 goto :MyExit

 :ErrExit
 Call Echo2 "- ERR Cr.Link Issue" "Destination Dir or file not found"
 Call Echo2 "- Destination Dir or file" "%LinkDest_DPNE%"
 Call Echo2 "- please check" "Installation"
 Pause
 :MyExit
 endlocal
goto :eof

:WorkDirSetValue
 set WorkDir=%WorkDir:#=%
 set PChar=%%%
 set WorkDir=%PChar%%WorkDir%%PChar%
 goto :eof
rem --------------------------------------------------------------------------------------------------------------------
:LinkCreate_URL
 rem Usage
 rem call :LinkCreate_URL "%DestFile_DPNE%" "%URL%" "%Icon%"
 shift
 set Link_NE=%~nx1
 set Link_DPNE=%~1
 set URL=%~2
 set Icon=%~3
 Call Echo2 " - Create URL for" "%Link_NE%"

 echo [InternetShortcut] >"%Link_DPNE%"
 echo URL=%URL% >>"%Link_DPNE%"
 echo IconFile=%Icon% >>"%Link_DPNE%"
 echo IconIndex=0 >>"%Link_DPNE%"
goto :eof
rem --------------------------------------------------------------------------------------------------------------------
:7zClean
 rem #New:08.11.2024/J.Fes removes for 7z History entries from Regestrie
 REM #EXA: Call PLMPerf90-Tools.cmd :7zClean
 Call Echo2 "#--#" "#--#"
 Call Echo2 "7Z Clean Start" "History entries from regestrie"
 Call Echo2 "7Z" "Clean HKCU\Software\7-Zip\FM\CopyHistory"
 Call reg.exe delete HKCU\Software\7-Zip\FM /v CopyHistory   /f  1>nul 2>nul
 Call Echo2 "7Z" "Clean HKCU\Software\7-Zip\FM\FolderHistory"
 Call reg.exe delete HKCU\Software\7-Zip\FM /v FolderHistory /f  1>nul 2>nul
 Call Echo2 "7Z" "Clean HKCU\Software\7-Zip\FM\PanelPath0"
 Call Echo2 "7Z" "Clean HKCU\Software\7-Zip\FM\PanelPath0"
 Call reg.exe delete HKCU\Software\7-Zip\FM /v PanelPath0    /f  1>nul 2>nul
 Call Echo2 "7Z Clean Done" "History entries from regestrie"
 Call Echo2 "#--#" "#--#"
 timeout /T:4

 goto :eof
rem --------------------------------------------------------------------------------------------------------------------
:PathCutLastDir
 rem schneidet das letzte Verzeichniss Uebergeben path ab
 rem P1 = Name der Variablen
 rem P2 = der bergebene Path
 rem Example : call :PathCutLastDir EntwRoot_LP %~dp0
 rem Example : call :PathCutLastDir MyVar %~dp0
 shift
 set PathCutLastDir$temp=%~2
 set PathCutLastDir$tempLastChar=%PathCutLastDir$temp:~-1%
 set PathCutLastDir$tempNoBacks=%PathCutLastDir$temp:~0,-1%

 if "%PathCutLastDir$tempLastChar%"=="\" (
   rem "\" abschneiden wenn vorhanden
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$tempNoBacks%
 ) else (
   rem
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$temp%
 )
 set PathCutLastDir$tempRes=%PathCutLastDir$tempRes:~0,-1%
 set %1=%PathCutLastDir$tempRes%
 set PathCutLastDir$temp=
 set PathCutLastDirDo$temp1=
 set PathCutLastDir$tempNoBacks=
 set PathCutLastDir$tempNoLastChar=
 set PathCutLastDir$tempLastChar=
 set PathCutLastDir$tempRes=
 goto :eof

:PathCutLastDirDo
 rem hiermit schneiden wir den Path ab
 rem echo.
 rem Echo P1=%1 P2=%2
 set PathCutLastDirDo$temp=%~dp2
 rem "\" abschneiden
 set PathCutLastDirDo$temp1=%PathCutLastDir$temp:~0,-1%
 set %1=%PathCutLastDirDo$temp%
 set PathCutLastDirDo$temp=
 set PathCutLastDirDo$temp1=
 goto :eof

rem ============================================================================
:PathRootDirTP
 REM  #New 22.02.2016/J.Fes
 rem parses from DIR last path section and sets value to:%1
 shift
 set %1=%~n2
goto :eof

:PathRootDirAbs
 shift
 set Parse_Absolut_DP$$Tmp=%~dp2
 set %1=%Parse_Absolut_DP$$Tmp:~0,-1%
 set Parse_Absolut_DP$$Tmp=
goto :eof

rem ============================================================================
:DirDefineAndCreateIfNotExist
 rem #Exa: Call PLMPerf90-Tools.cmd ":DirDefineAndCreateIfNotExist" DocCustom_DP "%PPA_Root_DP%\11-Documentation.Custom
 shift
 if "%~2" equ "" goto :MyERR1
 set %~1=%~2
 if exist "%~2" goto :MyEnd
 Echo - Create dir....................: %~2
 md "%~2"
 goto :MyEnd

:MyERR1
 call ColorSet ERR
 Call Echo2 "----" "----"
 Echo - ERR in ......................: Call: %0
 Echo - Info handover Parameters.....: %*
 Echo - Issue missing Parameter......: P1 or P2
 Call Echo2 "----" "----"
 Echo - ToDo.........................: Please fix issue cannot continue
 Echo - ToDo.........................: after pressing the Enter key the script is terminated
 Echo.
 Pause
 Exit
 goto :MyEnd
:MyEnd
 goto :eof

rem ============================================================================
:DelFilesIfExist
 rem #Exa: Call PLMPerf90-Tools.cmd ":DelFilesIfExist" "%PPA_Root_DP%\SubDir\MyFile.txt
 shift
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo #Debug: %0
  Echo #Debug: %~1
  Dir  "%~1"
  pause
:JumbOverDebug

 if not exist "%~1" goto :DelFilesIfExistEnd
 Call Echo2 " - Delete files" "%~1"
 del "%~1"
 goto :DelFilesIfExistEnd
:DelFilesIfExistEnd
goto :eof
rem ============================================================================
:DelDirIfExist
 rem #Exa: Call PLMPerf90-Tools.cmd ":DelDirIfExist" "%PPA_Root_DP%\SubDirName"
 shift
 if not exist "%~1" goto :DelDirIfExistEnd
 Call Echo2 " - Delete dir" "%~1"
 rd /s /q "%~1"
 goto :DelDirIfExistEnd
:DelDirIfExistEnd
 goto :eof

rem ============================================================================
:CleanDirIfExist
 REM #New: 18.10.2019/J.Fes
 rem #Exa: Call PLMPerf90-Tools.cmd ":CleanDirIfExist" "%PPA_Root_DP%\SubDirName"
 shift
 if not exist "%~1" goto :CleanDirIfExistEnd
 Call Echo2 " - CleanUp dir" "%~1\*.*"
 del /s /q "%~1\*.*" >nul
 goto :CleanDirIfExistEnd
:CleanDirIfExistEnd
 goto :eof


:GenFolderLinks
REM 27.11.2024
REM C:\Windows\system32>subst V: D:\addplm
REM
REM C:\Windows\system32>cd /d V:\JobManager\ProgEntw\Ver03\PLMPerfV4\20-PLMPerf.Profiles.Custom\addPLM
REM
REM V:\JobManager\ProgEntw\Ver03\PLMPerfV4\20-PLMPerf.Profiles.Custom\addPLM>mklink /D 10-JobScripts ..\..\04-PLMPerf.Profile.Templates\10-JobScripts
REM symbolische Verknpfung erstellt fr 10-JobScripts <<===>> ..\..\04-PLMPerf.Profile.Templates\10-JobScripts
REM
REM V:\JobManager\ProgEntw\Ver03\PLMPerfV4\20-PLMPerf.Profiles.Custom\addPLM>

goto :eof

:StartExplorer
 setlocal
  shift
  set Explore_DP=%~1
  set Info_txt=%~2

  Echo.
  Call Echo2 "****"
  Call Echo2 "*" "Explor PPA dir...: '%Info_txt%'"
  Call Echo2 "*" "Via Win-Explorer.: '%Explore_DP%'"
  start "" explorer.exe /e,"%Explore_DP%"
  Call Echo2 "****"
  timeout /T:3
  Echo.
 endlocal
 goto :eof

