@Echo off
rem -----------------------------------------------------------------------------------------
rem Description: copy JobMgr Application PPA_Start from:PPA_ResPPA_StartS_DP to:PPA_ResPPA_StartL_DP
rem #New: 31.10.2024/J.Fes
rem #LUp: 31.10.2024/J.Fes set inital version
rem #Doc: ENV PPA_ResPPA_StartS_DP PPA_ResPPA_StartL_DP is defined via PLMPerf03-EnvSet.cmd

REM Echo #Debug LI:8 %~nx0
REM Echo #Debug LI:8 PPA_ResPPA_StartS_DP:%PPA_ResPPA_StartS_DP%
REM Echo #Debug LI:8 PPA_ResPPA_StartL_DP:%PPA_ResPPA_StartL_DP%&Pause

rem -----------------------------------------------------------------------------------------
rem Description: copy JobMgr Application PPA_Start from:PPA_ResPPA_StartS_DP to:PPA_ResPPA_StartL_DP
REM -- #Doc: Script PLMPerf02-InitForCurentComputer.cmd
rem -- #New: 24.03.2021/J.Fes
rem -- #LUp: 05.08.2022/J.Fes add ropcopy parameter /A-:R removes write protection in target
rem -- #LUp: 10.03.2023/J.Fes add JobMgr_ResPPA_Start_DP
REM -- #LUp:13.11.2025/J.Fes refactoring Script
REM Echo #D:19: %~dpnx0
REM REM PLMPerf02-InitForCurentComputer.cmd
REM pause


setlocal
 set PPA_BinPublicS_DP=%~dp0..\..\03-BinPublic
 set PPA_BinPublicL_DP=%ProgramData%\PLMPerfV4\03-BinPublic
 set PPA_StartS_DP=%~dp0
 set PPA_StartS_DP=%PPA_StartS_DP:~0,-1%
 set PPA_StartL_DP=%ProgramData%\PLMPerfV4\01-PLMPerf.Applications\00-StartEnv


 REM -- #Doc:13.11.2025/J.Fes if call is done from local then nothing is todo
 if /I "%~dp0" equ "%PPA_BinPublicL_DP%" goto :MyEnd
  Call %~dp0ColorSet "INIT"
REM   Echo #D:35 before Call :Check_03-BinPublic %~nx0&Pause
  Call :Check_03-BinPublic
REM   Echo #D:37 before Call :Check_00-PPA_Start %~nx0&Pause
  Call "%PPA_BinPublicL_DP%\PathEnvAddPath.cmd" "%PPA_BinPublicL_DP%"
  Call :Check_00-PPA_Start
REM   Echo #D:39 after Call :Check_00-PPA_Start %~nx0&Pause
:MyEnd

endlocal& set PPA_BinPublicL_DP=%PPA_BinPublicL_DP%& set PPA_BinPublicS_DP=%PPA_BinPublicS_DP%& set PPA_StartS_DP=%PPA_StartS_DP%& set PPA_StartL_DP=%PPA_StartL_DP%& set PPA_AdmSettS_DP=%PPA_AdmSettS_DP%& set PPA_AdmSettL_DP=%PPA_AdmSettL_DP%&set PPA_StartFrom=%PPA_StartFrom%

 REM -- #Doc:13.11.2025/J.Fes add base path to path variable
 if /I "%PPA_BaseInit%" equ "DONE" goto :next
  call %~dp0Parse_Absolut_DP.cmd PPA_BinPublicS_DP "%PPA_BinPublicS_DP%\"
  call %~dp0Parse_Absolut_DP.cmd PPA_StartS_DP "%PPA_StartS_DP%\"
  Call %~dp0SetEnvFirstFound PPA_BinPublic_DP "%PPA_BinPublicL_DP%" "%PPA_BinPublicS_DP%"
  Call "%PPA_BinPublic_DP%\SetEnvFirstFound.cmd" PPA_Start_DP "%PPA_StartL_DP%" "%PPA_StartS_DP%"
  Call "%PPA_BinPublic_DP%\PathEnvAddPath.cmd" "%PPA_Start_DP%"
  Call "%PPA_BinPublic_DP%\PathEnvAddPath.cmd" "%PPA_BinPublic_DP%"

  Call "%PPA_BinPublic_DP%\Parse_Absolut_DP.cmd" PPA_RootS_DP "%PPA_StartS_DP%\..\..\"
  Call "%PPA_BinPublic_DP%\Parse_Absolut_DP.cmd" PPA_RootL_DP "%PPA_StartL_DP%\..\..\"

  Call "%PPA_BinPublic_DP%\Parse_Absolut_DP.cmd" PPA_AppRootS_DP "%PPA_StartS_DP%\..\%PPA_Applications_TP%"
  Call "%PPA_BinPublic_DP%\Parse_Absolut_DP.cmd" PPA_AppRootL_DP "%PPA_StartL_DP%\..\%PPA_Applications_TP%"

  set PPA_BaseInit=DONE
 :next

 Call :Get_ApplicationInfo

 if "%PPA_StartFrom%" equ "S" goto :PPA_S
 if "%PPA_StartFrom%" equ "L" goto :PPA_L

:PPA_S
 set PPA_Title=%PPA_AppTitle_S% (Start from:Server)
 set PPA_Root_DP=%PPA_RootS_DP%
 goto :MyEnd

:PPA_L
 set PPA_Title=%PPA_AppTitle_L% (Start from:Local)
 set PPA_Root_DP=%PPA_RootL_DP%
 goto :MyEnd


:MyEnd
 rem -- #Doc: Importand env var used in PPA Aplications PLMPerf_Root_DP points to PPAv4 central RootPath
 set PLMPerf_Root_DP=%PPA_Root_DP%
REM  Call Echo2 "#D:80 PPA_Root_DP" "%PPA_Root_DP% // %~nx0"&Pause


goto :eof

REM ---------------------------------------------------------------------------------
:Check_03-BinPublic

 set JobMgr_BinPublicVer=
 Call "%PPA_BinPublicS_DP%\03-BinPublicVer.cmd"
 set PPA_BinPublicVerS=%JobMgr_BinPublicVer%

 set JobMgr_BinPublicVer=unkown because fnf:'%PPA_BinPublicL_DP%\03-BinPublicVer.cmd'
 if exist "%PPA_BinPublicL_DP%\03-BinPublicVer.cmd" Call "%PPA_BinPublicL_DP%\03-BinPublicVer.cmd"
 set PPA_BinPublicVerL=%JobMgr_BinPublicVer%

 if /I "%PPA_BinPublicVerS%" equ "%PPA_BinPublicVerL%" goto :Next
 REM -- #Doc:12.11.2025/J.Fes now do Update BinPublicL_DP
 Echo --------------------------------------------------------------------------
 Echo Update 03-BinPublicL_DP.........: %PPA_BinPublicL_DP%
 Echo from 03-BinPublicS_DP...........: %PPA_BinPublicS_DP%
 Echo from Version (server)...........: %PPA_BinPublicVerL%
 Echo to Version (local)..............: %PPA_BinPublicVerS%
 timeout /T:4
 set toRun=Robocopy "%PPA_BinPublicS_DP%" "%PPA_BinPublicL_DP%" /xf *.tmp ~*.* *.bak 03-BinPublicVer.cmd user.config /NJH /NJS /NP /TBD /R:4 /W:1 /MIR
 Call %toRun%
 set RobocopyRes=%errorlevel%

 Echo --------------------------------------------------------------------------
REM  Echo Robocopy Result Code............: %RobocopyRes%
 if "%RobocopyRes%" LSS "8" (
  rem -- #Doc: special if robocopy Ok then copy to Local:03-BinPublicVer.cmd
  Copy "%PPA_BinPublicS_DP%\03-BinPublicVer.cmd" "%PPA_BinPublicL_DP%\03-BinPublicVer.cmd" 1>nul
 )

 REM -- #Doc:13.11.2025/J.Fes get final Version
 Call "%PPA_BinPublicL_DP%\03-BinPublicVer.cmd"
 set PPA_BinPublicVerL=%JobMgr_BinPublicVer%

:Next

 set SystemTrayMenu_user_config_S_DPNE=%PPA_BinPublicS_DP%\SystemTrayMenu\user.config
 set SystemTrayMenu_user_config_L_DPNE=%PPA_BinPublicL_DP%\SystemTrayMenu\user.config
 if not exist "%SystemTrayMenu_user_config_L_DPNE%" (
  rem -- #Doc: special copy 1x SystemTrayMenu Template 'user.config'
  copy "%SystemTrayMenu_user_config_S_DPNE%"  "%SystemTrayMenu_user_config_L_DPNE%" 1>nul
 )

goto :eof

REM ---------------------------------------------------------------------------------
:Check_00-PPA_Start
 REM -- #Doc:07.05.2025/J.Fes org PPA_Start local
 REM -- #LUp:21.11.2025/J.Fes
 set PLMPerf00-PPA_StartVer_NE=PLMPerf00-StartEnvVer.cmd
 set PPA_00-StartEnvVer=
 Call "%PPA_StartS_DP%\%PLMPerf00-PPA_StartVer_NE%"
 set PPA_00-StartEnvVerS=%PPA_00-StartEnvVer%

 set PPA_00-StartEnvVer=unkown because fnf:'%PPA_StartL_DP%\%PLMPerf00-PPA_StartVer_NE%'
 if exist "%PPA_StartL_DP%\%PLMPerf00-PPA_StartVer_NE%" Call "%PPA_StartL_DP%\%PLMPerf00-PPA_StartVer_NE%"
 set PPA_00-StartEnvVerL=%PPA_00-StartEnvVer%

 Call "%PPA_BinPublicL_DP%\Parse_Absolut_DP.cmd" PPA_AdmSettS_DP "%PPA_StartS_DP%\..\..\20-PLMPerf.Profiles.Custom\_AdminSettings\"
 Call "%PPA_BinPublicL_DP%\Parse_Absolut_DP.cmd" PPA_AdmSettL_DP "%PPA_StartL_DP%\..\..\20-PLMPerf.Profiles.Custom\_AdminSettings\"

 rem -- define if start from local or from
 set PPA_StartFrom=S
 if /I "%PPA_AdmSettS_DP%" equ "%PPA_AdmSettL_DP%" set PPA_StartFrom=L


 if /I "%PPA_StartFrom%" equ "L" goto :next
 if "%PPA_00-StartEnvVerS%" equ "%PPA_00-StartEnvVerL%" goto :Next
 REM -- #Doc:12.11.2025/J.Fes now do Update 00-PPA_StartL_DP
 Echo --------------------------------------------------------------------------
 Echo Update 00-PPA_StartS_DP..........: %PPA_StartL_DP%
 Echo from 00-PPA_StartS_DP............: %PPA_StartS_DP%
 Echo from Version (server)............: %PPA_00-StartEnvVerS%
 Echo to Version (local)...............: %PPA_00-StartEnvVerL%

 timeout /T:4
 set toRun=Robocopy "%PPA_StartS_DP%" "%PPA_StartL_DP%" /xf *.tmp ~*.* *.bak %PLMPerf00-PPA_StartVer_NE% /NP /NJH /NJS /TBD /R:4 /W:1 /MIR
 Call %toRun%
 set RobocopyRes=%errorlevel%
 Echo --------------------------------------------------------------------------
REM  Echo Robocopy Result Code............: %RobocopyRes%
 if "%RobocopyRes%" LSS "8" (
  rem -- #Doc: special if robocopy Ok then copy to Local:PLMPerf00-PPA_StartVer.cmd
  Copy "%PPA_StartS_DP%\%PLMPerf00-PPA_StartVer_NE%" "%PPA_StartL_DP%\%PLMPerf00-PPA_StartVer_NE%" 1>nul
 )

:Next

REM  set toRun=Robocopy  "%PPA_StartS_DP%" "%PPA_StartL_DP%" /xf *.tmp ~*.* *.bak %PLMPerf00-PPA_StartVer_NE% /NP /TBD /TEE /R:4 /W:1 /MIR
 if "%PPA_StartFrom%" equ "L"  goto :next
  set toRun=%PPA_BinPublicL_DP%\CopyFromTo.cmd "PPA _AdminSettings to local" "%PPA_AdmSettS_DP%"  "*.*" "%PPA_AdmSettL_DP%" "*.*"  "/MIR /XF *.bak *.tmp ~*.*" "PrintMin"
  Call %toRun%
:Next

 REM -- #Doc:24.11.2025/J.Fes if start local then restore settings from 01-PPA_CustomAdmSettings.cmd +  01-PPA_CustomProfileSetting_%PPA_CustomProfileAdm_N%.cmd
 if /I "%PPA_StartFrom%" neq "L" goto :next
  set toRun="%PPA_AdmSettL_DP%\01-PPA_CustomAdmSettings.cmd"
  Call %toRun%
  set toRun="%PPA_AdmSettL_DP%\01-PPA_CustomProfileSetting_%PPA_CustomProfileAdm_N%.cmd"
  Call %toRun%
  REM -- #Doc:25.11.2025/J.Fes in case Local start restore PPA_StartS_DP from PPA_RootS_DP
  set PPA_StartS_DP=%PPA_RootS_DP%\01-PLMPerf.Applications\00-StartEnv
:next

goto :eof

rem -------------------------------------------------------------------------------------------------------
:Get_ApplicationInfo
  set PPA_AppInfo_NE=ApplicationInfo.cmd
  set PPA_AppVerCmdS_DPNE=%PPA_AppRootS_DP%\01-PLMPerfApp\ApplicationInfo.cmd
  set PPA_AppVerCmdL_DPNE=%PPA_AppRootL_DP%\01-PLMPerfApp\ApplicationInfo.cmd

  Call :Get_ApplicationInfoDoGet "%PPA_AppVerCmdS_DPNE%" PPA_AppVerBuild_S PPA_AppVerInfo_S PPA_AppNameF_S PPA_AppTitle_S
  Call :Get_ApplicationInfoDoGet "%PPA_AppVerCmdL_DPNE%" PPA_AppVerBuild_L PPA_AppVerInfo_L PPA_AppNameF_L PPA_AppTitle_L

goto :eof
rem -------------------------------------------------------------------------------------------------------
:Get_ApplicationInfoDoGet
 REM -- #Doc:21.11.2025/J.Fes PPA_AppVerBuild PPA_AppVerBuild_S PPA_AppVerBuild_L is used for check Server - Local
 set %2=UNK
 set %3=UNK
 set %4=UNK
 set %5=PLMPerfV4 -//- Build:!!-UNK--!! because PPA not local installed on:%ComputerName%

 if not exist "%~1" goto :MyExit
 Call "%~1" "xGetInfo" ""

 set PPA_AppVerBuild=%PPA_VerDateTime%
 set PPA_AppVerInfo=PLMPerf:V%PPA_VerNumber:~0,3%
 set PPA_AppNameF=%ProductName%
 set PPA_AppTitle=%PPA_NameS% -//- Build:%PPA_AppVerBuild%

 set %2=%PPA_AppVerBuild%
 set %3=%PPA_AppVerInfo%
 set %4=%PPA_AppNameF%
 set %5=%PPA_AppTitle%

 :MyExit
 goto :eof



