REM -------------------------------------------------------------------------
REM  #Description.............: Methodes to Org:PLMPerf Tools
REM  #New.....................: 11.12.2024/jopp
REM  #LUp.....................: 18.02.2025/jopp
REM  #LUp.....................: 21.08.2025/jopp
REM -------------------------------------------------------------------------
REM #EXA: Call ApplicationSetup04-ServicesOrg.cmd ":PLMPerfServiceDoInstallService" %*
REM #EXA: Call ApplicationSetup04-ServicesOrg.cmd ":PLMPerfServiceRemove" %*
REM #EXA: Call ApplicationSetup04-ServicesOrg.cmd ":ServiceUserDataSetAndSave" %*

 set PPA_ServiceUserData_DP=%PPA_ProfileCustomBaseAdmRoot_DP%

 rem -- define Service Names for service type
 if "%PPA_SetupTypeS%" equ "PPAService"    Call :PLMPerfServiceDoAction_setPPAServiceNames
 if "%PPA_SetupTypeS%" equ "PPAJobClient"  Call :PLMPerfServiceDoAction_setPPAClientServiceNames

:Next
 rem restore user data
 Call :ServiceUserDataGet
 if "%~1" neq "" call %~1 %*
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:ServiceDataGet
 rem just dummy
 goto :eof


rem --------------------------------------------------------------------------------------------------------------------
:ServiceUserDataGet
 set toRun="%PPA_JobManagerCmdTools_exe_DPNE%"^
 -Action "SystemTools_2017_07"^
 -SubAction "UserDataRestoreFromFile"^
 -Title "PPA OS Service User"^
 -UserDataFile_DPNE "%PPA_ServiceUserData_DPNE%"^
 -UserDataRestoreScript_DPNE "%PPA_ServiceUserDataScript_DPNE%"^
 -UserDataRestorePreFix "PPAService_"^
 -JobData1ToProcessDoPrint "False"^
 -JobData2ResultsDoPrint "False"^
 -JobDetailsPrintSkip

 rem -- #Doc: Get from PPA_ServiceUserData_DPNE to PPA_ServiceUserDataScript_DPNE
 Call %toRun%

 rem -- #Doc: excute PPA_ServiceUserDataScript_DPNE to get UserDate into
 rem -- #Doc: Envvar PPAService_UserDomain
 rem -- #Doc: Envvar PPAService_UserName
 rem -- #Doc: Envvar PPAService_PwEncripted
 rem -- #Doc: Envvar PPAService_p
 Call "%PPA_ServiceUserDataScript_DPNE%" "PPAService_p" 1>nul 2>nul
 goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:ServiceUserDataSetAndSave
setlocal
 shift
 set PPA_ServiceUserData_DPNE_p=%~1
 set toRun="%PPA_JobManagerCmdTools_exe_DPNE%"^
 -Action "SystemTools_2017_07"^
 -SubAction "UserDataInputByUserAndSaveToFile"^
 -Title "PPA OS Service User"^
 -UserDataFile_DPNE "%PPA_ServiceUserData_DPNE_p%"^
 -JobData1ToProcessDoPrint "False"^
 -JobData2ResultsDoPrint "False"^
 -JobDetailsPrintSkip
REM -pauseOnEnd
REM -verbose
 call %toRun%
endlocal
 goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:ServiceGetStatus

 set toRun=sc.exe^
 query %PPA_ServiceTechnicalName%
 call %toRun%

 set PPA_ServiceStatus=%errorlevel%
 Call Echo2 "PPA_Service Status" "%PPA_ServiceStatus%"

 goto :eof
rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfServiceDoAction

 REM #Step: destrip application to local host
 REM  Call "%PPA_StartScript_DPNE%" "/PLMPerfDistributeSoftwareAndSettingsToLocalComputer"
 Set actionToDo=%~1

 REM #Step: set service
 set addPLMServiceHandlerExe_DPNE=%PPA_BinPublic_DP%\addPLMServiceHandler.exe
REM Dir %addPLMServiceHandlerExe_DPNE%

REM set toRun=sc.exe^
REM  create %PPA_ServiceTechnicalName%^
REM  displayname= "%PPA_ServiceDisplayName%"^
REM  start= demand^
REM  binPath= ""%PPA_PLMPerfServiceL_DP%\%PPA_PLMPerfService_NE%" -p %PPA_CustomProfile_N% --PLMPerf_Root_DP ""%PLMPerf_Root_DP%"""^
REM  obj= "%PPAService_UserDomain%\%PPAService_UserName%"^
REM  password= "%PPAService_p%"

REM -- #Doc:19.02.2025/J.Fes addPLMServiceHandlerExe_DPNE -> will automaticly generate a local copy from it selfe
REM -- #Doc:%ProgramData%\addPLMServiceHandlers\ServiceName.ServiceHandler

call Echo2 "*"
call Echo2 " #-#" "#--#"
REM call banner  %actionToDo%
call Echo2 " PLMPerfService do" "%actionToDo%"
call Echo2 " PPA Service Technical Name" "%PPA_ServiceTechnicalName%"
call Echo2 " PPA Service Description"    "%PPA_ServiceDescription%"
call Echo2 " PPA Service Handler"        "%addPLMServiceHandlerExe_DPNE%"
call Echo2 " #-#" "#--#"
call Echo2 "*"

set PPA_ServiceDoSetStatus=%PPA_SetupTypeS%

set toRun=
Call ToRunAddParam.cmd "%addPLMServiceHandlerExe_DPNE%"
rem Call ToRunAddParam.cmd --action "InstallService"
Call ToRunAddParam.cmd --action "%actionToDo%"

:AddNextParam
 shift
 if "%~1" equ "" goto :Continue
 Call ToRunAddParam.cmd %1
 goto :AddNextParam
:Continue

Call ToRunAddParam.cmd --serviceName "%PPA_ServiceTechnicalName%"
Call ToRunAddParam.cmd --serviceDescription "%PPA_ServiceDescription%"

if /I "%actionToDo%" neq "InstallService" goto :PLMPerfServiceDoActionMenu


rem --#Doc: possible values for PPA_SetupTypeS "PPAService" "PPAJobClient"
if "%PPA_SetupTypeS%" equ "PPAService"    call :PLMPerfServiceDoAction_setPPAServiceParam
if "%PPA_SetupTypeS%" equ "PPAJobClient"  call :PLMPerfServiceDoAction_setPPAClientServiceParam


rem --#Doc: next lines defines application parameters that are set for the service
rem --#Doc: this parameters are valid parameters for PLMPerfService and PLMPerfClientService

rem #toDo:
rem Done IMPLEMENT: Call ToRunAddParam.cmd --networkMap "X: \\PLMServer1\share21"
rem %PPAService_UserDomain%
REM -- #Doc:19.02.2025/J.Fes defines to use the user data as set below
REM  Call ToRunAddParam.cmd --serviceAccount "%PPAService_UserDomain%\%PPAService_UserName%; %PPAService_PwEncripted%"

REM   REM if --serviceAccount=LocalService or =LocalSystem or finaly if ServiceAccount has no access to required resources
rem Call ToRunAddParam.cmd --serviceAccount  "LocalService"
 Call ToRunAddParam.cmd --networkAuth "\\%PPA_CustomPLMPerfServer_N% %PPAService_UserDomain%\%PPAService_UserName%; %PPAService_PwEncripted%"

REM :: Setup paths
REM -- #Doc:19.02.2025/J.Fes given script will be processed after networkAuth and before starting --serviceExePath "%PPA_PLMPerfService_NE%"
rem set toRun=%toRun% --preServiceStartScript_DPNE  "\\PLMServer2\media\Trans\pre-service.cmd"

rem set toRun=%toRun% --autoCopyServiceFiles  "false"
REM -- #Doc:19.02.2025/J.Fes controls %PPA_PLMPerfService_NE% in this case restart is done after 10 sec
Call ToRunAddParam.cmd --monitorAndRestartServiceAfterSeconds 10
REM -- #Doc:19.02.2025/J:Fes controls autoupdate during running services
Call ToRunAddParam.cmd --autoUpdateWhenIsNewerFile "ApplicationInfo.cmd"
Call ToRunAddParam.cmd --autoUpdateWhenIsNewerFile "%PPA_PLMPerfService_NE%"
REM -- #Doc:19.02.2025/J.Fes if set then autoUpdate is enabled else is disabled
Call ToRunAddParam.cmd --autoCopyServiceFiles

:: Request self-updates from this source path
Call ToRunAddParam.cmd --selfUpdateExeSource_DPNE "%addPLMServiceHandlerExe_DPNE%"

REM (Optional) use Json  file contains all parameters
REM --argumentsJson_DPNE
:PLMPerfServiceDoActionMenu
 call Echo2 "----" "----"
 call Banner %PPA_SetupType%
 call Echo2 "----" "----"

 Call Echo2 "." "."
 Call Echo2 "for PPA Service" "%PPA_ServiceDescription%"
 Call Echo2 "Hint: you need Admin rights" "to be able to install - or - remove services"
 Call Echo2 "." "."
 call Echo2 " Y = %PPA_SetupType%" "Do:%actionToDo%"
 call Echo2 " I = %PPA_SetupType%" "Do:nothing just show command and return to this dialog"
 call Echo2 " Q = Quit"            "Exit menu and do realy nothing"
 Call Echo2 "." "."

 set DoActionYesNo=
 set /P DoActionYesNo="... please select Command: "
 Call Echo2 "."

REM -- #LUp:21.08.2025/J.Fes using gsudo.exe
REM  if /I "%PPA_ServiceDoSetStatus%" equ "OK"
 if /I "%DoActionYesNo%" equ "Y" goto :Next1
 if /I "%DoActionYesNo%" equ "I" goto :Next2

goto :MyEnd

:Next1
 call "%gsudo_exe_DPNE%" %toRun%
 goto :MyEnd


:Next2
 Call Echo2 "." "."
 call Echo2 "----" "----"
 Call Echo2 "GSudo.exe" "%gsudo_exe_DPNE%"
 Call Echo2 "Info toRun command below" "is copyed to clipbord"
 Echo toRun command...................: %toRun%
 Echo %toRun%|clip
 pause
 goto :PLMPerfServiceDoActionMenu
 goto :MyEnd

:MyEnd
call Echo2 "----" "----"
set PPAService_p=

goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfServiceDoAction_setPPAServiceNames
 REM -- #Doc:26.02.2025/J.Fes set for PPAService Names
 set PPA_ServiceTechnicalName=addPLM-PLMPerf-1Server-Profile-%PPA_CustomProfile_N%
 set PPA_ServiceTechnicalName_Handler=%PPA_ServiceTechnicalName%_Handler
 set PPA_ServiceDisplayName=%PPA_ServiceTechnicalName%
 set PPA_ServiceDescription=addPLM PLMPerf Server for Profile:(%PPA_CustomProfile_N%)
goto :eof

:PLMPerfServiceDoAction_setPPAServiceParam
 REM -- #Doc:26.02.2025/J.Fes set for PPAService Setup Paramters
 set PPA_ServiceDoSetStatus=OK

 Call ToRunAddParam.cmd --serviceInstallOrUpdateSourceRoot_DP "%PPA_PLMPerfService_DP%"
 rem -- #Doc: next 2 lines defines the application that will be running as a service
 REM -- #Doc:21.02.2025/J.Fes if not set then auto %ProgramData%\%ServiceName%.ServiceLocalRoot
 Call ToRunAddParam.cmd --serviceLocalRoot_DP "%PPA_PLMPerfServiceL_DP%"
 Call ToRunAddParam.cmd --serviceExe "%PPA_PLMPerfService_NE%"

 rem --#Doc: next 3 lines defines the application parameter that are set for the service
 rem --#Doc: for PLMPerfClientService use / and not -- as parameter
 Call ToRunAddParam.cmd --serviceExeParameters "--PLMPerf_Root_DP ''%PLMPerf_Root_DP%'' --Profile ''%PPA_CustomProfile_N%'' --ExecuteOnStart ''#ServiceHandlerExe#'' --ExecuteOnStartArguments ''--action NetworkAuth''"
 REM -- #LUp:28.08.2025/J.Fes use --serviceAccount "LocalSystem" for PLMPerfService
 REM  Call ToRunAddParam.cmd --serviceAccount "LocalSystem"
 Call ToRunAddParam.cmd --serviceAccount "%PPAService_UserDomain%\%PPAService_UserName%; %PPAService_PwEncripted%"

goto :eof

:PLMPerfServiceDoAction_setPPAClientServiceNames
 REM -- #Doc:26.02.2025/J.Fes set for PPAClientService Names
 set PPA_ServiceTechnicalName=addPLM-PLMPerf-2JobClient-Profile-%PPA_CustomProfile_N%
 set PPA_ServiceTechnicalName_Handler=%PPA_ServiceTechnicalName%_Handler
 set PPA_ServiceDisplayName=%PPA_ServiceTechnicalName%
 set PPA_ServiceDescription=addPLM PLMPerf JobClient for Profile:(%PPA_CustomProfile_N%)
REM  Call Echo2 "LI:242 PPA_ServiceDescription" "%PPA_ServiceDescription%"
 goto :eof

:PLMPerfServiceDoAction_setPPAClientServiceParam
REM -- #Doc:26.02.2025/J.Fes set for PPAService Setup Paramters
 set PPA_ServiceDoSetStatus=PPA_SetupTypeS:'%PPA_SetupTypeS%':#InWOrk 12.08.2025
 set PPA_ServiceDoSetStatus=OK
 Call ToRunAddParam.cmd --serviceInstallOrUpdateSourceRoot_DP "%PPA_PLMPerfClient_DP%"
 Call ToRunAddParam.cmd --serviceLocalRoot_DP "%PPA_PLMPerfClientL_DP%"
 Call ToRunAddParam.cmd --serviceExe "%PPA_PLMPerfClientService_NE%"
 rem --#Doc: next line defines the application parameter that are set for the service
 Call ToRunAddParam.cmd --serviceExeParameters "/PLMPerf_Root_DP ''%PLMPerf_Root_DP%'' /PLMPerf_ProfileName ''%PPA_CustomProfile_N%'' /JobClient_RootL_DP ''%PPA_RootL_DP%'' /JobClient_ForcePLMPerfMode"
 Call ToRunAddParam.cmd --serviceAccount "%PPAService_UserDomain%\%PPAService_UserName%; %PPAService_PwEncripted%"

 REM  "D:\PLMPerfV4_L\01-PLMPerf.Applications\03-JobClient\PLMPerformanceAnalytics.JobClient.exe" /PLMPerf_Root_DP "D:\addPLM\JobManager\ProgEntw\Ver03\PLMPerfV4" /PLMPerf_ProfileName "addPLM" /JobClient_ForcePLMPerfMode --ExecuteOnStart "C:\ProgramData\addPLMServiceHandlers\addPLM-PLMPerf-2JobClient-Profile-addPLM.ServiceHandler\addPLM-PLMPerf-2JobClient-Profile-addPLM.ServiceHandler.exe" --ExecuteOnStartArguments "--action NetworkAuth"
goto :eof



rem --------------------------------------------------------------------------------------------------------------------
:ServiceUpdate
 set toRun=sc.exe description %PPA_ServiceTechnicalName% "%PPA_ServiceDescription%"
 Call %toRun%
 set PPA_ServiceUpdateStatus=%errorlevel%
 goto :eof
rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfServiceDoInstallService
 setlocal
 Call Echo2 "#--#" "#--#"
 Call Echo2 " Inst. PLMPerf Service using" "%PPA_ServiceUserData_DPNE%"
 Call Echo2 " Inst. PLMPerf Service SetupType" "%PPA_SetupTypeS%"
 Call :PLMPerfServiceDoAction "InstallService" --forceReinstall
 timeout /T:4
 call :PLMPerfServiceStatusGet
 endlocal
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfServiceDoUninstallService
 Call Echo2 "#--#" "#--#"
 Call Echo2 " Remove PLMPerf Service using" "%PPA_ServiceUserData_DPNE%"
 Call Echo2 " Remove PLMPerf Service SetupType" "%PPA_SetupTypeS%"
 Call :PLMPerfServiceDoAction "UninstallService"
 timeout /T:4
 call :PLMPerfServiceStatusGet
 goto :eof


rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfServiceDoStartService
 rem -- #New:18.12.2024/J.Fes
 shift
REM  Call :PLMPerfServiceDoAction "StartService"
 Call :ServerServiceConfig "%PPA_ServiceTechnicalName_Handler%" "start= delayed-auto" PPA_ServiceHandlerStartTypeSetStatus
 Call :PLMPerfServiceDo "%PPA_ServiceTechnicalName_Handler%" start PPA_ServiceHandlerStartStatus
 timeout /T:4
 Call :PLMPerfServiceStatusGet
 goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfServiceDoStopService
 rem -- #New:18.12.2024/J.Fes
 shift
REM  Call :PLMPerfServiceDoAction "StopService"
 Call :PLMPerfServiceDo    "%PPA_ServiceTechnicalName_Handler%" stop PPA_ServiceHandlerStopStatus
 Call :ServerServiceConfig "%PPA_ServiceTechnicalName_Handler%" "start= disabled" PPA_ServiceHandlerStartTypeSetStatus
 timeout /T:4
 Call :PLMPerfServiceStatusGet
 goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfServiceStatusGet
 rem -- #New:18.12.2024/J.Fes
 shift
 Call ColorSet EvalResult
 call Echo2 "#--#" "#--#"
 Call :ServerServiceQuery "%PPA_ServiceTechnicalName%" qc    PPA_ServiceConfigInfo  "Config details"
REM  Call :ServerServiceQuery "%PPA_ServiceTechnicalName%" query PPA_ServiceStatusInfo  "Current Status"
REM  call Echo2 " #-#" "#--#"
 Call :ServerServiceQuery "%PPA_ServiceTechnicalName_Handler%" qc    PPA_ServiceHandlerConfigInfo  "Config details"
REM  Call :ServerServiceQuery "%PPA_ServiceTechnicalName_Handler%" query PPA_ServiceHandlerStatusInfo  "Current Status"
 call Echo2 "#--#" "#--#"
 pause
 goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:ServerServiceQuery
 setlocal
 set ServiceTechnicalName=%~1
 set ScCommand=%~2

 set ServerServiceQuery_txt_DPNE=%temp%\PPA$temp$ServiceInfo.txt
 set ServerServiceQueryFindKeys_txt_DPNE=%temp%\PPA$temp$ServiceInfoFindKeys.txt

REM  call delIfExist.cmd "%ServerServiceQuery_txt_DPNE%"
REM  call delIfExist.cmd "%ServerServiceQueryFindKeys_txt_DPNE%"

REM  call delIfExist.cmd "%ServerServiceQuery_txt_DPNE%"
REM  call delIfExist.cmd "%ServerServiceQueryFindKeys_txt_DPNE%"
 if exist "%ServerServiceQuery_txt_DPNE%" del "%ServerServiceQuery_txt_DPNE%">nul >>nul
 if exist "%ServerServiceQueryFindKeys_txt_DPNE%" del "%ServerServiceQueryFindKeys_txt_DPNE%">nul >>nul


REM SERVICE_NAME: addPLM-PLMPerf-1Server-Profile-addPLM
REM         TYPE               : 10  WIN32_OWN_PROCESS
REM         START_TYPE         : 3   DEMAND_START
REM         ERROR_CONTROL      : 1   NORMAL
REM         BINARY_PATH_NAME   : "D:\PLMPerfV4_L\01-PLMPerf.Applications\02-Service\PLMPerformanceAnalytics.Service.exe" --PLMPerf_Root_DP "D:\addPLM\JobManager\ProgEntw\Ver03\PLMPerfV4" --Profile "addPLM" --ExecuteOnStart "C:\ProgramData\addPLMServiceHandlers\addPLM-PLMPerf-1Server-Profile-addPLM.ServiceHandler\addPLM-PLMPerf-1Server-Profile-addPLM.ServiceHandler.exe" --ExecuteOnStartArguments "--action NetworkAuth"
REM         LOAD_ORDER_GROUP   :
REM         TAG                : 0
REM         DISPLAY_NAME       : addPLM-PLMPerf-1Server-Profile-addPLM
REM         DEPENDENCIES       :
REM         SERVICE_START_NAME : JF-DO2\jopp
REM
REM SERVICE_NAME: addPLM-PLMPerf-1Server-Profile-addPLM
REM         TYPE               : 10  WIN32_OWN_PROCESS
REM         STATE              : 1  STOPPED
REM         WIN32_EXIT_CODE    : 0  (0x0)
REM         SERVICE_EXIT_CODE  : 0  (0x0)
REM         CHECKPOINT         : 0x0
REM         WAIT_HINT          : 0x0


 rem Echo SERVICE_NAME>>"%ServerServiceQueryFindKeys_txt_DPNE%"
 Echo START_TYPE>>"%ServerServiceQueryFindKeys_txt_DPNE%"
 Echo BINARY_PATH_NAME>>"%ServerServiceQueryFindKeys_txt_DPNE%"
 Echo STATE>>"%ServerServiceQueryFindKeys_txt_DPNE%"
 Echo SERVICE_START_NAME>>"%ServerServiceQueryFindKeys_txt_DPNE%"

 call Echo2 "---- " " ----"
REM  Call Echo2 "PPA Service" "%ServiceTechnicalName%"
REM  Call Echo2 "PPA Service Info" "%~4 (via:%ScCommand%)"
 Echo PPA Service Name           : %ServiceTechnicalName%
 Echo PPA Service Info           : %~4 (via:%ScCommand%)

REM  set toRun=sc.exe^
REM  %ScCommand% %ServiceTechnicalName%

 set toRun=sc.exe^
 qc %ServiceTechnicalName%
 set PPA_ServiceStatus=%errorlevel%

REM  Echo toRun:%ToRun%
 Call %toRun% >>"%ServerServiceQuery_txt_DPNE%"


 set toRun=sc.exe^
 queryex %ServiceTechnicalName%
 Call %toRun% >>"%ServerServiceQuery_txt_DPNE%"
 rem Type "%ServerServiceQuery_txt_DPNE%" |find
 findstr /g:"%ServerServiceQueryFindKeys_txt_DPNE%" "%ServerServiceQuery_txt_DPNE%"

 endlocal& set %3=%PPA_ServiceStatus%
goto :eof


rem --------------------------------------------------------------------------------------------------------------------
:ServerServiceStartTypeSet1
 shift
 Call :ServerServiceConfig "start= delayed-auto" PPA_ServiceStartTypeSetStatus
 goto :eof

:ServerServiceStartTypeSet2
 shift
 Call :ServerServiceConfig "start= auto" PPA_ServiceStartTypeSetStatus
 goto :eof

:ServerServiceStartTypeSet3
 shift
 Call :ServerServiceConfig "start= demand" PPA_ServiceStartTypeSetStatus
 goto :eof

:ServerServiceStartTypeSet4
 shift
 Call :ServerServiceConfig "start= disabled" PPA_ServiceStartTypeSetStatus
 goto :eof

rem - - - - - -
:ServerServiceConfig
 setlocal

 call Echo2 " #-#" "#--#"
 set ServiceTechnicalName=%~1
 set ScCommand=%~2
 set toRun=sc.exe^
 config %ServiceTechnicalName%^
 %ScCommand%

 Echo DoRun: %ToRun%

REM  Call Echo2 "." "."
REM  call Echo2 "----" "----"
REM  Call Echo2 "After push any key" "you will be requested to get admin rights via 'gsudo' for: '%toRun%'"
REM  pause
REM  call Echo2 "----" "----"
 call "%gsudo_exe_DPNE%" %toRun%

 set PPA_ServiceStatus=%errorlevel%
 Call Echo2 "PPA Service do %ScCommand%" "%ServiceTechnicalName%"
 Call Echo2 "PPA_Service command" "%ScCommand%"
 Call Echo2 "PPA_Service end with status" "%PPA_ServiceStatus%"
 call Echo2 " #-#" "#--#"
 pause
 endlocal& set %2=%PPA_ServiceStatus%
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:PLMPerfServiceDo

 setlocal

 call Echo2 " #-#" "#--#"
 set ServiceTechnicalName=%~1
 set ScCommand=%~2
 set toRun=sc.exe^
 %ScCommand% %ServiceTechnicalName%

REM  Call Echo2 "." "."
REM  call Echo2 "----" "----"
REM  Call Echo2 "After push any key" "you will be requested to get admin rights via 'gsudo' for: '%toRun%'"
REM  pause
REM  call Echo2 "----" "----"
 call "%gsudo_exe_DPNE%" %toRun%
 set PPA_ServiceStatus=%errorlevel%
 Call Echo2 "PPA Service do %ScCommand%" "%ServiceTechnicalName%"
REM  Call Echo2 "PPA_Service do" "%ScCommand%"
 Call Echo2 "PPA_Service end with status" "%PPA_ServiceStatus%"
 call Echo2 " #-#" "#--#"
 pause
 endlocal& set %2=%PPA_ServiceStatus%
goto :eof

rem --------------------------------------------------------------------------------------------------------------------
:StartServices_msc
 shift
 start "services.msc" services.msc
 call Echo2 " #-#" "#--#"
 Call Echo2 " Windwos Tool Service.msc" "is starting"
 call Echo2 " #-#" "#--#"
 timeout /T:4
 goto :eof

