
REM -------------------------------------------------------------------------
REM  #Description.............: PLMPerf Profiles
REM  #New.....................: 15.11.2024/jopp
REM  #LUp.....................: 18.11.2024/jopp
REM -------------------------------------------------------------------------

@Call PLMPerf01-ScrBaseChk.cmd

setlocal
 Call :PLMPerfAnalyseCreateJobProfileCustom
endlocal
goto :eof

:PLMPerfAnalyseCreateJobProfileCustom
 if not exist "%PPA_ProfileCustomRoot_DP%\10-JobScripts" goto :PPA_ProfileCustom_ExistNo
 goto :PPA_ProfileCustom_ExistYes

:PPA_ProfileCustom_ExistNo
 set Action=S
 Call Echo2 "."
 Call Echo2 " ---" "----"
 Call Echo2 " PLMPerf Custom-Profile" "%PPA_CustomProfile_N%"
 Call Echo2 " S = Custom-Profile Create"   "%PPA_ProfileCustomRoot_DP%"
 Call Echo2 " Q = Quit"                    "Do nothing and end this menu"
 Call Echo2 "."
 set /P Action=" select Action (Default=%Action%): "
 Call Echo2 "."
 if /I "%Action%" equ "S" goto :PPA_ProfileCustom_DoCreateYes
 goto :PPA_ProfileCustom_DoCreateNo

:PPA_ProfileCustom_ExistYes
 set Action=Q
 Call ColorSet ERR
 Call Echo2 " #-#" "#--#"
 Call Echo2 " PLMPerf Custom-Profile"        "%PPA_CustomProfile_N%"
 Call Echo2 " #-#" "#--#"
 Call Echo2 " !! Please Check !!"  "Custom-Profile:%PPA_CustomProfile_N% exist alrady"
 Call Echo2 "."
 Call Echo2 " Y = Do Overwrite Custom-Profile.???"  "%PPA_ProfileCustomRoot_DP%"
 Call Echo2 "     Backup will be created"           "%PPA_ProfileCustom_Backup_DP%"
 Call Echo2 " Q = Quit"                          "Do nothing and end this menu"
 Call Echo2 "."
 set /P Action=" select Action (Default=%Action%): "
 Call Echo2 "."

 if /I "%Action%" equ "Y" goto :PPA_ProfileCustom_DoCreateYes
 goto :PPA_ProfileCustom_DoCreateNo

:PPA_ProfileCustom_DoCreateYes
 Call ColorSet IsExecuting
 if exist "%PPA_ProfileCustomRoot_DP%" Call :ProfileCustom_Backup

 REM -- #Doc: #Step1: Copy *Custom*.* files into CustomProfile but do not overwrite existing *Custom*.* /XC /XO /XN
 REM -- #LUp: 20.11.2024 now only 10-JobScripts
 Call CopyFromTo.cmd "Copy-1 ..ProfileTemplates\10-JobScripts\*Custom*.* files into CustomProfile but do not overwrite existing *Custom*.*" "%PPA_ProfileTemplates_DP%\10-JobScripts" "*Custom*.*" "%PPA_ProfileCustomRoot_DP%\10-JobScripts" "*.*"  "/MIR /XC /XO /XN /XF *.bak *.tmp ~*.*" "PrintYes"
 REM -- #Doc: #Step2: Copy all files but not *Custom*.* /XF *Custom*.*
 Call CopyFromTo.cmd "Copy-2 ..ProfileTemplates\10-JobScripts\*.* files into CustomProfile files but not *Custom*.*" "%PPA_ProfileTemplates_DP%\10-JobScripts" "*.*" "%PPA_ProfileCustomRoot_DP%\10-JobScripts" "*.*"  "/MIR /XF *Custom*.* *.bak *.tmp ~*.*" "PrintYes"
 Call Echo2 "."
 Call ColorSet OK
 Call Echo2 "Custom-Profile Create"   "DONE:YES"
 goto :MyEnd

:PPA_ProfileCustom_DoCreateNo
 Call Echo2 "."
 Call ColorSet WRN
 Call Echo2 "Custom-Profile Create"   "DONE:NO"
 goto :MyEnd

:MyEnd
 timeout /T:4
 Call Echo2 " ---" "----"
goto :eof


:ProfileCustom_Backup
 rem #New 04.11.2024
 Call ColorSet IsExecuting
REM  Call Echo2 "Custom-Profile Backup from" "%PPA_ProfileCustomRoot_DP%\10-JobScripts"
REM  Call Echo2 "Custom-Profile Backup to" "%PPA_ProfileCustom_Backup_DP%\10-JobScripts"
REM  set JobMgr_Debug=ON
 Call CopyFromTo.cmd "10-JobScripts" "%PPA_ProfileCustomRoot_DP%" "*.*" "%PPA_ProfileCustom_Backup_DP%"  "*.*" "/XD 20-JobLogs /MIR /XF *.bak *.tmp ~*.*" "PrintYes"
 Call Echo2 "Custom-Profile Backup" "DONE"
REM  set JobMgr_Debug=OFF
 timeout /T:5
goto :eof




