@Echo off
REM  Dokumentation:
REM  Deploys all Software and Resources to Customer Locations
REM  this Script is used by ..\03-BinPublic.Custom\JobManagerDeploy.cmd
REM
REM  Datum        wer     Info
REM  11.12.2015   J.Fes   Ersterstellung
REM  04.11.2014   J.Fes   Update
REM  10.12.2015   J.Fes   add :DeployAllRun

REM ---------------------------------------------------------------------------

 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 Echo.
 Echo Start PLMJobManger Deploy V.2015-12
 Echo ...

 call :DateTimeNowGet
 set Log_DP=%CmdCurRoot_DP%\..\03-BinPublic.Custom\JobManagerDeploy_Log\%DateTimeNowFileExt%

 rem Get Appl Version infos
 Call "%CmdCurRoot_DP%\..\01-BinServer\ApplicationInfo.cmd" GetVerInfo

 call :PathCutLastDir JobMgrRoot_DP %~dp0

 if "%Opt_Deploy_Applic%" equ  "" set Opt_Deploy_Applic=NO
 if "%Opt_Deploy_Custom%" equ  "" set Opt_Deploy_Custom=YES


:Menu
 set path=%CmdCurRoot_DP%;%JobMgrRoot_DP%\03-BinPublic;%path%


 Call :ColorSet Standard
 set MyApplProd_NShort=JMgrV2

 set DeloyAllInfo=
 if "%D1_ShortName%" neq "" set DeloyAllInfo=%D1_ShortName%
 if "%D2_ShortName%" neq "" set DeloyAllInfo=%DeloyAllInfo% - %D2_ShortName%
 if "%D3_ShortName%" neq "" set DeloyAllInfo=%DeloyAllInfo% - %D3_ShortName%
 if "%D4_ShortName%" neq "" set DeloyAllInfo=%DeloyAllInfo% - %D4_ShortName%


 REM Creates Menu
 set MyApplTitle=JobMgr.Deploy [%CustomShort%][%MyApplProd_NShort%.%JobMgr_VerNumber%]
 Title %MyApplTitle%
 Echo.
 Echo ---------------------------------------------------------------------------------------
 Echo * %MyApplTitle% *
 Echo ---------------------------------------------------------------------------------------
 Echo.
 Echo  from.....: %LeadSiteShortName%
 Echo  Root Dir.: %JobMgrRoot_DP%
 Echo.
 if "%D1_ShortName%" equ "" goto :next
 Echo  D1  = Deploy to: %D1_ShortName%
 Echo  R1  = Explore..: %D1_ShortName%
 Echo        %D1_Root_DP%
 Echo.
:next
 if "%D2_ShortName%" equ "" goto :next
 Echo  D2  = Deploy to: %D2_ShortName%
 Echo  R2  = Explore..: %D2_ShortName%
 Echo        %D2_Root_DP%
 Echo.
:next
 if "%D3_ShortName%" equ "" goto :next
 Echo  D3  = Deploy to: %D3_ShortName%
 Echo  R3  = Explore..: %D3_ShortName%
 Echo        %D3_Root_DP%
 Echo.
:next
 if "%D4_ShortName%" equ "" goto :next
 Echo  D4  = Deploy to: %D4_ShortName%
 Echo  R4  = Explore..: %D4_ShortName%
 Echo        %D4_Root_DP%
 Echo.
:next
 Echo        Deploy Mode:
 Echo  OA  = Applic......: %Opt_Deploy_Applic% // switch YES-NO - NO-YES
 Echo  OC  = Custom......: %Opt_Deploy_Custom% // switch YES-NO - NO-YES
 Echo.
 Echo  DA  = Deploy all..: %DeloyAllInfo%
 Echo.
 Echo  L   = Open LogDir.: [%Log_DP%]
 Echo  R   = Open RootDir: [%JobMgrRoot_DP%]
 Echo  Q   = QUIT / Exit
 Echo.

 rem #New 10.12.2015/J.Fes Deploy all for Batch
 if /I "%Opt_Deploy_AutoDa%" equ "DA" (
    Echo -----------------------------------------------------------------------
    Echo Start: Deploy ALL
    call :DeployAllRun
    Echo End..: Deploy ALL and Exit
    exit /B
 )



 set doNext=
 set /P doNext="please select option: "

 if /I "%doNext%"=="Q"  Call :ColorSet Standard& Exit /B
 if /I "%doNext%"=="D1" if "%D1_ShortName%" neq "" call :Deploy1
 if /I "%doNext%"=="D2" if "%D2_ShortName%" neq "" call :Deploy2
 if /I "%doNext%"=="D3" if "%D3_ShortName%" neq "" call :Deploy3
 if /I "%doNext%"=="D4" if "%D4_ShortName%" neq "" call :Deploy4

 if /I "%doNext%"=="R1" Start  " " Explorer.exe /e, "%D1_Root_DP%"
 if /I "%doNext%"=="R2" Start  " " Explorer.exe /e, "%D2_Root_DP%"
 if /I "%doNext%"=="R3" Start  " " Explorer.exe /e, "%D3_Root_DP%"
 if /I "%doNext%"=="R4" Start  " " Explorer.exe /e, "%D4_Root_DP%"

 if /I "%doNext%"=="OA" Call :Opt_Deploy_Applic_SwitchYESNO
 if /I "%doNext%"=="OC" Call :Opt_Deploy_Custom_SwitchYESNO
 if /I "%doNext%"=="DA" call :DeployAll
 if /I "%doNext%"=="R"  Start  " " Explorer.exe /e, "%JobMgrRoot_DP%"
 if /I "%doNext%"=="L"  if not exist "%Log_DP%" md "%Log_DP%"& Start  " " Explorer.exe /e, "%Log_DP%"

goto :Menu

:Opt_Deploy_Applic_SwitchYESNO
 if /I "%Opt_Deploy_Applic%" equ "YES" set Opt_Deploy_Applic=NO& goto :eof
 if /I "%Opt_Deploy_Applic%" equ "NO"  set Opt_Deploy_Applic=YES& goto :eof
 set Opt_Deploy_Applic=YES
goto :eof

:Opt_Deploy_Custom_SwitchYESNO
 if /I "%Opt_Deploy_Custom%" equ "YES" set Opt_Deploy_Custom=NO& goto :eof
 if /I "%Opt_Deploy_Custom%" equ "NO"  set Opt_Deploy_Custom=YES& goto :eof
 set Opt_Deploy_Custom=YES
goto :eof

rem ----------------------------------------------------------------------------
:DeployAll
 set DeployMode=%~1
 Echo.
 Echo.
 Echo ----------------------------------------------------------
 Echo Deploy ALL Start: %Date% %time%
 Echo from to.........: %DeloyAllInfo%
 Echo.
 Echo  S   = Start deploy
 Echo  Q   = QUIT / Exit
 Echo.
 set /P DoNext= if using other keys (inc.Return) no deploy will be done:
 if /I not "%DoNext%"=="S" Echo.& Echo Deploy not DONE& Pause& goto :eof
 call :DeployAllRun
goto :eof


:DeployAllRun
 rem #Doc: RUN Deploy to all locations
 if "%D1_ShortName%" neq "" Call :Deploy1 "-quiet"
 if "%D2_ShortName%" neq "" Call :Deploy2 "-quiet"
 if "%D3_ShortName%" neq "" Call :Deploy3 "-quiet"
 if "%D4_ShortName%" neq "" Call :Deploy4 "-quiet"
 goto :eof



:Deploy1
 rem Deploy 1 Target
 call :Deploy "%LeadSiteShortName%" "%JobMgrRoot_DP%" "%D1_ShortName%" "%D1_Root_DP%" "%~1"
 goto :eof
:Deploy2
 rem Deploy 2 Target
 call :Deploy "%LeadSiteShortName%" "%JobMgrRoot_DP%" "%D2_ShortName%" "%D2_Root_DP%" "%~1"
 goto :eof
:Deploy3
 rem Deploy 3 Target
 call :Deploy "%LeadSiteShortName%" "%JobMgrRoot_DP%" "%D3_ShortName%" "%D3_Root_DP%" "%~1"
 goto :eof
:Deploy4
 rem Deploy 4 Target
 call :Deploy "%LeadSiteShortName%" "%JobMgrRoot_DP%" "%D4_ShortName%" "%D4_Root_DP%" "%~1"
 goto :eof


rem -------------------------------------
:Deploy
 rem P1 = Short Name of Source
 rem P2 = Source Path
 rem P3 = Short Name of Target
 rem P4 = Target Path
 rem P5 = Option -quiet
 set Source_SortName=%~1
 set Source_DP=%~2
 set Target_SortName=%~3
 set Target_DP=%~4
 set Opt_quiet=%~5


 if not exist "%Log_DP%" md "%Log_DP%"
 set Log_DPNE=%Log_DP%\%CustomShort%-from_%Source_SortName%_to_%Target_SortName%.txt
 Echo.
 Echo.
 Echo --------------------------------------------------------------------------
 Echo Deploy Start...........: %Date% %time%
 Echo from Source Dir........: %Source_SortName% %Source_DP%
 Echo to Target Dir..........: %Target_SortName% %Target_DP%
 Echo Deploy Application Dirs: %Opt_Deploy_Applic%
 Echo Deploy Custom Dis......: %Opt_Deploy_Custom%
 Echo.
 if /I "%Source_DP%" equ "%Target_DP%" (
 ECHO ERROR..................: 'from DIR' and 'to DIR' is the same
 ECHO ERROR..................: !! NO Action will be Done !!
 )


 if /i "%Opt_quiet%" equ "-quiet" goto :Start_Deploy
 Echo  S   = Start Deploy
 Echo  Q   = QUIT / Exit
 Echo.
 set /P DoNext= if using other keys (inc.Return) no Deploy will be done:
 if /I not "%DoNext%"=="S" Echo.& Echo Deploy not DONE& Pause& goto :eof

:Start_Deploy
 call :ColorSet IsExecuting

 REM removes UP to 4 SUB Dirs in Target
 if /I "%JobMgr_DelDir1%" neq "" call :DelDir "%JobMgr_DelDir1%"
 if /I "%JobMgr_DelDir2%" neq "" call :DelDir "%JobMgr_DelDir2%"
 if /I "%JobMgr_DelDir3%" neq "" call :DelDir "%JobMgr_DelDir3%"
 if /I "%JobMgr_DelDir4%" neq "" call :DelDir "%JobMgr_DelDir4%"

 if /I "%Opt_Deploy_Applic%" equ "YES" (
  call :RobocopyRun "01-BinServer"
  call :RobocopyRun "02-BinClient"
  call :RobocopyRun "03-BinPublic"

  call :RobocopyRun "10-Documentation.Application"
  call :RobocopyRun "99-Install"
 )

 if /I "%Opt_Deploy_Custom%" equ "YES" (
  call :RobocopyRun "01-BinServer.Custom" /Lev:1
  call :RobocopyRun "01-BinServer.Custom\CustomerStandards"
  call :RobocopyRun "01-BinServer.Custom\_CustomTcSQL"
  call :RobocopyRun "02-BinClient.Custom" /Lev:1
  call :RobocopyRun "03-BinPublic.Custom" /Lev:1 /XD JobManagerDeploy_Log
  call :RobocopyRun "03-BinPublic.ClientServer"

  rem #Run Deploy SettingsGlobal JobScripts
  if /I "%JobMgrSettingsGlobal_JobScripts1%" neq "" call :RobocopyRun "90-DATA\%CustomShort%_SettingsGlobal\10-JobScripts\%JobMgrSettingsGlobal_JobScripts1%"
  if /I "%JobMgrSettingsGlobal_JobScripts2%" neq "" call :RobocopyRun "90-DATA\%CustomShort%_SettingsGlobal\10-JobScripts\%JobMgrSettingsGlobal_JobScripts2%"
  if /I "%JobMgrSettingsGlobal_JobScripts3%" neq "" call :RobocopyRun "90-DATA\%CustomShort%_SettingsGlobal\10-JobScripts\%JobMgrSettingsGlobal_JobScripts3%"
  if /I "%JobMgrSettingsGlobal_JobScripts4%" neq "" call :RobocopyRun "90-DATA\%CustomShort%_SettingsGlobal\10-JobScripts\%JobMgrSettingsGlobal_JobScripts4%"
  if /I "%JobMgrSettingsGlobal_JobScripts5%" neq "" call :RobocopyRun "90-DATA\%CustomShort%_SettingsGlobal\10-JobScripts\%JobMgrSettingsGlobal_JobScripts5%"
  if /I "%JobMgrSettingsGlobal_JobScripts6%" neq "" call :RobocopyRun "90-DATA\%CustomShort%_SettingsGlobal\10-JobScripts\%JobMgrSettingsGlobal_JobScripts6%"
  if /I "%JobMgrSettingsGlobal_JobScripts7%" neq "" call :RobocopyRun "90-DATA\%CustomShort%_SettingsGlobal\10-JobScripts\%JobMgrSettingsGlobal_JobScripts7%"
  if /I "%JobMgrSettingsGlobal_JobScripts8%" neq "" call :RobocopyRun "90-DATA\%CustomShort%_SettingsGlobal\10-JobScripts\%JobMgrSettingsGlobal_JobScripts8%"
  if /I "%JobMgrSettingsGlobal_JobScripts9%" neq "" call :RobocopyRun "90-DATA\%CustomShort%_SettingsGlobal\10-JobScripts\%JobMgrSettingsGlobal_JobScripts9%"


  call :RobocopyRun "90-DATA\%CustomShort%_SettingsGlobal\20-JobComputerScripts"  /Lev:1
  call :RobocopyRun "90-DATA\%CustomShort%_SettingsGlobal\40-JobServerScripts"  /Lev:1

  rem #Run Deploy Toolbar
  if /I "%JobMgrToolbar1%" neq "" call :RobocopyRun "%JobMgrToolbar1%"
  if /I "%JobMgrToolbar2%" neq "" call :RobocopyRun "%JobMgrToolbar2%"
  if /I "%JobMgrToolbar3%" neq "" call :RobocopyRun "%JobMgrToolbar3%"
  if /I "%JobMgrToolbar4%" neq "" call :RobocopyRun "%JobMgrToolbar4%"




  rem Option: setup Links
  rem call "%Target_DP%\99-Install\Application-Startmenu-Create-or-Update.cmd"
 )

 Echo from...................: %Source_SortName% %Source_DP%
 Echo to.....................: %Target_SortName% %Target_DP%
 Echo Deploy END.............: %Date% %time%
 Echo --------------------------------------------------------------------------

goto :End_Deploy


:End_Deploy
 Echo.
 Echo --------------------------------------------------------------------------
 Echo Deploy Endet %Date% %time%
 Echo  from: %Source_SortName%
 Echo  to..: %Target_SortName%"
 Echo  Details see
 Echo  Log.: %Log_DPNE%
 rem start "" "%JobMgrRoot_DP%\03-BinPublic\PSPad editor\PSPad.exe"  "%Log_DPNE%"
 goto ende

:DelDir
 set SubDir_PP=%~1

 Echo Deploy "%SubDir_PP%"
 Title "Del Dir:[%SubDir_PP%][in:%Target_SortName%]"
 set toRun=rd /s /q "%Target_DP%\%SubDir_PP%" >>"%Log_DPNE%"
 %toRun%
 goto :eof

:RobocopyRun
 set SubDir_PP=%~1
 set RobocopyOpt=%2 %3 %4 %5 %6 %7 %8 %9
 set ExcludeFiles=%MyCurCmd% *.tmp *.bak *_.* ~*.* Thumbs.db
 set ExcludeDirs=90-DATEN *Archiv* *Backup*

 Echo Deploy "%SubDir_PP%"
 Title "Deploy:[%SubDir_PP%][from:%Source_SortName% to:%Target_SortName%]"
 set toRun=robocopy "%Source_DP%\%SubDir_PP%" "%Target_DP%\%SubDir_PP%" *.* /mir /TEE /r:0 /w:0 /np /XD %ExcludeDirs%  /XF %ExcludeFiles% %RobocopyOpt% /log+:"%Log_DPNE%"
 %toRun%
 goto :eof

rem ##### ------------ Standard Subroutines ----------------------------- ######
:PathCutLastDir
 rem schneidet das letzte Verzeichniss Uebergeben path ab
 rem P1 = Name der Variablen
 rem P2 = der bergebene Path
 rem Example : call :PathCutLastDir EntwRoot_LP %~dp0
 rem Example : call :PathCutLastDir MyVar %~dp0

 set PathCutLastDir$temp=%2
 set PathCutLastDir$tempLastChar=%PathCutLastDir$temp:~-1%
 set PathCutLastDir$tempNoBacks=%PathCutLastDir$temp:~0,-1%

 if "%PathCutLastDir$tempLastChar%"=="\" (
   rem "\" abschneiden wenn vorhanden
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$tempNoBacks%
 ) else (
   rem
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$temp%
 )
 set PathCutLastDir$tempRes=%PathCutLastDir$tempRes:~0,-1%
 set %1=%PathCutLastDir$tempRes%
 set PathCutLastDir$temp=
 set PathCutLastDirDo$temp1=
 set PathCutLastDir$tempNoBacks=
 set PathCutLastDir$tempNoLastChar=
 set PathCutLastDir$tempLastChar=
 set PathCutLastDir$tempRes=
 goto :eof

:PathCutLastDirDo
 rem hiermit schneiden wir den Path ab
 rem echo.
 rem Echo P1=%1 P2=%2
 set PathCutLastDirDo$temp=%~dp2
 rem "\" abschneiden
 set PathCutLastDirDo$temp1=%PathCutLastDir$temp:~0,-1%
 set %1=%PathCutLastDirDo$temp%
 set PathCutLastDirDo$temp=
 set PathCutLastDirDo$temp1=
 goto :eof

rem --------------------------------------------------------------------
:DateTimeNowGet
 rem call :DateTimeNowGet
 rem Set File_LPNE=%DatRoot_LP%\MyName-%DateTimeNowFileExt%.txt


 if     "%time:~0,1%"==" " set time-h=0%time:~1,1%
 if not "%time:~0,1%"==" " set time-h=%time:~0,2%

 if     "%time:~3,1%"==" " set time-m=0%time:~4,1%
 if not "%time:~3,1%"==" " set time-m=%time:~3,2%

 set Date-Y=%Date:~-4%
 set Date-M=%Date:~-7,2%
 set Date-D=%Date:~-10,2%
 set DateTimeNowFileExt=%Date-Y%-%Date-M%-%Date-D%-%time-h%-%time-m%
 goto :eof


rem --------------------------------------------------------------------
:Wait
 set waitTime=2
 if not "%1"=="" set waitTime=%1
 CHOICE /C:w /N /T:w,%waitTime% warte %waitTime% [sec] oder "w" fuer weiter druecken.
 goto :eof

:Parse_ALL
 rem parst alle File Bezeichner aus
 rem "\" abschneiden
 set Parse_all$temp=%~dp1
 set Parse_all$temp=%Parse_all$temp:~0,-1%
 set %2_DP=%Parse_all$temp%
 set %2_D=%~d1
 rem "\" hinten und vorne abschneiden
 set Parse_all$temp=%~p1
 set Parse_all$temp=%Parse_all$temp:~1,-1%
 set %2_P=%Parse_all$temp%
 set %2_NE=%~nx1
 set %2_N=%~n1
 set %2_E=%~x1
 set %2_DPNE=%1
 set %2_DPN=%~dpn1
 set Parse_all$temp=
goto :eof


:Wait
 set waitTime=2
 if not "%1"=="" set waitTime=%1
 CHOICE /C:w /N /T:w,%waitTime% warte %waitTime% [sec] oder "w" fuer weiter druecken.
 goto :eof

:ende

rem ----------------------------------------------------------------------------
:ColorSet
Rem Stand 25.06.2011
Rem Examples:
 REM call :ColorSet Standard
 REM call :ColorSet IsExecuting
 REM call :ColorSet IsIdel
 REM call :ColorSet End
 REM call :ColorSet Ende
 REM call :ColorSet Ok
 REM call :ColorSet Err

 rem -- cmd Color Farbinfo:
 REM    0 = Schwarz        8 = Dunkelgrau
 REM    1 = Dunkelblau     9 = Blau
 REM    2 = Dunkelgrn     A = Grn
 REM    3 = Blaugrn       B = Zyan
 REM    4 = Dunkelrot      C = Rot
 REM    5 = Lila           D = Magenta
 REM    6 = Ocker          E = Gelb
 REM    7 = Hellgrau       F = Wei
 rem -- Farben nach Status setzen
 rem Gelb Schwarz
 if /I "%~1" equ "Standard"    set JobColorLast=E0
 rem 25.06.2011 07:00 Standard eingef. IsExecuting Neu
 if /I "%~1" equ "IsExecuting" set JobColorLast=D0
 rem Blaugrn Schwarz 15.11.2010 07:45 Hellgrau Schwarz
 if /I "%~1" equ "IsIdel"      set JobColorLast=70
 rem Hellgrau Schwarz
 if /I "%~1" equ "End"         set JobColorLast=70
 if /I "%~1" equ "Ende"        set JobColorLast=70
 rem Gruen Schwarz
 if /I "%~1" equ "Ok"          set JobColorLast=A0
 rem Rot Schwarz
 if /I "%~1" equ "Err"         set JobColorLast=C0

 rem jetzt die Farbe setzen
 if not "%JobColorLast%"=="" color %JobColorLast%
 goto :eof
