@Echo off

 REM ===========================================================================
 REM Aenderungs Info:
 REM Date/Time (Alt+D)  User    Infotext:
 REM 14.11.2014 15:17   J.Fes   Ersterstellung
 REM 25.03.2021         J.Fes   add Application-Startmenu-IconsOrg.cmd
 REM 23.11.2023         J.Fes   add :SetNXEnvforNXClients
 REM ===========================================================================

 Echo **************************************************************************
 Echo * Setup Default Options for JobClient Version 23.11.2023                 *
 Echo **************************************************************************

setlocal
 REM -- Rootpfade setzen -------------------------------------------------------
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 rem -- #New: 24.03.2021/J.Fes copy Application Icons from:JobMgr_ResIcons_S_DP to:JobMgr_ResIcons_L_DP
 Call "%CmdCurRoot_DP%\..\..\99-Install\Application-Startmenu-IconsOrg.cmd"

 Echo Import CMD......: Defaults
 reg.exe IMPORT "%CmdCurRoot_DP%\CMD_DefaultOptions.reg"

 Echo Import Explorer.: Defaults 1
 reg.exe IMPORT "%CmdCurRoot_DP%\Explorer_DefaultOptions.reg"

 Echo Import Explorer.: Defaults 2 - Hide Explorer Tree entries
 reg.exe IMPORT "%CmdCurRoot_DP%\Explorer_HideThisPCEntries.reg"


 Echo Desktop.........: Refresh
 call "%CmdCurRoot_DP%\..\..\03-BinPublic\DesktopRefresh.exe"

 if "%~1" equ "/ViewResult" (
    color E0
    Echo ---------------------------------------------------------------
    Echo.
    Echo JobComputer default settings are set for: \\%ComputerName%
    Echo Explorer.....: shows file extensions
    Echo                and expands dirs below current folder
    Echo                Show RUN is active
    Echo                Taskbar in small icons
    Echo cmd..........: window Size With:50x Higth:60
    Echo                Font set to Lucida Console Size:12
    pause
 )

 REM -- #New: 23.11.2023/J.Fes set :SetNXEnvforNXClients if P1 is not ''
 if "%~2" neq "" Call :SetNXEnvforNXClients

goto :End


:SetNXEnvforNXClients
 REM -- #New: 23.11.2023/J.Fes
 set UGII_USER_PROFILE_DIR_DP=%CmdCurRoot_DP%\UGII_USER_PROFILE_DIR
 if not exist "%UGII_USER_PROFILE_DIR_DP%" md "%UGII_USER_PROFILE_DIR_DP%"
 Call setx UGII_USER_PROFILE_DIR "%UGII_USER_PROFILE_DIR_DP%"
 rem #Doc: Example replace ']' with '_'
 set EnvVarXX=%EnvVarXX:]=_%
 Echo UGII_USER_PROFILE_DIR is set to.: %UGII_USER_PROFILE_DIR%
 goto :Eof

:End
endlocal

