@Echo off
 REM #LUp: 17.03.2020/add command
 REM #LUp: 23.03.2021/J.Fes add JobMgr_ProcERR_DP
 REM #LUp: 12.09.2022/J.Fes add use JobMgr_JCAliasName is needed to deactivate also if JobClinet using JobMgr_JCAliasName
 REM #LUp: 28.03.2024/J.Fes add if call :ResEvaluate_ERR_AND_STOP is used then we will send e-Mail always

 REM #Para: P1 = 'S'  (deactivates JobClient and stops in Script)
 REM #Para: P1 = 'PS' (deactivates JobClient and pause the Script)
 REM #Para: P1 = 'C'  (deactivates JobClient and continues the Script but not if JobMgr_Debug=ON )
 REM #Para: P2 = JobMgr_ERRKey
 REM #Para: P3 = JobMgr_ERRDescr
 REM #Para: P4 = SendMail (Optional) if P4 is set to "SendMail" then JobServer ..
 rem             will send mail to User as defined in JobServer Definition '00-JobMgrDefActivStatusMail'
 rem             but not when JobMgr_Debug is set
 REM #Para: P4 = SendMailForce if P4 is set to "SendMailAllways" then Mail will be send in all cases

 REM #EXA: 'S'  if "%Test%" neq "OK" call ErrorHandel "S"  "#Key#:ERR #ShortMSG#" "ERR.description"
 REM #EXA: 'PS' if "%Test%" neq "OK" call ErrorHandel "PS" "#Key#:ERR #ShortMSG#" "ERR.description"
 REM #EXA: 'C'  if "%Test%" neq "OK" call ErrorHandel "C"  "#Key#:ERR #ShortMSG#" "ERR.description"

 call ColorSet ERR

 if defined JobMgr_ProcERR_DP goto :Next
 set JobMgr_ProcERR_DP=%~dp0
 set JobMgr_ProcERR_DP=%JobMgr_ProcERR_DP:~0,-1%

:Next
 if defined JobMgr_ProcERR_DPNE goto :Next
 set JobMgr_ProcERR_DPNE=%JobMgr_ProcERR_DP%\__ProcessERROR_log.txt

:Next
 Set JobMgr_ERRControl=%~1
 Set JobMgr_ERRKey=%~2
 Set JobMgr_ERRDescr=%~3
 Set JobMgr_ERRSendMail=%~4

 set JobMgr_ERRSendMailDo=No
 rem #Doc: evaluates rules to send Mail Yes/No
 if /I "%JobMgr_ERRSendMail%" equ "SendMail" if /I "%JobMgr_Debug%" neq "ON" set JobMgr_ERRSendMailDo=Yes
 if /I "%JobMgr_ERRSendMail%" equ "SendMailForce" set JobMgr_ERRSendMailDo=Yes

 if not defined JobMgr_JCAliasName set JobMgr_JCAliasName=%ComputerName%

 if not exist "%JobMgr_ProcERR_DPNE%" (
  CALL :ErrLogHeaderWrite
 ) else (
  rem -- #Doc: in case JobMgr_ProcERR_DPNE exist add ERROR Details into JobMgr_ProcERR_DPNE
  CALL :GenericERR
 )
 REM run Evaluation and Stops process via EXIT
 if "%JobMgr_ERRControl%" equ "S"  Call :ResEvaluate_ERR_AND_STOP
 if "%JobMgr_ERRControl%" equ "PS" Call :ResEvaluate_ERR_AND_STOP "PAUSE"
goto :eof

REM ####### ------------ Standard Subroutines ---------------------- ###########
REM ============================================================================
:GenericERR
 setlocal
   set JobMgr_ERRKeyPrint=%JobMgr_ERRKey%.......................................
   set JobMgr_ERRKeyPrint=%JobMgr_ERRKeyPrint:~0,32%
   CALL Echo "%JobMgr_ERRKeyPrint%: %JobMgr_ERRDescr%" "%JobMgr_ProcERR_DPNE%"
 endlocal
goto :eof

REM ============================================================================
:ErrLogHeaderWrite
 REM writes ERR Header
 Call Echo "--------------------------------------------------------------------------" "%JobMgr_ProcERR_DPNE%"
 Call Echo "JobProcess ERROR Report created.: %date% %time%" "%JobMgr_ProcERR_DPNE%"
 Call Echo "Computer........................: %JobMgr_JCAliasName%" "%JobMgr_ProcERR_DPNE%"
 Call Echo "User............................: %UserName%" "%JobMgr_ProcERR_DPNE%"
 Call Echo "ERR.Key.........................: %JobMgr_ERRKey%" "%JobMgr_ProcERR_DPNE%"
 Call Echo "ERR.Descr.......................: %JobMgr_ERRDescr%" "%JobMgr_ProcERR_DPNE%"
 Call Echo "ERR.SendMailDo..................: %JobMgr_ERRSendMailDo%" "%JobMgr_ProcERR_DPNE%"
 goto :eof

REM ============================================================================
:ErrLogFooterWrite
 REM writes ERR Footer
 rem -- #LUp: 25.01.2024/J.Fes / IMAN removed
 Call Echo "--------------------------------------------------------------------------" "%JobMgr_ProcERR_DPNE%" "NOECHO"
 Call Echo "Environ Info of:\\%JobMgr_JCAliasName%"
 Call Echo "-- Path Environ ----------------------------------------------------------"  "%JobMgr_ProcERR_DPNE%" "NOECHO"
 set PATH>>"%JobMgr_ProcERR_DPNE%"
 Call Echo "-- NX*/UG* Environ -------------------------------------------------------"  "%JobMgr_ProcERR_DPNE%" "NOECHO"
 set NX>>"%JobMgr_ProcERR_DPNE%"
 set UG>>"%JobMgr_ProcERR_DPNE%"
 Call Echo "-- TC*/SPLM* Environ -----------------------------------------------------" "%JobMgr_ProcERR_DPNE%" "NOECHO"
 set TC>>"%JobMgr_ProcERR_DPNE%"
 set SPLM>>"%JobMgr_ProcERR_DPNE%"
 Call Echo "-- All Environ -----------------------------------------------------------" "%JobMgr_ProcERR_DPNE%" "NOECHO"
 set >>"%JobMgr_ProcERR_DPNE%"
 goto :eof

REM ============================================================================
:ResEvaluate_ERR_AND_STOP
 rem Writes for all Objects ERR case in JobResults
 rem #LUp:25.01.2024/J.Fes update reset Obj.P.Staus to JobRuleSelObjByPStat

 rem -- #Doc:15.11.2024/J.Fes not valid to use when using PPA_
 if defined PPA_VerNumber goto :JumbOverDeactivadJobClient

 if not defined JobRuleSelObjByPStat set JobRuleSelObjByPStat=D.NP.ERR
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "JobDataEdit_2012_09"
 set toRun=%toRun% -SubAction "JobData2ResultsSetProcessValue"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -ObjProcessResultCode "JM-999101"
 set toRun=%toRun% -ObjProcessState  "%JobRuleSelObjByPStat%"
 set toRun=%toRun% -ObjProcessResultMsg "[%JobMgr_ERRKey%][P.Stat:Reset to PreState:%JobRuleSelObjByPStat%]"
 set toRun=%toRun% -JobData2ResultsDoPrint
 call %toRun%

 rem #New:18.07.2019/J.Fes deactivates JobComputer to aviod that JobComputer get new Jobs
 rem #LUp:25.01.2024/J.Fes add JobMgr_ERRSendMailDo
 rem #LUp:28.03.2024/J.Fes if call :ResEvaluate_ERR_AND_STOP is used then we will send e-Mail always
 if /I "%JobMgr_Debug%" neq "ON" set JobMgr_ERRSendMailDo=Yes

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "JobControl_2018_10"
 set toRun=%toRun% -SubAction "ControlActivStatus"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -Type "JobComputer"
 set toRun=%toRun% -Name "%JobMgr_JCAliasName%"
 set toRun=%toRun% -Status "inactiv"
 set toRun=%toRun% -RuleName "JC-Stop because:%JobMgr_ERRKey%"
 set toRun=%toRun% -Description "%JobMgr_ERRKey% -//- %JobMgr_ERRDescr%"
 rem 21.05.2024/J.Fes + S.Gueth option -MailSubject  enhanced
 if /I "%JobMgr_ERRSendMailDo%" equ "Yes" set toRun=%toRun% -SendMail -MailConfigName "00-JobMgrDefActivStatusMail" -MailSubject "JobMgr:[%JobMgr_ServerSettings%] JC:[%JobMgr_JCAliasName%] Stop because:[%JobMgr_ERRKey%]"

 call %toRun%
 rem  03.05.2024 / Workaround until deactivation Issue is fixed
 rem  21.05.2024 / Workaround deactivated
 REM  timeout 50

:JumbOverDeactivadJobClient
 if /I "%~1" equ "PAUSE" if /i "%JobMgr_Debug%" neq "ON"  (
  Echo ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Echo after press enter you will see the error reason in cmd window.......
  pause
  Echo ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ----
  Type "%JobMgr_ProcERR_DPNE%"
  Echo ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  pause
 )

 call :ErrLogFooterWrite
 REM view result on JC if uses Debug Mode
 if /i "%JobMgr_Debug%" neq "ON" goto :ResEvaluate_ERR_AND_STOP_end
 Echo ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 Echo after press enter you will see the error reason in text-editor.......
 Echo Info: explorer start's with dir %temp%
 Echo ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 pause
 set Editor_DPNE=%BinPublic_DP%\PSPad editor\PSPad.exe
 if not exist "%Editor_DPNE%" set Editor_DPNE=Notepad.exe
 start "Text Editor" "%Editor_DPNE%" "%JobMgr_ProcERR_DPNE%"
 rem start "Explorer" Explorer "%temp%"
 Call Echo "Hint: type 'exit' then script and process exits"
 Echo ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 cmd

:ResEvaluate_ERR_AND_STOP_end
 Exit
goto :eof

