@Echo off

REM -------------------------------------------------------------------------------------
REM #New 24.05.2018/J.Fes (c) addPLM - GmbH
REM
REM #Doc: this script runs the TC Volumen RevokeGrand process
REM #Doc: folowing steps are done:
REM #Doc: - Step1: set User/Group:%TC_RevokeGrandName% default volume to %TC_RevokeGrandVolTemp%
REM #Doc: - Step2: run Revoke Grand for User/Group: %TC_RevokeGrandVol%
REM #Doc: - Step3: set User/Group:%TC_RevokeGrandName% default volume to %TC_RevokeGrandVol%


REM Techical details for usage:
REm ---------------------------
REM this script is triggerd by default via JobMgr TaskScript S:VolumeRevokeGrand_TC.vb
REM folowing Environvatiables must be set befor eXecuting this script:
REM
REM %TC_RevokeGrandType%
REM %TC_RevokeGrandName%
REM %TC_RevokeGrandVol%
REM %TC_RevokeGrandVolTemp%
REM %JobMgr_TcUser%
REM %JobMgr_TcPw%
REM %JobMgr_TcGroup%
REM %JobMgr_Log_DP%
REM %JobMgr_ProcessResult_Log_DPNE%
rem DateTimeStamp

REM -------------------------------------------------------------------------------------

setlocal
 if not defined JobMgr_Log_DP goto :ExitErrMIssingParameter
 call ColorSet "IsExecuting"

 rem insert in path variable tcpbBin_DP
 set path=%tcpbBin_DP%;%tc_root%\bin;%path%
 if not exist "%JobMgr_Log_DP%" md "%JobMgr_Log_DP%"

 set titleTxt=Revoke Grant:[%DateTimeStamp%]/Site:[%TcSiteId%]/for User:[%TC_RevokeGrandName%][\\%ComputerName%]
 title %titleTxt%
 Call Echo "---------------------------------------------------------------------------------" "" "NOECHO"

 set JobMgr_TcUseUPG=-u=%JobMgr_TcUser% -g=%JobMgr_TcGroup%
 set FileP_N=VolRG_%TcSiteId%_%TC_RevokeGrandType%_%TC_RevokeGrandName%_%TC_RevokeGrandVol%

 set JobMgr_LogL_DP=%CmdCurRoot_DP%\00_VRGLogL\PLog_%DateTimeStamp%

 set VolumeRevokeGrant_SetdefTempVol_Log_DPNE=%JobMgr_Log_DP%\%FileP_N%_01_VolTempSet_log.txt
 set VolumeRevokeGrant_Aktive_ini_DPNE=%JobMgr_LogL_DP%\%FileP_N%_02_VolAkt_RG.ini
 set VolumeRevokeGrant_Aktive_Log_DPNE=%JobMgr_LogL_DP%\%FileP_N%_03_VolAkt_RG_log.txt
 set VolumeRevokeGrant_SetdefAktivVol_Log_DPNE=%JobMgr_Log_DP%\%FileP_N%_04_VolAktSet_log.txt

 rem set default MSG
 set TC_RevokeGrandVolTemp_SetDefVol_ResMsg=Not Processed
 set TC_RevokeGrandVol_RevokeGrand_ResMsg=Not Processed
 set TC_RevokeGrandVol_SetDefVol_ResMsg=Not Processed

 rem set TC temp Dir
 set TC_TMP_DIR=%JobMgr_LogL_DP%
 if not exist "%TC_TMP_DIR%" md "%TC_TMP_DIR%"
 set temp=%TC_TMP_DIR%
 set tmp=%TC_TMP_DIR%
 set TC_LOG=%TC_TMP_DIR%
 set TC_KEEP_SYSTEM_LOG=TRUE
 set TC_Journalling=OFF
 set TC_Journaling=OFF
 set TC_TRACEBACK=OFF


 set titleTxt=Revoke Grant:[%DateTimeStamp%] Site:[%TcSiteId%] for:[%TC_RevokeGrandType%:%TC_RevokeGrandName%] Vol:[%TC_RevokeGrandVol%][\\%ComputerName%]
 title %titleTxt%
 Call Echo "Start Process...................: %Date% %time:~0,5%"
 Call Echo "Process LogFiles at local Comp..: %JobMgr_LogL_DP%"
 Call Echo "Process Logfiles at server......: %JobMgr_Log_DP%"


 rem -- #Step: set def volume to TC_RevokeGrandVolTemp -----------------------------------
 Call :SetDefaultVolume "#Step 1/3: set VolTemp"  "%TC_RevokeGrandVolTemp%"  "%VolumeRevokeGrant_SetdefTempVol_Log_DPNE%" TC_RevokeGrandVolTemp_SetDefVol_ResMsg

 rem -- #Step: eXecute Revoke Grand process
 CALL :RevokeGrandVolume "#Step 2/3: Revoke Grand"

 rem -- #Step: set def volume to TC_RevokeGrandVolTemp -----------------------------------
 Call :SetDefaultVolume "#Step 3/3: set VolDef"  "%TC_RevokeGrandVol%"  "%VolumeRevokeGrant_SetdefAktivVol_Log_DPNE%" TC_RevokeGrandVol_SetDefVol_ResMsg


 rem -- #Step: evalueate final result ----------------------------------------------------
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----" "%JobMgr_ProcessResult_Log_DPNE%"
 Call Echo "Process Evaluation..............: Results details"  "%JobMgr_ProcessResult_Log_DPNE%"
 Call Echo "Set Volume to TempVolume........: %TC_RevokeGrandVolTemp_SetDefVol_ResMsg%" "%JobMgr_ProcessResult_Log_DPNE%"
 Call Echo "eXecute Revoke Grand............: %TC_RevokeGrandVol_RevokeGrand_ResMsg%"  "%JobMgr_ProcessResult_Log_DPNE%"
 Call Echo "Set Volume to DefaultVolume.....: %TC_RevokeGrandVol_SetDefVol_ResMsg%" "%JobMgr_ProcessResult_Log_DPNE%"
 Call Echo "End.............................: %Date% %time:~0,5%"  "%JobMgr_ProcessResult_Log_DPNE%"

 call ColorSet "End"
endlocal
goto :eof

:ExitErrMIssingParameter
 Call Echo "ERR:1 in %~0"
 Call Echo "Missign at leased one Environvatiable"
 Call Echo "TC_RevokeGrandType..............: %TC_RevokeGrandType%"
 Call Echo "TC_RevokeGrandName..............: %TC_RevokeGrandName%"
 Call Echo "TC_RevokeGrandVol...............: %TC_RevokeGrandVol%"
 Call Echo "TC_RevokeGrandVolTemp...........: %TC_RevokeGrandVolTemp%"
 Call Echo "JobMgr_TcUser...................: %JobMgr_TcUser%"
 Call Echo "JobMgr_TcPw.....................: %JobMgr_TcPw%"
 Call Echo "JobMgr_TcGroup..................: %JobMgr_TcGroup%"
 Call Echo "JobMgr_Log_DP...................: %JobMgr_Log_DP%"
 timeout /t 5
 exit /B 1

goto :eof
rem ----------------------------------------------------------------------------
:RevokeGrandVolume

 set ActionTitel=%~1

 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "Action..........................: %ActionTitel%"
 Call Echo "for.............................: %TC_RevokeGrandType%:%TC_RevokeGrandName%"
 Call Echo "to volume.......................: %TC_RevokeGrandVol%"
 Call Echo "via tool........................: %tcpbBin_DP%\tcpb_change_volumes.exe"

 rem -- #Step: RUN REVOKE GRAND via tcpb_change_volumes.exe ------------------------------
 Echo %TC_RevokeGrandVol%;%TC_RevokeGrandType%;%TC_RevokeGrandName%;revoke>"%VolumeRevokeGrant_Aktive_ini_DPNE%"
 Echo %TC_RevokeGrandVol%;%TC_RevokeGrandType%;%TC_RevokeGrandName%;grant>>"%VolumeRevokeGrant_Aktive_ini_DPNE%"

 set toRun="%tcpbBin_DP%\tcpb_change_volumes.exe"
 set toRun=%toRun% -mode=modify
 set toRun=%toRun% -file="%VolumeRevokeGrant_Aktive_ini_DPNE%"
 set toRun=%toRun% -access
 set toRun=%toRun% -log="%VolumeRevokeGrant_Aktive_Log_DPNE%"
 set toRun=%toRun% %JobMgr_TcUseUPG%


 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  set toRunForPrint=%toRun:"='%
  call Echo "###########################################################################"
  call Echo "#Debug..........................: Before revoke grand via tcpb_change_volumes.exe"
  call Echo "#Log............................: %VolumeRevokeGrant_Aktive_Log_DPNE%"
  call Echo "#toRun..........................: %toRunForPrint%"
  pause
 :JumbOverDebug

 Call Echo "eXecute Volume Revoke Grand via.: %tcpbBin_DP%\tcpb_change_volumes.exe"
 Call %toRun% -p=%JobMgr_TcPw% 1>nul 2>nul
 set TC_RevokeGrandVol_RevokeGrand_ResCode=%errorlevel%

 if "%TC_RevokeGrandVol_RevokeGrand_ResCode%" equ "0" set TC_RevokeGrandVol_RevokeGrand_ResMsg=OK:
 if "%TC_RevokeGrandVol_RevokeGrand_ResCode%" neq "0" set TC_RevokeGrandVol_RevokeGrand_ResMsg=ERR:%TC_RevokeGrandVol_RevokeGrand_ResCode%
 set TC_RevokeGrandVol_RevokeGrand_ResMsg=%TC_RevokeGrandVol_RevokeGrand_ResMsg% for:%TC_RevokeGrandType%:%TC_RevokeGrandName% Vol:%TC_RevokeGrandVol%


 Call Echo "Step:Revoke Grand Result........:  %TC_RevokeGrandVol_RevokeGrand_ResMsg%"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  set toRunForPrint=%toRun:"='%
  call Echo "###########################################################################"
  call Echo "#Debug..........................: After revoke grand via tcpb_change_volumes.exe"
  pause
 :JumbOverDebug


goto :eof


rem ----------------------------------------------------------------------------
:SetDefaultVolume
setlocal

 set ActionTitel=%~1
 set TC_VolDefault=%~2
 set Log_DPNE=%~3
 set TcDefaultVolumeSet_ResCode=
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "Action..........................: %ActionTitel%"
 Call Echo "for.............................: %TC_RevokeGrandType%:%TC_RevokeGrandName%"
 Call Echo "to volume.......................: %TC_VolDefault%"
 Call Echo "via tool........................: make_user.exe"

 set toRun=make_user.exe
 if /I "%TC_RevokeGrandType%" equ "USER" set toRun=%toRun% -user=%TC_RevokeGrandName%
 if /I "%TC_RevokeGrandType%" equ "GROUP" set toRun=%toRun% -group=%TC_RevokeGrandName%
 set toRun=%toRun% -defaultvolume=%TC_VolDefault%
 set toRun=%toRun% -update
 set toRun=%toRun% -v
 set toRun=%toRun% %JobMgr_TcUseUPG%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  set toRunForPrint=%toRun:"='%
  call Echo "###########################################################################"
  call Echo "#Debug..........................: Before run make_user.exe set def volume"
  call Echo "#Log............................: %Log_DPNE%"
  call Echo "#toRun..........................: %toRunForPrint%"
  pause
 :JumbOverDebug

 %toRun% -p=%JobMgr_TcPw% >>"%Log_DPNE%" 2>nul
 set TcDefaultVolumeSet_ResCode=%errorlevel%

 if "%TcDefaultVolumeSet_ResCode%" equ "0" set TcDefaultVolumeSet_ResMsg=OK:
 if "%TcDefaultVolumeSet_ResCode%" neq "0" set TcDefaultVolumeSet_ResMsg=ERR:%TcDefaultVolumeSet_ResCode%
 set TcDefaultVolumeSet_ResMsg=%TcDefaultVolumeSet_ResMsg% for:%TC_RevokeGrandType%:%TC_RevokeGrandName% SetDefVol:%TC_VolDefault%

 Call Echo "Step:Set default volume..........:  %TcDefaultVolumeSet_ResMsg%"


 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  set toRunForPrint=%toRun:"='%
  call Echo "###########################################################################"
  call Echo "#Debug..........................: after run make_user.exe set def volume"
  pause
 :JumbOverDebug

endlocal& set %4=%TcDefaultVolumeSet_ResMsg%
goto :eof
