@Echo off

 rem ---------------------------------------------------------------------------
 rem JobManagerV3 Script to Purge TC Dataset's (c) addPLM
 rem
 rem Aenderungs Info:
 rem Date        User      Description:
 rem 12.08.2015  J.Fes     Ersterstellung
 rem 06.12.2023  J.Fes     Update use default methodes
 rem ---------------------------------------------------------------------------

setlocal
 call TC_tempSet.cmd "%CmdCurRoot_DP%\JobTmp"

 rem #Doc deactivate SQL Debug
 set TC_SQL_DEBUG=
 if not defined purge_datasets_keep set purge_datasets_keep=3

 call :ColorSet IsExecuting
 call Echo "%titleTxt%"
 call Echo "----------------------------------------------------------------------------"
 Call Echo "TC-Purge Job Settings:"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "JobName.........................: %JobName%"
 Call Echo "Computer........................: %ComputerName%"
 Call Echo "JobTempDir......................: %temp%"
 Call Echo "##- - - - TC settings: - - - -##"
 Call Echo "TcSide..........................: #TcSite.SiteInfoWith_SiteId_and_pName#"
 Call Echo "TcUser..........................: %JobMgr_TcUser%"
 Call Echo "TC_ROOT.........................: %TC_ROOT%"
 Call Echo "TC_DATA.........................: %TC_DATA%"
 Call Echo "##- - - - Purge settings: - - ##"
 Call Echo "Purge Methode...................: %purge_datasets_via_methode%"
 Call Echo "Purge Datasets with keep n vers.: %purge_datasets_keep% (n)"


 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  call Echo "#Debug...: %~0"
  pause
 :JumbOverDebug

 if /i "%purge_datasets_via_methode%" equ "M1_use_Tool_Purge_Datasets" call :M1_Use_Tool_Purge_Datasets
 if /i "%purge_datasets_via_methode%" equ "M2_use_Tcpb_Purge_Dataset"  call :M2_use_Tcpb_Purge_Dataset

endlocal
goto :end


rem -----------------  RUN Methode 2 purge via Tool TC-PowerBox Purge_Datasets -----------------
:M2_use_Tcpb_Purge_Dataset

 rem #Doc: set base Variables
 set tcpb_purge_dataset_input_DPNE=%temp%\01-tcpb_purge_dataset_input.txt
 set tcpb_purge_datasets_log_DPNE=%temp%\02-tcpb_purge_dataset_log.txt
 set tcpb_purge_datasets_cmd_log_DPNE=%temp%\03-tcpb_purge_dataset_cmd_log.txt

 rem #Step: --- Extract tcpb_purge_dataset_input_DPNE content ItemId's ----------------------
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action JobDataExtract_2013_10
 set toRun=%toRun% -SubAction InputListExtract
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 rem #Doc: next 2 Lines: Work around to input #ObjectType #
 set toRun=%toRun% -format "#ItemId#@#Rev#@#ObjectName#@#ObjectType#"
 set toRun=%toRun% -inputList_DPNE "%tcpb_purge_dataset_input_DPNE%"
 set toRun=%toRun% -JobData1ToProcessDoPrint
 call %toRun%


 rem #Step: --- Execute purge datasets via purge_datasets.exe ------------------
 rem set tcpbRoot_S_DP=%tc_user_lib%
 set tcpb_purge_dataset_NE=tcpb_purge_dataset.exe
 set tcpb_purge_dataset_S_DPNE=%tcpbRoot_S_DP%\%tcpb_purge_dataset_NE%
 set tcpbRoot_L_DP=%BinL_DP%
 set tcpb_purge_dataset_L_DPNE=%tcpbRoot_L_DP%\%tcpb_purge_dataset_NE%
 set path=%tcpbRoot_L_DP%;%path%

 Call CopyFromTo.cmd "Copy description" "%tcpbRoot_S_DP%" "*.*" "%tcpbRoot_L_DP%" "*.*" "/xf *.bak,*tmp"


 set toRun="%tcpb_purge_dataset_L_DPNE%"
 set toRun=%toRun% -input="%tcpb_purge_dataset_input_DPNE%"
 set toRun=%toRun% -log="%tcpb_purge_datasets_log_DPNE%"
 set toRun=%toRun% -preserve_modification
 set toRun=%toRun% -k=%purge_datasets_keep%
 set toRun=%toRun% -g=dba
 set toRun=%toRun% -u=%JobMgr_TcUser%

if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
 set toRunForPrint=%toRun:"=%
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Debug..........................: %~0"
 call Echo "#before run.....................: %tcpb_purge_dataset_S_DPNE%"
 call Echo "#toRun..........................: %toRunForPrint% -p=**********"
 call Echo "---------------------------------------------------------------------------"
 pause
:JumbOverDebug

 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 call Echo "Purge via Dataset's.............: with setting"
 call Echo "tcpb_purge_dataset_input_DPNE...: [%tcpb_purge_dataset_input_DPNE%]"
 call Echo "tcpb_purge_datasets_cmd_log_DPNE: [%tcpb_purge_datasets_cmd_log_DPNE%]"
 call Echo "tcpb_purge_datasets_log_DPNE....: [%tcpb_purge_datasets_log_DPNE%]"
 call Echo "-k..............................: [%purge_datasets_keep%]"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 call Echo "Purge via Dataset's.............: Protocol"
 call %toRun% -p=%JobMgr_TcPw% >>"%tcpb_purge_datasets_cmd_log_DPNE%"

if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
 set toRunForPrint=%toRun:"='%
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Debug..........................: %~0"
 call Echo "#after run......................: %tcpb_purge_dataset_S_DPNE%"
 call Echo "#toRun..........................: %toRunForPrint% -p=**********"
 pause
:JumbOverDebug

 rem #Step: --- Run set result's -----------------------------------------------
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "JobDataEdit_2012_09"
 set toRun=%toRun% -SubAction "JobData2ResultsSetProcessValue"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -ObjProcessResultCode "0"
 set toRun=%toRun% -ObjProcessState  "D.OK"
 set toRun=%toRun% -ObjProcessResultMsg "[PurgeDS:M2 via DS]"
 set toRun=%toRun% -JobData2ResultsDoPrint

 call %toRun%
goto :eof

rem -----------------  Methode 1 purge via Tool Purge_Datasets -----------------
:M1_use_tool_Purge_Datasets

 set itemidsfile_DPNE=%CmdCurRoot_DP%\01-itemidsfile.txt
 set purge_datasets_cmd_log_DPNE=%CmdCurRoot_DP%\02-purge_datasets_cmd_log.txt

 rem #Step: --- Extract itemidsfile_DPNE content ItemId's ----------------------
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action JobDataExtract_2013_10
 set toRun=%toRun% -SubAction InputListExtract
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -format #ItemId#
 set toRun=%toRun% -inputList_DPNE "%itemidsfile_DPNE%"
 set toRun=%toRun% -JobData1ToProcessDoPrint

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  set toRun=%toRun% -JobParaDoPrint
  set toRun=%toRun% -verbose
  set toRun=%toRun% -pauseOnEnd
  Echo #Debug:%~0
  Echo Start:%toRun%
  pause
 :JumbOverDebug
 call %toRun%
 
 rem #Step: --- Execute purge datasets via purge_datasets.exe ------------------
 if not defined purge_datasets_keep set purge_datasets_keep=3
 set toRun=purge_datasets.exe
 set toRun=%toRun% -itemidsfile="%itemidsfile_DPNE%"
 set toRun=%toRun% -k=%purge_datasets_keep%
 set toRun=%toRun% -g=dba
 set toRun=%toRun% -u=%JobMgr_TcUser%

if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
 set toRunForPrint=%toRun:"=%
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Debug..........................: %~0"
 call Echo "#before run.....................: purge_datasets.exe"
 call Echo "#toRun..........................: %toRunForPrint% -p=**********"
 call Echo "---------------------------------------------------------------------------"
 pause
:JumbOverDebug

 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 call Echo "Purge via ITEMS ................: with settings"
 call Echo "purge_datasets_cmd_log_DPNE.....: [%purge_datasets_cmd_log_DPNE%]"
 call Echo "-itemidsfile....................: [%itemidsfile_DPNE%]"
 call Echo "-k..............................: [%purge_datasets_keep%]"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 call Echo "Purge via ITEMS.................: Protocol"
 call %toRun% -p=%JobMgr_TcPw% >>"%purge_datasets_cmd_log_DPNE%"

if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
 set toRunForPrint=%toRun:"='%
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Debug..........................: %~0"
 call Echo "#after run......................: purge_datasets.exe"
 call Echo "#toRun..........................: %toRunForPrint% -p=**********"
 pause
:JumbOverDebug


 rem #Step: --- Run set result's -----------------------------------------------
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "JobDataEdit_2012_09"
 set toRun=%toRun% -SubAction "JobData2ResultsSetProcessValue"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -ObjProcessResultCode "0"
 set toRun=%toRun% -ObjProcessState  "D.OK"
 set toRun=%toRun% -ObjProcessResultMsg "[PurgeDS:M1 via Item]"
 set toRun=%toRun% -JobData2ResultsDoPrint

 call %toRun%
goto :eof

rem #### ----------------- Standard Subroutines ------------------------- ######
:ColorSet
 rem Gelb Schwarz
 if /I "%1"=="IsExecuting" set JobColorLast=E0
 rem Blaugrn Schwarz
 if /I "%1"=="IsIdel"      set JobColorLast=30
 rem Hellgrau Schwarz
 if /I "%1"=="End"         set JobColorLast=70
 if /I "%1"=="Ende"        set JobColorLast=70
 rem Gruen Schwarz
 if /I "%1"=="Ok"          set JobColorLast=A0
 rem Rot Schwarz
 if /I "%1"=="Err"         set JobColorLast=C0

 rem jetzt die Farbe setzen
 if not "%JobColorLast%" equ "" color %JobColorLast%
 goto :eof

rem ---------- END ACTION ------------------------------------------------------
:end

 rem -- Farbe auf JobEnds setzen
 call :ColorSet End

