@Echo off
 REM ===========================================================================
 REM (c) addPLM - GmbH S.Gueth 29.09.2016
 rem
 REM Aenderungs Info:
 REM User    Date/Time (Alt+D)  Infotext:
 REM J.Fes   28.02.2016 18:46   Ersterstellung
 REM S.Gueth 29.09.2016 10:43   Anpassung fr TcDataQuality Check
 REM ===========================================================================
 Echo **************************************************************************
 Echo * Excuting TcDataQuality Script PLMJobManager Environ                    *
 Echo * Version: (c)addPLM GmbH  29.09.2016                                    *
 Echo **************************************************************************

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2

 REM -- define incudes #New: 05.07.2016/J.Fes
 set JobMgr_10-JobScriptsInc_01=_JobMgrDefaults
 set JobMgr_10-JobScriptsInc_02=_CustomDefaults\TcPrompt

 rem -- #Doc: 07.07.2016/J.Fes Use to refile 'SO SiteObjects' as 'RO ReplicaObjects'
 rem if not defined JobMgr_RfUse_for_SO_RO set JobMgr_RfUse_for_SO_RO=YES

 REM -- #Doc: Inits all Basics of Job
 Call "%~dp0_JobInitial.cmd" "TCDataQuality" "YES" "YES" "YES" "YES"

 rem set TC Data QUaility Check settings file (name or full path)
 if not defined TCDataQualitySettingsXML_DPNE set TCDataQualitySettingsXML_DPNE=%CmdCurRoot_DP%\settings\TCDataQualitySettings.xml


 REM Disk Connect [default=OFF]
 set JobMgr_use_DiskConnect=OFF

 REM -- #Step: Farbe setzen IsIdel
 call :ColorSet IsIdel

 REM -- PathVariable erweitern
 rem set path=%CmdCurRoot_DP%;%BinPublic_Custom_DP%;%BinPublic_ClientServer_DP%;%BinPublic_DP%;%Path%

 set titleTxt=Rf:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner Debug:%JobMgr_Debug%
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   pause
   Echo #Debug....: Start Explorer
   Echo at JobDir.: [%CmdCurRoot_DP%]
   start "" Explorer "%CmdCurRoot_DP%"
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
:JumbOver


 rem --#Step: Run TCDataQuality Process
 if exist "%TCPrompt_Custom_DPNE%" Call "%TCPrompt_Custom_DPNE%"
 if "%JobMgr_TCPromptGet_ResCode%" equ "0" Call "%CmdCurRoot_DP%\TcDataQuality_Execute.Cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"


 if /i "%JobMgr_Test%" neq "ON" goto :JumbOver
  Banner Test:End
  Echo -------------------------------------------------------------------------
  Echo #TestMode.........: End Test
  Echo JobName...........: [%JobName%]
  Echo -------------------------------------------------------------------------
  pause
:JumbOver

REM   rem #New: 14/11/2014/J.Fes
REM   Echo CleanUp......: %CmdCurRoot_DP%\startup\..
REM   rd /S /Q "%CmdCurRoot_DP%\startup"
REM   Echo CleanUp......: %CmdCurRoot_DP%\Resources\..
REM   rd /S /Q "%CmdCurRoot_DP%\Resources"
REM   del /S /Q "%CmdCurRoot_DP%\*.fscproxylog"

REM   rem #New:24/11/2014 18:12/J.Fes preventing sending big logfies to JobServer
REM   call robocopy "%CmdCurRoot_DP%" "%CmdCurRoot_DP%\..\_JobLogFilesNotSendBackToJobServer\%JobName%" "*.*log*" /S /MIN:3072000 /R:5 /W:1

rem #New: 29.03.2017 09:12 J.Fes
REM   Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
REM   Call Echo "CleanUp.........................: %CmdCurRoot_DP%\startup\.."
REM   rd /S /Q "%CmdCurRoot_DP%\startup"
REM   Call Echo "CleanUp.........................: %CmdCurRoot_DP%\Resources\.."
REM   rd /S /Q "%CmdCurRoot_DP%\Resources"
REM   del /S /Q "%CmdCurRoot_DP%\*.fscproxylog"
REM   del /S /Q "%CmdCurRoot_DP%\*.prt"

  rem #New:24/11/2014 18:12/J.Fes preventing sending big logfies to JobServer
  rem call robocopy "%CmdCurRoot_DP%" "%CmdCurRoot_DP%\..\_JobLogNotSendToJobServer\%JobName%" "*.*log*" /Move /S /MIN:3072000 /R:1 /W:1
goto :end

REM ============================================================================
:end
 cd /d "%tempOrig_DP%"
 Call Echo "--------------------------------------------------------------------------"
 Call Echo "Info: all files in...............: %temp%"
 Call Echo "Info: will be zipt by JobClient..: and send to JobServer"
 EXIT /B 0
