@Echo off
 REM ===========================================================================
 REM (c) addPLM - GmbH J.Feuerstein 28.02.2016
 rem
 REM Aenderungs Info:
 REM User    Date/Time (Alt+D)  Infotext:
 REM J.Fes   28.02.2016 18:46   Ersterstellung
 REM S.Gueth 09.09.2016 15:09   Anpassung fr TCXml -Export -Import -ConfrimExport
 REM ===========================================================================
 set toRun=
 Echo **************************************************************************
 Echo * Excuting Xml_ExportImport Script PLMJobManager Environ                    *
 Echo * Version: (c)addPLM GmbH  09.09.2016                                    *
 Echo **************************************************************************

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2

 rem set action that should be processed
 rem PLMXmlExport | TCXmlExport | TCXmlImport | TCXmlConfirmExport
 set Action=unknown

 rem set JobMgrDataOrg_Root_DP_Custom --> exported data will be stored there
 set JobMgrDataOrg_Root_DP_Custom=#12-Data#

 rem set TC Site Id for TcXmlImport
 set TcSiteIdImport=unknown

 rem set addition Arguments for process
 rem for tcxml processes: arguments 'file', 'u', 'p', 'g' and 'low_level' will be set automatically, you do not have to do this here
 set ShellExecArguments_Custom=""

 REM -- Basiseinstellungen fuer das Verhalten es Scriptes ----------------------
 REM Hier knnen Verschiedene Einstellungen getroffen werden die steuern wie das Script ablaufen soll
 REM      Die mit "#" Gitter eingeschlossenen Variablen werden vom JobServer ersetzt
 
 REM Alle wichtigen Stellen sind mit # gekennzeichnset
 REM #Doc:  steht an allen Dokumentations Stellen
 REM #ToDo: steht an allen Stellen die angepasst werden sollen

 rem wird im JobScript angegben so wird der File:[#JobName#_ObjectsList.txt] nicht dem JobFile hinzugefuegt.
 set JobAddFile_ObjectsList_txt=false
 rem wird im JobScript angegben so wird der File:[#JobName#_ObjectsListAllDetails.txt] nicht dem JobFile hinzugefuegt.
 set JobAddFile_ObjectsListAllDetails_txt=false

 REM Debug: [bei Einzel Test's auf=ON] [sonst auf OFF stellen]
 set JobMgr_Debug=OFF
 REM -- JobScriptParametersExtended:
 REM    Hinweis:"JobScriptParametersExtended" ist nach dem ausfueller der # variablen leer
 REM             wenn das Datenfeld von Script/Param. J.Cmd.ParmExt auch leer ist
 #JobScriptParametersExtended#

 REM Steuert Verhalten wenn ein Error aufgetreten ist [ON=Anhalten] [OFF=automatisch weiter arbeiten!]
 REM allgemein einstellen wie JobMgr_Debug [default=%JobMgr_Debug%]
 set JobMgr_OnErrorShowResultOnClient=%JobMgr_Debug%
 REM set JobMgr_OnErrorShowResultOnClient=ON
 
 REM Disk Connect [default=OFF]
 set JobMgr_use_DiskConnect=OFF

 REM -- #Step: Farbe setzen IsIdel
 call :ColorSet IsIdel

 REM -- Rootpfade setzen -------------------------------------------------------
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 REM -- JobServer Variablen ----------------------------------------------------
 set JobManagerRoot_DP=#00-ApplRoot_DP#
 set BinServer_DP=#01-BinServer_DP#
 set BinClient_DP=#02-BinClient_DP#
 set BinPublic_DP=#03-BinPublic_DP#
 set BinPublic_Custom_DP=#03-BinPublic_Custom_DP#
 set BinPublic_ClientServer_DP=#03_BinPublic_ClientServer_DP#
 set JobScriptMinus1_DP=#JobScriptMinus1_DP#

 REM -- JobData ----------------------------------------------------------------
 set JobScripts_DP=#10-JobScripts_DP#
 set JobName=#JobName#
 set JobPacket_NE=#JobPacket_NE#
 set JobParameter=#JobParameter#

 set DataRoot_CustomWorkInst_DP=#DataRoot_CustomWorkInst_DP#

 REM -- uebergabe SiteDef ------------------------------------------------------
 set TcSiteId=#TcSiteId#
 if /i "%Action%" equ "TCXmlImport" set TcSiteId=%TcSiteIdImport%


 REM -- PathVariable erweitern
 set path=%CmdCurRoot_DP%;%BinPublic_Custom_DP%;%BinPublic_ClientServer_DP%;%BinPublic_DP%;%Path%

 set title_str=[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %title_str%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner Debug:%JobMgr_Debug%
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   pause
   Echo #Debug....: Start Explorer
   Echo at JobDir.: [%CmdCurRoot_DP%]
   start "" Explorer "%CmdCurRoot_DP%"
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
:JumbOver

 REM -- temp dir Organiesieren -------------------------------------------------
 set tempOrig_DP=%temp%


 REM -- define incudes #New: 05.07.2016/J.Fes
 set JobMgr_10-JobScriptsInc_01=_JobMgrDefaults
 set JobMgr_10-JobScriptsInc_02=_CustomDefaults\TcPrompt

 rem -- TC Prompt for Custom
 set TCPrompt_Custom_DPNE=%CmdCurRoot_DP%\TCPrompt_Custom.cmd
 if exist "%TCPrompt_Custom_DPNE%" Call "%TCPrompt_Custom_DPNE%"

 rem set SITCONS_AUTH_KEY: important for TCXml Processes with parameter -low_level
 set SITCONS_AUTH_KEY=


 rem #toDo: Setup custom settings
 set JobMgr_use_PLMJobManagerWatchDog=ON


 if /i "%Action%" neq "PLMXmlExport" goto :Next
  rem --#Step: Run PLMexport Process
  Call "%CmdCurRoot_DP%\PLMxmlExport.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"  "%CmdCurRoot_DP%\..\XmlExportImport"
:Next

 if /i "%Action%" neq "TCXmlExport" goto :Next
  rem --#Step: Run TCXmlExport Process
  Call "%CmdCurRoot_DP%\TCXmlExport.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"
:Next

 if /i "%Action%" neq "TCXmlImport" goto :Next
  rem --#Step: Run TCXmlImport Process
  Call "%CmdCurRoot_DP%\TCXmlImport.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"
:Next

 if /i "%Action%" neq "TCXmlConfirmExport" goto :Next
  rem --#Step: Run PLMexport Process
  Call "%CmdCurRoot_DP%\TCXmlConfirmExport.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"
:Next

 if /i "%JobMgr_Test%" neq "ON" goto :JumbOver
  Banner Test:End
  Echo -------------------------------------------------------------------------
  Echo #TestMode.........: End Test
  Echo JobName...........: [%JobName%]
  Echo -------------------------------------------------------------------------
  pause
:JumbOver

REM   rem #New: 14/11/2014/J.Fes
REM   Echo CleanUp......: %CmdCurRoot_DP%\startup\..
REM   rd /S /Q "%CmdCurRoot_DP%\startup"
REM   Echo CleanUp......: %CmdCurRoot_DP%\Resources\..
REM   rd /S /Q "%CmdCurRoot_DP%\Resources"
REM   del /S /Q "%CmdCurRoot_DP%\*.fscproxylog"

REM   rem #New:24/11/2014 18:12/J.Fes preventing sending big logfies to JobServer
REM   call robocopy "%CmdCurRoot_DP%" "%CmdCurRoot_DP%\..\_JobLogFilesNotSendBackToJobServer\%JobName%" "*.*log*" /S /MIN:3072000 /R:5 /W:1


goto :end


REM ###### ------------ Standard Subroutines ---------------------- ##########
REM ============================================================================
:TcPromtCmdError
 Call :ColorSet ERR
 set ErrLog_DPNE=%temp%\__Err_MissingTcPromtCmd_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start process on:\\%ComputerName% missing TcPromptCmd [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo TcPromtCmd:=%TcPromtCmd%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite
 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /i "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo type exit script continues
 cmd
 goto :end


REM ============================================================================
:ErrLogHeaderWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo JobClient Error Report  created %date% %time%>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:ErrLogFooterWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo.>>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 Echo Environ Info of:\\%ComputerName%>>"%ErrLog_DPNE%"
 Echo.>>"%ErrLog_DPNE%"
 Echo -- Path Environ ---------------------------------------------------------->>"%ErrLog_DPNE%"
 set PATH>>"%ErrLog_DPNE%"

 Echo -- UG* Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set UG>>"%ErrLog_DPNE%"
 Echo -- IMAN* Environ --------------------------------------------------------->>"%ErrLog_DPNE%"
 set IMAN>>"%ErrLog_DPNE%"
 Echo -- All Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set>>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:ColorSet
Rem Stand 25.06.2011
Rem Examples:
 REM call :ColorSet Standard
 REM call :ColorSet IsExecuting
 REM call :ColorSet IsIdel
 REM call :ColorSet End
 REM call :ColorSet Ende
 REM call :ColorSet Ok
 REM call :ColorSet Err

 REM -- cmd Color Farbinfo:
 REM    0 = Schwarz        8 = Dunkelgrau
 REM    1 = Dunkelblau     9 = Blau
 REM    2 = Dunkelgrn     A = Grn
 REM    3 = Blaugrn       B = Zyan
 REM    4 = Dunkelrot      C = Rot
 REM    5 = Lila           D = Magenta
 REM    6 = Ocker          E = Gelb
 REM    7 = Hellgrau       F = Wei
 REM -- Farben nach Status setzen
 REM Gelb Schwarz
 if /I "%~1" equ "Standard"    set JobColorLast=E0
 REM 25.06.2011 07:00 Standard eingef. IsExecuting Neu
 if /I "%~1" equ "IsExecuting" set JobColorLast=D0
 REM Blaugrn Schwarz 15.11.2010 07:45 Hellgrau Schwarz
 if /I "%~1" equ "IsIdel"      set JobColorLast=70
 REM Hellgrau Schwarz
 if /I "%~1" equ "End"         set JobColorLast=70
 if /I "%~1" equ "Ende"        set JobColorLast=70
 REM Gruen Schwarz
 if /I "%~1" equ "Ok"          set JobColorLast=A0
 REM Rot Schwarz
 if /I "%~1" equ "Err"         set JobColorLast=C0

 REM jetzt die Farbe setzen
 if "%JobColorLast%" neq "" color %JobColorLast%
 goto :eof

REM ============================================================================
:TypeFile
 REM Types the description and the contens of a file
 setlocal
  set FileToType_DPNE=%~1
  set FileDescription=%~2
  Echo ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---
  Echo Description    : %FileDescription%
  Echo Contens of File: %FileToType_DPNE%
  if     exist "%FileToType_DPNE%" type "%FileToType_DPNE%"
  if not exist "%FileToType_DPNE%" Echo Info...........: File not exist
 endlocal
 goto :eof

REM ============================================================================
:Wait
 set waitTime=2
 if "%1" neq "" set waitTime=%1
 CHOICE.exe /C:w /N /T:w,%waitTime% "warte %waitTime%[sec] oder [w] druecken fuer weiter: "
 goto :eof

REM ============================================================================ 
:Parse_ALL
 REM parst alle File Bezeichner aus
 REM "\" abschneiden
 set Parse_all$temp=%~dp1
 set Parse_all$temp=%Parse_all$temp:~0,-1%
 set %2_DP=%Parse_all$temp%
 set %2_D=%~d1
 REM "\" hinten und vorne abschneiden
 set Parse_all$temp=%~p1
 set Parse_all$temp=%Parse_all$temp:~1,-1%
 set %2_P=%Parse_all$temp%
 set %2_NE=%~nx1
 set %2_N=%~n1
 set %2_E=%~x1
 set %2_DPNE=%1
 set %2_DPN=%~dpn1
 set Parse_all$temp=
goto :eof 

REM ============================================================================
:Ugsshare_DiskConnectErr
 set ErrLog_DPNE=%temp%\__Err_Ugsshare_DiskConnect.txt
 REM schreibt die erweiterten Infos an einen ErrLogFile
 Echo Err: erf. Netzwerkverb. fuer: %TcSiteId% [%ConnectNetUnc_to_Info%] konnte nicht richtig verbunden werden!!>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo --------------------------------------------------------------------->>"%ErrLog_DPNE%"
 type "%ErrLog_DPNE%"
 Echo !!Einstellungen oder Netzwerkverbindungen pruefen!!
 cmd 
 Pause
 goto :eof

REM ============================================================================
:end
 cd /d "%tempOrig_DP%"
 Echo --------------------------------------------------------------------------
 Echo Info: all files in: [%temp%]
 Echo       will be zipt by JobClient and send to JobServer
 REM -- farbe wieder auf standard zurueck setzen
 Call :ColorSet End
