@Echo off

 setlocal EnableDelayedExpansion EnableExtensions
 rem ---------------------------------------------------------
 rem JobManager Generic Script
 rem (c) J.Feuerstein 24.11.2006
 rem
 rem Aenderungs Info:
 rem User    Date/Time (Shift+strg+T)  Infotext:
 rem S.Gueth 09.09.2016                Erstellung
 rem ---------------------------------------------------------
 rem Variablen ersetzungs Abschnitt
 rem Info die mit "#" Gitter eingeschlossenen Vaiablen werden vom JobServer
 rem vor dem senden an den JobClient ersetzt

 set CmdCur_Title=#JobName#
 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=%~3

 rem -- am Anfang Farbe auf IsIdel setzen
 call :ColorSet IsIdel

 REM -- JobScriptParametersExtended:
 REM    Hinweis:"JobScriptParametersExtended" ist nach dem ausfueller der # variablen leer
 REM             wenn das Datenfeld von Script/Param. J.Cmd.ParmExt auch leer ist
 #JobScriptParametersExtended#

 rem ---------------------------------------------------------------------------
 if /i "%JobMgr_Test%" equ "ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner Test:ON
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
 )
 if "%JobMgr_Debug%"=="ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner Debug:ON
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
 )

 rem -- #Step: JobMgr CmdTools local kopieren ----------------------------------
 set JobManagerCmdTools_DP=%JobManagerRoot_DP%\03-BinPublic.ClientServer

 set BinL_DP=%CmdCurRoot_DP%\..\BinL
 if not exist "%BinL_DP%" md "%BinL_DP%"
 Call Echo "TcUser/Group.............: [%JobMgr_TcUser%/%JobMgr_TcGroup%]"
 Call Echo "Upd. JobMgrCmd BinL......: [%BinL_DP%]"
 Call Echo "from.....................: [%JobManagerCmdTools_DP%]"

 set JobManagerCmdTools_L=%BinL_DP%\JobManagerCmdTools.exe
 set robocopy_opt=/R:5 /W:5
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%JobManagerCmdTools_DP%" "%BinL_DP%" "JobManagerCmdTools.exe"
 rem new 21.01.2014
 set JFProcessMonitorL_exe=%BinL_DP%\JFProcessMonitor.exe
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%BinPublic_DP%" "%BinL_DP%" "JFProcessMonitor.exe"

 REM -- Option: Control software starten ---------------------------------------
 rem #New: 21.03.2016/J.Fes
 if /I "%JobMgr_use_PLMJobManagerWatchDog%" equ "ON" (
  Echo --------------------------------------------------------------------------
  call "ProgStart_If_NotRuning.cmd" "PLMJobManagerWatchDog" "%BinPublic_DP%\PLMJobManagerWatchDog_Start.cmd"
 )


:StartJobProcessing
 call :ColorSet IsExecuting
 set JobTimeStart=%Date% %time:~0,8%
 set title_str=Job:[%JobName%] [%TcSiteId%] [Action:%Action%] [Start:%JobTimeStart%] [\\%ComputerName%] [%JobMgr_TcUser%]
 title %title_str%
 Echo %title_str%
 Echo --------------------------------------------------------------------------
 Echo Job Info:
 Echo Action.........................: %Action%
 Echo JobName........................: %JobName%
 Echo Computer.......................: %ComputerName%
 Echo TempDir........................: %temp%
 Echo TcSide.........................: %TcSiteId%
 Echo TcUser.........................: %JobMgr_TcUser%
 Echo CustomMoveToArchive_DP.........: %CustomMoveToArchive_DP%
 Echo Start..........................: %JobTimeStart%
 Echo.
 

 rem -- #Step: TC Prompt erhalten  - - - - - - - - - -
rem set TC_PREFERENCES_OVERRIDE_FROM_FILE=true
rem set TC_PREFERENCES_OVERLAY_FILE=
rem set TC_SHARED_MEMORY_DIR_Disable=true

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "TcPLMxml_Export_2016_02"
 set toRun=%toRun% -SubAction "TcXmlExport"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobData1ToProcessDoPrint
 set toRun=%toRun% -u "%JobMgr_TcUser%"
 set toRun=%toRun% -p "%JobMgr_TcPw%"
 set toRun=%toRun% -g "%JobMgr_TcGroup%"
 set toRun=%toRun% -ShellExecProg_DPNE tcxml_export
 set toRun=%toRun% -ShellExecArguments "%ShellExecArguments_Custom%"
 set toRun=%toRun% -ShellMaxDurationSEC "-1"
 set toRun=%toRun% -JobMgrDataOrg_Root_DP "%JobMgrDataOrg_Root_DP_Custom%"
 set toRun=%toRun% -JobData2ResultsDoPrint
REM  set toRun=%toRun%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  set toRun=%toRun% -verbose -pauseOnEnd
  set toRunForPrint=%toRun:"=%
  Echo --------------------------------------------------------------------------
  call Echo "#Debug...: %~0"
  call Echo "toRun...: %toRunForPrint%"
  Echo --------------------------------------------------------------------------
  pause
 :JumbOverDebug

 REM -- #Step: Run Now Exporting all PLMxmlFiles of Job
 call %toRun%


 set JobTimeEnd=%Date% %time:~0,8%
 Echo.
 Echo --------------------------------------------------------------------------
 Echo End.................: %JobTimeEnd%


 if "%JobMgr_Debug%"=="ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Echo #Debug Info: Ende
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   pause
 )

REM  set JobMgr_Test=ON
 if /i "%JobMgr_Test%" equ "ON" (
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   Banner #Test:End
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  --
   pause
 )
 rem -- Farbe auf JobEnds setzen
 call :ColorSet End

 rd /s /q "%CmdCurRoot_DP%\JobTemp"

goto :end




rem #### ------------ Standard Subroutines --------------------- ######
rem ============================================================================
:JobParam_List
 setlocal
  set JobParams=%~1
  set NCur=0
 :JobParam_List_PrintNext
  set /a NCur=%NCur%+1
  FOR /F "tokens=%NCur% delims=-" %%i IN ("%JobParams%") do Call :JobParam_Print "%%i"
  if %NCur% LEQ 10 goto :JobParam_List_PrintNext
 endlocal
 goto :eof

:JobParam_Print
 setlocal
  set JobParaCur=%~1
  if not "%JobParaCur%"=="" Echo                     : -%JobParaCur%
 endlocal
 goto :eof



rem ============================================================================
:ColorSet
 rem -- cmd Color Farbinfo:
 REM    0 = Schwarz        8 = Dunkelgrau
 REM    1 = Dunkelblau     9 = Blau
 REM    2 = Dunkelgrn     A = Grn
 REM    3 = Blaugrn       B = Zyan
 REM    4 = Dunkelrot      C = Rot
 REM    5 = Lila           D = Magenta
 REM    6 = Ocker          E = Gelb
 REM    7 = Hellgrau       F = Wei

 rem -- Farben nach Status setzen
 rem Gelb Schwarz
 if /I "%1"=="IsExecuting" set JobColorLast=E0
 rem Blaugrn Schwarz
 if /I "%1"=="IsIdel"      set JobColorLast=30
 rem Hellgrau Schwarz
 if /I "%1"=="End"         set JobColorLast=70
 if /I "%1"=="Ende"        set JobColorLast=70
 rem Gruen Schwarz
 if /I "%1"=="Ok"          set JobColorLast=A0
 rem Rot Schwarz
 if /I "%1"=="Err"         set JobColorLast=C0

 rem jetzt die Farbe setzen
 if not "%JobColorLast%"=="" color %JobColorLast%
 goto :eof


rem ============================================================================
:TcPromtCmdError
 Call :ColorSet Err
 set ErrLog_DPNE=%temp%\__Err_MissingTcePromtCmd_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start JobProcess on:\\%ComputerName% missing TCEPromptCmd [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 rem call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo TCEPromtCmd:=%TCEPromtCmd%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 rem call :ErrLogFooterWrite
 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 pause
 start " " Notepad.exe "%ErrLog_DPNE%"
 pause
 goto :end

rem ============================================================================
:Wait
 setlocal
 if "%1" equ "" goto :myEnd
 set waitTime=
 set waitTime=%~1
 set waitTitel=%~2
 if "%waitTitel%" neq "" (
 Echo - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 Echo %waitTitel%
 )
 Wait.exe %waitTime% ESC "wait:[%waitTime%] or push 'ESC'-key to continue"
:myEnd
 endlocal
goto :eof


rem ============================================================================
:ReplaceInvalidChar
 setlocal
  rem entfernt alle unzulaessigen Zeichen
  set ReplaceInvalidChar=%~2
REM   set ReplaceInvalidChar=%ReplaceInvalidChar:~1,-1%
REM   set ReplaceInvalidChar=%ReplaceInvalidChar:-=_%
  rem \ durch _ ersetzen
  set ReplaceInvalidChar=%ReplaceInvalidChar:\=_%
  rem / durch _ ersetzen
  set ReplaceInvalidChar=%ReplaceInvalidChar:/=_%
  rem . durch _ ersetzen
  set ReplaceInvalidChar=%ReplaceInvalidChar:.=_%
  rem " " durch _ ersetzen
  set ReplaceInvalidChar=%ReplaceInvalidChar: =_%
  rem "-" durch _ ersetzen
  set ReplaceInvalidChar=%ReplaceInvalidChar:-=_%
  rem "*" durch _ ersetzen
  set ReplaceInvalidChar=%ReplaceInvalidChar:^*=_%
  rem Echo VarName %1 Wert %2 wird zu %ReplaceInvalidChar%
  rem Echo ReplaceInvalidChar=%ReplaceInvalidChar%
  rem pause
 endlocal& set %1=%ReplaceInvalidChar%
goto :eof

rem ============================================================================
:Parse_ALL
 rem parst alle File Bezeichner aus
 rem "\" abschneiden
 set Parse_all$temp=%~dp1
 set Parse_all$temp=%Parse_all$temp:~0,-1%
 set %2_DP=%Parse_all$temp%
 set %2_D=%~d1
 rem "\" hinten und vorne abschneiden
 set Parse_all$temp=%~p1
 set Parse_all$temp=%Parse_all$temp:~1,-1%
 set %2_P=%Parse_all$temp%
 set %2_NE=%~nx1
 set %2_N=%~n1
 set %2_E=%~x1
 set %2_DPNE=%1
 set %2_DPN=%~dpn1
 set Parse_all$temp=
goto :eof

rem ============================================================================
:TracAc
 rem example: Call :TracAc "%0 [MyInfo XYZ]"
 setlocal

 set P1=%~1
 set P2=%~2
 set P3=%~3
 set P4=%~4
 set P5=%~5
 set P6=%~6
 set P7=%~7
 set P8=%~8
 set P9=%~9
 if DEFINED P1 Echo %date% %time:~0,8% %P1%>>"%TracAc_DPNE%"
 if DEFINED P2 Echo %date% %time:~0,8% %P2%>>"%TracAc_DPNE%"
 if DEFINED P3 Echo %date% %time:~0,8% %P3%>>"%TracAc_DPNE%"
 if DEFINED P4 Echo %date% %time:~0,8% %P4%>>"%TracAc_DPNE%"
 if DEFINED P5 Echo %date% %time:~0,8% %P5%>>"%TracAc_DPNE%"
 if DEFINED P6 Echo %date% %time:~0,8% %P6%>>"%TracAc_DPNE%"
 if DEFINED P7 Echo %date% %time:~0,8% %P7%>>"%TracAc_DPNE%"
 if DEFINED P8 Echo %date% %time:~0,8% %P8%>>"%TracAc_DPNE%"
 if DEFINED P9 Echo %date% %time:~0,8% %P9%>>"%TracAc_DPNE%"
 endlocal
 goto :eof



rem ============================================================================
:end
 cd /d "%temp_DP_org%"
 Echo --------------------------------------------------------------------------
 Echo Info: all files in: [%temp%]
 Echo       will be zipt by JobClient and send to JobServer
 rem -- farbe wieder auf standard zurueck setzen
 Call :ColorSet End
