@Echo off
 Call Echo "****************************************************************************"
 Call Echo "* Excuting TCPBDataImport Script                                           *"
 Call Echo "* Version: 06.05.2021  (c)addPLM GmbH                                      *"
 Call Echo "****************************************************************************"

setlocal

 REM -- #Step: Farbe setzen IsIdel
 call ColorSet IsIdel
 call Echo "--- #Step: Setup Base -----------------------------------------------------"

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=%~3
 if not defined JobMgr_TcGroup  set JobMgr_TcGroup=dba
 if not defined JobMgr_PMon_USE set JobMgr_PMon_USE=OFF

 rem --#Doc: define JobDir and JobFiles
 set JobTemp_DP=%CmdCurRoot_DP%\JobTemp
 if not exist "%JobTemp_DP%" md "%JobTemp_DP%"

 rem --#Doc: define JobFiles
 set JobInputList_NE=_F01_JobInputList.txt
 set JobInputList_DPNE=%JobTemp_DP%\%JobInputList_NE%
 set JobCmdOutPutLog_NE=_F02_CMDLog.txt
 set JobCmdOutPutLog_DPNE=%JobTemp_DP%\%JobCmdOutPutLog_NE%
 set JobLogFile_NE=_F03_Joblog.txt
 set JobLogFile_DPNE=%JobTemp_DP%\%JobLogFile_NE%
 set JobResultFile_NE=_F04_Joblog.txt
 set JobResultFile_DPNE=%JobTemp_DP%\%JobResultFile_NE%%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  call Echo "----------------------------------------------------------------------------"
  call Echo "#Debug..........................: %~0"
  call Echo "#Step...........................: Before Job"
  pause
:JumbOverDebug

 rem --#Steps: from: 'Extract' -to- 'Excute' -to- 'Evaluate' ------------------
 call :JobExecuting "%JobTemp_DP%"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  call Echo "----------------------------------------------------------------------------"
  call Echo "#Debug..........................: %~0"
  call Echo "#Step...........................: after Job"
  pause
 :JumbOverDebug

endlocal& set Program_ExitCode=%Program_ExitCode%
goto :eof

rem ============================================================================
:JobExecuting
 rem #Doc: Main Script to run process
 rem #Doc get File Params

 set temp=%~1
 set tmp=%temp%

 set TC_SQL_DEBUG=
 set TC_TMP_DIR=%temp%
 set TC_KEEP_SYSTEM_LOG=TRUE
 set TC_Journalling=OFF
 set TC_Journaling=OFF
 set TC_TRACEBACK=OFF

 set BMF_BYPASS_ALL_EXTENSION_RULES=ON
 set NR_BYPASS=1
 set AM_BYPASS=ON

 call ColorSet IsExecuting
 call Echo "--- #Step: Job Executing ---------------------------------------------------"

 REM -- Run fccCheck #New 06.05.2021
 if defined JobMgr_fccCheck_parentfsc_address set JobMgr_fccCheck_USE=true
 Call "%CmdCurRoot_DP%\fccCheck.cmd"

 REM -- set Parameter ----------------
 set JobParameter=#JobParameter#
 if not defined JobParameter set JobParameter=-No_Paramter

 REM -- Run fccCheck
 REM  set JobMgr_fccCheck_USE=true
 rem call fccCheck.cmd

 set titleTxt=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%

 Echo.                                                                               .
 Echo %titleTxt%
 call Echo "----------------------------------------------------------------------------"
 Call Echo "Job Settings:"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "JobName.........................: %JobName%"
 Call Echo "Computer........................: %ComputerName%"
 Call Echo "JobDir..........................: %temp:~-50%"
 Call Echo "##- - - - TC settings: - - - -##"
 Call Echo "TcSide..........................: #TcSite.SiteInfoWith_SiteId_and_pName#"
 Call Echo "TcUser..........................: %JobMgr_TcUser%"
 Call Echo "TC_ROOT.........................: %TC_ROOT%"
 Call Echo "TC_DATA.........................: %TC_DATA%"
 Call Echo "TC_SHARED_MEMORY Disable........: %TC_SHARED_MEMORY_DIR_Disable%"
 Call Echo "FMS FMS_HOME....................: %FMS_HOME%"
 Call Echo "FCC CHK.........................: %JobMgr_fccCheck_USE%//ParentFscAdr:%JobMgr_fccCheck_parentfsc_address%"
 Call Echo "##- - - - Job settings:  - - -##"
 Call JobParam_List "Job Parameter...................:" "%JobParameter%"
 Call Echo "Proc.Monitor....................: %JobMgr_PMon_USE%"

 cd /d "%temp%"
 set >>"%temp%\zzEnvironBeforeJob.txt"


 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobData2ResultsDoPrint
 set toRun=%toRun% -JobParaDoPrint
 set toRun=%toRun% -SubActionSettingsXML "%SubActionSettingsXML%"
 set toRun=%toRun% -u "%JobMgr_TcUser%"
 set toRun=%toRun% -p "%JobMgr_TcPw%"
 set toRun=%toRun% -g "%JobMgr_TcGroup%"
 set toRun=%toRun% -TcSQL_DP "#02-BinClient_DP#.Custom\_CustomTcSQL\%TcSiteId%"
 set toRun=%toRun% -verbose
REM  set toRun=%toRun% -HashCodeGenOFF

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_03_ExecuteProcess.txt
  set toRun=%toRun% -verbose -pauseOnEnd -Pause
  set toRunForPrint=%toRun:"='%
  Call Echo "#Debug:.........................: Before: [%~0]"
  call Echo "#ToRun..........................: %toRunForPrint%"
  Echo %toRun% >>"%Debug_DPNE%"
:JumbOverDebug

REM   ECHO -----------------------------------
REM   Echo #Debug LI:#LiNum# %~0
REM   Echo continue and exit via exit
REM   cmd

 call  %toRun%

 IF /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Call Echo "#Debug:.........................: Results Info"
  Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
  Call Echo "#Debug..........................: %~0 Job:Execute END"
  pause
:JumbOverDebug

goto :eof

