@Echo off
 REM ===========================================================================
 REM Basisscript JobManager V2 fuer den Refile mit NX8 in der TC Umgebung
 REM (c) J.Feuerstein 24.11.2006
 rem
 REM Aenderungs Info:
 REM User    Date/Time (Alt+D)  Infotext:
 REM J.Fes   24.11.2006 00:05   Ersterstellung 24.11.2006
 REM J.Fes   14.07.2013 15:54   Skript umgestellt auf JCT Tools
 REM ===========================================================================

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2

 Call Echo "**************************************************************************"
 Call Echo "* Excuting NX.Macro in PLMJobManager Environ                              *"
 Call Echo "* Version: 10.02.2017 00:27 (c)addPLM GmbH                                *"
 Call Echo "**************************************************************************"

 REM -- define incudes #New: 05.07.2016/J.Fes
 set JobMgr_10-JobScriptsInc_01=_JobMgrDefaults
 set JobMgr_10-JobScriptsInc_02=_CustomDefaults\TcPrompt

 rem -- #Doc: 07.07.2016/J.Fes Use to refile 'SO SiteObjects' as 'RO ReplicaObjects'
 rem if not defined JobMgr_RfUse_for_SO_RO set JobMgr_RfUse_for_SO_RO=YES

 REM -- #Doc: Inits all Basics of Job
 Call "%~dp0_JobInitial.cmd" "NxMacro" "YES" "NO" "YES" "YES"


 rem -- TC Prompt for Custom
 set TCPrompt_Custom_DPNE=%CmdCurRoot_DP%\TCPrompt_Custom.cmd
 set TCPrompt_Custom_Opt=NX110

 set titleTxt=Rf:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%

 if exist "%TCPrompt_Custom_DPNE%" Call "%TCPrompt_Custom_DPNE%"


 rem -- #Dco: setup Macro
 set NXTitle=NX10 PLM Macro
 rem #Doc: .macro file must be in Code page: UTF-8
 set NXMacroTemplate_PPNE=NXMacros\NXMacro_SaveActivePart_Close.macro
 set NXUgrafParamExtended_Custom= -bypass=yes


if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Debug NXTitle..................: %NXTitle%"
 call Echo "NXMacroTemplate_PPNE............: %NXMacroTemplate_PPNE%"
 pause
:JumbOverDebug


if "%JobMgr_TCPromptGet_ResCode%" equ "0" Call :StartNxMacroExecute

if /i "%JobMgr_Test%" neq "ON" goto :JumbOverTest
 Banner Test:End
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Test..........................: ENDE"
 call Echo "#toRun.........................: %toRunForPrint%"
 pause
:JumbOverTest



rem und Ende
goto :end

REM ----------------------------------------------------------------------------
:StartNxMacroExecute
 REM -- extend PathVariable
 set path=%CmdCurRoot_DP%;%BinPublic_Custom_DP%;%BinPublic_ClientServer_DP%;%BinPublic_DP%;%Path%

 rem #Doc: if *__MaxSEC = 0 then process Wait allways = Never stopps searching for titel
 set NXFindCondition10_TitlesNoPart=%NXTitle%;%NXTitle% -;%NXTitle% - [No Part];%NXTitle% - [Kein Teil]
 set NXFindCondition10_TitlesNoPart_MaxSEC=0
 set NXFindCondition20_TitleLike=%NXTitle%*
 set NXFindCondition20_TitleLike_MaxSEC=0
 set NXMacroTemplate_DPNE=%CmdCurRoot_DP%\%NXMacroTemplate_PPNE%
 set NXMacroRuns_MaxSEC=0
 set NXAfterAction_WaitTime_Msec=1500

 Call "%CmdCurRoot_DP%\NxMacroExecute.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"
goto :end
REM ============================================================================
:end
 cd /d "%tempOrig_DP%"
 Echo --------------------------------------------------------------------------
 Echo Info: all files in: [%temp%]
 Echo       will be zipt by JobClient and send to JobServer
