@Echo off
 REM ===========================================================================
 REM Basisscript JobManager V2 fuer den Refile mit NX in der TC Umgebung
 REM (c) J.Feuerstein 24.11.2006
 REM Aenderungs Info:
 REM User    Date/Time (Alt+D)  Infotext:
 REM J.Fes   24.11.2006 J.Fes   Ersterstellung 05.09.2013
 REM J.Fes   14.07.2013 J.Fes   Skript umgestellt auf JS Cmd Tools
 REM J.Fes   19.11.2013 J.Fes   integrate UGII_LOAD_OPTIONS + UGII_LOCAL_USER_DEFAULTS
 REM J.Fes   25.12.2013 J.Fes   result is now returning via: %PrgExitCode%
 REM J.FES   21.01.2014 J.Fes   add Process Monitoring
 REM J.FES   12.02.2014 J.Fes   add ResultClassification_DPNE
 REM J.FES   29.04.2014 J.Fes   add JobMgr_RfExtEvalROpt
 REM J.FES   29.04.2014 J.Fes   setlocal endlocal partial removed
 REM J.FES   02.06.2014 J.Fes   error reporting enhanced
 REM ===========================================================================

 Echo **************************************************************************
 Echo * Excuting Refile Script for  PLMJobManager Environ                      *
 Echo * Version: 02.06.2014 addPLM GmbH (c)                                    *
 Echo **************************************************************************

setlocal
 REM -- #Step: Farbe setzen IsIdel
 call :ColorSet IsIdel

 call Echo "--- #Step: Set Up Base ---------------------------------------------------------"

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=%~3
 if not defined JobMgr_TcGroup set JobMgr_TcGroup=dba

 REM -- temp dir Organiesieren -------------------------------------------------
 rem #New: 11.07.2013 13:43 S.Gue
 set JobTemp1_SO_DP=%CmdCurRoot_DP%\JobTempSO
 set JobTemp2_RO_DP=%CmdCurRoot_DP%\JobTempRO
 set RfLogFile_NE=_Rf20_RefileJob.log
 set RfFailedLog_NE=_Rf21_RefileFailed.log
 set RfCmdJobLog_NE=_Rf23_RefileCmdJob.log

 rem #New 30.11.2013 /J.Fes
 set ExtractJobList_MsgLog_DPNE="%CmdCurRoot_DP%\JobData1_ExtractList.log"
 set EvaluateJobResult_MsgLog_DPNE="%CmdCurRoot_DP%\JobData2_ResultEvaluate.log"

 REM -- define cmd files to set variables --------------------------------------
 set JobCustomSetEnv_cmd=%CmdCurRoot_DP%\JobCustomSetEnv.cmd

 rem -- Execute first time RfCustomSetEnv.cmd
 if exist "%JobCustomSetEnv_cmd%" call "%JobCustomSetEnv_cmd%"

 REM -- Option: Control software starten ---------------------------------------
 rem #New: 30.11.2013/J.Fes
 if /I "%JobMgr_use_PLMJobManagerWatchDog%" equ "ON" (
  REM Echo Check Start: PLMJobManagerWatchDog.exe
  Echo --------------------------------------------------------------------------
  call "ProgStart_If_NotRuning.cmd" "PLMJobManagerWatchDog" "%BinPublic_DP%\PLMJobManagerWatchDog_Start.cmd"
 )

 rem #New: 19.06.2014/J.Fes
 if /I "%JobMgr_start_TaskMgr%" equ "ON" (
  REM Echo Check Start: TaskMgr.exe
  Echo --------------------------------------------------------------------------
  call "ProgStart_If_NotRuning.cmd" "TaskMgr" "taskmgr.exe"
 )

 REM new 31.05.2010 21:53
 if /i "%JobMgr_use_TcServerKill%" equ  "ON" (
   call ProgIs_Running.cmd  teamcenter teamcenter_Is_running
   if "%teamcenter_Is_running%" equ "0" (
     REM TcServer Process beenden aber nur wenn TeamCenter nicht aktive ist
     call ProgKill.cmd TcServer "#12-Data#\Refile_TcServerStop_log.txt"
    )
 )


 call Echo "--- #Step: ExecuteMacro ---------------------------------------"
 call :ExecuteMacro "%CmdCurRoot_DP%\JobTemp"


 endlocal& set PrgExitCode=%PrgExitCode%
goto :end


rem ============================================================================
:ExecuteMacro
 rem #Doc: Main Script to run Refile
 rem #Doc get File Params
 set temp=%~1
 if not exist "%temp%" md "%temp%"

 rem #New 15.04.2014 13:48
 set tmp=%temp%
 set HOME=%temp%


 set JobErrLog_DPNE=%temp%\_RfErfrLog.txt

 REM -- cut '\' on end
 if "%UGII_BASE_DIR:~-1%" equ "\" set UGII_BASE_DIR=%UGII_BASE_DIR:~0,-1%
 if "%UGII_ROOT_DIR:~-1%" equ "\" set UGII_ROOT_DIR=%UGII_ROOT_DIR:~0,-1%

 REM -- extend search path
 set Path=%UGII_BASE_DIR%;%UGII_ROOT_DIR%;%Path%

 set UGII_TMP_DIR=%temp%
 SET UGII_KEEP_SYSTEM_LOG=TRUE
 set UGII_UGSOLIDS_TMP=%UGII_TMP_DIR%

 REM disable eingefuegt 17.08.12 J.Fes/K.S
 set UGII_UGMGR_USE_CACHE=

 REM -- Symetric Multi-Processing (SMP) disable
 REM diabled 07.02.2011
 set UGII_SMP_ENABLE=

 REM -- CGM erstellung deaktiveren eingefuegt 09.02.10 J.fes
 set UGII_IMAGE_CREATE_CGM=
 set UGII_IMAGE_CREATE_CGM_DRAW=
 set UGII_IMAGE_CREATE_CGM_OPTIONS=
 set UGII_IMAGE_CREATE_NAME=
 set UGII_IMAGE_CREATE_ORIGINAL_BACKGROUND=

 REM -- PFM vermeidet fehler beim refile von PFM Parts eingefuegt 29.11.2010 Info erhalten ber IR1814812
 set UGII_UGMGR_ALLOW_PFM_IMPORT_EXPORT=1

 REM -- IMAN-Variablen umbiegen -------------------------------------------
 SET IMAN_SQL_DEBUG=
 set IMAN_TMP_DIR=%temp%
 SET IMAN_KEEP_SYSTEM_LOG=TRUE
 SET IMAN_Journalling=OFF
 SET IMAN_journaling=OFF
 SET IMAN_TRACEBACK=OFF
 SET IMAN_Journal_Modules=NONE
 SET API_JOURNAL=NONE
 set APB_SCHEMA=

 REM -- TC-Variablen umbiegen -------------------------------------------
 REM 11.08.10 SQL Debug on for Test's
 SET TC_SQL_DEBUG=
 set TC_TMP_DIR=%temp%
 SET TC_KEEP_SYSTEM_LOG=TRUE
 SET TC_Journalling=OFF
 SET TC_Journaling=OFF
 SET TC_TRACEBACK=OFF

 REM -- define Load_options -----------------------------------------------
 set UGII_LOAD_OPTIONS=%CmdCurRoot_DP%\startup\load_options.def

 REM -- define nx_refile.dpv -----------------------------------------------
 SET UGII_LOCAL_USER_DEFAULTS=%CmdCurRoot_DP%\startup\NxMacroExecute.dpv
 set UGII_USER_DIR=%CmdCurRoot_DP%
 set UGII_GROUP_DIR=


 rem 21.01.2014
 rem Monitors NxCB_program_exe_NE
 rem  - mit max 2 Std Laufzeit
 rem  - mit max 6gb Memory usage fr 5 min
 rem  - mit max 5 min ohne das neue files im JobTemp entstehen oder editiert werden
 set toMon=%JFProcessMonitorL_DPNE%
 set toMon=%toMon% --waitForProcess 10000
 set toMon=%toMon% --processName ugraf
 set toMon=%toMon% --parentProcessId 0
 REM  set toMon=%toMon% --runtimeLimitSeconds 7200
 set toMon=%toMon% --killChildProcesses
 set toMon=%toMon% --fileLastWriteTime "%temp%\*.*;600"
 REM  set toMon=%toMon% --memoryUsageHigh 6000;300
 set toMon=%toMon% --saveResultsTo "%temp%\zzJFProcessMonitor_log.xml"
 set toMon=%toMon% --tailTextFile "%temp%\%username%*.syslog"
 set toMon=%toMon% --titlePrefix "Job:[%JobName%][%TcSiteId%]"

 REM -- set Rf Parameter ----------------
 set PrgExitCode=
 set JobPara=#JobParameter#

 REM -- set Rf.Contol defaults ----------
 set TC_SHARED_MEMORY_DIR_Disable=false
 set JobMgr_JobPMon_USE=true
 set JobMgr_fccCheck_USE=true

 REM -- set Rf.Environ
 if exist "%RfSetEnv_cmd%" call "%RfSetEnv_cmd%"
 REM -- set Custom.Environ
 if exist "%JobCustomSetEnv_cmd%" call "%JobCustomSetEnv_cmd%"

 REM -- Refile Programm --------------------------------------------------------
 set ugraf_exe_DPNE=%UGII_ROOT_DIR%\ugraf.exe

 rem #New: 30.05.2014 TC_SHARED_MEMORY_DIR
 if /i "%TC_SHARED_MEMORY_DIR_Disable%" neq "true" goto :TC_SHARED_MEMORY_DIR_Enable

:TC_SHARED_MEMORY_DIR_Disable
 rem disable TC_SHARED_MEMORY_DIR, via:
 set TC_NO_TEXTSRV_SHARED_MEMORY=TRUE
 set TC_USE_METADATA_SHARED_MEMORY=FALSE
 set TC_USE_PREFS_SHARED_MEMORY=FALSE
 goto :TC_SHARED_MEMORY_DIR_Next

:TC_SHARED_MEMORY_DIR_Enable
 set TC_SHARED_MEMORY_DIR=%CmdCurRoot_DP%\..\TC_SHARED_MEMORY_%TcSiteId%
 if not exist "%TC_SHARED_MEMORY_DIR%" md "%TC_SHARED_MEMORY_DIR%"
 goto :TC_SHARED_MEMORY_DIR_Next

:TC_SHARED_MEMORY_DIR_Next

 call :Parse_NE %UGII_LOAD_OPTIONS%        UGII_LOAD_OPTIONS
 call :Parse_NE %UGII_LOCAL_USER_DEFAULTS% UGII_LOCAL_USER_DEFAULTS

 set titleRf_str=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleRf_str%

 Echo.                                                                               .
 call :ColorSet IsExecuting
 Echo %titleRf_str%
 call Echo "----------------------------------------------------------------------------"
 Call Echo "Macro Job Settings:"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "JobName.................: %JobName%"
 Call Echo "Computer................: %ComputerName%"
 Call Echo "JobDir..................: %temp:~-50%"
 Call Echo "TcSide..................: #TcSite.SiteInfoWith_SiteId_and_pName#"
if "%TC_ROOT%" equ "" goto :NextStep
 Call Echo "TcUser..................: %JobMgr_TcUser%"
 Call Echo "FMS_HOME................: %FMS_HOME%"
 Call Echo "TC_ROOT.................: %TC_ROOT%"
 Call Echo "TC_DATA.................: %TC_DATA%"
:NextStep
 Call Echo "UGII_LOAD_OPTIONS.......: ..\%UGII_LOAD_OPTIONS_NE%"
 Call Echo "UGII_SITE_DIR...........: %UGII_SITE_DIR%"
 Call Echo "UGII_LOCAL_USER_DEF.....: ..\%UGII_LOCAL_USER_DEFAULTS_NE%"

 cd /d "%temp%"
 set >>"%temp%\zzEnvironBevorRefile.txt"
 if /i "%JobMgr_JobPMon_USE%" neq "false" start "PMon Job:[%JobName%][%TcSiteId%]" %toMon%
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "Job Protocol:"

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "NxDataProcessing_2013_09"
 set toRun=%toRun% -SubAction "NXMacroExecute"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"

 set toRun=%toRun% -NXFindCondition10_TitlesNoPart "%NXFindCondition10_TitlesNoPart%"
 set toRun=%toRun% -NXFindCondition10_TitlesNoPart_MaxSEC "%NXFindCondition10_TitlesNoPart_MaxSEC%"
 set toRun=%toRun% -NXFindCondition20_TitleLike "%NXFindCondition20_TitleLike%"
 set toRun=%toRun% -NXFindCondition20_TitleLike_MaxSEC "%NXFindCondition20_TitleLike_MaxSEC%"
 set toRun=%toRun% -NXMacroTemplate_DPNE "%NXMacroTemplate_DPNE%"
 set toRun=%toRun% -NXMacroRuns_MaxSEC "%NXMacroRuns_MaxSEC%"
 set toRun=%toRun% -NXAfterAction_WaitTime_Msec "%NXAfterAction_WaitTime_Msec%"
 set toRun=%toRun% -NXTitle "%NXTitle%"
rem set toRun=%toRun% -CloseNxOnEnd
 set toRun=%toRun% -OpenNxOnStart
 set toRun=%toRun% -NXUgrafParamExtended "%NXUgrafParamExtended_Custom%"


  if "%TC_ROOT%" equ "" goto :NextStep
   set toRun=%toRun% -u "%JobMgr_TcUser%" -p "%JobMgr_TcPw%"
   if defined JobMgr_TcGroup set toRun=%toRun% -g "%JobMgr_TcGroup%"
 :NextStep
 set toRun=%toRun% -JobData1ToProcessDoPrint
 set toRun=%toRun% -JobData2ResultsDoPrint

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_01NXMacroExecute.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   Echo #Debug.: BEVOR: [%~0]
   Echo %toRun% >>"%Debug_DPNE%"
   Echo %toRun%
   set toRunForPrint=%toRun:"=%
   call Echo " %~0 toRun:%toRunForPrint% " "" "NOECHO"
   pause
:JumbOverDebug

 call %toRun%
 set PrgExitCode=%errorlevel%

 call Echo "--- #Res.: PrgExitCode.: [%PrgExitCode%] ---------------------------------------------"
 Call Echo "End" "" "NOECHO"
 Banner "End"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  call Echo "---------------------------------------------------------------------------"
  call Echo "#Debug PrgExitCode..............: %PrgExitCode%"
  call Echo "#toRun..........................: %toRunForPrint%"
  call Echo "#Step...........................: #Desctription"
  pause
 :JumbOverDebug
 
 Echo CleanUp......: %temp%\%userName%2TierTransientVolume\..
 rd /S /Q  "%temp%\%userName%2TierTransientVolume" >nul 1>nul 2>nul

 if "%PrgExitCode%" equ "0" goto :PrgExitOK
 goto :ProcessEnd

:PrgExitOK
 Call :ColorSet OK
 REM -- delete alle files not to send to JobServer
 if /I "%JobMgr_TcNxDebug%" neq "ON" (
       if /I "%JobMgr_Debug%" neq "ON" (
          Echo CleanUp......: %temp%\..
          del /S /Q "%temp%\apiserver.exe*.*","%temp%\*.bak","%temp%\*.tmp","%temp%\*.prt","%temp%\tcserver.*","%temp%\tcserver.*.*">nul 1>nul 2>nul
       )
 )
 goto :ProcessEnd

:ProcessEnd
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo.
  Echo #Debug:%~0 [Rf:End]
  pause
:JumbOverDebug
goto :eof

REM ============================================================================
:Parse_NE
 set %2_NE=%~nx1
 goto :eof


:end
