@Echo off
 REM      Date       User    Description
 REM #LUp:25.02.2022/S.Gueth initial for TC Part Update UnDo

 Call Echo "****************************************************************************"
 Call Echo "* Excuting Script for N Part Utility UnDo                                  *"
 Call Echo "* Version: 25.02.2022 (c)addPLM GmbH                                       *"
 Call Echo "****************************************************************************"

setlocal

 REM -- #Step: Farbe setzen IsIdel
 Call ColorSet IsIdel
 Call Echo "--- #Step: Setup Base ------------------------------------------------------"
 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=%~3

 if not defined JobMgr_TcGroup        set JobMgr_TcGroup=dba
 if not defined JobMgr_NxPuDataSets   set JobMgr_NxPuDataSets=OFF
 if not defined JobMgr_TCDataCheck    set JobMgr_TCDataCheck=OFF
 if not defined JobMgr_NxPuPMon_USE   set JobMgr_NxPuPMon_USE=ON
 if not defined JobMgr_NxPuExtEvalROptForPrint  set JobMgr_NxPuExtEvalROptForPrint=OFF


  rem #Doc: Main Script to run NxPartUtil
 rem #Doc get File Params
 set temp=%~1
 set tmp=%temp%
 rem #LUp: 04.01.17/J.Fes
 Call :Parse_D "%temp%" HOMEDRIVE
 Call :Parse_P "%temp%" HOMEPATH
 set HOME=%temp%

 set NxPartUtilJobLog_DPNE=%~2
 set NxPartUtilJobLog2_DPNE=%~dpn2_2%~x2
 set NxPartUtilFailedLog_DPNE=%~3
 set NxPartUtilCmdJobLog_DPNE=%~4
 set NxPartUtilPaket_DPNE=%~5
 set JobMgr_NxPartUtilReplica=%~6

 set NxPartUtilErrLog_DPNE=%temp%\_PartUErrLog.txt

 set UGII_TMP_DIR=%temp%
 set UGII_KEEP_SYSTEM_LOG=TRUE
 set UGII_UGSOLIDS_TMP=%temp%

 REM disable eingefuegt 17.08.12 J.Fes/K.S
 set UGII_UGMGR_USE_CACHE=

 REM -- Symetric Multi-Processing (SMP) disable
 REM diabled 07.02.2011
 set UGII_SMP_ENABLE=

 REM -- CGM erstellung deaktiveren eingefuegt 09.02.10 J.fes
 set UGII_IMAGE_CREATE_CGM=
 set UGII_IMAGE_CREATE_CGM_DRAW=
 set UGII_IMAGE_CREATE_CGM_OPTIONS=
 set UGII_IMAGE_CREATE_NAME=
 set UGII_IMAGE_CREATE_ORIGINAL_BACKGROUND=

 REM -- PFM soves ISSUES processing PFM Parts 29.11.2010 Info erhalten ber IR1814812
 set UGII_UGMGR_ALLOW_PFM_IMPORT_EXPORT=1

 REM -- IMAN-Variablen umbiegen -------------------------------------------
 set IMAN_SQL_DEBUG=
 set IMAN_TMP_DIR=%temp%
 set IMAN_KEEP_SYSTEM_LOG=TRUE
 set IMAN_Journalling=OFF
 set IMAN_journaling=OFF
 set IMAN_TRACEBACK=OFF
 set IMAN_Journal_Modules=NONE
 set API_JOURNAL=NONE
 set APB_SCHEMA=

 REM -- TC-Variablen umbiegen -------------------------------------------
 REM 11.08.10 SQL Debug on for Test's
 set TC_SQL_DEBUG=
 set TC_TMP_DIR=%temp%
 set TC_KEEP_SYSTEM_LOG=TRUE
 set TC_Journalling=OFF
 set TC_Journaling=OFF
 set TC_TRACEBACK=OFF

 REM -- def: TC LOG --------------------
 set TC_Administration_Logging=OFF
 set TC_System_Logging=OFF
 set TC_LOG=%TC_TMP_DIR%

REM -- use password file if pw file is avilable
if "%JobMgr_TcPwFile_DPNE%" equ "" set JobMgr_TcPwOpt=-p="%JobMgr_TcPw%"
if "%JobMgr_TcPwFile_DPNE%" neq "" set JobMgr_TcPwOpt=-pf="%JobMgr_TcPwFile_DPNE%"



 set titleTxt=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%

 Echo.                                                                               .
 Call ColorSet IsExecuting
 Echo %titleTxt%
 Call Echo "----------------------------------------------------------------------------"
 Call Echo "NxPartUtil Job Settings:"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "JobName.........................: %JobName%"
 Call Echo "Computer........................: %ComputerName%"
 Call Echo "NxPartUtilDir....................: %temp:~-50%"
 Call Echo "##- - - - TC settings: - - - -##"
 Call Echo "TcSide..........................: #TcSite.SiteInfoWith_SiteId_and_pName#"
 Call Echo "TcUser..........................: %JobMgr_TcUser%"
 Call Echo "TC_ROOT.........................: %TC_ROOT%"
 Call Echo "TC_DATA.........................: %TC_DATA%"
 Call Echo "TC_SHARED_MEMORY Disable........: %TC_SHARED_MEMORY_DIR_Disable%"
 Call Echo "FMS FMS_HOME....................: %FMS_HOME%"
 Call Echo "FCC CHK.........................: %JobMgr_fccCheck_USE%//ParentFscAdr:%JobMgr_fccCheck_parentfsc_address%"
 Call Echo "##- - - - NX settings: - - - -##"
 Call Echo "UGII_ROOT_DIR...................: %UGII_ROOT_DIR%"
 Call Echo "UGII_LOAD_OPTIONS...............: %UGII_LOAD_OPTIONS%"
 Call Echo "UGII_SITE_DIR...................: %UGII_SITE_DIR%"
 Call Echo "UGII_LOCAL_USER_DEF.............: ..\%UGII_LOCAL_USER_DEFAULTS_NE%"
 Call Echo "##- - - - Rf settings: - - - -##"
 Call :JobParam_List "NxPartUtil Parameter............." "%NxPartUtilPara%"
 Call Echo "NxPu via Datasets...............: %JobMgr_NxPuDataSets%"
 Call Echo "NxPu SiteObj as ReplicaObj......: %JobMgr_NxPuUse_for_SO_RO%"
 Call Echo "NxPu Replica Parts..............: %JobMgr_NxPartUtilReplica%"
 Call Echo "NxPu Eval TC DataCheck ON/OFF...: %JobMgr_TCDataCheck%"
 Call Echo "NxPu Eval Use Custom eval.......: %JobMgr_NxPuExtEvalROptForPrint%"
 Call Echo "NxPu Proc.Monitor ON/OFF........: %JobMgr_NxPuPMon_USE%"


 rem  #Doc: Execute via Datasets
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "Process TC.NX.Parts via DataSets:"

 set NxPartUtilPrgExitCode=0
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -SubActionSettingsXML "%JobMgr_TCPartUpdateUnDoSettingsXml%"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -TcSQL_DP "#TcSQL_DP#"
 set toRun=%toRun% -u "%JobMgr_TcUser%"
 if "%JobMgr_TcPwFile_DPNE%" equ "" set toRun=%toRun% -p "%JobMgr_TcPw%"
 if "%JobMgr_TcPwFile_DPNE%" neq "" set toRun=%toRun% -pf "%JobMgr_TcPwFile_DPNE%"
 set toRun=%toRun% -g "%JobMgr_TcGroup%"
 set toRun=%toRun% -JobParaDoPrint -JobData2ResultsDoPrint

 IF /i "%JobMgr_Debug%" NEQ "ON" goto :JumbOverDebug
   set toRun=%toRun% -verbose -pauseOnEnd
   set toRunForPrint=%toRun:"='%
   Call Echo "#Debug:.........................: Before TC.Refile via DataSets"
   Call Echo "toRun...........................: %toRunForPrint%"
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_02_RfDataSets_cmd.txt
   Echo %toRun% >>"%Debug_DPNE%"
   pause
 :JumbOverDebug

 REM #Doc: Process TC.NX.Parts via Dataset controled by JobManagerCmdTools
 Call %toRun%

 IF /i "%JobMgr_Debug%" EQU "ON" (
  Call Echo "#Debug:.........................: After TC.Refile via DataSets"
  pause
 )

endlocal
goto :end





REM ####### ------------ Standard Subroutines ---------------------- ###########
REM ============================================================================
:JobParam_List
 setlocal
  set ParmListTitle=%~1
  set JobParams=%~2
  rem " ersetzen durch '
  set JobParams=%JobParams:"='%
  set NCur=0
:JobParam_List_PrintNext
  set /a NCur=%NCur%+1
  FOR /F "tokens=%NCur% delims=-" %%i IN ("%JobParams%") do Call :JobParam_Print "%%i"
  if %NCur% LEQ 10 goto :JobParam_List_PrintNext
 endlocal
 goto :eof

:JobParam_Print
 setlocal
  set JobParaCur=%~1
  if "%NCur%" equ "1" (
                            Call Echo "%ParmListTitle% -%JobParaCur%"
  ) else (
   if "%JobParaCur%" neq "" Call Echo "................................: -%JobParaCur%"
  )
 endlocal
 goto :eof

REM ============================================================================
:TypeFile
 REM Types the description and the contens of a file
 setlocal
  set FileToType_DPNE=%~1
  set FileDescription=%~2
  Echo ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ----
  Echo File Content Description........: %FileDescription%
  Echo Content of File.................: %FileToType_DPNE%
  if     exist "%FileToType_DPNE%" type "%FileToType_DPNE%"
  if not exist "%FileToType_DPNE%" Echo ERROR:fnf file not found........: [%FileToType_DPNE%]

 endlocal
 goto :eof

REM ============================================================================
:Parse_NE
 set %2_NE=%~nx1
 goto :eof

:Parse_D
 set %2=%~d1
 goto :eof

:Parse_P
 set %2=%~p1
 goto :eof

REM ============================================================================
:end
