@Echo off
 REM      Date       User   Description
 REM #LUp:15.03.2018/J.Fes  add JobMgr_TCDataCheck
 REM #LUp:15.03.2018/J.Fes  Re.Org: UGII_LOAD_OPTIONS_NE // UGII_LOCAL_USER_DEFAULTS_NE
 REM #LUp:24.04.2018/J.Fes  Re.Org: add -Action "PartUtility_2018_04"
 REM #LUp:20.07.2022/J.Fes  PMon and List Data get Updated
 REM #LUp:12.12.2022/J.Fes  add Echo BMF_BYPASS_ALL_EXTENSION_RULES.. AM_BYPASS
 REM #LUp:23.07.2023/J.Fes  Check Version for current partupdate process
 REM #LUp:31.12.2023/J.Fes  add redo Check
 REM #LUp:14.01.2024/J.Fes  enhance PMon fileLastWriteTimeSec
 REM #LUp:08.07.2024/J.Fes  enhance :Redo
 REM #LUp:04.11.2024/J.Fes


 Call Echo "****************************************************************************"
 Call Echo "* Excuting Script for JobMgr Part Utility                                  *"
 Call Echo "* Version:04.11.2024 (c)addPLM GmbH                                        *"
 Call Echo "****************************************************************************"

setlocal

 REM -- #Step: Farbe setzen IsIdel
 Call ColorSet IsIdel
 Call Echo "--- #Step: Setup Base ------------------------------------------------------"
 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=%~3

 if not defined JobMgr_TcGroup        set JobMgr_TcGroup=dba
 if not defined JobMgr_NxPuDataSets   set JobMgr_NxPuDataSets=OFF
 if not defined JobMgr_TCDataCheck    set JobMgr_TCDataCheck=OFF
 if not defined JobMgr_NxPuPMon_USE   set JobMgr_NxPuPMon_USE=ON
 if not defined JobMgr_NxPuExtEvalROptForPrint  set JobMgr_NxPuExtEvalROptForPrint=OFF


 REM -- temp dir Organiesieren -------------------------------------------------
 rem #New: 11.07.2013 13:43 S.Gue
 set JobTemp1_SO_DP=%CmdCurRoot_DP%\JobTempSO
 set JobTemp2_RO_DP=%CmdCurRoot_DP%\JobTempRO
 set NxPartUtilLog_NE=_NxPartUtil20_Job.log
 set NxPartUtilFailedLog_NE=_NxPartUtil21_Failed.log
 set NxPartUtilCmdJobLog_NE=_NxPartUtil23_CmdJob.log

 REM -- define cmd files to set variables --------------------------------------
 set NxPartUtilSetEnv_cmd=%CmdCurRoot_DP%\NxPartUtilSetEnv.cmd
 set NxPartUtilCustomSetEnv_cmd=%CmdCurRoot_DP%\NxPartUtilCustomSetEnv.cmd

 Rem -- define ResultClassification_DPNE JobMgr --------------------------------
 set ResultClassification_DPNE=%CmdCurRoot_DP%\Resources\NxPartUpdNxSylog_ResClRules.xml

 REM -- PaketFile festlegen
 set NxPartUtilInputList_NE=_PU01_NxPartUtilList.txt
 set NxPartUtilInputList1_SO_DPNE=%JobTemp1_SO_DP%\%NxPartUtilInputList_NE%
 set NxPartUtilInputList2_RO_DPNE=%JobTemp2_RO_DP%\%NxPartUtilInputList_NE%

 REM -- Logfiles fr Owning Site festlegen ------------------------------
 set NxPartUtilLogFile1_SO_DPNE=%JobTemp1_SO_DP%\%NxPartUtilLog_NE%
 set NxPartUtilFailedLog1_SO_DPNE=%JobTemp1_SO_DP%\%NxPartUtilFailedLog_NE%
 set NxPartUtilCmdJobLog_SO_DPNE=%JobTemp1_SO_DP%\%NxPartUtilCmdJobLog_NE%

 REM -- Logfiles fr Replica festlegen ----------------------------------
 set NxPartUtilLogFile2_RO_DPNE=%JobTemp2_RO_DP%\%NxPartUtilLog_NE%
 set NxPartUtilFailedLog2_RO_DPNE=%JobTemp2_RO_DP%\%NxPartUtilFailedLog_NE%
 set NxPartUtilCmdJobLog_RO_DPNE=%JobTemp2_RO_DP%\%NxPartUtilCmdJobLog_NE%

 rem -- Execute first time NxPartUtilCustomSetEnv.cmd
 Call "%NxPartUtilCustomSetEnv_cmd%" "DEFAULTS"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Call Echo "----------------------------------------------------------------------------"
  Call Echo "#Debug..........................: %~0"
  Call Echo "#Step...........................: Before run PartUtility with TC"
  pause
 :JumbOverDebug

 Call Echo "--- #Step: Extract  Input List ---------------------------------------------"
 Call :ExtractProcessList

if not exist "%NxPartUtilInputList1_SO_DPNE%" goto :Next
 echo.
 Call Echo "--- #Step: Process Site Owning (SO) ----------------------------------------"
 if not defined JobMgr_NxPuUse_for_SO_RO set JobMgr_NxPuUse_for_SO_RO=NO
 Call :NxPartUtilExecute "%JobTemp1_SO_DP%" "%NxPartUtilLogFile1_SO_DPNE%" "%NxPartUtilFailedLog1_SO_DPNE%" "%NxPartUtilCmdJobLog_SO_DPNE%" "%NxPartUtilInputList1_SO_DPNE%"  "%JobMgr_NxPuUse_for_SO_RO%"
:Next

if not exist "%NxPartUtilInputList2_RO_DPNE%" goto :Next
 echo.
 Call Echo "--- #Step: Process Replica Objects (RO) ------------------------------------"
 Call :NxPartUtilExecute "%JobTemp2_RO_DP%" "%NxPartUtilLogFile2_RO_DPNE%" "%NxPartUtilFailedLog2_RO_DPNE%" "%NxPartUtilCmdJobLog_RO_DPNE%" "%NxPartUtilInputList2_RO_DPNE%"  "YES"
:Next

REM New 21.04.2015 S.Gueth
IF /I "%JobMgr_NxPuDataSets%" EQU "ON" goto :Next
 rem on standard process do evaluate P.Res
 echo.
 Call Echo "--- #Step: Evaluate Process Results ----------------------------------------"
 Call :NxPartUtilResEvaluate
:Next

endlocal& set NxPartUtilPrgExitCode=%NxPartUtilPrgExitCode%
goto :end


rem ============================================================================
:NxPartUtilExecute
 rem #Doc: Main Script to run NxPartUtil
 rem #Doc get File Params
 set temp=%~1
 set tmp=%temp%
 rem #LUp: 04.01.17/J.Fes
 Call :Parse_D "%temp%" HOMEDRIVE
 Call :Parse_P "%temp%" HOMEPATH
 set HOME=%temp%

 set NxPartUtilJobLog_DPNE=%~2
 set NxPartUtilJobLog2_DPNE=%~dpn2_2%~x2
 set NxPartUtilFailedLog_DPNE=%~3
 set NxPartUtilCmdJobLog_DPNE=%~4
 set NxPartUtilPaket_DPNE=%~5
 rem NO/YES
 set JobMgr_NxPartUtilReplica=%~6

 set NxPartUtilErrLog_DPNE=%temp%\_PartUErrLog.txt

 set UGII_TMP_DIR=%temp%
 set UGII_KEEP_SYSTEM_LOG=TRUE
 set UGII_UGSOLIDS_TMP=%temp%

 REM disable eingefuegt 17.08.12 J.Fes/K.S
 set UGII_UGMGR_USE_CACHE=

 REM -- Symetric Multi-Processing (SMP) disable
 REM diabled 07.02.2011
 set UGII_SMP_ENABLE=

 REM -- CGM erstellung deaktiveren eingefuegt 09.02.10 J.fes
 set UGII_IMAGE_CREATE_CGM=
 set UGII_IMAGE_CREATE_CGM_DRAW=
 set UGII_IMAGE_CREATE_CGM_OPTIONS=
 set UGII_IMAGE_CREATE_NAME=
 set UGII_IMAGE_CREATE_ORIGINAL_BACKGROUND=

 REM -- PFM soves ISSUES processing PFM Parts 29.11.2010 Info erhalten ber IR1814812
 set UGII_UGMGR_ALLOW_PFM_IMPORT_EXPORT=1

 REM -- IMAN-Variablen umbiegen -------------------------------------------
 set IMAN_SQL_DEBUG=
 set IMAN_TMP_DIR=%temp%
 set IMAN_KEEP_SYSTEM_LOG=TRUE
 set IMAN_Journalling=OFF
 set IMAN_journaling=OFF
 set IMAN_TRACEBACK=OFF
 set IMAN_Journal_Modules=NONE
 set API_JOURNAL=NONE
 set APB_SCHEMA=

 REM -- TC-Variablen umbiegen -------------------------------------------
 REM 11.08.10 SQL Debug on for Test's
 set TC_SQL_DEBUG=
 set TC_TMP_DIR=%temp%
 set TC_KEEP_SYSTEM_LOG=TRUE
 set TC_Journalling=OFF
 set TC_Journaling=OFF
 set TC_TRACEBACK=OFF

 REM -- define Load_options.def --------
 if not defined UGII_LOAD_OPTIONS_NE set NxPartUtil_load_options_LoadCompNO.def
 set UGII_LOAD_OPTIONS=%CmdCurRoot_DP%\startup\%UGII_LOAD_OPTIONS_NE%

 REM -- define process.dpv -------------
 if not defined UGII_LOCAL_USER_DEFAULTS_NE set UGII_LOCAL_USER_DEFAULTS_NE=NxPartUtil_Default.dpv
 set UGII_LOCAL_USER_DEFAULTS=%CmdCurRoot_DP%\startup\%UGII_LOCAL_USER_DEFAULTS_NE%

 set UGII_USER_DIR=%CmdCurRoot_DP%
 set UGII_GROUP_DIR=

 REM -- def: TC LOG --------------------
 set TC_Administration_Logging=OFF
 set TC_System_Logging=OFF
 set TC_LOG=%TC_TMP_DIR%

REM -- use password file if pw file is avilable
if "%JobMgr_TcPwFile_DPNE%" equ "" set JobMgr_TcPwOpt=-p="%JobMgr_TcPw%"
if "%JobMgr_TcPwFile_DPNE%" neq "" set JobMgr_TcPwOpt=-pf="%JobMgr_TcPwFile_DPNE%"

rem #New 04.08.2017/S.Gueth
if /I "%JobMgr_TCDataCheck%" equ "ON" Call :TCDataExtract "pre"

rem -- #New: 05.05.2017/J.Fes define toMon
if /i "%JobMgr_NxPuPMon_USE%" NEQ "ON" goto :Next
 set toMonSearchPath=%temp%
 IF /I "%JobMgr_NxPuDataSets%" EQU "ON" set toMonSearchPath=%temp%\.

 rem #LUp: 20.07.2022/J.Fes add tailTextFile*
 set toMon=%JFProcessMonitorL_DPNE%
 set toMon=%toMon% --titlePrefix "Job:[%JobName%][%TcSiteId%]"
 set toMon=%toMon% --waitForProcess 15000
 set toMon=%toMon% --processName part_utility
 set toMon=%toMon% --parentProcessId 0
 rem  set toMon=%toMon% --runtimeLimitSeconds 7200
 set toMon=%toMon% --killChildProcesses
 rem #LUp:14.01.2024/J.Fes 60 sec/min * 30 min sec = 1800 sec
 if not defined JobMgr_PMon_fileLastWriteTimeSec set /a JobMgr_PMon_fileLastWriteTimeSec=60*30
 set toMon=%toMon% --fileLastWriteTime "%toMonSearchPath%\*.*;%JobMgr_PMon_fileLastWriteTimeSec%"
 rem #LUp: 15.08.2016  / J.Fes
 set toMon=%toMon% --fileContainsString "%toMonSearchPath%\*part_utility*.syslog;This is most likely the result of a crash of the Teamcenter server, or the Teamcenter server encountering an unrecoverable error"
 rem set toMon=%toMon% --monitorExistingFiles
 rem  set toMon=%toMon% --memoryUsageHigh 6000;300
 set toMon=%toMon% --saveResultsTo "%temp%\zzPMon_log.xml"
 set toMon=%toMon% --tailTextFile "%toMonSearchPath%\*part_utility*.syslog"
 set toMon=%toMon% --tailTextFile_log "%temp%\_%JobRuleName%_PMon_syslog.log"
 set toMon=%toMon% --tailForceMilliseconds "500"
 set toMon=%toMon% --duraTimeSpanIfGreaterThen 1000

:Next
 REM -- set Parameter ----------------
 set NxPartUtilPrgExitCode=
 set NxPartUtilPara=#JobParameter#

 REM -- set PU.Contol defaults ---------
 rem -- #Doc default do not disable TC_SHARED_MEMORY_DIR_Disable
 if not defined TC_SHARED_MEMORY_DIR_Disable set TC_SHARED_MEMORY_DIR_Disable=false
 if defined JobMgr_fccCheck_parentfsc_address set JobMgr_fccCheck_USE=true

 REM -- set Rf.Environ
 if exist "%NxPartUtilSetEnv_cmd%" Call "%NxPartUtilSetEnv_cmd%"
 REM -- set Custom.Environ
 Call "%NxPartUtilCustomSetEnv_cmd%" "NxPartUtil"

 REM -- Programm -----------------------
 set part_utility_exe_DPNE=%UGII_BASE_DIR%\NXBIN\part_utility.exe

 REM -- PreCheck's before processing
 if not defined JobMgr_TCPromptGet_ResCode Call ErrorHandel "S" "TcPromt:UNK"                      "[Missing -or- NOT executed -or- NOT working]"
 if "%JobMgr_TCPromptGet_ResCode%" neq "0" Call ErrorHandel "S" "TcPromt:ERR"                      "TcPromptResCode:%JobMgr_TCPromptGet_ResCode% // TcPromptResMsg:%JobMgr_TCPromptGet_ResMsg%"

 if not exist "%NxPartUtilSetEnv_cmd%"       Call ErrorHandel "S" "NxPartUtilSetEnv.cmd fnf"       "File not found:[%NxPartUtilSetEnv_cmd%]"
 if not exist "%NxPartUtilCustomSetEnv_cmd%" Call ErrorHandel "S" "NxPartUtilCustomSetEnv.cmd fnf" "File not found:[%NxPartUtilCustomSetEnv_cmd%]"

 REM #New: 21.02.2017 J.Fes check UGII_USER_DIR + UGII_SITE_DIR
 if not exist "%UGII_SITE_DIR%\startup"    Call ErrorHandel "S" "UGII_SITE_DIR\startup dnf"        "Dir not found:[%UGII_SITE_DIR%\startup]"
 if not exist "%UGII_LOCAL_USER_DEFAULTS%" Call ErrorHandel "S" "UGII_LOCAL_USER_DEFAULTS fnf"     "File not found:[%UGII_LOCAL_USER_DEFAULTS%]"
 if not exist "%UGII_LOAD_OPTIONS%"        Call ErrorHandel "S" "UGII_LOAD_OPTIONS fnf"            "File not found:[%UGII_LOAD_OPTIONS%]"
 if not exist "%part_utility_exe_DPNE%"    Call ErrorHandel "S" "part_utility.exe fnf"             "File not found:[%part_utility_exe_DPNE%]"

 REM -- Run fccCheck
 Call fccCheck.cmd
 REM -- #Doc: fccCheck.cmd exits them selve if error happend
 if exist "%NxPartUtilErrLog_DPNE%" goto :PartUtiEnd

 Call :Parse_NE %UGII_LOAD_OPTIONS%        UGII_LOAD_OPTIONS
 Call :Parse_NE %UGII_LOCAL_USER_DEFAULTS% UGII_LOCAL_USER_DEFAULTS

 set titleTxt=Job:[%JobName%][%TcSiteId%][Replica:%JobMgr_NxPartUtilReplica%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%

 Echo.                                                                               .
 Call ColorSet IsExecuting
 Echo %titleTxt%
 Call Echo "----------------------------------------------------------------------------"
 Call Echo "NxPartUtil Job Settings:"
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "JobName.........................: %JobName%"
 Call Echo "Computer........................: %ComputerName%"
 Call Echo "NxPartUtilDir....................: %temp:~-50%"
 Call Echo "##- - - - TC settings: - - - -##"
 Call Echo "TcSide..........................: #TcSite.SiteInfoWith_SiteId_and_pName#"
 Call Echo "TcUser..........................: %JobMgr_TcUser%"
 Call Echo "TC_ROOT.........................: %TC_ROOT%"
 Call Echo "TC_DATA.........................: %TC_DATA%"
 Call Echo "TC_SHARED_MEMORY Disable........: %TC_SHARED_MEMORY_DIR_Disable%"
 Call Echo "FMS FMS_HOME....................: %FMS_HOME%"
 Call Echo "FCC CHK.........................: %JobMgr_fccCheck_USE%//ParentFscAdr:%JobMgr_fccCheck_parentfsc_address%"
 Call Echo "##- - - - TC Environ Vars: - -##"
 Call Echo "BMF_BYPASS_ALL_EXTENSION_RULES..: %BMF_BYPASS_ALL_EXTENSION_RULES%"
 Call Echo "AM_BYPASS.......................: %AM_BYPASS%"
 Call Echo "TC_PREFERENCES_OVERLAY_FILE.....: %TC_PREFERENCES_OVERLAY_FILE%"
 Call Echo "##- - - - NX settings: - - - -##"
 Call Echo "UGII_ROOT_DIR...................: %UGII_ROOT_DIR%"
 Call Echo "UGII_LOAD_OPTIONS...............: %UGII_LOAD_OPTIONS%"
 Call Echo "UGII_SITE_DIR...................: %UGII_SITE_DIR%"
 Call Echo "UGII_LOCAL_USER_DEF.............: ..\%UGII_LOCAL_USER_DEFAULTS_NE%"
 Call Echo "##- - - - PU settings: - - - -##"
 Call :JobParam_List "NxPartUtil Parameter............." "%NxPartUtilPara%"
 Call Echo "NxPu via Datasets...............: %JobMgr_NxPuDataSets%"
 Call Echo "NxPu SiteObj as ReplicaObj......: %JobMgr_NxPuUse_for_SO_RO%"
 Call Echo "NxPu Replica Parts..............: %JobMgr_NxPartUtilReplica%"
 Call Echo "NxPu Eval TC DataCheck ON/OFF...: %JobMgr_TCDataCheck%"
 Call Echo "NxPu Eval Use Custom eval.......: %JobMgr_NxPuExtEvalROptForPrint%"
 Call Echo "NxPu Proc.Monitor ON/OFF........: %JobMgr_NxPuPMon_USE%"
 if /i "%JobMgr_NxPuPMon_USE%" EQU "ON" (
 Call Echo "NxPu Proc.Monitor fileLastWriteT: %JobMgr_PMon_fileLastWriteTimeSec% (sec)"
 )


 cd /d "%temp%"

 rem New 16.01.2018 S.Gueth: JobMgr_TcPw removed before gen env file
 setlocal
   set JobMgr_TcPw=
   set >>"%temp%\zzEnvironBeforeProcess.txt"
 endlocal

 REM New S.Gueth 17.04.2015 for refiling parts
 IF /I "%JobMgr_NxPuDataSets%" NEQ "ON" goto :NxPartUtilPaket
 IF /I "%JobMgr_NxPuDataSets%" EQU "ON" goto :NxPartUtilDataSets

rem -------------------------------------------------------------------------------
:NxPartUtilPaket
 rem  #Doc: Execute PartUpdate via List

 rem #New: 20.07.2022/J.Fes List Data to Process
 Echo.
 Call Echo "################################################################################"
 Call Echo "--------------------------------------------------------------------------------"
 set toRun="%JobManagerCmdTools_L%"
 set toRun=%toRun% -Action "JobDataExtract_2013_10"
 set toRun=%toRun% -SubAction "JobDataList"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -Title "List of Datasets to update -//- Using Replica:'%JobMgr_NxPartUtilReplica%'"
 set toRun=%toRun% -JobDataFilter_ObjectClass "DS"
 if "%JobMgr_NxPartUtilReplica%" equ "NO" set toRun=%toRun% -JobDataFilter_SiteOwning "O"
 if "%JobMgr_NxPartUtilReplica%" neq "NO" set toRun=%toRun% -JobDataFilter_SiteOwning "R"
 set toRun=%toRun% -JobData1ToProcessDoPrint
 set toRun=%toRun% -JobDetailsPrintSkip
 rem
 call %toRun%
 Call Echo "################################################################################"
 IF /i "%JobMgr_Debug%" EQU "ON" (
  set toRunForPrint=%toRun:"='%
  Call Echo "#Debug:.........................: after List of JobData"
  call Echo "#toRun..........................: %toRunForPrint%"
  pause
 )


:Redo
REM
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "Process TC.NX.Parts via list....: Protocol"

 IF /i "%JobMgr_Debug%" EQU "ON" (
  Call Echo "#Debug:.........................: Before Process TC.NX.Parts via list"
  pause
 )
 REM -- Start JobMgr PMon #LUp21.03.17 start min based on JobMgr_WIMode
 if /i "%JobMgr_NxPuPMon_USE%" EQU "ON" (
  if /i "%JobMgr_WIMode%" equ "Normal" (
    start "PMon Job:[%JobName%][%TcSiteId%]" %toMon%
  ) else (
    start "PMon Job:[%JobName%][%TcSiteId%]" /min %toMon%
  )
 )


 rem -- #Doc: Check Delete files see redo
 if exist "%NxPartUtilJobLog_DPNE%" del "%NxPartUtilJobLog_DPNE%"
 if exist "%NxPartUtilFailedLog_DPNE%" del "%NxPartUtilFailedLog_DPNE%"
 if exist "%temp%\*.syslog" del "%temp%\*.syslog"

 rem -- #Doc: Start PartUpdate process
 set toRun="%part_utility_exe_DPNE%" %NxPartUtilPara% -i="%NxPartUtilPaket_DPNE%" -log="%NxPartUtilJobLog_DPNE%" -out="%NxPartUtilFailedLog_DPNE%" -u=%JobMgr_TcUser% %JobMgr_TcPwOpt% -g=%JobMgr_TcGroup%
 call %toRun%
 set NxPartUtilPrgExitCode=%errorlevel%

 Call :ReDoCheck "%NxPartUtilJobLog_DPNE%"
 if /I "%ReDoCheck_r%" equ "YES" goto :Redo


 IF /i "%JobMgr_Debug%" EQU "ON" (
  Call Echo "#Debug:.........................: After Process TC.NX.Parts via list"
  call Banner NxPartUtilJobLog_SizeByte:%NxPartUtilJobLog_SizeByte%
  pause
 )
goto :PartUtiExit

rem -------------------------------------------------------------------------------
:NxPartUtilDataSets
 rem  #Doc: Execute via Datasets
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "Process TC.NX.Parts via DataSets:"

 set NxPartUtilPrgExitCode=0
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "PartUtility_2018_04"
 set toRun=%toRun% -SubAction "PROCESSDATASETS"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobTemp_DP "%temp%"
 rem set toRun=%toRun% -PuProg_DPNE "%part_utility_exe_DPNE%"
 set toRun=%toRun% -PUPara " %NxPartUtilPara%"
 set toRun=%toRun% -PartUtilityExe_DPNE "%part_utility_exe_DPNE%"
 set toRun=%toRun% -PuProg_DPNE "%part_utility_exe_DPNE%"
 rem set toRun=%toRun% -NxPartUtilPara "'%NxPartUtilPara%'"
 set toRun=%toRun% -u "%JobMgr_TcUser%"
 if "%JobMgr_TcPwFile_DPNE%" equ "" set toRun=%toRun% -p "%JobMgr_TcPw%"
 if "%JobMgr_TcPwFile_DPNE%" neq "" set toRun=%toRun% -pf "%JobMgr_TcPwFile_DPNE%"
 set toRun=%toRun% -g "%JobMgr_TcGroup%"
 set toRun=%toRun% -ShellMaxDurationSEC "-1"
REM  set toRun=%toRun% -JobMgr_NxPuPMon_USE "%JobMgr_NxPuPMon_USE%"
 set toRun=%toRun% -PuInputList_DPNE "%NxPartUtilPaket_DPNE%"
 set toRun=%toRun% -JobData2ResultsDoPrint

 if exist "%ResultClassification_DPNE%" set toRun=%toRun% -ResultClassification_DPNE "%ResultClassification_DPNE%"
 if defined ResultClassificationCustom_DPNE set toRun=%toRun% -ResultClassificationCustom_DPNE "%ResultClassificationCustom_DPNE%"
 if defined JobMgr_ProcessExtEvalROpt set toRun=%toRun% %JobMgr_ProcessExtEvalROpt%

 IF /i "%JobMgr_Debug%" NEQ "ON" goto :JumbOverDebug
   set toRun=%toRun% -JobParaDoPrint -verbose -pauseOnEnd
   set toRunForPrint=%toRun:"='%
   Call Echo "#Debug:.........................: Before TC.PartUpdate via DataSets"
   Call Echo "toRun...........................: %toRunForPrint%"
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_02_PUDataSets_cmd.txt
   Echo %toRun% >>"%Debug_DPNE%"
   pause
 :JumbOverDebug


 REM -- Start JobMgr PMon #LUp21.03.17 start min based on JobMgr_WIMode
 if /i "%JobMgr_NxPuPMon_USE%" EQU "ON" (
  if /i "%JobMgr_WIMode%" equ "Normal" (
    start "PMon Job:[%JobName%][%TcSiteId%]" %toMon%
  ) else (
    start "PMon Job:[%JobName%][%TcSiteId%]" /min %toMon%
  )
 )


 REM #Doc: Process TC.NX.Parts via Dataset controled by JobManagerCmdTools
 call %toRun%

 IF /i "%JobMgr_Debug%" EQU "ON" (
  Call Echo "#Debug:.........................: After TC.PartUpdate via DataSets"
  pause
 )
goto :PartUtiExit

REM --#Doc: Script below controls end of PartUpdate process --------------------------------
:PartUtiExit

 if /I "%JobMgr_TCDataCheck%" equ "ON" Call :TCDataExtract "post"

 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Banner "P.End"
 Call Echo "NxPartUtilPrgExitCode...........: %NxPartUtilPrgExitCode%"
 Call Echo "PartUpdate......................: End"  "" "NOECHO"

 REM -- #Doc: in case of processing via Datasets jumb to :PartUtiEnd
 IF /I "%JobMgr_NxPuDataSets%" EQU "ON" goto :PartUtiEnd

 if defined titelTxt title %titelTxt%
 if exist "%temp%\%UserName%2TierTV" (
   Call Echo "CleanUp.........................: rd /S /Q %temp%\%UserName%2TierTV"
   rd /S /Q "%temp%\%UserName%2TierTV" >nul 1>nul 2>nul
 )
 if exist "%temp%\%userName%2TierTransientVolume" (
   Call Echo "CleanUp.........................: rd /S /Q %temp%\%userName%2TierTransientVolume"
   rd /S /Q "%temp%\%userName%2TierTransientVolume" >nul 1>nul 2>nul
 )

 if "%NxPartUtilPrgExitCode%" neq "0" Call :PuPrgExit_WRN
 if "%NxPartUtilPrgExitCode%" equ "0" Call :PuPrgExit_OK

:PartUtiEnd
 IF /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  IF /I "%JobMgr_NxPuDataSets%" EQU "ON" goto :Next
   Call Echo "#Debug:.........................: Results Info"
   Call Echo "PUPrg...........................: %part_utility_exe_DPNE%"
   Call Echo "NxPartUtilPrgExitCode...........: %NxPartUtilPrgExitCode%"
   Call :TypeFile "%NxPartUtilJobLog_DPNE%"     "Job Log:"
   Call :TypeFile "%NxPartUtilFailedLog_DPNE%"  "Failed Log:"
  :next
  Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
  Call Echo "#Debug..........................: %~0 PU:Execute END"
  pause
:JumbOverDebug

goto :eof

REM ============================================================================
:PuPrgExit_OK
 Call ColorSet OK
 REM -- delete alle files not to send to JobServer
 rem 20.09.2016 / J.Fes disabled del %temp%\tcserver.*
REM  if /I "%JobMgr_TcNxDebug%" equ "ON"  goto :eof
REM  if /I "%JobMgr_Debug%" equ "ON"  goto :eof
 Call Echo "CleanUp.........................: %temp%\.."
 del /S /Q "%temp%\*.prt","%temp%\XXtcserver.*","%temp%\XXtcserver.*.*","%temp%\*.bak","%temp%\*.tmp" >nul 1>nul 2>nul
goto :eof


REM ============================================================================
:PuPrgExit_WRN
 set titelTxt=WRN:%NxPartUtilPrgExitCode% !! part_utility.exe [%Date%/%time:~0,8%] !!
 rem #New 11.11.2015/J.Fes Prevent Issues of 'dead Sessions' in TC.DB
 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
 Call Echo "%titelTxt%"
 Banner Clearlocks
 Call Echo "Run Clearlocks..................: -verbose"
 Call Clearlocks -verbose
goto :eof

REM ============================================================================
:ExtractProcessList
 rem #Doc: Extracts the IR lists for Process input
 rem #New: 15.07.2013

 Call ColorSet ExtractLi

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "PartUtility_2018_04"
 set toRun=%toRun% -SubAction "EXTRACT"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobTemp1_SO_DP "%JobTemp1_SO_DP%"
 set toRun=%toRun% -JobTemp2_RO_DP "%JobTemp2_RO_DP%"

 set toRun=%toRun% -JobTemp1_SO_DP "%JobTemp1_SO_DP%"
 set toRun=%toRun% -JobTemp2_RO_DP "%JobTemp2_RO_DP%"
 set toRun=%toRun% -PUInputList_NE "%NxPartUtilInputList_NE%"
 set toRun=%toRun% -PUInputList1_SO_DPNE "%NxPartUtilInputList1_SO_DPNE%"
 set toRun=%toRun% -PUInputList2_RO_DPNE "%NxPartUtilInputList2_RO_DPNE%"
REM set toRun=%toRun% -NxPartUtilInputList_NE "%NxPartUtilInputList_NE%"
REM set toRun=%toRun% -NxPartUtilInputList1_SO_DPNE "%NxPartUtilInputList1_SO_DPNE%"
REM set toRun=%toRun% -NxPartUtilInputList2_RO_DPNE "%NxPartUtilInputList2_RO_DPNE%"
 set toRun=%toRun% -JobData1ToProcessDoPrint
 REM New 21.04.2015 S.Gueth
 IF /I "%JobMgr_NxPuDataSets%" == "ON" (
   set JobMgr_PUListContent=DS
 )

 REM 07.12.2015/J.Fes/S.Gueth
 REM #Doc: if PU Param -refile_specified_non_master_only is used then add Dataset CliNames into PUList.txt
 if "%JobParameter%" NEQ  "%JobParameter: -refile_specified_non_master_only=%" (
    set JobMgr_PUListContent=DS
 )

 REM New 25.09.2015 J.Fes
 IF /I "%JobMgr_PUListContent%" equ "DS" (
   set toRun=%toRun% -PUListContent DS
 )


 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_01_ExtractList.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   set toRunForPrint=%toRun:"='%
   Call Echo "#Debug:.........................: Before: [%~0]"
   Call Echo "#ToRun..........................: %toRunForPrint%"
   Echo %toRun% >>"%Debug_DPNE%"
:JumbOverDebug

 Call %toRun%
 set toRun=
goto :eof

rem ============================================================================
:TCDataExtract
 REM #New: 08.08.2017 S.Gueth
 REM #LUp: 08.03.2018 J.JFes now via SubActionSettings

 set JobMgr_eXtract_prePost=%~1

 if not defined TcData_eXtract_DP set TcData_eXtract_DP=%temp%\TcData
 if not exist "%TcData_eXtract_DP%" md "%TcData_eXtract_DP%"

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "TcExtractData_2013_10"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -SubActionSettingsXml "%JobMgr_ExtractSettingsXml%"
 set toRun=%toRun% -eXtract_prePost "%JobMgr_eXtract_prePost%"
 set toRun=%toRun% -TcData_eXtract_DP "%TcData_eXtract_DP%"
 set toRun=%toRun% -TcSQL_DP "#TcSQL_DP#"

  if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_04_BOM1ExtractPre.txt
REM    set toRun=%toRun% -verbose -pauseOnEnd
   set toRun=%toRun% -pauseOnEnd
   set toRunForPrint=%toRun:"='%
   Call Echo "#Debug:.........................: Before: [%~0]"
   Call Echo "#ToRun..........................: %toRunForPrint%"
   Echo %toRun% >>"%Debug_DPNE%"
:JumbOverDebug

 Call %toRun%

goto :eof


rem ============================================================================
:NxPartUtilResEvaluate
 rem #Doc: Evaluate the results
 rem #New: 15.07.2013/J.Fes
 rem #LUp: 02.06.2014/J.Fes
 Call ColorSet EvalResult

 REM #Doc: if PUErrLog exist and no PU.Prg did run then Get Err Result
 if exist "%NxPartUtilErrLog_DPNE%" if "%NxPartUtilPrgExitCode%" equ "" goto :NxPartUtilResEvaluate_ERR
 REM -- set Custom.Environ
 Call "%NxPartUtilCustomSetEnv_cmd%" "EVALUATE"

:NxPartUtilResEvaluate_PU
 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "PartUtility_2018_04"
 set toRun=%toRun% -SubAction "EVALUATE"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobData2ResultsDoPrint
 set toRun=%toRun% -PUPara " %NxPartUtilPara%"

 rem #New:12.02.2014/J.Fes
 if exist "%ResultClassification_DPNE%" set toRun=%toRun% -ResultClassification_DPNE "%ResultClassification_DPNE%"
 rem #New:05.06.2015/S.Gueth + J.Fes
 if defined ResultClassificationCustom_DPNE set toRun=%toRun% -ResultClassificationCustom_DPNE "%ResultClassificationCustom_DPNE%"
 rem #New:28.04.2014/J.Fes
 if defined JobMgr_ProcessExtEvalROpt set toRun=%toRun% %JobMgr_ProcessExtEvalROpt%

 if /I "%JobMgr_TCDataCheck%" neq "ON" goto :next
   Call Echo "RfResEvaluate...................: uses TCDataCheck"
   set toRun=%toRun% -SubActionSettingsXml "%JobMgr_EvaluateSettingsXml%"
   set toRun=%toRun% -TcData_eXtract_DP "%TcData_eXtract_DP%"
   set toRun=%toRun% -CBConfigXml CBMgrConfig.xml
:next

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_03_EvaluateResult.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   set toRunForPrint=%toRun:"='%
   Call Echo "#Before:........................: Evaluate: [%~0]"
   Call Echo "#ToRun..........................: %toRunForPrint%"
   Echo %toRun% >>"%Debug_DPNE%"
:JumbOverDebug

 Call %toRun%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_03_EvaluateResult.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   set toRunForPrint=%toRun:"='%
   Call Echo "#After:.........................: Evaluate: [%~0]"
   Echo %toRun% >>"%Debug_DPNE%"
:JumbOverDebug


goto :eof


REM ####### ------------ Standard Subroutines ---------------------- ###########
REM ============================================================================
:JobParam_List
 setlocal
  set ParmListTitle=%~1
  set JobParams=%~2
  rem " ersetzen durch '
  set JobParams=%JobParams:"='%
  set NCur=0
:JobParam_List_PrintNext
  set /a NCur=%NCur%+1
  FOR /F "tokens=%NCur% delims=-" %%i IN ("%JobParams%") do Call :JobParam_Print "%%i"
  if %NCur% LEQ 10 goto :JobParam_List_PrintNext
 endlocal
 goto :eof

:JobParam_Print
 setlocal
  set JobParaCur=%~1
  if "%NCur%" equ "1" (
                            Call Echo "%ParmListTitle% -%JobParaCur%"
  ) else (
   if "%JobParaCur%" neq "" Call Echo "................................: -%JobParaCur%"
  )
 endlocal
 goto :eof

REM ============================================================================
:TypeFile
 REM Types the description and the contens of a file
 setlocal
  set FileToType_DPNE=%~1
  set FileDescription=%~2
  Echo ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ----
  Echo File Content Description........: %FileDescription%
  Echo Content of File.................: %FileToType_DPNE%
  if     exist "%FileToType_DPNE%" type "%FileToType_DPNE%"
  if not exist "%FileToType_DPNE%" Echo ERROR:fnf file not found........: [%FileToType_DPNE%]

 endlocal
 goto :eof

REM ============================================================================
:Parse_NE
 set %2_NE=%~nx1
 goto :eof

:Parse_D
 set %2=%~d1
 goto :eof

:Parse_P
 set %2=%~p1
 goto :eof

REM ============================================================================
:ReDoCheck
 REM -- #New: 27.12.2023/J.Fes
 REM -- #Doc: Checks file size of NxPartUtilJobLog_DPNE
 REM -- #Doc: if size = 0 byte then trigger redo the PartUpdate process
 REM -- #Doc: if redo done > 1 then redo is not triggerd

 if not defined RedoCheckDoneNtimes set RedoCheckDoneNtimes=0
 set /a RedoCheckDoneNtimes=%RedoCheckDoneNtimes% + 1

 rem --#Doc: get size of
 call GetFileFileSize.cmd "%NxPartUtilJobLog_DPNE%" NxPartUtilJobLog_SizeByte

 Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
REM  call Banner RedoCheckDoneNtimes:%RedoCheckDoneNtimes%
REM  call Banner SizeByte:%NxPartUtilJobLog_SizeByte%
 Call Echo "Redo Check......................: Result"
 Call Echo "Nx PartUtil JobLog..............: %NxPartUtilJobLog_DPNE%"
 Call Echo "Nx PartUtil JobLog Size.........: %NxPartUtilJobLog_SizeByte% (Byte)"
 Call Echo "CheckDone N times...............: %RedoCheckDoneNtimes% (n)"

REM  set NxPartUtilJobLog_SizeByte=0
 rem -- #Doc: Check if Redo is required
 if "%NxPartUtilJobLog_SizeByte%" GTR "0" goto :RedoNo
 if "%RedoCheckDoneNtimes%" GTR "6"       goto :RedoNo
 goto :RedoYes

:RedoYes
 set ReDoCheck_r=YES
 set ReDoCheck_timeout=10
 set ReDoCheck_log_DPNE=%JobManagerRoot_DP%\11-Documentation.Custom\NxPartUtilExecute_cmd_ReDoLog.csv
 Call Echo "Redo required...................: %ReDoCheck_r% and wait now for %ReDoCheck_timeout% sec then redo process"
if not exist "%ReDoCheck_log_DPNE%" (
 rem -- #Doc: 08.07.2024/Write header
 Echo Date;Time;JobClient;RedoCheckDoneNtimes;NxPartUtilJobLog_DPNE;NxPartUtilJobLog_Size-Byte >>"%ReDoCheck_log_DPNE%"
)
 Echo %date%;%time%;%ComputerName%;%RedoCheckDoneNtimes%;%NxPartUtilJobLog_DPNE%;%NxPartUtilJobLog_SizeByte% >>"%ReDoCheck_log_DPNE%"
 timeout /T %ReDoCheck_timeout%
goto :myEnd

:RedoNo
 set ReDoCheck_r=NO
 Call Echo "Redo required...................: %ReDoCheck_r% "
 goto :myEnd

:myEnd


goto :eof

REM ============================================================================
:end

