-- IR DS ALL 02.03.2015
-- #LUp: 17.04.2018/J.Fes add DataSetReleasedDateWSO
-- #LUp: 04.02.2020/J.Fes add DataSetLastSavDate
-- #LUp: 17.04.2018 J.Fes add DataSetReleasedDateWSO
-- #LUp: 10.09.2021 S.Gueth+J.Fes add case for DataSetType
Select 
 pd.puid               As DataSetPuid,
 s.psite_id            As OwningSite_TC_pSite_ID, 
 ptype.ptype_name      As DatasetRelation,
 case when pdt.pdatasettype_name is not NULL then pdt.pdatasettype_name
                       else wso.pobject_type end
                       As DataSetType,
 wso.pobject_name      As DataSetName,
 wso.pobject_desc      As DataSetDescription, 
 pd.rrev_chain_anchoru As pd_rrev_chain_anchoru,
 rev.pvalu_0           As rev_pvalue_0,
 rl.pvalu_0            As rl_pvalu_0,
 pu_owni_ds.puser_id   As DataSetOwningUser,
 pg_owni_ds.pname      As DataSetOwningGroup,
 pg_owni_ds.puid       As DataSetOwningGroupPuid,
 pao.pcreation_date    As DataSetCreateDate,
 pu_lmod_ds.puser_id   As DataSetLastModUser,
 pao.plast_mod_date    As DataSetLastModDate,
 wso.pdate_released    AS DataSetReleasedDateWSO,
 pd.rrev_chain_anchoru AS DataSetRevChainAnchorPuid
From
 infodba.PDATASET pd
 INNER JOIN infodba.PREVISIONS rev   On (pd.rrev_chain_anchoru = rev.puid) and (rev.pseq = 0)
 INNER JOIN infodba.PREF_LIST rl     On (rl.puid = pd.puid)  and (rl.pseq = 0)
 INNER JOIN infodba.PDATASETTYPE pdt On (pd.rdataset_typeu = pdt.puid)
 INNER JOIN infodba.PIMANRELATION pr On (pr.rsecondary_objectu = pd.puid)
 INNER JOIN infodba.PIMANTYPE ptype  On (ptype.puid = pr.rrelation_typeu)
 INNER JOIN infodba.PWORKSPACEOBJECT wso On (wso.puid = pd.puid)
 LEFT JOIN  infodba.PPOM_OBJECT o    On (o.puid = pd.puid)
 LEFT JOIN  infodba.PPOM_IMC s       On (s.puid = o.rowning_siteu) -- muss left Join sein
 INNER JOIN infodba.PPOM_APPLICATION_OBJECT pao On (pao.puid = rev.pvalu_0)
 INNER JOIN infodba.PPOM_USER pu_owni_ds        On (pu_owni_ds.puid = pao.rowning_useru)
 INNER JOIN infodba.PPOM_USER pu_lmod_ds        On (pu_lmod_ds.puid = pao.rlast_mod_useru)
 INNER JOIN infodba.PPOM_GROUP pg_owni_ds       On (pg_owni_ds.puid = pao.rowning_groupu)
where
 pr.rprimary_objectu = :para_puid
