Select
  ItemRev.ItemPuid     As ItemPuid,
  ItemRev.ItemId       As ItemId,
  paoI.PLAST_MOD_DATE  As ItemLastModDate,
  ItemRev.IrPuid       As IrPuid,
  ItemRev.IrId         As IrId,
  paoIr.PLAST_MOD_DATE As IrLastModDate,
  s.PSITE_ID           As OwningSite_TC_pSite_ID,
  ItemRev.Source
From
  (
    Select
      I.PUID               As ItemPuid,
      I.PITEM_ID           As ItemId,
      ir.PUID              As IrPuid,
      ir.PITEM_REVISION_ID As IrId,
      'SequYes'            As Source
    From
      infodba.PITEMREVISION ir
    Inner Join
      (
        Select
          ir.RITEMS_TAGU
          || ir.RSEQUENCE_ANCHORU Id,
          Max(ir.PSEQUENCE_ID) MaxSeq
        From
          infodba.PITEMREVISION ir
        Where
          ir.RSEQUENCE_ANCHORU Is Not Null
        Group By
          ir.RITEMS_TAGU
          || ir.RSEQUENCE_ANCHORU
      )
      HSeq
    On
      ir.PSEQUENCE_ID = HSeq.MaxSeq
    And ir.RITEMS_TAGU
      || ir.RSEQUENCE_ANCHORU = HSeq.Id
    Left Join infodba.PITEM I
    On
      (
        ir.RITEMS_TAGU = I.PUID
      )
    Union All
      (
        Select
          I.PUID               As ItemPuid,
          I.PITEM_ID           As ItemId,
          ir.PUID              As IrPuid,
          ir.PITEM_REVISION_ID As IrId,
          'SequNo'             As Source
        From
          infodba.PITEMREVISION ir
        Left Join infodba.PITEM I
        On
          (
            ir.RITEMS_TAGU = I.PUID
          )
        Where
          ir.RSEQUENCE_ANCHORU Is Null
      )
  )
  ItemRev
Left Join infodba.PPOM_OBJECT o
On
  (
    ItemRev.IrPuid = o.PUID
  )
Left Join infodba.PPOM_IMC s
On
  (
    o.ROWNING_SITEU = s.PUID
  )
Left Join infodba.PPOM_APPLICATION_OBJECT paoIr
On
  (
    ItemRev.IrPuid = paoIr.PUID
  )
Left Join infodba.PPOM_APPLICATION_OBJECT paoI
On
  (
    ItemRev.ItemPuid = paoI.PUID
  )
Where
  s.PSITE_ID Is Not Null