/* TCUA:Item IRs DS L.Up:02.3.15
   Offene Punkte: Export Recodes, Project's
*/

SELECT
  -- Item
  i.pitem_id             AS I_Id,
  i.puid                 AS I_puid,
  paoI.pcreation_date    AS I_CreationDate,
  paoI.plast_mod_date    AS I_LastModDate,
  oI.plsd                AS I_LastSavedDate,
  pgI.pname              AS I_Group,

  -- Ir
  ir.pitem_revision_id   AS Ir_Id,
  ir.puid                AS Ir_puid,
  paoIr.pcreation_date   AS Ir_CreationDate,
  paoIr.plast_mod_date   AS Ir_LastModDate,
  oIr.plsd               AS Ir_LastSavedDate,
  pgIr.pname             AS Ir_Group

FROM
 -- OP: Site / Export to
 -- Item I/i
           infodba.PITEM                   i
 LEFT JOIN infodba.PPOM_APPLICATION_OBJECT paoI  ON (i.puid = paoI.puid)
 LEFT JOIN infodba.PPOM_OBJECT             oI    ON (i.puid = oI.puid)
 LEFT JOIN infodba.PPOM_GROUP              pgI   ON (pgI.puid = paoI.rowning_groupu)

 -- Revision ir/Ir
 LEFT JOIN infodba.PITEMREVISION           ir    ON (i.puid = ir.ritems_tagu)
 LEFT JOIN infodba.PPOM_APPLICATION_OBJECT paoIr ON (ir.puid = paoIr.puid)
 LEFT JOIN infodba.PPOM_OBJECT             oIr   ON (ir.puid = oIr.puid)
 LEFT JOIN infodba.PPOM_GROUP              pgIr  ON (pgIr.puid = paoIr.rowning_groupu)
 LEFT JOIN infodba.PWORKSPACEOBJECT        pwo   ON (ir.puid = pwo.puid)

WHERE
 pwo.pactive_seq = 1
 AND UPPER(i.pitem_id) = UPPER('BG-Einzelteil-01')
 OR UPPER(i.pitem_id) = UPPER('ItemNoDs')
-- AND ir.pitem_revision_id = 'D' 
order by I_Id, Ir_CreationDate