Option Compare Text
Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Collections.Generic
Imports System.Data

Imports JF.PlmJobManager.JobServer
Imports JF.Tools
Imports JF.PlmJobManager


' # Doc: Example Usage of external .net .dll
'xReferences CustomDll_Example.dll

' Information for developer:
' All Lines with mark "#" should be edit by the developer
' # Template Vers: 3.1602;29.08.2022;J.Fes
' # ---------------------------------------------------------------------------------------
' # Documentation:
' # Description  : please add the description for this script in this line
' # Parameters   : /Para1=MyPara1 /Para2=MyPara2  
' # 
' # History:
' # Date         Person      ChangeInfo
' # MM.DD.YY     Name        #New: xxx
' # MM.DD.YY     Name        #LUp: yyy
' # ---------------------------------------------------------------------------------------

Namespace JS_ScriptingTemplate

    Public Class ScriptingEngineClass


        ''' <summary>
        ''' Returns Description and Version Info for ths script
        ''' </summary>
        Public Shared ReadOnly Property ScriptDescVers As String
            Get
                Return "#ToDo please Edit: #Description  VDD.MM.20YY HH:MM/J.Fes"
            End Get
        End Property

        Private ScriptOutput_frm As JobServer_ScriptRun_frm

        '-- ##debug:
        Dim DebugIsOn As Boolean = False

        ''' <summary>
        ''' #Please replace summary content
        ''' </summary>
        ''' <param name="JS_ScriptingInterface"></param>
        ''' <remarks> 
        ''' #New: #Date# / Name
        ''' </remarks>
        Public Function ScriptMain(ByVal JS_ScriptingInterface As ScriptingInterface.Methodes) As JF_Return_cls

            '-- #Doc: ScriptResult_r Required Object for returning script results
            Dim ScriptResult_r As New JF_Return_cls
            Dim RunResult_Obj As New JF_Return_cls

            Dim TextStr As String = ""
            Dim I As Integer
            Dim I2 As Integer

            Dim PauseOnEnd As Boolean = False
            PauseOnEnd = If(JS_ScriptingInterface.ParameterValueGet("PauseOnEnd") = "true", True, False)

            '-- #Doc: Debug ON Off
            ' DebugIsOn = true
            If System.Diagnostics.Debugger.IsAttached Then
                DebugIsOn = True
            End If

            Dim InfoSysHeader As JF.InfoSys.JF_InfoSys = JS_ScriptingInterface.TaskShedulerInfoSysGet
            Dim InfoSysProtocol As JF.InfoSys.JF_InfoSys = JS_ScriptingInterface.TaskShedulerInfoSysGet


            If PauseOnEnd Or DebugIsOn Then
                '-- #Doc: using "standard form" for printing script informations 
                Me.ScriptOutput_frm = New JobServer_ScriptRun_frm(JS_ScriptingInterface.ScriptDef)
                InfoSysHeader = Me.ScriptOutput_frm.InfoSysHeader
                InfoSysProtocol = Me.ScriptOutput_frm.InfoSysProtocol
                ScriptOutput_frm.Show()
            End If


            Call InfoSysProtocol.PrintObject("Script Descr + Ver", ScriptDescVers)
            Call InfoSysProtocol.StatusBarSetCurrActionInfo_Panel1(ScriptDescVers)


            '-- #Doc: printing Informations to the header textbox 
            Call InfoSysHeader.PrintInfoLine("#Step - 1 Script started!")

            '-- #Doc: handling Exeptions via Try Catch
            Try
                '-- parsing parameters 
                Dim Para1 As String = JS_ScriptingInterface.ParameterValueGet("Para1", "Para1DefaultValue")
                Dim Para2 As String = JS_ScriptingInterface.ParameterValueGet("Para2", "Para2DefaultValue")

                Dim StartParamInfoTxt As String = "parameters [" + JS_ScriptingInterface.ParameterStr + "]" + vbCrLf +
                 vbCrLf +
                 "Para1=" + Para1 + vbCrLf +
                 "Para2=" + Para2 + vbCrLf +
                 vbCrLf +
                 "..\10-JobLogArchiv :" + vbCrLf +
                 "[" + JS_ScriptingInterface.ServerSettings.Dir_DataRoot_DP_10JobLogArchiv + "]"

                '-- #Doc: print informations to the protokoll textbox
                Call InfoSysProtocol.PrintObject("Script started with", StartParamInfoTxt)


                Select Case JS_ScriptingInterface.JobDefCurrJob.JobDef.JobServerScript_RunCondition

                    Case ScriptingDef.RunCondition_enum.Cond01_GenNewJob_Bevor_SelectObjectData

                        ' suche nach Files in einem bestimmten Verzeichniss:
                        Dim FileList As System.Collections.ObjectModel.ReadOnlyCollection(Of String)
                        FileList = My.Computer.FileSystem.GetFiles(JS_ScriptingInterface.ServerSettings.Dir_DataRoot_DP_91JobControl, FileIO.SearchOption.SearchAllSubDirectories, "*.XML")

                        ' check if pause or stop button was pressed
                        If JS_ScriptingInterface.ProcessControlCheckPauseStop(InfoSysProtocol, ScriptResult_r) = ScriptingInterface.Methodes.ProcessControlStatusEnum.Stop Then
                            Exit Try
                        End If

                        If FileList.Count > 0 Then
                            InfoSysProtocol.Print("List of Files to process:")
                            For Each FileItem_DPNE As String In FileList
                                InfoSysProtocol.Print(FileItem_DPNE)
                            Next
                            '-- Vorgaben fuer weiteres Verhalten einstellen: "JobPaket an den Client senden:Yes"
                            JS_ScriptingInterface.JobDefCurrJob.JobDef.JobControlRule.JobControlInterface.JobPaket_SendToJobClient = True
                        Else
                            InfoSysProtocol.Print("No Files to process:")
                            '-- Vorgaben fuer weiteres Verhalten einstellen: "JobPaket an den Client senden:No"
                            JS_ScriptingInterface.JobDefCurrJob.JobDef.JobControlRule.JobControlInterface.JobPaket_SendToJobClient = False
                        End If

                        '-- Aktion vor Selection der Objekt Daten:
                        With JS_ScriptingInterface.JobDefCurrJob.JobDef.JobFiles
                            '-- erstellt ein File der dem JobFiles hinzugef?gt wird
                            Dim fileToAdd_DPNE As String = Path.Combine(.JobDestRootDir_DP, "_CustomSpecialJobFile.txt")
                            File.WriteAllText(fileToAdd_DPNE, "TEST" + vbCrLf + fileToAdd_DPNE)
                            InfoSysProtocol.Print(fileToAdd_DPNE)
                        End With


                        '-- Vorgaben fuer weiteres Verhalten einstellen: "Keine Objekte selectieren lassen"
                        JS_ScriptingInterface.JobDefCurrJob.JobDef.JobControlRule.JobControlInterface.SelectObjects_ViaJobRule = False
                        '-- Vorgaben fuer weiteres Verhalten einstellen: "JobPaket an den Client senden"
                        JS_ScriptingInterface.JobDefCurrJob.JobDef.JobControlRule.JobControlInterface.JobPaket_SendToJobClient_AlsoWhenObjectPaketEmty = False


                    Case ScriptingDef.RunCondition_enum.Cond02_GenNewJob_After_SelectObjectData
                        InfoSysProtocol.Print("#Step:" + ScriptingDef.RunCondition_enum.Cond02_GenNewJob_After_SelectObjectData.ToString())
                        '-- processing JobPacke DataTable ---------------------
                        If JS_ScriptingInterface.JobDefCurrJob IsNot Nothing AndAlso
                           JS_ScriptingInterface.JobDefCurrJob.ObjectPacket_DataTable IsNot Nothing Then
                            If JS_ScriptingInterface.JobDefCurrJob.ObjectPacket_DataTable.Rows.Count > 0 Then
                                ' Edit the the DataRow off the ObjectPacket_DataTable
                                InfoSysProtocol.Print("ObjectData found Processing Object Data:")
                                For Each DR As DataRow In JS_ScriptingInterface.JobDefCurrJob.ObjectPacket_DataTable.Rows

                                    ' check if pause or stop button was pressed
                                    If JS_ScriptingInterface.ProcessControlCheckPauseStop(InfoSysProtocol, ScriptResult_r) = ScriptingInterface.Methodes.ProcessControlStatusEnum.Stop Then
                                        Exit Try
                                    End If

                                    InfoSysProtocol.PrintInfoLine("Details of:" + DR.Item("ObjectCliName").ToString)
                                    For Each Col As DataColumn In JS_ScriptingInterface.JobDefCurrJob.ObjectPacket_DataTable.Columns
                                        InfoSysProtocol.Print(("[" + Col.ColumnName + "]=").PadRight(35, "."c) + DR.Item(Col.ColumnName).ToString)
                                    Next
                                Next
                            End If
                            ScriptResult_r.ReturnDataTable = JS_ScriptingInterface.JobDefCurrJob.ObjectPacket_DataTable
                            InfoSysProtocol.Print("JS_ScriptingInterface.JobDefCurrJob.ObjectPacket_DataTable.Rows.Count=" + JS_ScriptingInterface.JobDefCurrJob.ObjectPacket_DataTable.Rows.Count.ToString)
                        Else
                            InfoSysProtocol.Print("ObjectData NOT found!!")
                        End If

                        ' check if pause or stop button was pressed
                        If JS_ScriptingInterface.ProcessControlCheckPauseStop(InfoSysProtocol, ScriptResult_r) = ScriptingInterface.Methodes.ProcessControlStatusEnum.Stop Then
                            Exit Try
                        End If

                    Case ScriptingDef.RunCondition_enum.Cond10_JobResults_Get

                End Select

                '-- #Exa: processing DS of IR ---------------------
                '-- starting the progress bar
                Call InfoSysProtocol.StatusBarProgressBarStart()
                Call InfoSysProtocol.Print_and_StatusBarSetCurrActionStatusInfo_Panel3("now Processing after JS_ScriptingInterface.JobDefCurrJob.JobDef.JobServerScript_RunCondition ...")
                Call InfoSysHeader.Print("#Step - 2 Script is in process")

                '-- #Doc: check/List if IR is in JobMgr DB
                Dim Ir_Obj As New Ir_cls
                Ir_Obj.ItemName = "000002"
                Ir_Obj.Rev = "A"
                Ir_Obj.ObjectFromSiteID = "TCUA"
                RunResult_Obj = JS_ScriptingInterface.IR_GetDatsets(Ir_Obj)

                If RunResult_Obj.ReturnDataTable.Rows.Count > 0 Then
                    ' List of all Datarows 
                    For Each DR As DataRow In RunResult_Obj.ReturnDataTable.Rows
                        Call InfoSysProtocol.PrintInfoLine("Datasets of IR:" + DR.Item("IRName").ToString)
                        For Each Col As DataColumn In RunResult_Obj.ReturnDataTable.Columns
                            Call InfoSysProtocol.PrintObject(Col.ColumnName, DR.Item(Col.ColumnName).ToString)
                        Next
                    Next
                Else
                    Call InfoSysProtocol.Print("no datasets found for IR:" + Ir_Obj.ItemNameRev + " (Site:" + Ir_Obj.ObjectFromSiteID + ")")
                End If


                I2 = CInt("100")

            Catch ex As Exception
                ScriptResult_r.Ex = ex
                ScriptResult_r.ExUp = True
                ScriptResult_r.ExMsg = "CustomScript"
                InfoSysProtocol.PrintEx(ex, ScriptResult_r.ExMsg)
                Exit Try
            End Try

            '-- #Doc: returning results 
            If ScriptResult_r.Ex Is Nothing Then
                I = 0
                If I = 0 Then
                    ScriptResult_r.ResultCode = 0
                    ScriptResult_r.ResultMsg = "OK.: Schript ends with no errors (message generated with script)"
                Else
                    ScriptResult_r.ResultCode = 10
                    ScriptResult_r.ResultMsg = "ERR: Schript ends with ERRORS! (message generated with script)"
                End If
            End If

            ScriptResult_r.ResultMsg += vbCrLf + JS_ScriptingInterface.ScriptDef.Script_DPNE

            '-- setting the progress bar to idel			
            Call InfoSysHeader.Print("#Step - 3 Progressbar set idle")
            System.Threading.Thread.Sleep(1000)
            Call InfoSysProtocol.StatusBarProgressBarSetIdle()
            Call InfoSysProtocol.PrintInfoLine(ScriptResult_r.ResultMsg)

            If DebugIsOn Or PauseOnEnd Then
                TextStr = "#Step - 4 Script will end after clicking the button"
                InfoSysHeader.Print(TextStr)
                InfoSysProtocol.Print_and_StatusBarSetCurrActionStatusInfo_Panel3(TextStr)
                Me.ScriptOutput_frm.Pause("click me and script will end")

                '-- closing the ScriptRun form 
                Me.ScriptOutput_frm.Close()
                Me.ScriptOutput_frm.Dispose()
            End If

            Return ScriptResult_r
        End Function

    End Class
End Namespace




