Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Linq
Imports System.Data
Imports System.Collections.Generic
Imports JF.PlmJobManager
Imports JF.PlmJobManager.JobServer
Imports JF.Tools

'' Script For MSC MultiSite Check via TaskSheduler: 
''  Date         Person        ChangeInfo
''  05.09.2019   S.Gueth       created
''  

'' #Doc: Parameter usage:
'' Parameter                           Description   
'' /PauseOnEnd=true/false              enables / disables  pause on end 		

Namespace JobMgrScript

    Public Class ScriptingGUITest

        Public Function ScriptMain(ByVal JS_ScriptingInterface As JobServer.ScriptingInterface.Methodes) As JF_Return_cls

            ' Required class for returning script results
            Dim ScriptReturn_r As New JF_Return_cls
            Dim WaitTimeIn_MSec As Integer
            'Dim SiteId As String = Nothing
            Dim StatusToSet As String = Nothing
            Dim ProcessGroupNumber As String = Nothing
            Dim PauseOnEnd As Boolean = False
            Dim ScriptParameter As String = JS_ScriptingInterface.ScriptDef.cmdPara

            '-- #Step: open the ScriptRun form  
            Dim ScriptOutput_frm As New JobServer.JobServer_ScriptRun_frm(JS_ScriptingInterface.ScriptDef)
            'ScriptOutput_frm.Show()

            Dim InfoSysHeader = ScriptOutput_frm.InfoSysHeader
            Dim InfoSysProtocol = ScriptOutput_frm.InfoSysProtocol

            InfoSysHeader = JS_ScriptingInterface.CurActiveInfoSysGet
            InfoSysProtocol = JS_ScriptingInterface.CurActiveInfoSysGet


            '-- for printing Informations to the header textbox 
            InfoSysHeader.PrintObject("Script file", JS_ScriptingInterface.ScriptDef.Script_DPNE)
            InfoSysHeader.PrintObject("Script description", JF.Tools.JF_ToolsFile.ParsePath_NE(JS_ScriptingInterface.ScriptDef.NameDescription))
            InfoSysHeader.PrintObject("EATON", "Mark objects for migration")
            InfoSysHeader.PrintObject("using Paramter", ScriptParameter)

            Try
                'SiteId = JS_ScriptingInterface.ParameterValueGet("SiteId")
                PauseOnEnd = If(JS_ScriptingInterface.ParameterValueGet("PauseOnEnd") = "true", True, False)
                ScriptReturn_r.ResetToDefaultValues()
                InfoSysHeader.Print("Test header")


                InfoSysProtocol.PrintInfoLine("Test InfoSys line")
				
				
'test
                Dim itterations As Integer = 500
                Dim index As Integer = 0
                While index < itterations
                    
                    InfoSysProtocol.PrintInfoLine("Test InfoSys line: " + index.ToString)
                    Threading.Thread.Sleep(100)
					
                    InfoSysProtocol.StatusBarSetCurrActionStatusInfo_Panel3(
                                       "Processing:[" + index.ToString + "] " + Format(index, "[00.0%]" +
                                        " // DS.Mark:[Ok:/ERR:] " +
                                        " // Stop process "))

                    ' check if pause putton was clicked, #New: 3.1489;06.09.2019;S.Gueth
                    JS_ScriptingInterface.ScriptPauseCheck(InfoSysProtocol)

                    ' check if Stop Button was pressed, #New: 3.1489;06.09.2019;S.Gueth
                    If JS_ScriptingInterface.ScriptStopButtonWasClicked() Then
                        Dim stopMsg As String = "Script was stopped by user!"
                        InfoSysProtocol.PrintInfoLine(stopMsg)
                        ScriptReturn_r.ErrMsg = stopMsg
                        Return ScriptReturn_r
                    End If

                    index += 1
                End While

                '-- #Doc: Status 
                '					InfoSysProtocol.StatusBarSetCurrActionStatusInfo_Panel3( _ 
                '						"Processing:[" + index.ToString + "/" + count.ToString + "] " + Format(index/count, "[00.0%]" + _
                '						" // DS.Mark:[Ok:" + DatasetsMarkedOK.ToString + "/ERR:" + DatasetsMarkedERR.ToString + "] " + _
                '						" // Stop process " + Me.ProcessStopInfo))
                ' InfoSysProtocol.StatusBarSetCurrActionStatusInfo_Panel3(PStatusTxt)


            Catch ex As Exception
                ScriptReturn_r.Ex = ex
                ScriptReturn_r.ExMsg = "Exeption in script:" + JS_ScriptingInterface.ScriptDef.NameDescription
                InfoSysProtocol.PrintEx(ex, "MultiSiteCheck.ScriptMain")
            End Try

            If PauseOnEnd Then
                ScriptOutput_frm.Pause()
                '-- #Step: closing the ScriptRun form 
                ScriptOutput_frm.Close()
                ScriptOutput_frm.Dispose()
            Else
                WaitTimeIn_MSec = 2500
                InfoSysProtocol.Print_and_StatusBarSetCurrActionStatusInfo_Panel3("wait:" + (WaitTimeIn_MSec / 1000).ToString("#.#") + " sec")
                System.Threading.Thread.Sleep(WaitTimeIn_MSec)
            End If

            Return ScriptReturn_r
        End Function

    End Class
End Namespace

