Option Compare Text
Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Collections.Generic
Imports System.Data

Imports JF.PlmJobManager.JobServer
Imports JF.Tools
Imports JF.PlmJobManager


' # Doc: Example Usage of external .net .dll
'xReferences CustomDll_Example.dll

' Information for developer:
' All Lines with mark "#" should be edit by the developer
' # Template Vers: 3.1489;09.09.2019;J.Fes
' # ---------------------------------------------------------------------------------------
' # Documentation:
' # Description  : script to compute the grouped result messages, you can do this also via UI over ObjectsList -> Filter -> P.Data -> Res.Msg
' # Parameters   :
' #
' # History:
' # Date         Person      ChangeInfo
' # 28.07.21     S.Gueth     Initial Version
' # ---------------------------------------------------------------------------------------

Namespace JS_ScriptingTemplate

    Public Class ComputeResultMsg


        ''' <summary>
        ''' Returns Description and Version Info for ths script
        ''' </summary>
        Public Shared ReadOnly Property ScriptDescVers As String
            Get
                Return "Compute Grouped Result Messages  V28.07.2021/S.Gueth"
            End Get
        End Property

        Private ScriptOutput_form As JobServer_ScriptRun_frm

        '-- ##debug:
        Dim DebugIsOn As Boolean = False

        ''' <summary>
        ''' #Please replace summary content
        ''' </summary>
        ''' <param name="JS_ScriptingInterface"></param>
        ''' <remarks>
        ''' #New: #Date# / Name
        ''' </remarks>
        Public Function ScriptMain(ByVal JS_ScriptingInterface As ScriptingInterface.Methodes) As JF_Return_cls

            '-- #Doc: ScriptResult_r Required Object for returning script results
            Dim ScriptResult_r As New JF_Return_cls
            Dim RunResult_Obj As New JF_Return_cls

            Dim TextStr As String = ""

            Dim ComputeGroupedResMessagesDataSource = JS_ScriptingInterface.NewDataSourceObjGenerate("ComputeGroupedResMessages")

            Dim PauseOnEnd As Boolean = False
            PauseOnEnd = If(JS_ScriptingInterface.ParameterValueGet("PauseOnEnd") = "true", True, False)

            '-- #Doc: Debug ON Off
            ' DebugIsOn = true
            If System.Diagnostics.Debugger.IsAttached Then
                DebugIsOn = True
            End If

            Dim InfoSysHeader As JF.InfoSys.JF_InfoSys = JS_ScriptingInterface.TaskShedulerInfoSysGet
            Dim InfoSysProtocol As JF.InfoSys.JF_InfoSys = JS_ScriptingInterface.TaskShedulerInfoSysGet


            If PauseOnEnd Or DebugIsOn Then
                '-- #Doc: using "standard form" for printing script informations
                Me.ScriptOutput_form = New JobServer_ScriptRun_frm(JS_ScriptingInterface.ScriptDef)
                InfoSysHeader = Me.ScriptOutput_form.InfoSysHeader
                InfoSysProtocol = Me.ScriptOutput_form.InfoSysProtocol
                ScriptOutput_form.Show()
            End If


            InfoSysProtocol.PrintObject("Script Descr + Ver", ScriptDescVers)
            InfoSysProtocol.StatusBarSetCurrActionInfo_Panel1(ScriptDescVers)


            '-- #Doc: printing Informations to the header textbox
            Call InfoSysHeader.PrintInfoLine("#Step - 1 Script started!")

            Try


                InfoSysHeader.Print("")
                InfoSysHeader.StatusBarSetCurrActionStatusInfo_Panel_1und3_BackColor(System.Drawing.Color.Yellow)
                InfoSysHeader.PrintObject("Action Compute results", "grouped by result message/sections")

                Dim stopWatch As New JF_Stopwatch_cls("Compute Results")
                InfoSysHeader.StatusBarProgressBarStart(" Compute ", " results grouped by result message ")

                stopWatch.Start()
                ' compute error results
                ScriptResult_r = ComputeGroupedResMessagesDataSource.ComputeErrResultsGroupedByResultMessage()
                stopWatch.Stop()

                InfoSysHeader.PrintObject("elapsed time", stopWatch.TimeElapsed_str)
                InfoSysHeader.StatusBarProgressBarSetIdle()

                If Not ScriptResult_r.ResultIsEverythingOk Then
                    InfoSysHeader.PrintEx(ScriptResult_r.Ex, "Error Code: " + ScriptResult_r.ResultCodeAsString)
                    If ScriptResult_r.ExitMsgExist Then
                        InfoSysHeader.Print("SQL Command Text:")
                        InfoSysHeader.Print(ScriptResult_r.ExitMsg)
                    End If
                End If


            Catch ex As Exception
                ScriptResult_r.Ex = ex
                ScriptResult_r.ExUp = True
                ScriptResult_r.ExMsg = "Exception on computing grouped result messages"
                InfoSysProtocol.PrintEx(ex, ScriptResult_r.ExMsg)
                GoTo EndOfScript
            End Try

            '-- #Doc: returning results
            If Not ScriptResult_r.ErrUp Then
                ScriptResult_r.ResultCode = 0
                ScriptResult_r.ResultMsg = "OK.: Schript ends with no errors (message generated with script)"
            End If

            ScriptResult_r.ResultMsg += vbCrLf + JS_ScriptingInterface.ScriptDef.Script_DPNE

            '-- setting the progress bar to idel
            InfoSysHeader.Print("#Step - 2 Progressbar set idle")
            System.Threading.Thread.Sleep(1000)
            Call InfoSysProtocol.StatusBarProgressBarSetIdle()

EndOfScript:

            Call InfoSysProtocol.PrintInfoLine(ScriptResult_r.ResultMsg)

            If DebugIsOn Or PauseOnEnd Then
                TextStr = "#Step - 3 Script will end after clicking the button"
                InfoSysHeader.Print(TextStr)
                InfoSysProtocol.Print_and_StatusBarSetCurrActionStatusInfo_Panel3(TextStr)
                Me.ScriptOutput_form.Pause("click me and script will end")

                '-- closing the ScriptRun form
                Me.ScriptOutput_form.Close()
                Me.ScriptOutput_form.Dispose()
            End If


            Return ScriptResult_r
        End Function

    End Class
End Namespace




