Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Collections.Generic
Imports JF.PlmJobManager
Imports JF.PlmJobManager.JobServer
Imports JF.Tools

'' Script for JobServer log file clean up via TaskSheduler: 
''  Date         Person        ChangeInfo
''  25.07.2017   S.Gueth       created
''  21.03.2019   S.Gueth       updated Cb Clean Up by Cb Com Result added


'' #Doc: Parameter usage:
'' Parameter                           Description   
'' /DeleteFiles=true/false             defines if files to clean up should be deleted (true) or not (false)	
'' /JSSyslogCleanUp=true/false         defines if the JobServer syslog files should be cleaned up (all files older then 30 days will be deleted)
'' /ProcessDataCleanUp=true/false      defines if ProcessData Zip/7z files should be cleaned up (all files, that have no refference in JM database will be deleted)
'' /CBDataCleanUp=true/false           defines if the CheckBox data in the given data root dir (parameter CBDataDir_DP has to be set) should be cleaned up
''                                     the process is looking for all xml files that are not refferenced in JM database (as result link)
''                                     if there is no refference, the process is also looking for corresponding cgm and tif files 
''                                     -> all these files will be deleted
'' /CBDataDir_DP=C:\CBData\Root        defines the root directory of the check box data that should be cleaned up
'' /CBCleanUpDataBy=XML/IR/CompRes     XML: if Cb xml file has no refference in JobManager database, the xml file and the corresponding cgm, tif and syslog files will be cleaned up
''                                     IR: if an item revision Object does Not exist In JobManager database, the whole CB data directory For this Object will be cleaned up
''                                     CompRes: deletes all CheckBox, tif, cgm and syslog files where latest CB compair result in JobManager is OK -> where Result Code is 0 and has no WRN
'' /CBSitesForCleanUp=Site1,Site2      defines a list of sites (seperated by comma), where the analyse and clean up process for CheckBox should be checked against
'' /CBCompairProcStateCol=ProcStateCol01 defines the process group for checkbox compair
'' /CBPreventCleanUpSearchPatterns=*.txt;*.prt defines seachr patterns (devided by ; which will prevent the cleanup for the current object, when fill with these patterns are found)
'' /PauseOnEnd=true/false              enables / disables  pause on end 	

'' Clean up by CB xml file:
'' the process is looking for all xml files that are not refferenced in JM database (as result link) within the specified site id's
'' if there is no refference, the process is also looking for corresponding cgm, tif and syslog files 
'' -> all these files will be deleted
''
'' Clean up by Item Revision Object:
'' the process is looking for folders that contains cb xml files
'' the item revision object will be identified by the folder structure
'' -> example C:\CBData\Root\ ... \ItemID\Rev\CBExtract.xml
'' if this object does not exist in the JobManager db within the specified site id's
'' -> the whole folder (where the xml file is located) within subfolders will be deleted

Namespace JobMgrScript

    Public Class JSLogCleanUp

        Public Function ScriptMain(ByVal JS_ScriptingInterface As JobServer.ScriptingInterface.Methodes) As JF_Return_cls

            ' Required class for returning script results
            Dim ScriptReturn_r As New JF_Return_cls
            Dim WaitTimeIn_MSec As Integer
            Dim deleteFiles As Boolean = False
            Dim CBCleanUpDataBy As JSCleanUP_frm.CBCleanUpDataEnum
            Dim JSSyslogCleanUp As Boolean = False
            Dim ProcessDataCleanUp As Boolean = False
            Dim CBDataCleanUp As Boolean = False
            Dim CBDataDir_DP As String = ""
            Dim CBsiteIDsForCleanUp As String = ""
            Dim CBCompairProcStateCol As String = ""
            Dim CBPreventCleanUpSearchPatterns As String = ""
            Dim PauseOnEnd As Boolean = False
            Dim ScriptParameter As String = JS_ScriptingInterface.ScriptDef.cmdPara

            '-- #Step: open the ScriptRun form  
            Dim ScriptOutput_frm As New JobServer.JobServer_ScriptRun_frm(JS_ScriptingInterface.ScriptDef)
            ScriptOutput_frm.Show()

            '-- for printing Informations to the header textbox 
            ScriptOutput_frm.InfoSysHeader.PrintObject("Script file", JS_ScriptingInterface.ScriptDef.Script_DPNE)
            ScriptOutput_frm.InfoSysHeader.PrintObject("Script description", JF.Tools.JF_ToolsFile.ParsePath_NE(JS_ScriptingInterface.ScriptDef.NameDescription))
            ScriptOutput_frm.InfoSysHeader.PrintObject("JS.CleanUp", "JobServer log file clean up")
            ScriptOutput_frm.InfoSysHeader.PrintObject("using Paramter", ScriptParameter)

            Try
                deleteFiles = If(JS_ScriptingInterface.ParameterValueGet("DeleteFiles") = "true", True, False)
                If JS_ScriptingInterface.ParameterValueGet("CBCleanUpDataBy").ToUpper = "XML" Then
                    CBCleanUpDataBy = JSCleanUP_frm.CBCleanUpDataEnum.ByXmlFile
                ElseIf JS_ScriptingInterface.ParameterValueGet("CBCleanUpDataBy").ToUpper = "COMPRES" Then
                    CBCleanUpDataBy = JSCleanUP_frm.CBCleanUpDataEnum.ByCBCompairResult
                Else
                    CBCleanUpDataBy = JSCleanUP_frm.CBCleanUpDataEnum.ByIRObject
                End If
                JSSyslogCleanUp = If(JS_ScriptingInterface.ParameterValueGet("JSSyslogCleanUp") = "true", True, False)
                ProcessDataCleanUp = If(JS_ScriptingInterface.ParameterValueGet("ProcessDataCleanUp") = "true", True, False)
                CBDataCleanUp = If(JS_ScriptingInterface.ParameterValueGet("CBDataCleanUp") = "true", True, False)
                CBDataDir_DP = JS_ScriptingInterface.ParameterValueGet("CBDataDir_DP")
                CBsiteIDsForCleanUp = JS_ScriptingInterface.ParameterValueGet("CBSitesForCleanUp")
                CBCompairProcStateCol = JS_ScriptingInterface.ParameterValueGet("CBCompairProcStateCol")
                CBPreventCleanUpSearchPatterns = JS_ScriptingInterface.ParameterValueGet("CBPreventCleanUpSearchPatterns")
                PauseOnEnd = If(JS_ScriptingInterface.ParameterValueGet("PauseOnEnd") = "true", True, False)
                ScriptReturn_r.ResetToDefaultValues()
                ScriptOutput_frm.InfoSysHeader.PrintObject("JS.CleanUp delete files", deleteFiles.ToString())
                ScriptReturn_r = JS_ScriptingInterface.JobServerLogFileCleanUp(ScriptOutput_frm.InfoSysProtocol,
                                                                               JSSyslogCleanUp,
                                                                               ProcessDataCleanUp,
                                                                               CBDataCleanUp,
                                                                               CBDataDir_DP,
                                                                               CBCleanUpDataBy,
                                                                               CBsiteIDsForCleanUp,
                                                                               deleteFiles,
                                                                               CBCompairProcStateCol,
                                                                               CBPreventCleanUpSearchPatterns)
                ScriptReturn_r.ResultMsg = "Result JS.CleanUp: " +
                                            vbCrLf +
                                            ScriptReturn_r.ResultMsgEvaluate
                ScriptReturn_r.ResultMsg = ScriptReturn_r.ResultMsg.TrimEnd(CChar(vbLf)).TrimEnd(CChar(vbCr))

            Catch ex As Exception
                ScriptReturn_r.Ex = ex
                ScriptReturn_r.ExMsg = "Exeption in script:" + JS_ScriptingInterface.ScriptDef.NameDescription
                ScriptOutput_frm.InfoSysProtocol.PrintEx(ex, "JobServerLogFileCleanUp.ScriptMain")
            End Try

            If PauseOnEnd Then
                'WaitTimeIn_MSec = 2500
                'ScriptOutput_frm.InfoSysProtocol.Print_and_StatusBarSetCurrActionStatusInfo_Panel3("wait:" + (WaitTimeIn_MSec / 1000).ToString("#.#") + " sec")
                'System.Threading.Thread.Sleep(WaitTimeIn_MSec)
                ScriptOutput_frm.Pause()
            Else
                WaitTimeIn_MSec = 2500
                ScriptOutput_frm.InfoSysProtocol.Print_and_StatusBarSetCurrActionStatusInfo_Panel3("wait:" + (WaitTimeIn_MSec / 1000).ToString("#.#") + " sec")
                System.Threading.Thread.Sleep(WaitTimeIn_MSec)
            End If


            '-- #Step: closing the ScriptRun form 
            ScriptOutput_frm.Close()
            ScriptOutput_frm.Dispose()

            Return ScriptReturn_r
        End Function
    End Class
End Namespace

















