Print ''
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Table         : [GlobalConfig_tbl]'
Print ' Creation Date : 26.02.2016'
Print ' Autor         : J.Fes/S.Gueth'
Print ' '
Print '-------------------------------------------------------------------------'

use [#DB_N#]


Declare @MyActionMsg1 nvarchar (max)
Declare @MyTableName nvarchar (max)
    set @MyTableName='GlobalConfig_tbl'
--------------------------------------------------------------------------------
-- verzweigen auf TableCreate: oder TableUpdate:
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[GlobalConfig_tbl]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
  BEGIN
   goto TableUpdate
  END
ELSE
  BEGIN
   goto TableCreate
  END

--------------------------------------------------------------------------------
TableCreate:
  set @MyActionMsg1=
      '-- Table: [GlobalConfig_tbl] dose not exist and will be created new'
  Print (@MyActionMsg1)
  CREATE TABLE [dbo].[GlobalConfig_tbl] (
          [Id]                          [uniqueidentifier] NOT NULL ,
          [ClassKey]                    [nvarchar] (255) ,
          [ConfigXML]                   [xml]     NULL ,                  -- #New 07.08.2014 / J.Fes
          [Note]                        [nvarchar] (MAX)
  ) ON [PRIMARY]

goto CheckCreateIndex


--------------------------------------------------------------------------------
TableUpdate:

  set @MyActionMsg1=
       '-- Table: [' + @MyTableName + '] exist and will be updated'
  Print (@MyActionMsg1)

  Declare @ColumeName nvarchar (256)
  Declare @ColumeNameOld nvarchar (256)
  Declare @ColumeNameNew nvarchar (256)
  Declare @ExecuteStr nvarchar (max)

goto CheckCreateIndex
--------------------------------------------------------------------------------
CheckCreateIndex:


  If NOT Exists (select Name from sysindexes where Name = 'GlobalConfig_tbl_pk')
  begin
     print (' --> create index: GlobalConfig_tbl_pk')
     ALTER TABLE [dbo].[GlobalConfig_tbl]
       ADD CONSTRAINT [GlobalConfig_tbl_pk]
       PRIMARY KEY NONCLUSTERED ([Id])
       WITH (
         FILLFACTOR = 80,
         PAD_INDEX = OFF,
         STATISTICS_NORECOMPUTE = OFF,
         ALLOW_ROW_LOCKS = ON,
         ALLOW_PAGE_LOCKS = ON)
  end

  If NOT Exists (select Name from sysindexes where Name = 'GlobalConfig_tbl_uq')
  begin
     print (' --> create index: GlobalConfig_tbl_uq')
     ALTER TABLE [dbo].[GlobalConfig_tbl]
        ADD CONSTRAINT [GlobalConfig_tbl_uq]
        UNIQUE NONCLUSTERED ([ClassKey])
        WITH (
          FILLFACTOR = 80,
          PAD_INDEX = OFF,
          IGNORE_DUP_KEY = OFF,
          STATISTICS_NORECOMPUTE = OFF,
          ALLOW_ROW_LOCKS = ON,
          ALLOW_PAGE_LOCKS = ON)
  end
--------------------------------------------------------------------------------
EndeExit:
 Print '------------------------------------------------------------------------'
 Print 'Done on Database: #DB_N#'
 Print '------------------------------------------------------------------------'

GO
