Print ''
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Table         : [Objects_ObjectGroups_Rel_tbl]'
Print ' Creation Date : 20.08.2015'
Print ' Last Update.. : 20.08.2015/A.Becker'
Print ' Autor         : A.Becker'
Print ' '
Print '-------------------------------------------------------------------------'

use [#DB_N#]


Declare @MyActionMsg1 nvarchar (max)
Declare @MyTableName nvarchar (max)
set @MyTableName='Objects_ObjectGroups_Rel_tbl'
--------------------------------------------------------------------------------
-- verzweigen auf TableCreate: oder TableUpdate:
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Objects_ObjectGroups_Rel_tbl]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
  BEGIN
   goto TableUpdate
  END
ELSE
  BEGIN
   goto TableCreate
  END

--------------------------------------------------------------------------------
TableCreate:
  set @MyActionMsg1=
      '-- Table: [' + @MyTableName + '] dose not exist and will be created new'
  Print (@MyActionMsg1)

  CREATE TABLE [dbo].[Objects_ObjectGroups_Rel_tbl] (
         /* mappt Objects zu den ObjectGroups */
         [ObjectId]         uniqueidentifier NOT NULL,
         [ObjectGroupId]    uniqueidentifier NOT NULL
  )
  ON [PRIMARY]
  
  
goto CheckCreateIndex

--------------------------------------------------------------------------------
TableUpdate:
  set @MyActionMsg1=
       '-- Table: [' + @MyTableName + '] exist and will be updated'
  Print (@MyActionMsg1)
  goto CheckCreateIndex


--------------------------------------------------------------------------------
CheckCreateIndex:

  Declare @ColumeName nvarchar (256)
  Declare @ColumeNameOld nvarchar (256)
  Declare @ColumeNameNew nvarchar (256)
  Declare @ExecuteStr nvarchar (max)

  EXECUTE JF_PrimKeyCheckCreateDef 'IX_ObjectGroups_Rel_PK',  @MyTableName, 'ObjectId, ObjectGroupId'
  EXECUTE JF_IndexCheckCreateDef   'IX_ObjectGroups_Rel_Rev', @MyTableName, 'ObjectGroupId, ObjectId'
  -- 14.10.2015/J.Fes  entfernt
  -- EXECUTE JF_IndexCheckCreateDef   'IX_ObjectGroups_Rel_IdAndClass', @MyTableName, 'ObjectGroupId, ObjectClass'

  -- 14.10.2015/J.Fes Create Contrains hierher verlagert
  --                  !!!-- on change please review ..\DbMaintain\JobMgr_21_ObjectData_And_ProcessData_Delete.sql --!!!
  If NOT Exists (select Name  from sysobjects  where Name = "FK_ObjectGroupsRel_ObjectGroups" and type = "F")
  BEGIN
    Print '    |-> Create FOREIGN KEY (1/2) "FK_ObjectGroupsRel_ObjectGroups" --'
    ALTER TABLE [dbo].[Objects_ObjectGroups_Rel_tbl]
    ADD CONSTRAINT [FK_ObjectGroupsRel_ObjectGroups] FOREIGN KEY ([ObjectGroupId])
    REFERENCES [dbo].[ObjectGroups_tbl] ([Id])
    ON UPDATE CASCADE
    ON DELETE CASCADE
  END

  If NOT Exists (select Name  from sysobjects  where Name = "FK_ObjectGroupsRel_Objects" and type = "F")
  BEGIN
    Print '    |-> Create FOREIGN KEY (2/2) "FK_ObjectGroupsRel_Objects" --'
    ALTER TABLE [dbo].[Objects_ObjectGroups_Rel_tbl]
    ADD CONSTRAINT [FK_ObjectGroupsRel_Objects] FOREIGN KEY ([ObjectId])
    REFERENCES [dbo].[Objects_tbl] ([Id])
    ON UPDATE CASCADE
    ON DELETE CASCADE
  END

EndeExit:
 Print '------------------------------------------------------------------------'
 Print 'Done on Database: #DB_N#'
 Print '------------------------------------------------------------------------'

GO
