Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Description...: Test SQL Perfomance'
Print ' Creation Date.: 05.11.2015'
Print ' Autor.........: J.Feuerstein'
Print '-------------------------------------------------------------------------'

use [#DB_N#]

DECLARE @ExecuteSQLstr nvarchar(max)

print ''
Print '-- Test Perf: Start -----------------------------------------------------'

   declare @DateTimeStart datetime
   set @DateTimeStart = GetDate()

   -- rem clears buffer
--    print ('Step: DBCC DROPCLEANBUFFERS')
--    DBCC DROPCLEANBUFFERS

--    print ('Step: DBCC FREEPROCCACHE')
--    DBCC FREEPROCCACHE

   -- add your SQL
   SELECT TOP 25
   -- Objects_tbl.*,
   -- Ir.ObjectPuid AS IrPuid,
    Ir.ObjectName AS IrName
   FROM
    dbo.Objects_tbl WITH (nolock)
    LEFT OUTER JOIN dbo.Objects_Ir_Rel_tbl WITH (nolock) ON (dbo.Objects_tbl.Id = dbo.Objects_Ir_Rel_tbl.ObjectId)
    LEFT OUTER JOIN dbo.Objects_tbl Ir WITH (nolock) ON (dbo.Objects_Ir_Rel_tbl.IrId = Ir.Id)
   WHERE
    Objects_tbl.ObjectClass='DS'
    AND Objects_tbl.ProcStateColRf = 'RUN'
   -- AND Objects_tbl.ObjectFromSiteID='#SiteID#'
   -- AND Objects_tbl.ObjectOwningSiteID='#SiteID#'
    AND Objects_tbl.ObjectUgMaster_Type = 'SP'
    AND Objects_tbl.ObjectType = 'UGMASTER'
   ORDER BY
    Objects_tbl.ObjectLastModDate DESC



-- Print Duration
Execute JF_ShowTimeDiffToNow 'CLEAN BUFFER', @DateTimeStart

Print '-- Test Perf: Done ------------------------------------------------------'


ende:

go
