Print ''
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Table         : [Objects_tbl]'
Print ' Creation Date : 22.03.2006'
Print ' Autor         : J.Feuerstein'
Print '-------------------------------------------------------------------------'

use [#DB_N#]

Declare @MyActionMsg1 nvarchar (max)
Declare @MyTableName nvarchar (max)
set @MyTableName='Objects_tbl'
DECLARE @ExecuteSQLstr nvarchar(max)

declare @indexNrCur    int
declare @ProcStatColsN int
declare @ObjectAttrsN  int
declare @indexNrStr    nvarchar (max)
declare @IndexName     nvarchar (max)

declare @ColumeName    nvarchar (max)
declare @ColumeNameOld nvarchar (max)
declare @ColumeNameNew nvarchar (max)
declare @ExecuteStr    nvarchar (max)

-- def. Anzahl ProcStateCol's L.Update 06.08.2014
set @ProcStatColsN = 20
-- def. Anzahl ObjectAttr's L.Update 06.08.2014
set @ObjectAttrsN = 10

  -- #Step: create index for ProcStateColRf ProcStateCol01..20
  set @indexNrCur = 6
  WHILE @indexNrCur <= @ProcStatColsN + 1
  BEGIN
    set @indexNrStr=right('00' + convert(nvarchar,@indexNrCur),2)
    set @ColumeName='ProcStateCol' + @indexNrStr
    set @IndexName = 'Objects_tbl_IDX_PsCol' + @indexNrStr
    if @indexNrCur = @ProcStatColsN +1
    begin
      -- Sonderregel: Process [ProcStateColRf] angepasst 23.11.2011 J.Fes
      set @ColumeName='ProcStateColRf'
      set @IndexName = 'xxObjects_tbl_IDX_PsColRf'
    end
    -- Create Index: (neue Methode 28.01.2011]
    EXECUTE JF_IndexDelete @IndexName, @MyTableName, @ColumeName
    set @indexNrCur = @indexNrCur +1
  END


  -- #New: 06.08.2014 / J.Fes
  -- #Step: create index for  ObjectsAttr01..10
  set @indexNrCur = 1
  WHILE @indexNrCur <= @ObjectAttrsN
  BEGIN
    set @indexNrStr=right('00' + convert(nvarchar,@indexNrCur),2)
    set @ColumeName='ObjectAttr' + @indexNrStr
    set @IndexName = 'Objects_tbl_IDX_ObjectAttr' + @indexNrStr
    EXECUTE JF_IndexDelete @IndexName, @MyTableName, @ColumeName
    set @indexNrCur = @indexNrCur +1
  END

  EXECUTE JF_IndexDelete 'Objects_tbl_IDX17', @MyTableName, 'ObjectOwner'
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX18', @MyTableName, 'ObjectGroup'
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX19', @MyTableName, 'ObjectLastModUser'
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX20', @MyTableName, 'ObjectPuid'
  -- #New 13.07.2010 19:10 siehe auch Objects_tbl_Object_GetDS
  -- #Update 13.06.2014 18:45 Objects_tbl_IDX21 wurde nicht erzeugt korriegiert
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX21', @MyTableName, '[ObjectFromSiteID] ASC, [ObjectPuid] ASC'
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX22', @MyTableName, 'ObjectDescription'
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX23', @MyTableName, 'ObjectName2'
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX25', @MyTableName, 'ObjectFs_Vol'
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX26_ObjectSelectByMarker', @MyTableName, 'ObjectSelectByMarker'

  -- rem New 26.08.2011 17:41 geting faster HitCounts
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX30', @MyTableName, 'ObjectFs_NE'
  -- rem New 26.08.2011 17:42 geting ObjectReleaseState
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX31', @MyTableName, 'ObjectReleaseState'

  -- rem New 18.10.2011 21:03 Optimice Get JobPaket Rf AP
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX40', @MyTableName, '[ObjectUgMaster_APLevels] ASC, [ObjectUgMaster_CompCount] ASC, [ObjectCreateDate] DESC'
  -- New 21.10.2011 21:13  Optimice Get JobPaket SP
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX41', @MyTableName, '[ObjectCreateDate] DESC'

  -- New 13.12.2011 21:35  Optimice Get JobPaket SP
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX42', @MyTableName, '[ObjectUgMaster_FsHitCount]'

  -- #New: 28.08.2013 21:50 J.Fes
  EXECUTE JF_IndexDelete 'Objects_tbl_IDX43', @MyTableName, '[ObjectExportRecordDate] DESC'
 EndeExit:
 Print ('   |-> Done on Database: #DB_N#')
 Print '------------------------------------------------------------------------'

GO
