@Echo off
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%
 set MyCmd_DPNE=%~0
 if "%path_org%" equ "" set path_org=%Path%
 call :PathCutLastDir JobMgrRoot_DP "%~dp0"
 set path=%JobMgrRoot_DP%\03-BinPublic;%CmdCurRoot_DP%;%Path%

 cls

 Echo.
 Echo.
 Echo ##########################################################################
 Echo # PLMJobManager Service Tools                                            #
 Echo # Date         Who     Details                                           #
 Echo # 19.06.2014   J.Fes   #New: Creation of this Tool                       #
 Echo # 19.06.2014   J.Fes   #New: Set NXV                                     #
 Echo # 10.09.2014   J.Fes   #New: JSE,ASE,ASA,ASR                             #
 Echo # 02.02.2015   J.Fes   #New: DCL                                         #
 Echo # 09.02.2017   J.Fes   #New: UGII_DISPLAY_DEBUG                          #
 Echo # 13.12.2017   J.Fes   #New: UGII_DISPLAY_DEBUG                          #
 Echo # 10.03.2023   J.Fes   #LUp: Optimices                                   #
 Echo # 13.03.2024   J.Fes   #LUp: add SUP UGII_USER_PROFILE_DIR               #
 Echo ##########################################################################
 Echo.

  rem #New 24.03.2021/J.Fes see ENV JobMgr_ResIcons_DP
 Call %~dp0Application-Startmenu-IconsOrg.cmd

:Menu
 call ColorSet.cmd Dialog

 Call :DirOrg

 set MyApplTitle=JobMgr Service Menue %MyApplProd_NShort%.%JobMgr_VerNumber% [AppRoot:%JobMgrRoot_DP%]
 Title %MyApplTitle%
 Echo.
 Echo ----------------------------------------------------------------------------
 Echo * %MyApplTitle% *
 Echo ----------------------------------------------------------------------------
 Echo  SET = Setx TC and NX Environment Variables
 Echo  DCL = Directory Clean TempDirs + JobMgr
 Echo. ------ Org:JobManagerStartCustom.cmd JobMgr_RootL_DP ----------------------
 Echo  JSE = Edit %JobManagerStartCustom_DPNE%
 Echo. ------ Org:Autostart ------------------------------------------------------
 Echo  ASE = Edit %JobManagerAutostartCustom_DPNE%
 Echo  ASA = Autostart activate
 Echo  ASR = Autostart remove
 Echo  ASO = Autostart folder open
 Echo  ARF = Application Root folder open (%JobMgrRoot_DP%)
 Echo. ------ Org:Deploy Scripts -------------------------------------------------
 Echo  JDE = Edit %JobManagerDeployCustom_DPNE%
 Echo  JDR = RUN  %JobManagerDeployCustom_DPNE%
 Echo.
 Echo  Q   = Quit (finish this dialog)
 Echo.
 set doNext=

 set /P doNext="please select option: "

 if /I "%doNext%" equ "Q"   Exit
 call :doNextExec
 goto :Menu

rem ============================================================================
:doNextExec

 Call ColorSet.cmd IsExecuting
 if /I "%doNext%" equ "SET"                  call :SetNXTcEnvVariables
 if /I "%doNext%" equ "Nx_Debug_ON"          call :NxDebug_UGII_CHECKING_LEVEL ":ON"
 if /I "%doNext%" equ "Nx_Debug_OFF"         call :NxDebug_UGII_CHECKING_LEVEL ":OFF"
 if /I "%doNext%" equ "Nx_DebugDisplay_ON"   call :NxDebug_UGII_DISPLAY_DEBUG ":ON"
 if /I "%doNext%" equ "Nx_DebugDisplay_OFF"  call :NxDebug_UGII_DISPLAY_DEBUG ":OFF"

 if /I "%doNext%" equ "NX_Conf_Rule_ON" call :NX_Conf_Rule ":ON"
 if /I "%doNext%" equ "NX_Conf_Rule_OF" call :NX_Conf_Rule ":OFF"

 if /I "%doNext%" equ "TC_SQLDebug_ON" call :TcDebug_TC_SQL_DEBUG ":ON"
 if /I "%doNext%" equ "TC_SQLDebug_OF" call :TcDebug_TC_SQL_DEBUG ":OFF"
 if /I "%doNext%" equ "TC_TCDef_ON"    call :TC_TCDef ":ON"


 if /I "%doNext%" equ "JSE"              call :JSE
 if /I "%doNext%" equ "ASE"              call :ASE
 if /I "%doNext%" equ "ASA"              call :ASA
 if /I "%doNext%" equ "ASO"              call :ASO
 if /I "%doNext%" equ "ARF"              call :ARF
 if /I "%doNext%" equ "ASR"              call :ASR

 if /I "%doNext%" equ "JDE"              call :JDE
 if /I "%doNext%" equ "JDR"              call :JDR

 if /I "%doNext%" equ "DCL"              call :DCL
 if /I "%doNext%" equ "SUP"              call :SUP
 if /I "%doNext%" equ "R"  Start  " " Explorer.exe /e, "%JobMgrRoot_DP%"
 goto :eof

rem ============================================================================
:DCL
 call ColorSet.cmd Reset
 Echo.
 Echo ** Directory Clean *******************************************************
 Call ColorSet.cmd Dialog
 Echo  J    = Clean in JobMgrDir...: [%JobMgrRoot_DP%\*.bak;*.tmp;Thumbs.db]
 Echo  T    = Clean Temp Dir
 Echo.
 Echo  Q   = Quit (finish this Dialog)
 set doNextNow=
 set /P doNextNow="please select option: "
 if /I "%doNextNow%" equ "J" Call :DCL_JobMgrDir
 if /I "%doNextNow%" equ "T" CALL "%JobMgrRoot_DP%\03-BinPublic\TempDel.cmd"
 if /I "%doNextNow%" equ "Q" goto :DCL_Exit
 goto :DCL
:DCL_Exit
goto :eof

:DCL_JobMgrDir
 set toRun=del /s "%JobMgrRoot_DP%\*.bak","%JobMgrRoot_DP%\*.tmp","%JobMgrRoot_DP%\Thumbs.db"
 Call ColorSet.cmd IsExecuting
 Echo %toRun%
 %toRun%
goto :eof

rem ============================================================================
:JSE
  rem #New: 10.09.2014/JFes
  set CustomTool_NE=JobManagerStartCustom.cmd
  Echo -------------------------------------------------------------------------
  Echo Edit %CustomTool_NE%
  set CustomToolTemplate_DPNE=%JobMgrRoot_DP%\99-Install\%CustomTool_NE%
  set CustomTool_DPNE=%JobManagerStartCustom_DPNE%
  if not exist "%CustomTool_DPNE%" if exist "%CustomToolTemplate_DPNE%" (
    Echo Info Tool.....: %CustomTool_NE% do not exist
    Echo Create........: New
    Echo from template.: %CustomToolTemplate_DPNE%
    Echo to............: %CustomTool_DPNE%
    copy "%CustomToolTemplate_DPNE%" "%CustomTool_DPNE%"
    pause
  )
  start "" "%EditorEXE%" "%CustomTool_DPNE%"
 goto :eof

rem ============================================================================
:ASE
  rem #New: 10.09.2014/JFes
  set CustomTool_NE=JobManagerAutostartCustom.cmd
  Echo -------------------------------------------------------------------------
  Echo Edit %CustomTool_NE%
  rem 10.09.2014/JFes Edit JobManagerAutostartCustom.cmd
  set CustomToolTemplate_DPNE=%JobMgrRoot_DP%\99-Install\%CustomTool_NE%
  set CustomTool_DPNE=%JobManagerAutostartCustom_DPNE%
  if not exist "%CustomTool_DPNE%" if exist "%CustomToolTemplate_DPNE%" (
    Echo Info Tool.....: %CustomTool_NE% do not exist
    Echo Create........: New
    Echo from template.: %CustomToolTemplate_DPNE%
    Echo to............: %CustomTool_DPNE%
    copy "%CustomToolTemplate_DPNE%" "%CustomTool_DPNE%"
    pause
  )
  start "" "%EditorEXE%" %JobManagerAutostartCustom_DPNE%
goto :eof
rem ............................................................................
:ASA
  Echo -------------------------------------------------------------------------
  if not exist %JobManagerAutostartCustom_DPNE% (
     Echo Autostart: %JobManagerAutostartCustom_DPNE% not exist
     Echo Hint.....: Please Create Autostart first via command 'ASE'
     pause
     goto :eof
  )

  rem --#Doc: remove Legacy Stat Links
  Call :ASR_Legacy

  set toRun=jfShellLinkCreate.exe /Quiet
  set toRun=%toRun% /LinkFile="%JobManagerAutostartCustomLinkFile_DPNE%"
  set toRun=%toRun% /LinkDest="%JobManagerAutostartCustom_DPNE%"
  rem set toRun=%toRun% /WorkDir="%JobManagerAutostartCustom_DP%"
  set toRun=%toRun% /IconFile="%JobMgr_ResIcons_DP%\AutostartJobMgr.ico"
  if not exist "%JobManagerAutostartCustom_DPNE%" goto :next
  %toRun%

  rem #New: 10.12.2014 // J.Fes
  rem #LUp: 10.03.2023 // J.Fes removed
REM   set toRun=jfShellLinkCreate.exe /Quiet
REM   set toRun=%toRun% /LinkFile="%JobManagerToolbarCustomLinkFile_DPNE%"
REM   set toRun=%toRun% /LinkDest="%JobManagerAutostartCustom_DPNE%"
REM   set toRun=%toRun% /Arguments="/DefaultRunNo"
REM   rem set toRun=%toRun% /WorkDir="%JobManagerToolbarCustomLinkFile_DP%"
REM   set toRun=%toRun% /IconFile="%JobMgr_ResIcons_DP%\AutostartJobMgr.ico"
REM   %toRun%

:next
  Echo.
  Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
  Echo JobManagerV3: Autostart
  Echo Link........: %JobManagerToolbarCustomLinkFile_DPNE%
  Echo Link........: %JobManagerAutostartCustomLinkFile_DPNE%
  Echo Starts......: %JobManagerAutostartCustom_DPNE%
 if exist "%JobManagerAutostartCustomLinkFile_DPNE%" (
  Echo Status......: succsessfull added
  Start "" Explorer "%JobManagerAutostartCustomLinkFile_DP%"
 ) else (
  Echo Status......: ERROR NOT added
 )
 pause
goto :eof

:ASR
  Call :ASR_Legacy
  if exist "%JobManagerAutostartCustomLinkFile_DPNE%" del "%JobManagerAutostartCustomLinkFile_DPNE%"
:next
   Echo.
   Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
   Echo JobManagerV3: Autostart
   Echo Link........: %JobManagerAutostartCustomLinkFile_DPNE%
   Echo Starts......: %JobManagerAutostartCustom_DPNE%
  if exist "%JobManagerAutostartCustomLinkFile_DPNE%" (
   Echo Status......: ERROR not removed
   Start "" Explorer "%JobManagerAutostartCustomLinkFile_DP%"
  ) else (
   Echo Status......: Removed successfully
  )
  pause
goto :eof



:ARF
  Start "" Explorer "%JobMgrRoot_DP%"
goto :eof

:ASO
  Start "" Explorer "%JobManagerAutostartCustomLinkFile_DP%"
goto :eof

:ASR_Legacy
  rem -- #New 10.03.2023/J.Fes removes legacy Autostart Icons
  if exist "%JobManagerAutostartCustomLinkRemove_DPNE%" (
   Echo Dele Legacy.: Links: %JobManagerAutostartCustomLinkRemove_DPNE%
   del "%JobManagerAutostartCustomLinkRemove_DPNE%"
  )
goto :eof

rem ============================================================================
:JDE
  rem #New: 04.11.2014/JFes
  set CustomTool_NE=JobManagerDeploy.cmd
  Echo -------------------------------------------------------------------------
  Echo Edit %CustomTool_NE%
  set CustomToolTemplate_DPNE=%JobMgrRoot_DP%\99-Install\%CustomTool_NE%
  set CustomTool_DPNE=%JobManagerDeployCustom_DPNE%
  if not exist "%CustomTool_DPNE%" if exist "%CustomToolTemplate_DPNE%" (
    Echo Info Tool.....: %CustomTool_NE% do not exist
    Echo Create........: New
    Echo from template.: %CustomToolTemplate_DPNE%
    Echo to............: %CustomTool_DPNE%
    copy "%CustomToolTemplate_DPNE%" "%CustomTool_DPNE%"
    pause
  )
  start "" "%EditorEXE%" "%CustomTool_DPNE%"
goto :eof

:JDR
  rem #New: 04.11.2014/JFes
  set CustomTool_NE=JobManagerDeploy.cmd
  Echo -------------------------------------------------------------------------
  Echo Run %CustomTool_NE%
  rem 10.09.2014/JFes Edit JobManagerAutostartCustom.cmd
  set CustomTool_DPNE=%JobManagerDeployCustom_DPNE%
  if exist "%CustomTool_DPNE%" (
    Call ColorSet.cmd IsExecuting
    Echo Tool Run.....: %CustomTool_NE%
    Echo File ........: %JobManagerDeployCustom_DPNE%
    Call "%CustomTool_DPNE%"
    pause
  ) else (
    Call ColorSet.cmd ERR
    Echo Tool ERROR...: %CustomTool_NE%
    Echo File ........: %JobManagerDeployCustom_DPNE%
    Echo not exist please use bevor JDE
    pause
  )

goto :eof




rem ============================================================================
:NxDebug_UGII_CHECKING_LEVEL
 rem set unset NxDebug Var's
 goto %~1

:ON
 call :setX_U "UGII_CHECKING_LEVEL" "1"
 goto :NxDebug_end

:OFF
 call :setX_U "UGII_CHECKING_LEVEL" ""
 goto :NxDebug_end

:NxDebug_end
goto :eof
rem ============================================================================
:TC_TCDef
 rem #New 13.12.2017/J.Fes
 goto %~1

:ON
 set TC_TMP_DIR=C:\tmp\TCtmp
 if not exist "%TC_TMP_DIR%" md "%TC_TMP_DIR%"
 if exist "%TC_TMP_DIR%" goto :next
 rem Try2
 set TC_TMP_DIR=C:\%temp%\TCtmp
 if not exist "%TC_TMP_DIR%" md "%TC_TMP_DIR%"

:next

 call :setX_U "WhereReferencePOMPref" "1"
 call :setX_U "TC_TMP_DIR" "%TC_TMP_DIR%"
 call :setX_U "TC_KEEP_SYSTEM_LOG" "true"
 goto :NxDebug_end

:OFF
 call :setX_U "WhereReferencePOMPref" ""
 goto :NxDebug_end

:NxDebug_end
goto :eof
rem ============================================================================
:TcDebug_TC_SQL_DEBUG
 rem set unset TCDebug Var's
 goto %~1

:ON
 call :setX_U "TC_SQL_DEBUG" "BJTP"
 goto :NxDebug_end

:OFF
 call :setX_U "TC_SQL_DEBUG" ""
 goto :NxDebug_end

:NxDebug_end
goto :eof
rem ============================================================================
:NxDebug_UGII_DISPLAY_DEBUG
 rem set unset NxDebug Var's
 REM #New 09.02.2017/J.Fes add UGII_DISPLAY_DEBUG
 goto %~1

:ON
 call :setX_U "UGII_DISPLAY_DEBUG" "1"
 goto :NxDebug_end

:OFF
 call :setX_U "UGII_DISPLAY_DEBUG" ""
 goto :NxDebug_end

:NxDebug_end
goto :eof


rem ============================================================================
:NX_Conf_Rule
 rem set TC config rule
 goto %~1

:ON
 set /P TC_config_rule_name="please enter Name for TC_config_rule_name="
 call :setX_U "TC_config_rule_name" "%TC_config_rule_name%"
 goto :End

:OFF
 set TC_config_rule_name=
 call :setX_U "TC_config_rule_name" ""
 goto :End

:End
goto :eof

rem ============================================================================
:SUP
 rem set /P TC_config_rule_name="please enter Name for TC_config_rule_name="
 call :setX_U "UGII_USER_PROFILE_DIR" "%UGII_USER_PROFILE_DIR_addPLM%"

 if not exist "%UGII_USER_PROFILE_DIR%" (
   Echo Create UGII_USER_PROFILE_DIR....: %UGII_USER_PROFILE_DIR%
   Echo Create from template............: %UGII_USER_PROFILE_DIR_addPLMtemplate%
   Call robocopy "%UGII_USER_PROFILE_DIR_addPLMtemplate%" "%UGII_USER_PROFILE_DIR%" /xf *.tmp ~*.* *.bak /NP /TBD /TEE /R:4 /W:1 /MIR
 )
   Call ColorSet.cmd OK

   Echo.
   Echo !! ---------------------------------------------------------------- !!
   Echo After set UGII_USER_PROFILE_DIR.: on this Computer:\\%ComputerName%
   Echo Hint............................: you may need to restart TC/NX
   Echo !! ---------------------------------------------------------------- !!
   pause
 goto :eof
rem ============================================================================
:setX_U
 if "%~2" neq "" (
   Echo Define User Enviromnent Variable: %~1=%~2
   set %~1=%~2
 ) else (
   Echo Undefine User Enviromnent Variable: %~1
   set %~1=%~2
 )
 call setx.exe %~1 "%~2"

 goto :eof


rem ============================================================================
:SetNXTcEnvVariables
 CALL ColorSet.cmd Standard
 Echo.
 Echo --------------------------------------------------------------------------
 Echo  NX Debug
 Echo --------------------------------------------------------------------------
 Echo  DON  = NX Debug UGII_CHECKING_LEVEL ON  VALUE:[%UGII_CHECKING_LEVEL%]
 Echo  DOF  = NX Debug UGII_CHECKING_LEVEL OFF
 Echo.
 Echo  DDON = NX Debug UGII_DISPLAY_DEBUG ON   VALUE:[%UGII_DISPLAY_DEBUG%]
 Echo  DDOF = NX Debug UGII_DISPLAY_DEBUG OFF
 Echo.
 Echo  TCON = TC_config_rule_name defines for NX whitch TC config Rule is to be used
 Echo  TCOF = TC_config_rule_name undefine
 Echo.
 Echo  TCSQLDBON = SQL Debug = ON  (set TC_SQL_DEBUG=BJTP) VALUE:[%TC_SQL_DEBUG%]
 Echo  TCSQLDBOF = SQL Debug = OFF
 Echo.
 Echo  TCDEF= set TC def TC_TMP_DIR:[%TC_TMP_DIR%]
 Echo         WhereReferencePOMPref:[%WhereReferencePOMPref%]
 Echo.
 Echo  SUP  = set for addPLM NX User dir UGII_USER_PROFILE_DIR_addPLM
 Echo                 ^|-^> to Dir:[%UGII_USER_PROFILE_DIR_addPLM%]
 Echo.
 Echo  Q   = Quit (finish this Dialog)
 Echo.
 set doNext=
 set /P doNext="please select option: "


 if /I "%doNext%" equ "Q"     goto :eof
 if /I "%doNext%" equ "DON"   set doNext=Nx_Debug_ON
 if /I "%doNext%" equ "DOF"   set doNext=Nx_Debug_OFF
 if /I "%doNext%" equ "DDON"  set doNext=Nx_DebugDisplay_ON
 if /I "%doNext%" equ "DDOF"  set doNext=Nx_DebugDisplay_OFF

 if /I "%doNext%" equ "TCON"  set doNext=NX_Conf_Rule_ON
 if /I "%doNext%" equ "TCOF"  set doNext=NX_Conf_Rule_OF
 if /I "%doNext%" equ "TCSQLDBON" set doNext=TC_SQLDebug_ON
 if /I "%doNext%" equ "TCSQLDBOF" set doNext=TC_SQLDebug_OF
 if /I "%doNext%" equ "TCDEF" set doNext=TC_TCDef_ON



 rem run it now
 call :doNextExec

 goto :SetNXTcEnvVariables
goto :eof



rem ============================================================================
:DirOrg
 rem Get Appl Version infos
 Call "%CmdCurRoot_DP%\..\01-BinServer\ApplicationInfo.cmd" GetVerInfo

 rem Organiesiert die Verzeichnisse Neu 05.04.2012 10:45
 set ProgramFilesLocal=%ProgramFiles%
 if defined ProgramFiles(x86) set ProgramFilesLocal=%ProgramFiles(x86)%

 set MyApplBase_TP=JobManagerV3
 set MyApplProd_N=PLMJobManagerV3
 set MyApplProd_NShort=JMgrV3


 rem --------- Allgemeine Variablen
 set PsPadEXE=%CmdCurRoot_DP%\..\03-BinPublic\PSPad editor\PSPad.exe
 set EditorEXE=%PsPadEXE%

 set JobManager_WhatsNew_txt_DPNE=%CmdCurRoot_DP%\..\01-BinServer\Resources\Documents\JobManager_WhatsNew.txt
 set BinPublic_Custom_DP=%JobMgrRoot_DP%\03-BinPublic.Custom

 set JobManagerAutostartCustom_DPNE=%BinPublic_Custom_DP%\JobManagerAutostartCustom.cmd
 set JobManagerAutostartCustomLinkFile_DP=%APPDATA%\Microsoft\Windows\Start Menu\Programs\Startup
 set JobManagerAutostartCustomLinkFile_DPNE=%JobManagerAutostartCustomLinkFile_DP%\99-JobManagerV3 (AutoStart).lnk

 set JobManagerAutostartCustomLinkRemove_DPNE=%JobManagerAutostartCustomLinkFile_DP%\*JobManagerV3_AutoStart*.lnk

REM  rem 10.03.2023/J.Fes now copy to JobMgr root dir
REM Removed
REM  set JobManagerToolbarCustomLinkFile_DP=%JobMgrRoot_DP%\_JobManagerV3\95-ToolsCustom
REM  set JobManagerToolbarCustomLinkFile_DP=%JobMgrRoot_DP%\_JobManagerV3
REM  set JobManagerToolbarCustomLinkFile_DPNE=%JobManagerToolbarCustomLinkFile_DP%\99-JobManagerV3 (AutoStart).lnk


 set JobManagerStartCustom_DPNE=%BinPublic_Custom_DP%\JobManagerStartCustom.cmd
 set JobManagerDeployCustom_DPNE=%BinPublic_Custom_DP%\JobManagerDeploy.cmd
 set UGII_USER_PROFILE_DIR_addPLM=%BinPublic_Custom_DP%\NX_Custom\addPLM.User.Profile
 set UGII_USER_PROFILE_DIR_addPLMtemplate=%CmdCurRoot_DP%\NxTcSettings\UGII_USER_PROFILE_DIR

goto :eof


rem ##### ------------ Standard Subroutines --------------------- ######
:EditMe
 set toRun=start "Edit Me" "%PsPadEXE%" "%1.ppr"
 Echo.
 Echo --------------------------------------------------------------------------
 Echo Start bearbeiten CMD
 echo via: %toRun%
 %toRun%
 goto :eof


rem ============================================================================
:PathCutLastDir
 rem schneidet das letzte Verzeichniss Uebergeben path ab
 rem P1 = Name der Variablen
 rem P2 = der bergebene Path
 rem Example : call :PathCutLastDir JobMgrRoot_DP %~dp0
 rem Example : call :PathCutLastDir MyVar %~dp0

 set PathCutLastDir$temp=%~2
 set PathCutLastDir$tempLastChar=%PathCutLastDir$temp:~-1%
 set PathCutLastDir$tempNoBacks=%PathCutLastDir$temp:~0,-1%

 if "%PathCutLastDir$tempLastChar%" equ "\" (
   rem "\" abschneiden wenn vorhanden
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$tempNoBacks%
 ) else (
   rem
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$temp%
 )
 set PathCutLastDir$tempRes=%PathCutLastDir$tempRes:~0,-1%
 set %1=%PathCutLastDir$tempRes%
 set PathCutLastDir$temp=
 set PathCutLastDirDo$temp1=
 set PathCutLastDir$tempNoBacks=
 set PathCutLastDir$tempNoLastChar=
 set PathCutLastDir$tempLastChar=
 set PathCutLastDir$tempRes=
 goto :eof

:PathCutLastDirDo
 rem hiermit schneiden wir den Path ab
 rem echo.
 rem Echo P1=%1 P2=%2
 set PathCutLastDirDo$temp=%~dp2
 rem "\" abschneiden
 set PathCutLastDirDo$temp1=%PathCutLastDir$temp:~0,-1%
 set %1=%PathCutLastDirDo$temp%
 set PathCutLastDirDo$temp=
 set PathCutLastDirDo$temp1=
 goto :eof

:DateTimeNowGet
 if     "%time:~0,1%" equ " " set time-h=0%time:~1,1%
 if not "%time:~0,1%" equ " " set time-h=%time:~0,2%

 if     "%time:~3,1%" equ " " set time-m=0%time:~4,1%
 if not "%time:~3,1%" equ " " set time-m=%time:~3,2%

 set Date-Y=%Date:~6,4%
 set Date-M=%Date:~3,2%
 set Date-D=%Date:~0,2%
 set DateTimeNowFileExt=%Date-Y%-%Date-M%-%Date-D%-%time-h%-%time-m%
 goto :eof

