@echo off

rem Doku:
rem Organizes Start of Application PLMJobManger
rem JobServer and JobClient Computers can be startet via this script
rem #New:10.09.2014/J.Fes First Version
rem #LUp:11.11.2014/J.Fes default Start Times reduced
rem #LUp:10.12.2014/J.Fes Optimised
rem #LUp:08.02.2017/J.Fes add Usage ProgStart_If_NotRuning.cmd
rem #LUp:17.03.2023/J.Fes modify :JobServer_Start1 + Setup Base Dirs
rem #LUp:28.11.2023/J.Fes modify :JobServer_Start1 + Setup Base Dirs
rem #LUp:28.12.2023/J.Fes modify :CleanServerSysLog
REM #LUp:13.02.2024/J.Fes add /TaskInst for TaskSheduler
REM #LUp:21.06.2024/J.Fes update /Start [I1+2:%PLMSettingInterakt1%]

 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 set ProgKill_log_DP=%CmdCurRoot_DP%\_LogFiles
 if not exist "%ProgKill_log_DP%" md "%ProgKill_log_DP%"
 set ProgKill_log_DPNE=%ProgKill_log_DP%\AutoStartKillPros_Log.txt

 REM #Doc: run JobManagerStartCustom.cmd to get JobMgr_RootL_DP
 if exist "%CmdCurRoot_DP%\JobManagerStartCustom.cmd" call "%CmdCurRoot_DP%\JobManagerStartCustom.cmd"

 REM #Doc: In case of maintain JobMgr please use:
 REM  Call :PLMJobManagerIsInMaintance "10.12.2014 11:00"  "10.12.2014 14:00" "PLMJobMnager Update 01"  "If having Questions please call #Number#" "or send mail to support@addPLM.com"

 REM #ToDo: Setup CustomName
 set CustomNameShort=#CustomNameShort#
 REM #ToDo: Setup UNC Path to PLMShare
 set CmdCurRootDefault_UNC_DP=\\CustomServer\PLMShare\JobManagerV3
 REM #ToDo: Setup Custom_WorkInst
 set Custom_WorkInst=#CustomNameShort#_WorkInst_TestSystem

 REM -- #Doc: 17.03.2023/J.Fes Setup Base Dirs
 call "%CmdCurRoot_DP%\..\03-BinPublic\Parse_Absolut_DP.cmd" BinPublic_DP "%CmdCurRoot_DP%\..\03-BinPublic\"
 call "%BinPublic_DP%\Parse_Absolut_DP.cmd" BinServer_DP "%CmdCurRoot_DP%\..\01-BinServer\"
 call "%BinPublic_DP%\Parse_Absolut_DP.cmd" BinClient_DP "%CmdCurRoot_DP%\..\02-BinClient\"

 call "%BinPublic_DP%\ColorSet.cmd" Reset

 rem #New: 10.11.2022/J.Fes
 if /I "%~1" neq "" set DoCleanDirs=%~1
 if /I "%DoCleanDirs%" equ "CleanDir" (
   Call :JobMgrCleanLocal
   Exit /B
 )

 Echo --------------------------------------------------------------------------
 Set MyTitle=PLMJobManager AutoStart \\%ComputerName% [%Date% %Time%]
 title %MyTitle%
 Echo %MyTitle%

 rem New 10-12-2014 10:08/J.Fes
 call "%BinPublic_DP%\ColorSet.cmd" Dialog
 Echo --------------------------------------------------------------------------
 Echo  S   = Run AutoStart (default)
 Echo  Q   = QUIT / Exit  AutoStart will not be performed
 Echo.
 if /I "%~1" equ "/DefaultRunNo" call "%BinPublic_DP%\wait_for_key.cmd" "10" "Q" "S" DoNext
 if /I "%~1" neq "/DefaultRunNo" call "%BinPublic_DP%\wait_for_key.cmd" "10" "S" "Q" DoNext

 rem set /P DoNext= if using other keys (inc.Return) no AutoStart will be done:
 if /I "%DoNext%" equ "S" goto :Next
  call "%BinPublic_DP%\ColorSet.cmd" ERR
  Echo AutoStart not performed
  Pause
 goto :eof



:Next
 call "%BinPublic_DP%\ColorSet.cmd" IsExecuting
 call "%BinPublic_DP%\DesktopRefresh.exe"


 REM #ToDo: Set Base Settings TestSystem or ProdSystem
 set PLMSettingJobContr1=/ServerSettingsXML TestSystem /WorkInstTitel 10-JC /TCPPort 13000
 set PLMSettingTaskShed1=/ServerSettingsXML TestSystem /WorkInstTitel 11-TS /TCPPort 13001
 set PLMSettingInterakt1=/ServerSettingsXML TestSystem /WorkInstTitel 12-Int1 /TCPPort 13002
 set PLMSettingInterakt2=/ServerSettingsXML TestSystem /WorkInstTitel 13-Int2 /TCPPort 13002


 REM #ToDo: Set JobServer start
 if /I "%ComputerName%" equ "#JobServerN#" (
  rem #Doc: set P1=Root Dir to clean Up // P2=Days to Clean // P3 = CleanMode 'CleanTest' -or- 'CleanDo'
  call :CleanServerSysLog "%CmdCurRootDefault_UNC_DP%\90-DATA\%Custom_WorkInst%\11-ServerSysLog" "90" "CleanTest"
  call :JobServer_Start1
  exit /B
 )

 REM #ToDo: Set JobClient start for Site 1
 if /I "%ComputerName:~0,5%" equ "SITE1" call :JobClient_Start1

 REM #ToDo: Set JobClient start for Site 2
 if /I "%ComputerName:~0,5%" equ "SITE2" call :JobClient_Start2
 exit /B
goto :eof

rem ============================================================================
:JobClient_Stop
  rem 07.05.2012 15:24 J.Fes Stopt alle JobClient Processe
  call :Wait "%~1" "Step:[%StepCur%\%StepsN%] Stop JobClient Progs:[JobClient]"
  Call "%BinPublic_DP%\ProgKill.cmd" JobClient "%ProgKill_log_DPNE%" "10"
  Call "%BinPublic_DP%\ProgKill.cmd" PLMJobManagerWatchDog "%ProgKill_log_DPNE%" "1"

  Call "%BinPublic_DP%\ProgKill.cmd" JfProcessMonitor      "%ProgKill_log_DPNE%" "3"
  Call "%BinPublic_DP%\ProgKill.cmd" PLMJobManagerWatchDog "%ProgKill_log_DPNE%" "2"
  call :CleanDirs
goto :eof

rem ============================================================================
:JobServer_Stop
  call :Wait "%~1" "Step:[%StepCur%\%StepsN%] Stop JobServer Progs:[JobClient,JobServer]"
  Call "%BinPublic_DP%\ProgKill.cmd" JobClient "%ProgKill_log_DPNE%" "10"
  Call "%BinPublic_DP%\ProgKill.cmd" JobServer "%ProgKill_log_DPNE%" "20"
  Call "%BinPublic_DP%\ProgKill.cmd" PLMJobManagerWatchDog "%ProgKill_log_DPNE%" "3"

  Call "%BinPublic_DP%\ProgKill.cmd" JfProcessMonitor      "%ProgKill_log_DPNE%" "3"
  Call "%BinPublic_DP%\ProgKill.cmd" PLMJobManagerWatchDog "%ProgKill_log_DPNE%" "2"
  call :CleanDirs
 goto :eof
rem ============================================================================
:CleanDirs
  if exist "%temp%" call :DelDir "%temp%"
  rem if exist "C:\TEMP" call :DelDir "C:\TEMP"
  if defined JobMgr_RootL_DP if exist "%JobMgr_RootL_DP%" call :DelDir "%JobMgr_RootL_DP%"
 goto :eof

rem ============================================================================
:JobClient_Start1
 setlocal

  set StepsN=2
  set StepCur=0

  REM -- Stop JobClient --------------------------------------------------------
  set /A StepCur=%StepCur% + 1
  call :JobClient_Stop 2

  REM -- Start caffeine --------------------------------------------------------
REM   set /A StepCur=%StepCur% + 1
REM   call :Wait 0 "Step:[%StepCur%\%StepsN%] CheckIf [Caffeine is running]"
REM   call "%BinPublic_DP%\ProgStart_If_NotRuning.cmd" "caffeine" "%BinPublic_DP%\caffeine.exe"

  REM -- Start JobClient -------------------------------------------------------
  set /A StepCur=%StepCur% + 1
  set toRun="%BinClient_DP%\JobManagerStart.cmd" /JobClient %PLMSettingJobContr1% /JobClientStartMode Pause
  call :Wait 10 "Step:[%StepCur%\%StepsN%] Start [JobClient]"
  call %toRun%

 endlocal
goto :eof
rem ============================================================================
:JobClient_Start2
 setlocal

  set StepsN=3
  set StepCur=0

  REM -- Stop JobClient --------------------------------------------------------
  set /A StepCur=%StepCur% + 1
  call :JobClient_Stop 2

  REM -- Start caffeine --------------------------------------------------------
  set /A StepCur=%StepCur% + 1
  if exist "%BinPublic_DP%\caffeine.exe" start "Caffeine" "%BinPublic_DP%\caffeine.exe"

  REM -- Start JobClient -------------------------------------------------------
  set /A StepCur=%StepCur% + 1
  set toRun="%BinClient_DP%\JobManagerStart.cmd" /JobClient %PLMSettingJobContr1% /JobClientStartMode Pause
  call :Wait 10 "Step:[%StepCur%\%StepsN%] Start [JobClient]"
  call %toRun%

 endlocal
goto :eof



rem ============================================================================
:JobServer_Start1

  REM #Doc: Start JobServer
  REM #LUp: 09.03.2023/J.Fes add /TabsVisible /DefaultTab
  REM #LUp: 28.11.2023/J.Fes add Optimice JobServer Start Order
  REM #LUp: 13.02.2024/J.Fes add /TaskInst
  REM #LUp: 21.06.2024/J.Fes update /Start [I1+2:%PLMSettingInterakt1%]

  Echo.
  Echo AutoStart PLMJobManager JobServer:\\%ComputerName%

  set StepsN=5
  set StepCur=0

  REM -- Stop JobServer -----------
  set /A StepCur=%StepCur% + 1
  call :JobServer_Stop 3

REM   REM -- Start caffeine -------
REM   set /A StepCur=%StepCur% + 1
REM   call :Wait 0 "Step:[%StepCur%\%StepsN%] CheckIf [Caffeine is running]"
REM   call "%BinPublic_DP%\ProgStart_If_NotRuning.cmd" "caffeine" "%BinPublic_DP%\caffeine.exe"

  REM -- Start JobServer for Service:JobControl   /AutoStart "JobControl:A TaskScheduler:On"
  set toRun=call "%BinServer_DP%\JobManagerStart.cmd" /JobServer %PLMSettingJobContr1% /AutoStart JobControl:A /TabsVisible "JobControl+Scripts+ProcessGroups+Sites" /DefaultTab "JobControl"
  set /A StepCur=%StepCur% + 1
  call :Wait 5 "Step:[%StepCur%\%StepsN%] Start [JobControl:%PLMSettingJobContr1%]"
  call %toRun%

  REM -- Start JobServer for Service:TaskScheduler" check if use /TaskInst "TCSync;DBMaintain" is required
  set toRun=call "%BinServer_DP%\JobManagerStart.cmd" /JobServer %PLMSettingTaskShed1% /AutoStart TaskScheduler:On  /TabsVisible "TaskScheduler" /DefaultTab "TaskScheduler"
  set /A StepCur=%StepCur% + 1
  call :Wait 5 "Step:[%StepCur%\%StepsN%] Start [TaskScheduler]"
  call %toRun%

  REM -- Start JobServer for Interaktiv usage:PLMSite1
  set toRun=call "%BinServer_DP%\JobManagerStart.cmd" /JobServer %PLMSettingInterakt1% /TabsVisible "JobControl+ObjectList+Reports" /DefaultTab "ObjectList"
  set /A StepCur=%StepCur% + 1
  call :Wait 5 "Step:[%StepCur%\%StepsN%] Start [I1:%PLMSettingInterakt1%]"
  call %toRun%

  set toRun=call "%BinServer_DP%\JobManagerStart.cmd" /JobServer %PLMSettingInterakt2% /TabsVisible "JobControl+ObjectList+Reports" /DefaultTab "ObjectList"
  set /A StepCur=%StepCur% + 1
  call :Wait 5 "Step:[%StepCur%\%StepsN%] Start [I2:%PLMSettingInterakt2%]"
  call %toRun%

rem Optional
REM   set /A StepCur=%StepCur% + 1
REM   call :Wait 5 "Step:[%StepCur%\%StepsN%] Start [PLMPerf]"
REM   setlocal
REM     set JobMgr_Root_DP=
REM     start "PLMPerf" "\\#CustomPlmServer#\#plmshare#\PLMPerfV3\01-PLMPerf\JobManagerStart.cmd" /PLMPerf -admin -Config #CustomKey# -ConfigTabsLeft
REM   endlocal

goto :eof

rem ============================================================================
:CleanServerSysLog
 rem -- #New: 02.02.2011 J.Fes
 rem -- #LUp: 28.12.2023 J.Fes add Parameter P2 + P3

 rem P1=RootDir WorkInst
 rem P2=Delete by Date oder then n days #Exa: 10,20,24
 rem P3=CleanMode 'CleanTest' -or- 'CleanDo'

 setlocal
  set CleanDir=%~1
  set DelDateOlderThen=%~2
  set CleanMode=%~3

  if "%~3" equ "" goto :eof

  set CleanMode_opt=/modified /recurse /rd /includeRHS
  rem -- #Doc: Option: /preview = List Only DoNot delete Data
  if /I "%CleanMode%" neq "CleanDo" set CleanMode_opt=%CleanMode_opt% /preview

  call "%BinPublic_DP%\ColorSet.cmd" IsExecuting
  Echo --------------------------------------------------------------------------
  Echo CleanUp Dir.....................: %CleanDir%
  Echo older...........................: %DelDateOlderThen% (n) Days
  Echo CleanUp options.................: %CleanMode_opt%
  Echo --------------------------------------------------------------------------

  set toRun="%BinPublic_DP%\delage32.exe" "%CleanDir%\*.log" %DelDateOlderThen% %CleanMode_opt%

  if /I "%CleanMode%" neq "CleanDo" (
   call "%BinPublic_DP%\ColorSet.cmd" WRN
   Echo CleanUp Action info.............: CleanUpDo is not active NO files will be deleted.
   Call %toRun%
   pause
  ) else (
   call "%BinPublic_DP%\ColorSet.cmd" IsExecuting
   Echo CleanUp Action info.............: CleanUpDo is active files older then '%DelDateOlderThen%' will be deleted
   Call %toRun%
  )
  Echo --------------------------------------------------------------------------
 endlocal
goto :eof

rem ================================================================================--
:JobMgrCleanLocal
  rem #New: 10.11.2022/J.Fes
  set StepsN=3
  set StepCur=0

  Echo ----------------------------------------------------------------------------
  Call "%BinPublic_DP%\Banner" Clean:Start
  call :Wait "3" "Clean:Start '%JobMgr_RootL_DP%\..'"

  rem -- Stop JobClient --------------------------------------------------------
  set /A StepCur=%StepCur% + 1
  call :Wait "3" "Step:[%StepCur%\%StepsN%] Stop JobMgr Processes"

  rem taskkill /FI "WINDOWTITLE eq Windows Title Name*" 1>nul 2>nul
  Call "%BinPublic_DP%\ProgKill.cmd" ServerManager         "%ProgKill_log_DPNE%" "3"
  Call "%BinPublic_DP%\ProgKill.cmd" JobClient             "%ProgKill_log_DPNE%" "3"
  Call "%BinPublic_DP%\ProgKill.cmd" JobServer             "%ProgKill_log_DPNE%" "5"
  Call "%BinPublic_DP%\ProgKill.cmd" JfProcessMonitor      "%ProgKill_log_DPNE%" "3"
  Call "%BinPublic_DP%\ProgKill.cmd" PLMJobManagerWatchDog "%ProgKill_log_DPNE%" "2"

  set /A StepCur=%StepCur% + 1
  call :Wait "3" "Step:[%StepCur%\%StepsN%] Clean:'%JobMgr_RootL_DP%\..'"
  Call :DelDir "%JobMgr_RootL_DP%"

  Echo ----------------------------------------------------------------------------
  Call "%BinPublic_DP%\Banner" Clean:END
  call :Wait "3" "Clean:End '%JobMgr_RootL_DP%\..'"
  Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
  Echo JobManager clean local..........: DONE
  Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
  Echo After press any key this script ends. Then please start JobMgr application.
  pause

 goto :eof
rem ================================================================================--
:DelDir
 setlocal
  rem #LUp 10.11.2022/J.Fes
  rem #Exa: call :DelDir "%temp%"
  set Dir_to_Clean_DP=%~1
  Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
  Echo Cleaning Directory..............: '%Dir_to_Clean_DP%'
   if not exist "%Dir_to_Clean_DP%" goto :DelDirNo

   REM Delete all files (recursive) in %Dir_to_Clean_DP%
   Echo Cleaning Directory..............: Dir exist now clean dir
   del /s /q "%Dir_to_Clean_DP%"
   REM Determine the items left and try to delete any subdirs
   for /f "delims=#" %%i in ('dir /a:d /b %Dir_to_Clean_DP%') do rd /s /q %Dir_to_Clean_DP%\"%%i"
   rd /s /q "%Dir_to_Clean_DP%"
   rem 1>NUL 2>NUL
  goto :MyEnd

  :DelDirNo
    Echo Cleaning Directory..............: Dir not exist nothing is todo
   goto :MyEnd

  :MyEnd
  Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 endlocal
goto :eof
rem ============================================================================


rem ============================================================================
rem ##### ------------ Standard Subroutines --------------------- ######
rem ============================================================================
:Wait
 rem #LUp: 10.11.2022/J.Fes
 setlocal
 set WaitTime=2
 if "%~1" neq "" set WaitTime=%~1
 if "%~2" equ "" goto :JumbOverPrintInfo
 Echo --------------------------------------------------------------------------
 Echo %~2 -//- (%Date% %time:~0,8%)
 :JumbOverPrintInfo
 Echo  Wait: %WaitTime% [sec] // or:Press 'any key' to continue
 timeout /T %WaitTime% 1>NUL 2>NUL
 endlocal
goto :eof

rem ============================================================================
:PLMJobManagerIsInMaintance
 call "%BinPublic_DP%\ColorSet.cmd" ERR
 Echo --------------------------------------------------------------------------
 Echo PLMJobManager AutoStart not exscuted Maintance is activ
 Echo --------------------------------------------------------------------------
 if "%~3" neq "" Echo Reason..: %~3
 if "%~4" neq "" Echo Info....: %~4
 if "%~5" neq "" Echo Info....: %~5
 Echo.
 Echo Started.: %~1
 Echo Ends at~: %~2
 Echo.
 Echo If you have any questions please contact your Admin.
 Echo.
 Echo  !! -- AutoStart will not be executed -- !!
 Echo.
 pause
 exit
 goto :eof

