@Echo off
rem -----------------------------------------------------------------------------------------
rem Description: copy JobMgr Application Icons from:JobMgr_ResIcons_S_DP to:JobMgr_ResIcons_L_DP
rem #New: 24.03.2021/J.Fes
rem #LUp: 05.08.2022/J.Fes add ropcopy parameter /A-:R removes write protection in target
rem #LUp: 10.03.2023/J.Fes add JobMgr_ResIcons_DP
rem #LUp: 10.03.2023/J.Fes add if not exist "%temp%" md "%temp%"
rem
rem #Doc: Optionsparameter: Result ENV:JobMgr_ResIcons_DP points to used JobMgr Icons

setlocal
 REM -- #LUp:09.10.2025/J.Fes
 if not exist "%temp%" md "%temp%"
 if not exist "%tmp%" md "%tmp%"

 set CmdCurRoot$DP=%~dp0
 set CmdCurRoot$DP=%CmdCurRoot$DP:~0,-1%
 set path=%CmdCurRoot$DP%;%path%
 set JobMgr_EchoLog_DPNE=.
 set P1_DoInit=%~1
 set P2_WaitAtEnd_Sec=100
 if "%~2" neq "" set P2_WaitAtEnd_Sec=%~2

 REM -- #Doc:07.05.2025/J.Fes org Icons local
 set JobMgr_ResIcons_L_DP=%ProgramData%\JobManager_V3\Icons
 set JobMgr_ResIcons_S_DP=%CmdCurRoot$DP%\Icons
 Call robocopy "%JobMgr_ResIcons_S_DP%" "%JobMgr_ResIcons_L_DP%" /A-:R /r:3 /w:1 /TBD /NP /NJH /NJS /NDL 1>nul 2>>nul

 Call "%CmdCurRoot$DP%\Parse_Absolut_DP.cmd" BinPublic_S_DP "%CmdCurRoot$DP%\..\03-BinPublic\"
                                         set BinPublic_L_DP=%ProgramData%\JobManager_V3\03-BinPublic
 set BinPublicVer_N=03-BinPublicVer.cmd
 set BinPublicVer_S_DPNE=%BinPublic_S_DP%\%BinPublicVer_N%
 set BinPublicVer_L_DPNE=%BinPublic_L_DP%\%BinPublicVer_N%

 call :GetVer "%BinPublicVer_S_DPNE%" BinPublicVer_S
 call :GetVer "%BinPublicVer_L_DPNE%" BinPublicVer_L
REM  Call "%CmdCurRoot$DP%\Echo2.cmd" "BinPublicVer_S_DPNE" "%BinPublicVer_S_DPNE%"
REM  Call "%CmdCurRoot$DP%\Echo2.cmd" "BinPublicVer_L_DPNE" "%BinPublicVer_L_DPNE%"
REM  Call "%CmdCurRoot$DP%\Echo2.cmd" "BinPublicVer_S" "%BinPublicVer_S%"
REM  Call "%CmdCurRoot$DP%\Echo2.cmd" "BinPublicVer_L" "%BinPublicVer_L%"
 rem set P1_DoInit=INIT
 if /I "%P1_DoInit%" equ "INIT" if defined BinPublic_S_DP if defined BinPublic_L_DP goto :DoCopyYes
 if /I "%BinPublicVer_S%" equ "UNK" goto :DoCopyNo
 if /I "%BinPublicVer_S%" equ "%BinPublicVer_L%" goto :DoCopyNo

:DoCopyYes
 if /I "%P1_DoInit%" equ "INIT" call :InitInfo
 Call :DoCopyBinPubliclocal
 if /I "%P1_DoInit%" equ "INIT" call :InitInfoDone

:DoCopyNo
 rem #Doc: define BinPublic_DP via SetEnvFirstFound
 Call "%CmdCurRoot$DP%\SetEnvFirstFound.cmd" BinPublic_DP "%BinPublic_L_DP%" "%BinPublic_S_DP%"

endlocal& set JobMgr_ResIcons_S_DP=%JobMgr_ResIcons_S_DP%&set JobMgr_ResIcons_L_DP=%JobMgr_ResIcons_L_DP%&set BinPublic_DP=%BinPublic_DP%&set BinPublic_S_DP=%BinPublic_S_DP%&set BinPublic_L_DP=%BinPublic_L_DP%

 set JobMgr_ResIcons_DP=%JobMgr_ResIcons_S_DP%
 if exist "%JobMgr_ResIcons_L_DP%" set JobMgr_ResIcons_DP=%JobMgr_ResIcons_L_DP%
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo ---------------------------------------------------------------------------
  Echo #Debug..........................: explorer.exe /e,%JobMgr_ResIcons_DP%
  start "" explorer.exe /e,"%JobMgr_ResIcons_DP%"
  pause
 :JumbOverDebug
goto :eof

rem -------------------------
:GetVer
 set %2=UNK
 if not exist "%~1" goto :myEnd
 call "%~1"
 set %2=%JobMgr_BinPublicVer%
 set JobMgr_BinPublicVer=
:myEnd
 goto :eof

:DoCopyBinPubliclocal
  REM -- #LUp:10.09.2025/J.Fes copy only 1 time user.config if not local
  set SystemTrayMenu_user_config_S_DPNE=%BinPublic_S_DP%\SystemTrayMenu\user.config
  set SystemTrayMenu_user_config_L_DPNE=%BinPublic_L_DP%\SystemTrayMenu\user.config
  set CopyFromToOpt=/mir /xf *.tmp ~*.* *.bak "%SystemTrayMenu_user_config_S_DPNE%"
  if "%P2_WaitAtEnd_Sec%" equ "0" set CopyFromToOpt=%CopyFromToOpt% /NJH /NJS /NOSD /NODD /NDL
  Call "%CmdCurRoot$DP%\CopyFromTo.cmd" "GET 03-BinPublic to:local" "%BinPublic_S_DP%" "*.*" "%BinPublic_L_DP%" "*.*" "%CopyFromToOpt%"
  if exist "%SystemTrayMenu_user_config_L_DPNE%" goto :myEnd
  Call CopyFromTo.cmd "get SystemTrayMenu\user.config" "%BinPublic_S_DP%\SystemTrayMenu" "user.config" "%BinPublic_L_DP%\SystemTrayMenu"  "*.*"  ""
:myEnd

 goto :eof

:InitInfo
 Call ColorSet IsExecuting
 Call Echo2 "****"
 Call Echo2 "*" " GET 03-BinPublic to:local Ver:07.05.2025"
 Call Echo2 "*" " to Computer.: %ComputerName%"
 Call Echo2 "*" " from Source.: %BinPublic_S_DP%"
 Call Echo2 "*" " to local Dir: %BinPublic_L_DP%"
 Call Echo2 "****"
 goto :eof

:InitInfoDone
 Call Echo2 "----" "----"
 Call Echo2 "03-BinPublic to:local" " Done"
 call timeout /T:%P2_WaitAtEnd_Sec%
goto :eof
