@Echo off
 rem -----------------------------------------------------------------------------------------
 rem erstellt das PLMJobManager Application Toolbar mit allen erforderlichen verkuepfungen
 rem #New: 04.04.2007  J.Fes
 rem #LUp: 19.12.2022  J.Fes
 rem #LUp: 06.03.2024  J.Fes  Update 03-BinPublic\Sysinternals\procexp.exe - to - procexp64.exe ..
 rem #LUp: 01.06.2024  J.Fes  Update StartMenu_03-AutoStart_DP
 rem #LUp: 21.10.2025  J.Fes  add Call :LinkCreate "Systool TurnedOnTimesView"
 rem #LUp: 09.11.2025  J.Fes  add Call :LinkCreate "Systool TurnedOnTimesView"^

 rem Optionsparameter:
 rem P1 Quiet Modus
 cls

 set Quiet=false
 if /I "%1"=="/Quiet" set Quiet=true

 set ThisScript_DPNE=%~0
 rem Root Variablen
 set MyApplProd_N=PLMJobManagerV3

 set MyAppl_Root_DP=%~dp0
 set MyAppl_Root_DP=%MyAppl_Root_DP:~0,-1%

 rem dir %~dp0Application-Startmenu-IconsOrg.cmd
 rem #New 24.03.2021/J.Fes copy Application Icons from:JobMgr_ResIcons_S_DP to:JobMgr_ResIcons_L_DP
 Call %~dp0Application-Startmenu-IconsOrg.cmd INIT 0

 rem set Path=%MyAppl_Root_DP%\03-BinPublic;%Path%
 set Path=%BinPublic_DP%;%Path%

 rem Server Dirs ermitteln
 call :PathCutLastDir MyAppl_Root_DP "%~dp0"

 rem #22.02.2016/J.Fes parse Parse MyApplBase_TP from MyAppl_Root_DP
 call :PathRootDirTP MyApplBase_TP "%MyAppl_Root_DP%"

 set BinServer_DP=%MyAppl_Root_DP%\01-BinServer
 set BinPublicClientServer=%MyAppl_Root_DP%\03-BinPublic.ClientServer
 set BinClient_DP=%MyAppl_Root_DP%\02-BinClient

 REM -- #Doc:06.05.2025/J.Fes set BinPublic_DP note BinPublic_DP is set in Application-Startmenu-IconsOrg.cmd
 if not defined BinPublic_DP   set BinPublic_DP=%MyAppl_Root_DP%\03-BinPublic
 if not defined BinPublic_S_DP set BinPublic_S_DP=%BinPublic_DP%

 set BinPublicCustom_DP=%BinPublic_S_DP%.Custom
 set BinPublicCustom_AppSettings_DP=%BinPublicCustom_DP%\02-AppSettings
 if not exist "%BinPublicCustom_AppSettings_DP%" md "%BinPublicCustom_AppSettings_DP%"

 rem --#Doc: 10.03.2023/J.Fes removed
 set Install_DP=%MyAppl_Root_DP%\99-Install
 set InstallComponents_DP=%Install_DP%\Components

 rem -- #New:07.12.2022/J.Fes JobMgrToolbarAndStartLink_Org_Settings
 set JobMgrToolbarAndStartLink_Org_Settings_DP=%BinPublicCustom_DP%\01-AdminInstall
 set JobMgrToolbarAndStartLink_Org_Settings_DPNE=%JobMgrToolbarAndStartLink_Org_Settings_DP%\01-JobMgrToolbarAndStartLink_Org_Settings.cmd

 set QuickLaunch_DP=%APPDATA%\Microsoft\Internet Explorer\Quick Launch

 set MyTitle=Create -or- Update %MyApplProd_N% Toolbar
 set MyScriptVersion=01.11.2016/J.Fes #LUp:Add Password Org via KeePassMobil
 set MyScriptVersion=02.05.2017/J.Fes #LUp:Org .\11-Documentation.Custom\01-Admin
 set MyScriptVersion=09.08.2017/J.Fes #LUp:Org view: StartMenu_DP
 set MyScriptVersion=08.02.2018/J.Fes #LUp:Org .\11-Documentation.Custom
 set MyScriptVersion=01.05.2018/J.Fes #LUp:Org Remove 95-Sysinternals Filemon add FreeFileSync optimice
 set MyScriptVersion=13.11.2018/J.Fes #LUp:Org JobClient.Starter.CUI.exe replaced by JobClient.exe
 set MyScriptVersion=28.01.2020/J.Fes #LUp:Org add help for 11-JobManagerCmdTools_Help.txt
 set MyScriptVersion=17.11.2020/J.Fes #LUp:ReOrg Names 01 XX 01-XX
 set MyScriptVersion=04.12.2020/J.Fes #LUp:ReOrg Check req. Dirs via Call :DirDefineAndCreateIfNotExist
 set MyScriptVersion=02.03.2021/J.Fes #LUp:ReOrg Intensive JobMgr Link generation
 set MyScriptVersion=24.03.2021/J.Fes #LUp:Solving Issue generate Link to JobMgr-Software-Update-Tool
 set MyScriptVersion=18.05.2021/J.Fes #LUp:Solving Issue generate Link Explore Folder *.Custom
 set MyScriptVersion=07.12.2022/J.Fes #LUp:add JobMgr-Toolbar-and-StartLink_Org
 set MyScriptVersion=10.03.2023/J.Fes #LUp:Org Icons
 set MyScriptVersion=17.03.2023/J.Fes #LUp:add JobServer Start with Object+Reports Only
 set MyScriptVersion=10.11.2023/J.Fes #LUp:add StartMenu_95-ToolsCustom_QHelp_DP
 set MyScriptVersion=17.02.2024/J.Fes #LUp:add StartMenu 03-AutoStart
 set MyScriptVersion=23.04.2025/J.Fes #LUp:add TCNXStopProcess.cmd
 set MyScriptVersion=08.05.2025/J.Fes #LUp:add BinPublic_DP to local and Create Init Link
 set MyScriptVersion=06.10.2025/J.Fes #LUp:Update Org StartMenu Extensionsextensions

 Call :JobMgrToolbarAndStartLink_Org "default"

REM  Echo "StartMenu_DP:" "%StartMenu_DP%"
REM  pause


 rem define default Action
 set Action=S


:Menu
 call ColorSet.cmd Dialog
 call "%~dp0DateTimeGetUTC.cmd"
 set StartMenuBackup_DP=%StartMenu_DP%_Backup-%$DateTimeNowFileExt_YMDHMS%

 Echo.
 Echo --------------------------------------------------------------------------------
 call "%~dp0..\03-BinPublic.ClientServer\ApplicationInfo.cmd" "GetInfo" "NoPause"
 Echo --------------------------------------------------------------------------------
 Echo Action Info.....................: %MyTitle%
 Echo Version.........................: %MyScriptVersion%
 Echo JobMgr Root.....................: %MyAppl_Root_DP%
 Echo JobMgr Root.....................: %MyAppl_Root_DP%
 Echo Using Icon Dir..................: %JobMgr_ResIcons_DP%
 Echo Using BinPublic.................: %BinPublic_DP%
 Echo Using BinPublic Source..........: %BinPublic_S_DP%
 Echo Create JobMgr Links for System..: %JobMgrSetting_N%
 Echo Create JobMgr Links for Toolbar.: %StartMenu_TP%
 Echo Start Menu Root.................: %StartMenu_DP%
 Echo Start Menu Backup...............: %StartMenuBackup_DP%

 Title %MyTitle%
 Echo.
 if /i "%Quiet%" equ "true" goto :AskAction_JumbOver

 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ---- ---
 Echo  C  = Set Custom JobMgr ServerSettings-Name and Toolbar.....
 Echo  R  = Reset Custom JobMgr ServerSettings-Name and Toolbar to default
 Echo.
 Echo  S  = create Start Links for ServerSettings:%JobMgrSetting_N% Toolbar:%StartMenu_TP%
 Echo  J  = create Start Links like S + JobPlaner
 Echo.
 Echo  Q  = Quit action (do nothing)
 Echo.
REM  Echo #Debug 126
 Echo.
 set /P Action="select Action (Default=S) "
 Echo.

REM goto :Menu

:AskAction_JumbOver
 if /I "%Action%" equ "J" (
   set JobPlanerLinkDoCreate=Yes
   goto :StartCreateToolbar
 )

 if /I "%Action%" equ "S" (
   set JobPlanerLinkDoCreate=No
   goto :StartCreateToolbar
 )

 if /I "%Action%" equ "C" (
   Call :JobMgrToolbarAndStartLink_Org "custom"
 )

 if /I "%Action%" equ "R" (
   Call :JobMgrToolbarAndStartLink_Org "custom-reset"
 )

 if /I "%Action%" equ "Q" (
   Echo --------------------------------------------------------------------------------
   Echo Quit select
   Echo  nothing will be done / changed
   Echo --------------------------------------------------------------------------------
   Pause
   exit /b
 )

goto :Menu

rem ----------------------------------------------------------------------------
:JobMgrToolbarAndStartLink_Org
 REM #New:07.12.2022/J.Fes
 REM #Doc:setup JobMgr Startmenu

 if /I "%~1" equ "custom-reset" (
  Echo --------------------------------------------------------------------------------
  Echo 'JobMgr-ServerSettings-Name' and 'JobMgr-Toolbar-Extension'
  Echo JobMgr-ServerSettings-Name......: reset to default
  Echo JobMgr-Toolbar-Extension........: reset to default
  Echo reset to default................: via delete: '%JobMgrToolbarAndStartLink_Org_Settings_DPNE%'
  if exist "%JobMgrToolbarAndStartLink_Org_Settings_DPNE%" del "%JobMgrToolbarAndStartLink_Org_Settings_DPNE%"
  Pause
 )

 rem -- #LUp:07.12.2022/J.Fes set defaults for JobMgrSetting_N and StartMenu_E
 set JobMgrSetting_N=DefaultSystem& set StartMenu_E=
 If /I "%MyApplBase_TP:~-2%" equ "_T" set JobMgrSetting_N=TestSystem& set StartMenu_E=T
 If /I "%MyApplBase_TP:~-2%" equ "_P" set JobMgrSetting_N=ProdSystem& set StartMenu_E=P

 rem -- #Doc: read if exist settings stored in JobMgrToolbarAndStartLink_Org_Settings_DPNE
 if exist "%JobMgrToolbarAndStartLink_Org_Settings_DPNE%" call "%JobMgrToolbarAndStartLink_Org_Settings_DPNE%"

 if /I "%~1" equ "default" goto :JobMgrToolbarAndStartLink_Org_default
 if /I "%~1" equ "custom"  goto :JobMgrToolbarAndStartLink_Org_custom
 goto :myEnd

 :JobMgrToolbarAndStartLink_Org_custom
  Echo.
  Echo --------------------------------------------------------------------------------
  Echo Please set Custom 'JobMgr-ServerSettings-Name' and 'JobMgr-Toolbar-Extension'

  rem -- #Doc: set JobMgrSetting_N and StartMenu_E
  set /P JobMgrSetting_N="JobMgr-ServerSettings-Name (#Exa:DefaultSystem/TestSystem/ProdSystem/ACC) (Default=%JobMgrSetting_N%) "
  set /P     StartMenu_E="JobMgr-Toolbar-Extension (#Exa:T/P/ACC/#Doc:Use '.' NOT to use) (Default=%StartMenu_E%) "

  if "%StartMenu_E:~-1%" equ " " set StartMenu_E=
  if "%StartMenu_E:~-1%" equ "." set StartMenu_E=

  Echo JobMgr-ServerSettings-Name....: %JobMgrSetting_N%
  Echo JobMgr-Toolbar-Extension......: %StartMenu_E%

  rem -- #Doc: save JobMgrSetting_N and StartMenu_E
  if not exist "%JobMgrToolbarAndStartLink_Org_Settings_DP%" md "%JobMgrToolbarAndStartLink_Org_Settings_DP%"

  Echo @Echo off>%JobMgrToolbarAndStartLink_Org_Settings_DPNE%
  Echo set JobMgrSetting_N=%JobMgrSetting_N%>>%JobMgrToolbarAndStartLink_Org_Settings_DPNE%
  Echo set StartMenu_E=%StartMenu_E%>>%JobMgrToolbarAndStartLink_Org_Settings_DPNE%
  goto :myEnd


 :JobMgrToolbarAndStartLink_Org_default
  goto :myEnd

 :myEnd
  set StartMenu_TP=_%MyApplBase_TP%
  rem #Doc: if StartMenu_E='' then goto :myEnd2
  if "%StartMenu_E%" equ "" goto :myEnd2

  rem --#Doc: Check if _T _P is to remove when StartMenu_E=''
  set MyApplBase_TP$tmp=%MyApplBase_TP%
  set MyApplBase_TP$tmp=JobManagerV3

  If /I "%MyAppl_Root_DP:~-2%" equ "_T" set MyApplBase_TP$tmp=%MyApplBase_TP:~0,-2%
  If /I "%MyAppl_Root_DP:~-2%" equ "_P" set MyApplBase_TP$tmp=%MyApplBase_TP:~0,-2%
  set StartMenu_TP=_%MyApplBase_TP$tmp%_%StartMenu_E%
 :myEnd2

  set StartMenu_DP=%MyAppl_Root_DP%\%StartMenu_TP%
goto :eof

rem ----------------------------------------------------------------------------
:StartCreateToolbar

REM  Call :zzCopyInfo-03-BinPublic
 REM - Create Toolbar Backup
 Call :Toolbar_Backup
 Call :BaseLinksCreate
 Call :JobManagerCreateStartLinks 91-JobMgrStart "%JobMgrSetting_N%" %JobPlanerLinkDoCreate%
 Call :StartMenuCreateDone
 goto :eof


:Toolbar_Backup
 rem #New 17.03.2023
 if not exist "%StartMenu_DP%" goto :Toolbar_Backup_end
 set toRun=robocopy "%StartMenu_DP%" "%StartMenuBackup_DP%" "*.*" /xf *.tmp ~*.* *.bak /NP /TBD /TEE /R:4 /W:1 /MIR
 Echo --------------------------------------------------------------------------------
 Echo Backup Toolbar from dir.........: %StartMenu_DP%
 Echo Backup Toolbar to dir...........: %StartMenuBackup_DP%
 Call %toRun% >nul
 Echo Backup Toolbar..................: Done
 timeout /T:2
 :Toolbar_Backup_end

goto :eof

:BaseLinksCreate
 Call ColorSet.cmd IsExecuting
 Echo --------------------------------------------------------------------------------
 Echo Create..........................: JobManager Toolbar
 Echo Version.........................: %MyScriptVersion%
 Echo --------------------------------------------------------------------------------
 Echo Start...........................: %Date% %time:~0,5%

 call :DelDirIfExist "%StartMenu_DP%\01-Install"
 rem 13.08.2013/J.Fes 02-Setup aufgeloest
 call :DelDirIfExist "%StartMenu_DP%\02-Setup"
 call :DelDirIfExist "%StartMenu_DP%\03-AutoStart.Setup"
 rem 13.08.2013 Clean Up WhatsNew
 call :DelDirIfExist "%MyAppl_Root_DP%\10-Documentation.Application\01-Install"
 call :DelDirIfExist "%MyAppl_Root_DP%\10-Documentation.Application\02-Setup"
 call :DelDirIfExist "%MyAppl_Root_DP%\10-Documentation.Application\03-WhatsNew"
 call :DelDirIfExist "%DocAppl_DP%\99-Internet-Links"

 call :DelFilesIfExist "%StartMenu_80-OpenFolder_DP%\01-%MyApplBase_TP% Application root folder.lnk"
 call :DelFilesIfExist "%StartMenu_DP%\90-PLMJobManagerV3_ProjectDoc_Customer.lnk"

 call :DelFilesIfExist "%MyAppl_Root_DP%\10-Documentation.Application\JobManagerV3 WhatsNew.lnk"
 call :DelFilesIfExist "%MyAppl_Root_DP%\10-Documentation.Application\JobManagerV3 WhatsNew.pdf.lnk"
 call :DelFilesIfExist "%MyAppl_Root_DP%\10-Documentation.Application\JobManagerV3 WhatsNew.xlsx.lnk"

 rem #New:02.05.2017/J.Fes
 Call :DirDefineAndCreateIfNotExist InstallTemplates_DP         "%MyAppl_Root_DP%\99-Install\Templates"
 Call :DirDefineAndCreateIfNotExist InstallInternetLinks_DP     "%MyAppl_Root_DP%\99-Install\Internet-Links"

 Call :DirDefineAndCreateIfNotExist DocAppl_DP                  "%MyAppl_Root_DP%\10-Documentation.Application"

 rem 04.12.2020/sove Issue update
 Call :DirDefineAndCreateIfNotExist DocAppl_95Scrpting_Help_DP  "%DocAppl_DP%\95-JobServer_Scripting_Help"
 set StartMenu_DocAppl_DP=%StartMenu_DP%\10-Documentation.Application

 rem #New:18.05.2021/J.Fes
 Call :DirDefineAndCreateIfNotExist BinServer_Custom_DP         "%MyAppl_Root_DP%\01-BinServer.Custom"
 Call :DirDefineAndCreateIfNotExist BinClient_Custom_DP         "%MyAppl_Root_DP%\02-BinClient.Custom"
 Call :DirDefineAndCreateIfNotExist BinPublic_Custom_DP         "%MyAppl_Root_DP%\03-BinPublic.Custom"
 Call :DirDefineAndCreateIfNotExist JobMgr90-DATA_DP              "%MyAppl_Root_DP%\90-DATA"
 Call :DirDefineAndCreateIfNotExist JobMgr91-DATA_TempTransfer_DP "%MyAppl_Root_DP%\91-DATA.TempTransfer"
 rem #New:02.05.2017/J.Fes
 Call :DirDefineAndCreateIfNotExist DocCustom_DP                "%MyAppl_Root_DP%\11-Documentation.Custom"

 Call :DirDefineAndCreateIfNotExist DocCustom_01-Admin_DP       "%DocCustom_DP%\01-Admin"
 Call :DirDefineAndCreateIfNotExist StartMenu_DP                "%StartMenu_DP%"

 rem 13.08.2013 01-Install umbenannt nach 01-Install_and_Setup
 Call :DirDefineAndCreateIfNotExist StartMenu_01-Install_DP     "%StartMenu_DP%\01-Install_and_Setup"
 Call :DirDefineAndCreateIfNotExist StartMenu_01-InstallDocu_DP "%StartMenu_01-Install_DP%"
 REM 13.08.2013 02-WhatsNew eingefgt
 Call :DirDefineAndCreateIfNotExist StartMenu_02-WhatsNew_DP    "%StartMenu_DP%\02-WhatsNew"
 REM 17.02.2024/J.Fes
 Call :DirDefineAndCreateIfNotExist StartMenu_03-AutoStart_DP   "%StartMenu_DP%\03-AutoStart.Setup"

 Call :DirDefineAndCreateIfNotExist StartMenu_80-OpenFolder_DP  "%StartMenu_DP%\80-OpenFolder"
 rem added 29.08.2019 S.Gueth
 Call :DirDefineAndCreateIfNotExist StartMenu_81-InternetLinks  "%StartMenu_DP%\81-InternetLinks"
 Call :DirDefineAndCreateIfNotExist StartMenu_90-Tools_DP       "%StartMenu_DP%\90-Tools"
 rem 05.07.2014
 Call :DirDefineAndCreateIfNotExist StartMenu_95-ToolsCustom_DP "%StartMenu_DP%\95-ToolsCustom"
 Call :DirDefineAndCreateIfNotExist StartMenu_95-ToolsCustom_QHelp_DP "%StartMenu_95-ToolsCustom_DP%\_QHelp"

 call :CleanDirIfExist "%StartMenu_01-Install_DP%"
 call :CleanDirIfExist "%StartMenu_02-WhatsNew_DP%"

 rem #New:18.10.2019/J.Fes cleaup old links
 Call :CleanDirIfExist "%StartMenu_80-OpenFolder_DP%"
 call :CleanDirIfExist "%StartMenu_81-InternetLinks%"
 call :CleanDirIfExist "%StartMenu_90-Tools_DP%"
 Echo --------------------------------------------------------------------------------

REM  Call Echo2 "StartMenu_DocAppl_DP" "%StartMenu_DocAppl_DP%"
REM  Call :LinkCreate "Folder Link to:'10-Documentation.Application'"^
REM  "%DocAppl_DP%"^
REM  "%StartMenu_DocAppl_DP%"^
REM  ""^
REM  ""^
REM  ""^
REM  ""^
REM  "FolderLink"
REM
REM  Call :LinkCreate "Folder Link to:'11-Documentation.Custom'"^
REM  "%DocCustom_DP%"^
REM  "%StartMenu_DP%\11-Documentation.Custom"^
REM  ""^
REM  ""^
REM  ""^
REM  ""^
REM  "FolderLink"

 REM -- #LUp:08.05.2025/J.Fes replace FolderLink with default links
 Call :DelHiddenDirIfExist "%StartMenu_DocAppl_DP%"
 Call :DelHiddenDirIfExist "%StartMenu_DP%\11-Documentation.Custom"

 set LinkFile_DPNE=%StartMenu_DP%\00-Link to 10-Documentation.Application.lnk
 Call :LinkCreate "Link to:10-Documentation.Application"^
 "%DocAppl_DP%"^
 "%LinkFile_DPNE%"

 set LinkFile_DPNE=%StartMenu_DP%\00-Link to 11-Documentation.Custom.lnk
 Call :LinkCreate "Link to:11-Documentation.Custom"^
 "%DocCustom_DP%"^
 "%LinkFile_DPNE%"

REM  pause

rem ############## Main Progs #####################
REM  Call Echo2 "#D: Li:316 StartMenu_DocAppl_DP" "%StartMenu_DocAppl_DP% // %~nx0"&Pause
REM  Call :DelDirIfExist "%StartMenu_DocAppl_DP%"
REM  Call Echo2 "#D: Li:318 StartMenu_DocAppl_DP" "%StartMenu_DocAppl_DP% // %~nx0"&Pause
REM
REM
REM  Call :LinkCreate^
REM  "Link to:'10-Documentation.Application'"^
REM  "%DocAppl_DP%"^
REM  "%LinkFile_DPNE%"
REM pause

REM  ^
REM  "%JobMgr_ResIcons_DP%\TextDocument_Search.ico"

REM  Call :LinkCreate "Folder Link to:'10-Documentation.Application'"^
REM  "%DocAppl_DP%"^
REM  "%StartMenu_DocAppl_DP%"^
REM  ""^
REM  ""^
REM  ""^
REM  ""
REM  Call Echo2 "#D: Li:327 StartMenu_DocAppl_DP" "%StartMenu_DocAppl_DP% // %~nx0"&Pause
REM  pause





 rem remove LNK
 CALL :ArchivIfExist  "%MyAppl_Root_DP%\11-Documentation.Custom\90-PLMJobManager_ProjectDoc_Customer.pptx"  "%MyAppl_Root_DP%\11-Documentation.Custom\zzArchiv"  "90-PLMJobManagerV3_ProjectDoc_Customer_Archiv.pptx"

 set PLMJobManager_Setup_Customer_DPNE=%DocCustom_01-Admin_DP%\91-PLMJobManager_Setup_Customer.pptx
 set PLMJobManager_Setup_template_DPNE=%InstallTemplates_DP%\91-PLMJobManager_Setup_Customer.pptx
 rem #Doc: 02.05.2017/J.Fes move existing
 if not exist "%PLMJobManager_Setup_Customer_DPNE%" if exist "%PLMJobManager_Setup_template_DPNE%" (
  Echo Create PLMJobManager Setup Custom: %PLMJobManager_Setup_Customer_DPNE%
  copy "%PLMJobManager_Setup_template_DPNE%" "%PLMJobManager_Setup_Customer_DPNE%"
 )


 rem #New 25.01.2018/J.Fes Org Prj
 set PLMJobManager_ProjectDocumentsTemplate_DP=%InstallTemplates_DP%\zz-ProjectDocumentsTemplate
 set PLMJobManager_ProjectDocumentsTemplate_Customer_DP=%DocCustom_DP%\zz-DocumentsTemplateBeforUsePleaseCopy
 if not exist "%PLMJobManager_ProjectDocumentsTemplate_DP%" goto :Next
 Echo - Org.PLMJobMgr Doc Templates...: into customer documentation folder ..
 Echo   ^|- from Template dir..........: %PLMJobManager_ProjectDocumentsTemplate_Customer_DP%
 Echo   ^|- to Custom doc dir..........: %PLMJobManager_ProjectDocumentsTemplate_DP%
 robocopy "%PLMJobManager_ProjectDocumentsTemplate_DP%"  "%PLMJobManager_ProjectDocumentsTemplate_Customer_DP%" /xf *.tmp ~*.* *.bak /NP /TBD /TEE /R:4 /W:1 /MIR >nul

 :Next
rem #################### 00-DOCU  #########################
rem siehe hier immer auch Link Create bei Install und Setup

 Echo --------------------------------------------------------------------------------
 Echo Start Create/Update.............: Application links
 Echo --------------------------------------------------------------------------------

 rem -- Help Dokumentation -----------------------------------------------------
 Echo - Create Link's.................: Help -----------------------------------------
 rem #New; 28.01.2020/J.Fes link to JobManagerCmdTools_Help.txt
 rem #Doc: 01.03.2021/J.Fes delete wrong copied help file
 Call :DelFilesIfExist "%DocAppl_DP%\JobManagerCmdTools_Help.txt"

 set LinkFile_DPNE=%DocAppl_95Scrpting_Help_DP%\11-JobManagerCmdTools_Help.txt.lnk
 Call :LinkCreate "JobManagerCmdTools_Help.txt"^
 "%BinPublicClientServer%\JobManagerCmdTools_Help.txt"^
 "%DocAppl_95Scrpting_Help_DP%\11-JobManagerCmdTools_Help.txt.lnk"^
 "%JobMgr_ResIcons_DP%\TextDocument_Search.ico"
 rem #Doc: copy 11-JobManagerCmdTools_Help.txt.lnk file to toolbar DocAppl
 if exist "%LinkFile_DPNE%" copy "%LinkFile_DPNE%" "%DocAppl_DP%\*.*" >>nul

 Echo - Create Link's.................: 01-Install and Setup -------------------------

 rem 22.03.2013 14:28 J.Fes
 rem --- JobMgr CMDtool CBSettings Start neu 21.03.2013 J.Fes
 Call :LinkCreate "JobManager_WhatsNew.txt"^
 "%BinPublicClientServer%\JobManager_WhatsNew.txt"^
 "%StartMenu_01-Install_DP%\10 -------- (JobManagerV3 Docu) ---------.lnk"^
 "%JobMgr_ResIcons_DP%\ToolbarSeperator.ico"


 Call :LinkCreate "ApplicationInfo.cmd"^
 "%MyAppl_Root_DP%\01-BinServer\ApplicationInfo.cmd"^
 "%StartMenu_01-InstallDocu_DP%\15-JobManagerV3 Version Info.lnk"^
 "%JobMgr_ResIcons_DP%\Application-VersionInfo.ico"

rem ######################################################

 Call :LinkCreate "JobManager_WhatsNew.txt"^
 "%BinPublicClientServer%\JobManager_WhatsNew.txt"^
 "%StartMenu_01-Install_DP%\20 -------- (Setup Tools) ---------.lnk"^
 "%JobMgr_ResIcons_DP%\ToolbarSeperator.ico"

 Call :LinkCreate "CheckBox Manager"^
 "%MyAppl_Root_DP%\03-BinPublic.ClientServer\JobManagerCmdTools_SettingsManager\JobManagerStart.cmd"^
 "%StartMenu_01-Install_DP%\23-CheckBox (CB.Mgr).lnk"^
 "%JobMgr_ResIcons_DP%\CheckBox.ico"^
 "/JobMgrCmdTools_CBSettingsMgr -ApplMode Setup"^
 "Min"^
 "%MyAppl_Root_DP%\03-BinPublic.ClientServer\JobManagerCmdTools_SettingsManager"^


 rem 05.10.2016 S.Gueth
 rem --- JobMgr DataQuality CBSettings Start
 Call :LinkCreate "JobMgr TC DataQuality Settings"^
 "%MyAppl_Root_DP%\03-BinPublic.ClientServer\JobManagerCmdTools_DataQuality\JobManagerStart.cmd"^
 "%StartMenu_01-Install_DP%\25-DataQuality (DQ.Settings Manager).lnk"^
 "%JobMgr_ResIcons_DP%\DataQuality_Manager.ico"^
 "/JobMgrCmdTools_DQSettingsMgr"^
 "Min"^
 "%MyAppl_Root_DP%\03-BinPublic.ClientServer\JobManagerCmdTools_DataQuality"


 Call :LinkCreate "30 -------- (Update Tools) ---------"^
 "%BinPublicClientServer%\JobManager_WhatsNew.txt"^
 "%StartMenu_01-Install_DP%\30 -------- (Update Tools) ---------.lnk"^
 "%JobMgr_ResIcons_DP%\ToolbarSeperator.ico"


 rem *#LUp 24.03.2021 J.Fes
 rem --- JobMgr CBSettings Manager Start neu 21.03.2013 J.Fes
 Call :LinkCreate "JobMgr Software Update Tool"^
 "%MyAppl_Root_DP%\92-Update\JobManagerStart.cmd"^
 "%StartMenu_01-Install_DP%\31-JobManager Software Update.lnk"^
 "%JobMgr_ResIcons_DP%\JobMgrUpdate.ico"^
 "/JobMgr_Updater"^
 "Min"^
 "#temp#"


 Call :LinkCreate "Open Folder: JobMgr Software Update"^
 "%MyAppl_Root_DP%\92-Update"^
 "%StartMenu_01-Install_DP%\32-JobManager Software Update open Folder.lnk"^

 rem -- #New: 28.03.2017 10:25
 Call :LinkCreate "Install SQLCMD tool"^
 "%MyAppl_Root_DP%\99-Install\SQLCmd_Setup\SQLCmd_Setup_PleaseRunAsAdmin.cmd"^
 "%StartMenu_01-Install_DP%\26-SQLCMD Setup PleaseRunAsAdmin.lnk"^
 "%JobMgr_ResIcons_DP%\setup.ico"

 rem -- Verknpfung auf diese Startmenu Create Update Routine selber
 Call :LinkCreate "Creates or Updates the application Startmenue"^
 "%ThisScript_DPNE%"^
 "%StartMenu_01-Install_DP%\33-JobManager Startmenu Create or Update.lnk"^
 "%JobMgr_ResIcons_DP%\Application-Startmenu-Create-or-Update.ico"^
 ""^
 "Normal"^
 "%MyAppl_Root_DP%\99-Install"



rem ############## WHATS NEW #####################

 Echo - Create Link's.................: 02-WhatsNew ----------------------------------

 rem -- #Doc:20.07.09/J.Fes !! Achtung Link in den das %MyAppl_Root_DP%\10-Documentation.Application Verzeichniss legen da ..\_JobManagerV3\10-Documentation.Application ein Ordner link ist!!
 Call :LinkCreate "JobManager WhatsNew.txt"^
 "%BinPublicClientServer%\JobManager_WhatsNew.txt"^
 "%StartMenu_02-WhatsNew_DP%\01-JobManagerV3 WhatsNew.txt.lnk"^
 "%JobMgr_ResIcons_DP%\whatsnew.ico"

 Call :LinkCreate "JobManager WhatsNew.pdf"^
 "%BinPublicClientServer%\JobManager_WhatsNew.pdf"^
 "%StartMenu_02-WhatsNew_DP%\02-JobManagerV3 WhatsNew.pdf.lnk"^
 "%JobMgr_ResIcons_DP%\pdf.ico"


 Call :LinkCreate "JobManager WhatsNew.xlsx"^
 "%BinPublicClientServer%\JobManager_WhatsNew.xlsx"^
 "%StartMenu_02-WhatsNew_DP%\03-JobManagerV3 WhatsNew.xlsx.lnk"


 Echo - Create Link's.................: 80-OpenFolder --------------------------------
 Call :LinkCreate "Explore:application root"^
 "%MyAppl_Root_DP%"^
 "%StartMenu_80-OpenFolder_DP%\00-%MyApplBase_TP% Application root folder.lnk"^

 rem -- Link to 01-BinServer.Custom folder
 Call :LinkCreate "Explore:01-BinServer.Custom"^
 "%BinServer_Custom_DP%"^
 "%StartMenu_80-OpenFolder_DP%\01-BinServer.Custom.lnk"

 rem -- #New: 07.11.2019/J.Fes Link to 02-BinClient.Custom folder
 Call :LinkCreate "Explore:02-BinClient.Custom"^
 "%BinClient_Custom_DP%"^
 "%StartMenu_80-OpenFolder_DP%\02-BinClient.Custom.lnk"

 rem -- Link to 03-BinPublic.Custom folder
 Call :LinkCreate "Explore:03-BinPublic.Custom"^
 "%BinPublic_Custom_DP%"^
 "%StartMenu_80-OpenFolder_DP%\03-BinPublic.Custom.lnk"

 Call :LinkCreate "Explore:11-Documentation.Custom"^
 "%MyAppl_Root_DP%\11-Documentation.Custom"^
 "%StartMenu_80-OpenFolder_DP%\11-Documentation.Custom folder.lnk"

 Call :LinkCreate "Explore:90-DATA"^
 "%JobMgr90-DATA_DP%"^
 "%StartMenu_80-OpenFolder_DP%\90-DATA folder.lnk"

 Call :LinkCreate "Explore:91-DATA.TempTransfer"^
 "%JobMgr91-DATA_TempTransfer_DP%"^
 "%StartMenu_80-OpenFolder_DP%\91-DATA.TempTransfer.lnk"

 Call :LinkCreate "Explore:92-Update"^
 "%MyAppl_Root_DP%\92-Update"^
 "%StartMenu_80-OpenFolder_DP%\92-Update (Dir to Manage JobMgr Updates).lnk"

 Call :LinkCreate "Explore:JobManager Program local"^
 "%MyAppl_Root_DP%\01-BinServer\JobManagerStart.cmd"^
 "%StartMenu_80-OpenFolder_DP%\93-JobManager Program local.lnk"^
 "%JobMgr_ResIcons_DP%\folderOpen.ico"^
 "/JobMgrLocalRoot_Open"^
 "Min"^
 "%MyAppl_Root_DP%\01-BinServer"

 rem #New:12.06.2025/J.Fes
 Call :LinkCreate "Explore:JobManager 03-BinPublic local"^
 "%BinPublic_L_DP%"^
 "%StartMenu_80-OpenFolder_DP%\94-JobManager 03-BinPublic (local).lnk"^
 "%JobMgr_ResIcons_DP%\IconFolderOpen.ico"^

 rem #New:10.11.2023/J.Fes
 Call :LinkCreate "Explore:JobManager Icons local"^
 "%JobMgr_ResIcons_L_DP%"^
 "%StartMenu_80-OpenFolder_DP%\95-JobManager Icons (local).lnk"^
 "%JobMgr_ResIcons_DP%\IconFolderOpen.ico"^


 rem -- #New: 14.06.2016 10:11
 REM -- #LUp:12.06.2025/J.Fes removed
REM  Call :LinkCreate "Explore:Quick Launch"^
REM  "%AppData%\Microsoft\Internet Explorer\Quick Launch"^
REM  "%StartMenu_80-OpenFolder_DP%\95-Windows Quick Launch.lnk"

 Call :LinkCreate "Explore:Windows Autostart - Startup"^
 "%APPDATA%\Microsoft\Windows\Start Menu\Programs\Startup"^
 "%StartMenu_80-OpenFolder_DP%\96-Windows Autostart - Startup.lnk"

 rem -- #New:01.06.2024/J.Fes add Link also to StartMenu_03-AutoStart_DP menu
 copy "%StartMenu_80-OpenFolder_DP%\96-Windows Autostart - Startup.lnk" "%StartMenu_03-AutoStart_DP%\*">nul

 Call :LinkCreate "Explore:Users Windows Start Menu"^
 "%APPDATA%\Microsoft\Windows\Start Menu\Programs"^
 "%StartMenu_80-OpenFolder_DP%\97-Windows Start Menu (User).lnk"

set JobMgr_ResIcons_L_DP=%ProgramData%\JobManager_V3\Icons

rem ############## 81-InternetLinks #####################
 rem -- 81-InternetLinks Dokumentation
 Echo - Create Link's.................: 81-InternetLinks -----------------------------

 call :LinkCreate_URL^
 "%StartMenu_81-InternetLinks%\11 JobManagerV3 WhatsNew.txt - [from Web].url"^
 "https://download.addplm.com/JobManagerV3/02-LatestVersion_ZipPwNo/00-JobManagerV3_WhatsNew.txt"

REM  Call :LinkCreate "PLMJobManager CreateNewIssue MailTemplate"^
REM  "%InstallTemplates_DP%\94-PLMJobManager_CreateNewIssueMailTemplate.oft"^
REM  "%StartMenu_81-InternetLinks%\12 PLMJobManager CreateNewIssue MailTemplate.lnk"

REM  set LinkDest_DPNE=C:\Windows\System32\cmd.exe

 Call :LinkCreate "20 - - - - - - - - - - - - - - - - - - - -"^
 "%ComSpec%"^
 "%StartMenu_81-InternetLinks%\20 - - - - - - - - - - - - - - - - - - - -.lnk"^
 "%JobMgr_ResIcons_DP%\ToolbarSeperator.ico"

 rem 06.11.2024/J.Fes update Links to new Sturcture
 call :LinkCreate_URL^
 "%StartMenu_81-InternetLinks%\21 PLMJobManager Homepage at addPLM.url"^
 "http://www.addplm.com/"

 call :LinkCreate_URL^
 "%StartMenu_81-InternetLinks%\22 PLMJobManager Setup Download area - [LatestVersion Setup].url"^
 "https://download.addplm.com/JobManagerV3/01-LatestVersion-setup/"

 call :LinkCreate_URL^
 "%StartMenu_81-InternetLinks%\23 PLMJobManager Patch Download area - [LatestVersion].url"^
 "https://download.addplm.com/JobManagerV3/02-LatestVersion_ZipPwNo/"

 call :LinkCreate_URL^
 "%StartMenu_81-InternetLinks%\24 PLMJobManager Patch Download area - [TestVersion].url"^
 "https://download.addplm.com/JobManagerV3/03-TestVersion_ZipPwNo/"
  rem https://download.addplm.com/JobManagerV3/03-TestVersion_ZipPwNo/

 call :LinkCreate_URL^
 "%StartMenu_81-InternetLinks%\25 PLMJobManager Templates Download area - [10-JobScripts].url"^
 "https://download.addplm.com/JobManagerV3/V3-0002-AppResources/90-DATA/CustomerNameShort_SettingsGlobal/10-JobScripts/"

 call :LinkCreate_URL^
 "%StartMenu_81-InternetLinks%\25 PLMJobManager Tools Download.url"^
 "https://download.addplm.com/Tools/"


 Call :LinkCreate "30 - - - - - - - - - - - - - - - - - - - -"^
 "%ComSpec%"^
 "%StartMenu_81-InternetLinks%\30 - - - - - - - - - - - - - - - - - - - -.lnk"^
 "%JobMgr_ResIcons_DP%\ToolbarSeperator.ico"

 REM 18.10.2019/J.Fes update Link
 rem set LinkDest_URL=http://support.ugs.com/global/de/
 call :LinkCreate_URL^
 "%StartMenu_81-InternetLinks%\31 Siemens GTAG Produktsupport-Download (en-US).url"^
 "https://support.sw.siemens.com/en-US/signin"
rem  "https://www.plm.automation.siemens.com/en_us/support/gtac/"

 REM 18.10.2019/J.Fes update Link
 REM set LinkDest_URL=http://support.ugs.com/global/de/
 call :LinkCreate_URL^
 "%StartMenu_81-InternetLinks%\32 Siemens GTAG Produktsupport-Download (de-DE).url"^
 "https://support.sw.siemens.com/de-DE/signin"
REM  "https://www.plm.automation.siemens.com/de/support/gtac/"

 REM  set LinkDest_URL=http://uganswer.ugs.com/
rem 02.03.2021 - is integratet in GTAG Produktsupport
REM  call :LinkCreate_URL^
REM  "%StartMenu_81-InternetLinks%\33 Siemens GTAG Solution Center (uganswer) (WebKey Login req.).url"^
REM  "https://solutions.industrysoftware.automation.siemens.com/"

 call :LinkCreate_URL^
 "%StartMenu_81-InternetLinks%\34 Siemens Documentation Center (.en).url"^
 "https://www.plm.automation.siemens.com/global/en/support/docs.html"

 call :LinkCreate_URL^
 "%StartMenu_81-InternetLinks%\35 Siemens Community (Find Answers).url"^
 "https://community.plm.automation.siemens.com/"



rem ############## 90-Tools #####################

 Echo - Create Link's.................: 90-Tools -------------------------------------
 REM 13.12.2021/J.Fes removed not used and avoint ISSUE Log4j-Zero-Day
 REM  Call :LinkCreate "anlyse logfies"^
 REM  "%BinPublic_DP%\LogExpert\LogExpert.exe"^
 REM  "%StartMenu_90-Tools_DP%\10-LogExpert.lnk"^
 REM  ""^
 REM  ""^
 REM  ""^
 REM  "#temp#"
REM  call :DelFilesIfExist "%StartMenu_90-Tools_DP%\10-LogExpert.lnk"
REM  call :DelDirIfExist   "%BinPublic_DP%\LogExpert"

 set LinkFile_DPNE=%StartMenu_90-Tools_DP%\00-JobManagerV3 INIT (1x).lnk
 Call :LinkCreate^
 "00-Application Init"^
 "%Install_DP%\Application-Startmenu-IconsOrg.cmd"^
 "%LinkFile_DPNE%"^
 "%JobMgr_ResIcons_DP%\JobMgrApplInit.ico"^
 "INIT 100"
 copy "%LinkFile_DPNE%" "%StartMenu_01-Install_DP%\*.*" >nul
 rem copy "%LinkFile_DPNE%" "%StartMenu_DP%\*.*" >nul


 REM -- #New:24.04.2025/J.Fes
 set LinkFile_DPNE=%StartMenu_90-Tools_DP%\01-Toolbar Manager (SystemTrayMenu.exe).lnk
 Call :LinkCreate^
 "01-SystemTrayMenu - MGR 1"^
 "%BinPublic_DP%\SystemTrayMenu\SystemTrayMenu.exe"^
 "%LinkFile_DPNE%"^
 "%JobMgr_ResIcons_DP%\SystemTrayMenu.ico"^
 "%StartMenu_DP%"
 copy "%LinkFile_DPNE%" "%StartMenu_01-Install_DP%\*.*" >nul

 REM -- #New:24.04.2025/J.Fes
 REm -- #LUp:12.06.2025/J.Fes removed
REM  set LinkFile_DPNE=%StartMenu_90-Tools_DP%\02-Toolbar Manager-2 (TrayToolbar.exe).lnk
REM  Call :LinkCreate^
REM  "02-TrayToolbar - MGR 2"^
REM  "%BinPublic_DP%\traytoolbar\TrayToolbar.exe"^
REM  "%LinkFile_DPNE%"
REM  copy "%LinkFile_DPNE%" "%StartMenu_01-Install_DP%\*.*" >nul


 Call :LinkCreate "10 - - - - - - - - - - - - - - - - - - - -"^
 "%ComSpec%"^
 "%StartMenu_90-Tools_DP%\10 - - - - - - - - - - - - - - - - - - - -.lnk"^
 "%JobMgr_ResIcons_DP%\ToolbarSeperator.ico"


 set LinkFile_DPNE=%StartMenu_90-Tools_DP%\11-PSPad (Texteditor).lnk
 Call :LinkCreate "11-PSPad (Texteditor)"^
 "%BinPublic_DP%\PSPad editor\PSPad.exe"^
 "%LinkFile_DPNE%"
 copy "%LinkFile_DPNE%" "%StartMenu_DP%\*.*" >nul

REM  set LinkFile_DPNE=%StartMenu_90-Tools_DP%\12-ScreenShot (Use Print Key to Capture ScreenShots).lnk
REM  Call :LinkCreate "Start Screenshot software"^
REM  "%MyAppl_Root_DP%\02-BinClient\JobManagerStart.cmd"^
REM  "%LinkFile_DPNE%"^
REM  "%JobMgr_ResIcons_DP%\Greenshot.ico"^
REM  "/Screenshot"^
REM  "Min"
 set LinkFile_DPNE=%StartMenu_90-Tools_DP%\12-ScreenShot (Use Print Key to Capture ScreenShots).lnk
 Call :LinkCreate "Start Screenshot software"^
 "%BinPublic_DP%\Greenshot\Greenshot.exe"^
 "%LinkFile_DPNE%"^
 "%JobMgr_ResIcons_DP%\Greenshot.ico"^
 copy "%LinkFile_DPNE%" "%StartMenu_DP%\*.*" >nul

 Call :LinkCreate "7-Zip File Manager"^
 "%BinPublic_DP%\7-Zip\7zFM.exe"^
 "%StartMenu_90-Tools_DP%\13-7-Zip (Zip File Manager).lnk"

 rem #Doc: 02.05.2017/J.Fes Prepare copy 93-JobManagerRemoteConnections.rdg template
 set JobManagerRemoteConnectionsV1_Custom_DPNE=%DocCustom_01-Admin_DP%\93-JobManagerRemoteConnections.rdg
 set JobManagerRemoteConnections_Custom_DPNE=%DocCustom_01-Admin_DP%\93-PLMJobManager_RemoteConnections_Customer.rdg
 set JobManagerRemoteConnections_template_DPNE=%InstallTemplates_DP%\93-PLMJobManager_RemoteConnections_Customer.rdg
 rem #Doc: 02.05.2017/J.Fes move existing
 if exist "%JobManagerRemoteConnectionsV1_Custom_DPNE%" (
  Echo move existing...................: 93-JobManagerRemoteConnections.rdg
  Echo from............................: %JobManagerRemoteConnectionsV1_Custom_DPNE%
  Echo to..............................: %JobManagerRemoteConnections_Custom_DPNE%
  move "%JobManagerRemoteConnectionsV1_Custom_DPNE%" "%JobManagerRemoteConnections_Custom_DPNE%"
 )
 if not exist "%JobManagerRemoteConnections_Custom_DPNE%" if exist "%JobManagerRemoteConnections_template_DPNE%" (
  Echo Copy Custom RDP template........: %JobManagerRemoteConnections_Custom_DPNE%
  copy "%JobManagerRemoteConnections_template_DPNE%" "%JobManagerRemoteConnections_Custom_DPNE%"
 )

 if not exist "%JobManagerRemoteConnections_Custom_DPNE%" set JobManagerRemoteConnections_Custom_DPNE=

 Call :LinkCreate "Remote Desktop Connection Manager"^
 "%BinPublic_DP%\RDCMgr\RDCMan.exe"^
 "%StartMenu_90-Tools_DP%\14-RDC (Remote Desktop Connection Manager).lnk"^
 ""^
 "%JobManagerRemoteConnections_Custom_DPNE%"



 rem -- 03-BinPublic\RemoteSupport mit addPLM Via TeamViewer Link Create --
 rem 25.05.2016 11:45 / J.Fes /TC11 with new addPLM_RemoteSupport_via_TeamViewer.exe no need to use -idch63gua5.exe anymore
 Call :LinkCreate "Remote Support via TeamViewer "^
 "%BinPublic_DP%\addPLM_RemoteSupport_via_TeamViewer.exe"^
 "%StartMenu_90-Tools_DP%\16-Remote Support Via TeamViewer.lnk"


 Call :LinkCreate "PDF Reader"^
 "%BinPublic_DP%\PdfReader\Foxit Reader.exe"^
 "%StartMenu_90-Tools_DP%\17-PdfReader Start.lnk"^
 "%JobMgr_ResIcons_DP%\pdf.ico"^
 ""^
 ""^
 "%DocAppl_DP%"


 rem #New:19.12.2022/J.Fes
 Call :LinkCreate "90 - - - - - - - - - - - - - - - - - - - -"^
 "%ComSpec%"^
 "%StartMenu_90-Tools_DP%\90 - - - - - - - - - - - - - - - - - - - -.lnk"^
 "%JobMgr_ResIcons_DP%\ToolbarSeperator.ico"


 rem new 19.06.2014 12:30
 rem -- 03-BinPublic\JobManagerServiceTools_Start.cmd Link Create --
 set LinkFile_DPNE=%StartMenu_90-Tools_DP%\90-JobManager Service Tools.lnk
 Call :LinkCreate "JobManager Service Tools"^
 "%MyAppl_Root_DP%\99-Install\JobManagerServiceTools_Start.cmd"^
 "%LinkFile_DPNE%"^
 "%JobMgr_ResIcons_DP%\JobManagerServiceTools_Start.ico"^
 ""^
 "%MyAppl_Root_DP%\99-Install"

 copy "%LinkFile_DPNE%" "%StartMenu_01-Install_DP%\24-JobManager Service Tools.lnk">nul
 rem -- #New:01.06.2024/J.Fes add Link also to StartMenu_03-AutoStart_DP menu
 copy "%LinkFile_DPNE%" "%StartMenu_03-AutoStart_DP%\*">nul

 rem -- 22.02.2016 91-JobComputer Setup Defaults.lnk moved to here --
 Call :LinkCreate "set JobClient Default Options for cmd"^
 "%MyAppl_Root_DP%\99-Install\ClientSettings\ClientSetup_DefaultOptions.cmd"^
 "%StartMenu_90-Tools_DP%\91-JobComputer Setup Defaults.lnk"^
 "%JobMgr_ResIcons_DP%\ClientSetup_DefaultOptions.ico"^
 "/ViewResult"


 REM -- #New:21.10.2025/J.Fes
 Call :LinkCreate "Systool TurnedOnTimesView"^
 "%BinPublic_DP%\SysTools\TurnedOnTimesView.exe"^
 "%StartMenu_90-Tools_DP%\92-TurnedOnTimesView (View Computer Start - Reboot Infos).lnk"^
 ""^
 ""^
 ""^
 "%BinPublic_DP%\SysTools"

:Test
 REM -- #New:09.11.2025/J.Fes
 REM -- -config EverythingJobMgr.ini
 REM  "-config %ProgramData%\JobManager_V3\03-BinPublic.Settings\EverythingSearch\Everything.ini"

 Call :DirCreate Temp$_DP "%BinPublicCustom_AppSettings_DP%\EverythingSearch"

 Call :LinkCreate "Application EverythingSearch"^
 "%BinPublic_DP%\EverythingSearch\everything.exe"^
 "%StartMenu_90-Tools_DP%\93-Everything.exe (Find files quickly and conveniently).lnk"^
 ""^
 "-config %Temp$_DP%\Everything.ini"^
 ""^
 "%Temp$_DP%"

REM  Echo #Debug Li:861 %~nx0&Pause

set JobMgrToolbarAndStartLink_Org_Settings_DP=%BinPublicCustom_DP%\01-AdminInstall

 rem #New:19.12.2022/J.Fes
 Call :LinkCreate "95 - - - - - - - - - - - - - - - - - - - -"^
 "%ComSpec%"^
 "%StartMenu_90-Tools_DP%\95 - - - - - - - - - - - - - - - - - - - -.lnk"^
 "%JobMgr_ResIcons_DP%\ToolbarSeperator.ico"

 rem -- 03-BinPublic\Sysinternals\procexp.exe Link Create --
 Call :LinkCreate "Sysinternals ProcessExplorer"^
 "%BinPublic_DP%\Sysinternals\procexp64.exe"^
 "%StartMenu_90-Tools_DP%\96-Sysinternals ProcessExplorer (64).lnk"^
 ""^
 "/accepteula"^
 ""^
 "%BinPublic_DP%\Sysinternals"

 rem 16.07.2023/J.Fes removed OP /accepteula
 Call :LinkCreate "Sysinternals AutoRuns"^
 "%BinPublic_DP%\Sysinternals\autoruns64.exe"^
 "%StartMenu_90-Tools_DP%\97-Sysinternals AutoRuns (64).lnk"^
 ""^
 ""^
 ""^
 "%BinPublic_DP%\Sysinternals"

 Call :LinkCreate "Sysinternals Procmon"^
 "%BinPublic_DP%\Sysinternals\Procmon64.exe"^
 "%StartMenu_90-Tools_DP%\99-Sysinternals ProcMon (64).lnk"^
 ""^
 "/accepteula"^
 ""^
 "%BinPublic_DP%\Sysinternals"

:Test_c
 rem #New: 17.02.2024/J.Fes
:03-AutoStart
 Call :LinkCreate "Open file - JobManager_Docu_AutoStart.pdf"^
 "%MyAppl_Root_DP%\99-Install\JobMgrStartViaTaskSheduler\JobManager_Docu_AutoStart.pdf"^
 "%StartMenu_03-AutoStart_DP%\01-Open PDF JobManager_Docu_AutoStart.pdf.lnk"^
 "%JobMgr_ResIcons_DP%\pdf.ico"^
 ""^
 ""^
 "%MyAppl_Root_DP%\99-Install"

 Call :LinkCreate "Microsoft Sysinternals Autologon64.exe"^
 "%BinPublic_DP%\Sysinternals\Autologon64.exe"^
 "%StartMenu_03-AutoStart_DP%\02-Setup Win-Autologin User (via MS-Sysinternals Autologon64.exe - may need Win-Admin rights).lnk"^
 "%JobMgr_ResIcons_DP%\AutoLogin.ico"^
 "/accepteula"^
 ""^
 "%BinPublic_DP%\Sysinternals"

 rem #New: 17.02.2024/J.Fes
 Call :LinkCreate "WIN Taskplaner (taskschd.msc /s)"^
 "%%windir%%\system32\taskschd.msc"^
 "%StartMenu_03-AutoStart_DP%\03-Setup JobMgr-Autostart Custom (via WIN-Taskscheduler).lnk"^
 ""^
 "/s"^
 ""^
 "%BinPublic_DP%\Sysinternals"

 rem -- #Doc: 01.06.2024/J.Fes
 rem -- #Doc: additional Links are copied via ... copy "#LinkFile#" "%StartMenu_03-AutoStart_DP%\*"
 rem -- #Doc: to see all entries search for StartMenu_03-AutoStart_DP



 rem #New:19.12.2022/J.Fes
 Call :LinkCreate "20 - - - - - - - - - - - - - - - - - - - -"^
 "%ComSpec%"^
 "%StartMenu_90-Tools_DP%\20 - - - - - - - - - - - - - - - - - - - -.lnk"^
 "%JobMgr_ResIcons_DP%\ToolbarSeperator.ico"

 rem -- 03-BinPublic\caffeine.exe Link Create --
 Call :LinkCreate "keep host awake"^
 "%BinPublic_DP%\caffeine.exe"^
 "%StartMenu_90-Tools_DP%\21-Caffeine.lnk"^
 ""^
 ""^
 ""^
 "#temp#"


 rem -- 03-BinPublic\DotNetFrameWorkVersionChecker.exe Link Create --
 Call :LinkCreate "DotNetFrameWork Version Checker"^
 "%BinPublic_DP%\DotNetFrameWorkVersionChecker.exe"^
 "%StartMenu_90-Tools_DP%\22-DotNetFrameWork Version Checker.lnk"^
 ""^
 ""^
 ""^
 "#temp#"


 rem #New
 rem -- 03-BinPublic\DesktopRefresh.exe Link Create --
 Call :LinkCreate "refresh your desktop"^
 "%BinPublic_DP%\DesktopRefresh.exe"^
 "%StartMenu_90-Tools_DP%\23-Desktop Refresh.lnk"^
 "%JobMgr_ResIcons_DP%\DesktopRefresh.ico"^
 ""^
 ""^
 "#temp#"


 rem #New: 01.11.2016 10:31
 set PLMJobManager_Passwords_template_DPNE=%InstallTemplates_DP%\92-PLMJobManager_Passwords_Customer.kdbx
 set PLMJobManager_Passwords_Customer_DPNE=%DocCustom_01-Admin_DP%\92-PLMJobManager_Passwords_Customer.kdbx

 rem #Doc: 02.05.2017/J.Fes move existing
 if exist "%PLMJobManager_Passwords_template_DPNE%" if not exist "%PLMJobManager_Passwords_Customer_DPNE%"  (
  Echo Copy Custom Password template %PLMJobManager_Passwords_Customer_DPNE%
  copy "%PLMJobManager_Passwords_template_DPNE%" "%PLMJobManager_Passwords_Customer_DPNE%"
 )

 Call :LinkCreate "Manage JobMgr user and pw"^
 "%BinPublic_DP%\KeePass\KeePass.exe"^
 "%StartMenu_90-Tools_DP%\24-PLMJobManager Password Org via KeePass (admin).lnk"^
 ""^
 ""%PLMJobManager_Passwords_Customer_DPNE%""^
 ""^
 "%DocCustom_01-Admin_DP%"


 REM -- #New: 12.02.2019/J.Fes
 rem -- 03-BinPublic\ClipX\clipx.exe Link Create --
 Call :LinkCreate "X-ClipBord Monitor"^
 "%BinPublic_DP%\ClipX\clipx.exe"^
 "%StartMenu_90-Tools_DP%\25-ClipX ClipBord Monitor.lnk"^
 ""^
 ""^
 ""^
 "#temp#"

 REM -- #New: 19.12.2022/J.Fes
 rem -- %windir%\system32\taskschd.msc Link Create --
 Call :LinkCreate "26-WIN-Taskscheduler"^
 "%windir%\system32\taskschd.msc"^
 "%StartMenu_90-Tools_DP%\26-WIN-Taskscheduler.lnk"^
 ""^
 "/s"^
 ""^
 "#temp#"

 Call :LinkCreate "30 - - - - - - - - - - - - - - - - - - - -"^
 "%ComSpec%"^
 "%StartMenu_90-Tools_DP%\30 - - - - - - - - - - - - - - - - - - - -.lnk"^
 "%JobMgr_ResIcons_DP%\ToolbarSeperator.ico"

 set LinkFile_DPNE=%StartMenu_90-Tools_DP%\31-TC-NX-StopProcess.lnk
 Call :LinkCreate "31-TC-NX-StopProcess"^
 "%BinPublic_S_DP%\TCNXStopProcess.cmd"^
 "%LinkFile_DPNE%"^
 "%JobMgr_ResIcons_DP%\TCNXStopProcess.ico"^
 "100"^
 ""^
 "#temp#"
:Next



 REM -- #New: 19.12.2022/J.Fes
 rem -- 95-ToolsCustom\NxSyslogMonitoring --
 set LinkFile_DPNE=%StartMenu_95-ToolsCustom_DP%\51-NxSylogMonitoring - (Dura-TimeSpan - 0.1 sec).lnk
 if exist "%LinkFile_DPNE%" goto :Next
 Call :LinkCreate "51-NxSylogMonitoring - (DuraTimeSpan - 0.1 sec)"^
 "%BinPublic_S_DP%\NxSyslogMonitoring.cmd"^
 "%LinkFile_DPNE%"^
 "%JobMgr_ResIcons_DP%\NxSyslogMonitoring.ico"^
 "100"^
 ""^
 "#temp#"
:Next

 set LinkFile_DPNE=%StartMenu_95-ToolsCustom_DP%\52-NxSylogMonitoring - (Dura-TimeSpan - 0.5 sec).lnk
 if exist "%LinkFile_DPNE%" goto :Next
 Call :LinkCreate "52-NxSylogMonitoring - (DuraTimeSpan - 0.5 sec)"^
 "%BinPublic_S_DP%\NxSyslogMonitoring.cmd"^
 "%LinkFile_DPNE%"^
 "%JobMgr_ResIcons_DP%\NxSyslogMonitoring.ico"^
 "500"^
 ""^
 "#temp#"
:Next

 set LinkFile_DPNE=%StartMenu_95-ToolsCustom_DP%\53-NxSylogMonitoring - (Dura-TimeSpan - 1.0 sec).lnk
 if exist "%LinkFile_DPNE%" goto :Next
 Call :LinkCreate "53-NxSylogMonitoring - (DuraTimeSpan - 1.0 sec)"^
 "%BinPublic_S_DP%\NxSyslogMonitoring.cmd"^
 "%LinkFile_DPNE%"^
 "%JobMgr_ResIcons_DP%\NxSyslogMonitoring.ico"^
 "1000"^
 ""^
 "#temp#"
:Next

rem #New 10.11.2023/J.Fes
 set LinkFile_DPNE=%StartMenu_95-ToolsCustom_QHelp_DP%\CopyToClipBoard-01.lnk
 if exist "%LinkFile_DPNE%" goto :Next
 Call :LinkCreate "CopyToClipBoard-01"^
 "%BinPublic_DP%\CopyToClipBoard.cmd"^
 "%LinkFile_DPNE%"^
 "%JobMgr_ResIcons_DP%\CopyToClipBoard1.ico"^
 "Text1-To-ClipBoard"^
 ""^
 "#temp#"
:Next

 set LinkFile_DPNE=%StartMenu_95-ToolsCustom_QHelp_DP%\CopyToClipBoard-02.lnk
 if exist "%LinkFile_DPNE%" goto :Next
 Call :LinkCreate "CopyToClipBoard-02"^
 "%BinPublic_DP%\CopyToClipBoard.cmd"^
 "%LinkFile_DPNE%"^
 "%JobMgr_ResIcons_DP%\CopyToClipBoard2.ico"^
 "Text2-To-ClipBoard"^
 ""^
 "#temp#"
:Next


goto :eof

rem ################ JobMgr StartLinks ###############################################
:JobManagerCreateStartLinks
 rem Create's JobManager Programm Link's

 rem P1=Teilpath des Link Root Dir's neu 07.07.2010 J.Fes
 set JobMgrProgsStartMenu_DP=%StartMenu_DP%\%~1

 if "%~1" equ "." set JobMgrProgsStartMenu_DP=%StartMenu_DP%
 rem P2=JobMgrSystem 07.07.2010 J.Fes
 set JobMgrSystem=%~2
 rem bergabe ob der JobPlaner Link erzeugt werden soll
 set JobPlanerLinkDoCreate=%~3
 Echo - Create Link's.................: %JobMgrSystem% for JobServer...JobClient...JobPlaner:(%JobPlanerLinkDoCreate%)..Setup
 if not exist "%JobMgrProgsStartMenu_DP%" md "%JobMgrProgsStartMenu_DP%"
 rem 01.05.2018/J.Fes Remove 91-TestSystem .. 92-ProdSystem Link Dirs

 call :DelFilesIfExist "%JobMgrProgsStartMenu_DP%\*-Job*.lnk"
 call :DelDirIfExist "%StartMenu_DP%\91-TestSystem"
 call :DelDirIfExist "%StartMenu_DP%\92-ProdSystem"

 rem --- JobManager Start neu 07.07.2010
 rem -- LUp:17.03.2023/J.Fes
 call :DelFilesIfExist "%JobMgrProgsStartMenu_DP%\01-JobServer (%JobMgrSystem%).lnk"
REM  set JobMgr_Debug=ON
 call :DelFilesIfExist "%StartMenu_DP%\0?-JobClient (%JobMgrSystem%) Start in*Mode.*"

 Call :LinkCreate^
 "JobServer (%JobMgrSystem%) Start-1 -//- with all Tabs"^
 "%MyAppl_Root_DP%\01-BinServer\JobManagerStart.cmd"^
 "%JobMgrProgsStartMenu_DP%\01-JobServer (%JobMgrSystem%) Start-1 for work with FullControl.lnk"^
 "%JobMgr_ResIcons_DP%\JobServer.ico"^
 "/JobServer /ServerSettingsXML %JobMgrSystem%"^
 "Min"^
 "#temp#"^
 ""^
 "%JobMgrProgsStartMenu_DP%\01-JobServer (%JobMgrSystem%).lnk"


 rem -- #New: 17.03.2023/J.Fes add
 Call :LinkCreate^
 "JobServer (%JobMgrSystem%) Start-2 -//- with Object+Reports Tabs Only"^
 "%MyAppl_Root_DP%\01-BinServer\JobManagerStart.cmd"^
 "%JobMgrProgsStartMenu_DP%\01-JobServer (%JobMgrSystem%) Start-2 for work with ObjectData+Reports.lnk"^
 "%JobMgr_ResIcons_DP%\JobServer.ico"^
 "/JobServer /ServerSettingsXML %JobMgrSystem% /TabsVisible ObjectList+Reports /DefaultTab JobControl"^
 "Min"^
 "#temp#"


 rem -- #New: 17.03.2023/J.Fes add
 Call :LinkCreate^
 "JobServer (%JobMgrSystem%) Start-3 for JobControl -//- with JobControl+Scripts+ProcessGroups+Sites Tabs Only"^
 "%MyAppl_Root_DP%\01-BinServer\JobManagerStart.cmd"^
 "%JobMgrProgsStartMenu_DP%\01-JobServer (%JobMgrSystem%) Start-3 for work with JobControl.lnk"^
 "%JobMgr_ResIcons_DP%\JobServer.ico"^
 "/JobServer /ServerSettingsXML %JobMgrSystem% /TabsVisible JobControl+Scripts+ProcessGroups+Sites"^
 "Min"^
 "#temp#"

 rem -- #New: 17.03.2023/J.Fes add
 Call :LinkCreate^
 "JobServer (%JobMgrSystem%) Start-4 use DRWidx -//- for work with DRWidx"^
 "%MyAppl_Root_DP%\01-BinServer\JobManagerStart.cmd"^
 "%JobMgrProgsStartMenu_DP%\01-JobServer (%JobMgrSystem%) Start-4 for work with DRWidx.lnk"^
 "%JobMgr_ResIcons_DP%\JobServer.ico"^
 "/JobServer /ServerSettingsXML %JobMgrSystem% /DrawingIndexSearchUIShow"^
 "Min"^
 "#temp#"



 rem --- JobClient im AutoStart Mode neu 07.07.2010
 rem angepasst 07.07.2010 J.Fes
 Call :LinkCreate^
 "JobClient (%JobMgrSystem%) Start-1 in Automatic Mode"^
 "%MyAppl_Root_DP%\02-BinClient\JobManagerStart.cmd"^
 "%JobMgrProgsStartMenu_DP%\02-JobClient (%JobMgrSystem%) Start-1 in Automatic-Mode.lnk"^
 "%JobMgr_ResIcons_DP%\JobClient.ico"^
 "/JobClient /ServerSettingsXML %JobMgrSystem% /JobClientStartMode Automatic"^
 "Min"^
 "#temp#"^




 rem --- JobClient im Test Mode neu 07.07.2010
 set LinkDirSpecialMode_DP=%JobMgrProgsStartMenu_DP%
 if not exist "%LinkDirSpecialMode_DP%" md "%LinkDirSpecialMode_DP%"

 Call :LinkCreate "JobClient (%JobMgrSystem%) Start-2 in Test Mode"^
 "%MyAppl_Root_DP%\02-BinClient\JobManagerStart.cmd"^
 "%JobMgrProgsStartMenu_DP%\02-JobClient (%JobMgrSystem%) Start-2 in Test-Mode.lnk"^
 "%JobMgr_ResIcons_DP%\JobClient.ico"^
 "/JobClient /ServerSettingsXML %JobMgrSystem% /JobClientStartMode TestMode"^
 "Min"^
 "#temp#"

 Call :LinkCreate "JobClient (%JobMgrSystem%) Start-3 in Debug Mode"^
 "%MyAppl_Root_DP%\02-BinClient\JobManagerStart.cmd"^
 "%JobMgrProgsStartMenu_DP%\02-JobClient (%JobMgrSystem%) Start-3 in Debug-Mode.lnk"^
 "%JobMgr_ResIcons_DP%\JobClient.ico"^
 "/JobClient /ServerSettingsXML %JobMgrSystem% /JobClientStartMode DebugMode"^
 "Min"^
 "#temp#"

 Call :LinkCreate "JobClient (%JobMgrSystem%) Start-3 in Test + Debug Mode"^
 "%MyAppl_Root_DP%\02-BinClient\JobManagerStart.cmd"^
 "%JobMgrProgsStartMenu_DP%\02-JobClient (%JobMgrSystem%) Start-4 in Test+Debug-Mode.lnk"^
 "%JobMgr_ResIcons_DP%\JobClient.ico"^
 "/JobClient /ServerSettingsXML %JobMgrSystem% /JobClientStartMode TestDebugMode"^
 "Min"^
 "#temp#"

 Echo - Copy JobMgr Start Links to....: %JobMgrProgsStartMenu_DP%
 copy "%JobMgrProgsStartMenu_DP%\*.lnk" "%StartMenu_DP%\*.*" >nul

 call :DelFilesIfExist "%LinkDirSpecialMode_DP%\02-JobClient (%JobMgrSystem%) [StartMode 3-PauseMode].lnk"


rem --- JobPlaner Start neu 07.07.2010 ---------------------------------------
 if /I "%JobPlanerLinkDoCreate%" neq "YES" goto :Next
 Call :LinkCreate "JobPlaner (%JobMgrSystem%)"^
 "%MyAppl_Root_DP%\01-BinServer\JobManagerStart.cmd"^
 "%JobMgrProgsStartMenu_DP%\10 -JobPlaner (%JobMgrSystem%).lnk"^
 "%JobMgr_ResIcons_DP%\JobPlaner.ico"^
 "/JobPlaner /ServerSettingsXML %JobMgrSystem%"^
 "Min"^
 "#temp#"
:Next

 rem --- JobManager SETUP neu 07.07.2010 ---------------------------------------
 set LinkFile_DPNE=%JobMgrProgsStartMenu_DP%\90-JobServer (%JobMgrSystem%) Setup.lnk
 Call :LinkCreate "JobServer (%JobMgrSystem%) Setup"^
 "%MyAppl_Root_DP%\01-BinServer\JobManagerStart.cmd"^
 "%LinkFile_DPNE%"^
 "%JobMgr_ResIcons_DP%\JobServer_Setup.ico"^
 "/JobServer /Setup /ServerSettingsXML %JobMgrSystem%"^
 "Min"^
 "#temp#"


 REM #LUp: 01.05.2018/J.Fes reor start links for Update
 rem call :DelFilesIfExist "%StartMenu_01-Install_DP%\*JobServer*Setup.lnk"
 REM #DOC: copy 21 JobServer (%JobMgrSystem%) Setup.lnk into 01-Install menu
 copy  "%LinkFile_DPNE%" "%StartMenu_01-Install_DP%\21-JobServer (%JobMgrSystem%) Setup.lnk"
 call :DelFilesIfExist "%JobMgrProgsStartMenu_DP%\91-JobComputer Setup Defaults.lnk"
goto :eof

rem ----------------------------------------------------------------------------------
:StartMenuCreateDone
 Call :DesktopRefresh
 if /I "%Quiet%" equ "true"  goto :eof
 Call ColorSet.cmd OK
 Echo.
 Echo --------------------------------------------------------------------------------
 Echo Result created startmenu:
 Echo  "%StartMenu_DP%"
 Echo.
 Echo Info:
 Echo Explorer will start with the created startmenu
 Pause
 start "" explorer.exe /e,%StartMenu_DP%
 goto :eof


rem ##### ----------------- Standard Subroutines ------------------------ ######


:PathCutLastDir
 rem schneidet das letzte Verzeichniss Uebergeben path ab
 rem P1 = Name der Variablen
 rem P2 = der bergebene Path
 rem Example : call :PathCutLastDir EntwRoot_LP %~dp0
 rem Example : call :PathCutLastDir MyVar %~dp0

 set PathCutLastDir$temp=%~2
 set PathCutLastDir$tempLastChar=%PathCutLastDir$temp:~-1%
 set PathCutLastDir$tempNoBacks=%PathCutLastDir$temp:~0,-1%

 if "%PathCutLastDir$tempLastChar%"=="\" (
   rem "\" abschneiden wenn vorhanden
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$tempNoBacks%
 ) else (
   rem
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$temp%
 )
 set PathCutLastDir$tempRes=%PathCutLastDir$tempRes:~0,-1%
 set %1=%PathCutLastDir$tempRes%
 set PathCutLastDir$temp=
 set PathCutLastDirDo$temp1=
 set PathCutLastDir$tempNoBacks=
 set PathCutLastDir$tempNoLastChar=
 set PathCutLastDir$tempLastChar=
 set PathCutLastDir$tempRes=
 goto :eof

:PathCutLastDirDo
 rem hiermit schneiden wir den Path ab
 rem echo.
 rem Echo P1=%1 P2=%2
 set PathCutLastDirDo$temp=%~dp2
 rem "\" abschneiden
 set PathCutLastDirDo$temp1=%PathCutLastDir$temp:~0,-1%
 set %1=%PathCutLastDirDo$temp%
 set PathCutLastDirDo$temp=
 set PathCutLastDirDo$temp1=
 goto :eof

rem ============================================================================
:PathRootDirTP
 REM  #New 22.02.2016/J.Fes
 rem parses from DIR last path section and sets value to:%1
 set %1=%~n2
goto :eof

rem ============================================================================
:DirDefineAndCreateIfNotExist
 rem #Exa: Call Call :DirDefineAndCreateIfNotExist DocCustom_DP "%MyAppl_Root_DP%\11-Documentation.Custom
 if "%~2" equ "" goto :MyERR1
 set %~1=%~2
 if exist "%~2" goto :MyEnd
 Echo - Create dir....................: %~2
 md "%~2"
 goto :MyEnd

:MyERR1
 Call ColorSet.cmd ERR
 Echo --------------------------------------------------------------------------------
 Echo - ERR in ......................: Call: %0
 Echo - Info handover Parameters.....: %*
 Echo - Issue missing Parameter......: P1 or P2
 Echo --------------------------------------------------------------------------------
 Echo - ToDo.........................: Please fix issue cannot continue
 Echo - ToDo.........................: after pressing the Enter key the script is terminated
 Echo.
 Pause
 Exit
 goto :MyEnd
:MyEnd
 goto :eof



:DelFilesIfExist
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
  Echo #Debug: %0
  Echo #Debug: %~1
  Dir  "%~1"
  pause
:JumbOverDebug

 if not exist "%~1" goto :DelFilesIfExistEnd
 Echo - Delete files..................: %~1
 del "%~1"
 goto :DelFilesIfExistEnd
:DelFilesIfExistEnd
goto :eof

:DelDirIfExist
 if not exist "%~1" goto :DelDirIfExistEnd
 Echo - Delete dir....................: %~1
 rd /s /q "%~1"
 goto :DelDirIfExistEnd
:DelDirIfExistEnd
 goto :eof

:CleanDirIfExist
 REM #New: 18.10.2019/J.Fes
 if not exist "%~1" goto :CleanDirIfExistEnd
 Echo - CleanUp dir...................: %~1\*.*
 del /s /q "%~1\*.*" >nul
 goto :CleanDirIfExistEnd
:CleanDirIfExistEnd
 goto :eof

:DelHiddenDirIfExist
 dir /A:H "%~1" 1>nul 2>>nul
REM  Echo Errorlevel=%Errorlevel%
 if /I "%Errorlevel%"  equ "0" (
REM  Echo HIDDEN Dir "%~1" exist
 Echo - Delete hidden dir.............: %~1
 rd /s /q "%~1"
 )
 goto :eof

:ArchivIfExist
 rem usage CALL :ArchivIfExist  "%Source_DPNE%"  "%Dest_DP%"  "%Dest_NE%"
 if not exist "%~1" goto :ArchivIfExistEnd

 set Source_DPNE=%~1
 set Dest_DP=%~2
 set Dest_NE=%~3
 set Dest_DPNE=%Dest_DP%\%Dest_NE%
 Echo -----^> Archiv File: ["%~1"]
 Echo  from............................: %Source_DPNE%
 Echo  to..............................: %Dest_DPNE%
 if not exist "%Dest_DP%" md "%Dest_DP%"
 move "%Source_DPNE%" "%Dest_DPNE%"

 goto :ArchivIfExistEnd
:ArchivIfExistEnd
 goto :eof

rem ============================================================================
:DesktopRefresh
 rem #New:22.02.2016/J.Fes
 Rem #Doc:refeshes the desktop
 Call "%BinPublic_DP%\DesktopRefresh.exe"
goto :eof
rem ============================================================================
:ColorSet
Rem Stand 25.06.2011
Rem Examples:
 REM Call ColorSet.cmd Standard
 REM Call ColorSet.cmd IsExecuting
 REM Call ColorSet.cmd IsIdel
 REM Call ColorSet.cmd End
 REM Call ColorSet.cmd Ende
 REM Call ColorSet.cmd Ok
 REM Call ColorSet.cmd Err

 rem -- cmd Color Farbinfo:
 REM    0 = Schwarz        8 = Dunkelgrau
 REM    1 = Dunkelblau     9 = Blau
 REM    2 = Dunkelgrn     A = Grn
 REM    3 = Blaugrn       B = Zyan
 REM    4 = Dunkelrot      C = Rot
 REM    5 = Lila           D = Magenta
 REM    6 = Ocker          E = Gelb
 REM    7 = Hellgrau       F = Wei
 rem -- Farben nach Status setzen
 rem Gelb Schwarz
 if /I "%~1" equ "Standard"    set JobColorLast=E0
 rem 25.06.2011 07:00 Standard eingef. IsExecuting Neu
 if /I "%~1" equ "IsExecuting" set JobColorLast=D0
 rem Blaugrn Schwarz 15.11.2010 07:45 Hellgrau Schwarz
 if /I "%~1" equ "IsIdel"      set JobColorLast=70
 rem Hellgrau Schwarz
 if /I "%~1" equ "End"         set JobColorLast=70
 if /I "%~1" equ "Ende"        set JobColorLast=70
 rem Gruen Schwarz
 if /I "%~1" equ "Ok"          set JobColorLast=A0
 rem Rot Schwarz
 if /I "%~1" equ "Err"         set JobColorLast=C0
 if /I "%~1" equ "Dialog"      set JobColorLast=3F

 rem jetzt die Farbe setzen
 if not "%JobColorLast%"=="" color %JobColorLast%
 goto :eof
rem ============================================================================

:LinkCreate
 rem #New: 01.03.2021/J.Fes
 rem #LUp: 17.03.2023/J.Fes P9 = delete link
 rem #Doc: Create the Link via

 setlocal

REM  rem Doku:
REM  jfShellLinkCreate /LinkFile="c:\path\to\linkfile.lnk"
REM                   /LinkDest="c:\path\to\destfile.exe"
REM                  [/Arguments="/Option1 /Option2"]
REM                  [/WorkDir="c:\path\to\"]
REM                  [/IconFile="c:\path\to\iconfile.ext"]
REM                  [/DisplayMode="Normal|Max|Min"]
REM                  [/Description="Kommentar"]
REM                  [/Quiet] (keine Konsolenausgaben)

REM   Echo On
 set Description=%~1
 set LinkDest_DPNE=%~2
 set LinkFile_DPNE=%~3
 set LinkFile_NE=%~nx3
 set IconFile_DPNE=%~4
 set Arguments=%~5
REM  if "%Arguments%" neq "" set Arguments=%Arguments:'=""%
REM  if "%~5" neq "%Arguments%" Echo "Arguments=%Arguments%"&Pause
 set DisplayMode=%~6
 set WorkDir=%~7
 set FolderLink=%~8

REM  set EnvVarXX=%EnvVarXX:~0,12%
 rem #Doc: Example replace ']' with '_'
REM  set EnvVarXX=%EnvVarXX:]=_%

 rem 17.03.2023
REM  if "%Arguments%" equ "" goto :Next
REM  Echo Arguments before=%Arguments%
REM  set Arguments=%Arguments:''="%
REM  Echo Arguments after=%Arguments%
REM  pause

:Next
 rem set /p= - Check File exist .............: %~1 <nul
 Echo - Create Link for...............: %Description%
 rem Echo - IconFile......................: %IconFile_DPNE%
 if not exist "%LinkDest_DPNE%" goto :ErrExit

 set toRun=jfShellLinkCreate.exe /Quiet
 set toRun=%toRun% /LinkFile="%LinkFile_DPNE%"
 set toRun=%toRun% /LinkDest="%LinkDest_DPNE%"
 if "%IconFile_DPNE%" neq "" set toRun=%toRun% /IconFile="%IconFile_DPNE%"
REM  Echo 1276 %Arguments%
REM  pause
 if "%Arguments%"     neq "" set toRun=%toRun% /Arguments="%Arguments%"
REM  pause
 if "%DisplayMode%"   neq "" set toRun=%toRun% /DisplayMode="%DisplayMode%"

 if "%WorkDir%"       equ "" goto :next
 if "%WorkDir:~0,1%"  equ "#" Call :WorkDirSetValue
 if "%WorkDir%"       neq "" set toRun=%toRun% /WorkDir="%WorkDir%"
 :Next
 if "%Description%"   neq "" set toRun=%toRun% /Description="%Description%"
 if "%FolderLink%"    neq "" set toRun=%toRun% /FolderLink

 %toRun%
 goto :MyExit

 :ErrExit
 Echo - ERR Create Link file/dir nf...: '%LinkDest_DPNE%'
 Echo - please check..................: Installation
 Pause
 :MyExit
 endlocal
goto :eof

:WorkDirSetValue
 set WorkDir=%WorkDir:#=%
 set PChar=%%%
 set WorkDir=%PChar%%WorkDir%%PChar%
 goto :eof

rem ----------------------------------------------------------------------------
:LinkCreate_URL
 rem Usage
 rem call :LinkCreate_URL "%DestFile_DPNE%" "%URL%" "%Icon%"
 set Link_NE=%~nx1
 set Link_DPNE=%~1
 set URL=%~2
 set Icon=%~3
 Echo - Create URL for................: %Link_NE%

 echo [InternetShortcut] >"%Link_DPNE%"
 echo URL=%URL% >>"%Link_DPNE%"
 echo IconFile=%Icon% >>"%Link_DPNE%"
 echo IconIndex=0 >>"%Link_DPNE%"
goto :eof

:DirCreate
 if not exist "%~2" md "%~2"
 set %1=%~2
 goto :eof

rem ============================================================================
:Ende
 exit /B
