 REM -- #Doc: Inits all Basics of Job
 REM -- #New: 08.02.2017/J.Fes           first version
 REM    #LUp: 15.03.2023/J.Fes           move set robocopy_opt=/R:5 /W:1 add beginning
 REM    #LUp: 29.06.2023/J.Fes           add Start JobMgr_start_ProcExp
 REM    #LUp: 26.09.2023/J.Fes           call "%~dp0Parse_Absolut_DP.cmd" BinL_DP
 REM    #LUp: 02.11.2023/J.Fes           add Env JobRuleSelObjByPStat #Doc:to get Object selected by P.Stat
 REM    #LUp: 21.02.2024/J.Fes+S.Geuth   Soure folder for JobProcess tools moved from:'%BinPublic%' to:'%BinPublic_ClientServer_DP%'
 REM    #LUp: 24.03.2024/J.Fes           add Env JobRuleScriptParaName
 REM    #LUp: 05.09.2024/J.Fes           add JobMgrDefaultScriptsVer
 REM    #LUp: 01.10.2024/J.Fes           add JobRuleProcStateColDisplayText

 REM -- #Doc: all Parameter P1..P5 must be set
 REM    P1 JobTitel                   sets JobTitel for cmd window
 REM    P2 DoUpdate BinL              YES/NO
 REM    P3 DoUpdate BinL inc. Oracle  YES/NO
 REM    P4 Start WatchDog             YES/NO
 REM    P5 Start TaskMgr              YES/NO
 REM    P6 Start SysInt procexp64.exe YES/NO
 REM    #Doc: Do not set for P5=YES + P6=YES at the same time because then TaskMgr and procexp64.exe is excuting at the same time
 REM -- Usage: Call "%~dp0_JobInitial.cmd" "#Titel#" "YES" "YES" "YES" "NO" "YES"

 REM -- set root path ---------------------------------------------------------
REM  CHCP 65001

 rem #New:06.09.2024 contains latest Version info
 set JobMgrDefaultScriptsVer=2024-09-06-01

 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 cd /D "%CmdCurRoot_DP%"
 set BinL_DP=%CmdCurRoot_DP%\..\BinL
 call "%~dp0Parse_Absolut_DP.cmd" BinL_DP "%CmdCurRoot_DP%\..\BinL\"
 if not exist "%BinL_DP%" md "%BinL_DP%"
 Call Echo "BinL dir........................: %BinL_DP%"

 REM -- #Step: set color Init
 call "%CmdCurRoot_DP%\ColorSet" "Init"

 if "%~5" equ "" (
   call %~dp0ColorSet ERR
   Call %~dp0Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
   Call %~dp0Echo "Missing required Para5 in.......: '%~0'"
   Call %~dp0Echo "please check....................: calling script"
   Call %~dp0Echo "END.............................: script stops Job via EXIT"
   Pause
   Exit
 )

 set robocopy_opt=/R:5 /W:1
 set JobTitleB=%~1
 set JobMgr_JobInitial_DoUpdBinL=%~2
 set JobMgr_JobInitial_DoUpdORABinL=%~3
 set JobMgr_start_PLMJobManagerWatchDog=%~4
 set JobMgr_start_TaskMgr=%~5
 set JobMgr_start_ProcExp=%~6

 REM -- temp dir Organisieren -------------------------------------------------
 set tempOrig_DP=%temp%
 set temp=%CmdCurRoot_DP%
 set tmp=%temp%

 REM -- JobServer Variablen ----------------------------------------------------
 set JobManagerRoot_DP=#00-ApplRoot_DP#
 set BinServer_DP=#01-BinServer_DP#
 set BinServer_Custom_DP=#01-BinServer_DP#.Custom
 set BinClient_DP=#02-BinClient_DP#
 set BinClient_Custom_DP=#02-BinClient_DP#.Custom

 set BinPublic_DP=#03-BinPublic_DP#
 set BinPublic_Custom_DP=#03-BinPublic_Custom_DP#
 set BinPublic_ClientServer_DP=#03_BinPublic_ClientServer_DP#

 set JobScriptTemplateMinus1_DP=#JobScriptTemplateMinus1_DP#
 set JobServerScripts_DP=#40-JobServerScripts_DP#
 set JobMgr_TcPwFile_NE=#TcPwFile_NE#
 set JobMgr_JobCreationDT=#DateTimeNow_DDMMYYYYHMS#
 rem #Exa: 2022-07-05_09h15m24s
 set JobMgr_JobCreationDT_ForFileExtend1=#DateTimeNow_ForFileExtend#
 rem #Exa: 20220705-091524
 set JobMgr_JobCreationDT_ForFileExtend2=#DateTimeNow_yyyy-MM-dd-HH-mm#
 set JobMgr_JobCreationDT_ForFileExtend3=#DateTimeNow_yyyyMMdd-HHmmss#
 set $DateTimeNowFileExt=#DateTimeNow_yyyy-MM-dd-HH-mm#

 REM -- JobData ----------------------------------------------------------------
 set JobScripts_DP=#10-JobScripts_DP#
 set JobName=#JobName#
 set JobRuleName=#JobRule.JobName#
 set JobRuleSelObjByPStat=#JobRule.SelObjectsBy_ProcStateVal#
 set JobRuleProcStateColDisplayText=#JobRule.ProcStateColDisplayText#
 set JobRuleScriptParaName=#JobRule.JobScriptName#

 set JobPacket_NE=#JobPacket_NE#
 set JobParameter=#JobParameter#
 set JobMgrDataOrg_Root_DP_Custom=#12-Data#
 set JobMgrDataOrg_Root_DP=#12-Data#\Archiv

 rem -- Defaults TC Prompt Data root
 if exist "%CmdCurRoot_DP%\TcPrompt_Custom.cmd" set TcPrompt_Custom_DPNE=%CmdCurRoot_DP%\TcPrompt_Custom.cmd
 if exist "%CmdCurRoot_DP%\NxPrompt_Custom.cmd" set NxPrompt_Custom_DPNE=%CmdCurRoot_DP%\NxPrompt_Custom.cmd

 REM -- uebergabe SiteDef ------------------------------------------------------
 set TcSiteId=#TcSiteId#

 REM -- default Debug and Test
 set JobMgr_Debug=OFF
 set JobMgr_Test=OFF

 REM --------## add JC.script(cmd).ParmaExt Start ##----------------------------
#JobScriptParametersExtended#
 REM --------## add JC.script(cmd).ParmaExt End ##------------------------------

 rem -- #New:24.03.2023/J.Fes moved down after BinPublic_DP is set
 rem -- #LUp: 21.02.2024/J.Fes+S.Gueth Soure folder for JobProcess tools moved from:'%BinPublic%' to:'%BinPublic_ClientServer_DP%'
 if exist "%BinPublic_ClientServer_DP%\JobMgrCMDHelper.exe" (
   set JobMgr_HelperToolsSource_DP=%BinPublic_ClientServer_DP%
 ) else (
   set JobMgr_HelperToolsSource_DP=%BinPublic_DP%
 )
 Call Echo "RunLogged PMon PLMWatchDoc from.: %JobMgr_HelperToolsSource_DP%"
 robocopy %robocopy_opt% /S /NP /NJS /NJH /NDL /NFL "%JobMgr_HelperToolsSource_DP%" "%BinL_DP%" RunLogged.exe JFProcessMonitor.exe PLMJobManagerWatchDog.exe Banner.exe delage64.exe JobMgrCMDHelper.exe >nul 2>nul

 set RunLoggedL_DPNE=%BinL_DP%\RunLogged.exe
 set JFProcessMonitorL_DPNE=%BinL_DP%\JFProcessMonitor.exe
 set PLMJobManagerWatchDogL_DPNE=%BinL_DP%\PLMJobManagerWatchDog.exe
 set BannerL_DPNE=%BinL_DP%\Banner.exe
 set JobMgrCMDHelper_L=%BinL_DP%\JobMgrCMDHelper.exe


 rem -- #Doc: get if exist JobMgr_TcPwFile_DPNE
 if "%JobMgr_TcPwFile_NE%" equ "" goto :Next
 if exist "%CmdCurRoot_DP%\%JobMgr_TcPwFile_NE%" set JobMgr_TcPwFile_DPNE=%CmdCurRoot_DP%\%JobMgr_TcPwFile_NE%
 Call Echo "#Debug JobMgr_TcPwFile..........: %JobMgr_TcPwFile_DPNE%"
 Call Echo "#Debug JobMgr_TcPwFile_DPNE.....: %JobMgr_TcPwFile_DPNE%"
 goto :Next

:Next

 REM -- PathVariable erweitern
 Call "%CmdCurRoot_DP%\PathEnvAddPath.cmd" "%BinPublic_DP%"
 Call "%CmdCurRoot_DP%\PathEnvAddPath.cmd" "%BinPublic_ClientServer_DP%"
 Call "%CmdCurRoot_DP%\PathEnvAddPath.cmd" "%CmdCurRoot_DP%"

 call Parse_Absolut_DP.cmd BinL_DP "%CmdCurRoot_DP%\..\BinL\"
 Call "%CmdCurRoot_DP%\PathEnvAddPath.cmd" "%BinL_DP%"

 if /i "%JobMgr_Test%" neq "ON" goto :JumbOverTest
  set JobTitleB=%JobTitleB%[Test:%JobMgr_Test%]
  Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
  Call Banner Test:%JobMgr_Test%
  Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
:JumbOverTest

 REM -- set JobTitle -----------------------------------------------------------
 set JobTitleB=%JobTitleB%[%JobName%]
 set JobTitle=%JobTitleB%[%Date% %time:~0,5%][\\%ComputerName%]
 title %JobTitle%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
  Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
  Banner Debug:%JobMgr_Debug%
  Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
  Call Echo "#JobMgr_JobInitial..............: List of parameters"
  Call Echo "#P1 JobTitleB...................: %JobTitleB%"
  Call Echo "#P2 Do update BinL..............: %JobMgr_JobInitial_DoUpdBinL%"
  Call Echo "#P3 Do update ORA BinL..........: %JobMgr_JobInitial_DoUpdORABinL%"
  Call Echo "#P4 Start WatchDog..............: %JobMgr_start_PLMJobManagerWatchDog%"
  Call Echo "#P5 JobMgr_start_TaskMgr........: %JobMgr_start_TaskMgr%"
  Call Echo "#A1 Start Explorer..............: %CmdCurRoot_DP%"
 rem  Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
:JumbOver

 Call Echo "----------------------------------------------------------------------------"
 Call Echo "Job Initial for.................: %JobTitle%"
 Call Echo "Job uses JobRuleName............: %JobRuleName%"
 Call Echo "Job Data select by P.Group......: %JobRuleProcStateColDisplayText%"
 Call Echo "Job Data selected O.P.Status....: %JobRuleSelObjByPStat%"
 Call Echo "Job BinL_DP.....................: %BinL_DP%"
 Call Echo "Job settings....................: [BinL:%JobMgr_JobInitial_DoUpdBinL%][Ora:%JobMgr_JobInitial_DoUpdORABinL%][Debug:%JobMgr_Debug%][Test:%JobMgr_Test%]"



 if /I "%JobMgr_JobInitial_DoUpdBinL%" neq "YES" goto :JobMgr_JobInitial_DoUpdBinL_NO

 rem -- #Step: JobMgr CmdTools local kopieren --------------------
 set JobManagerCmdTools_L=%BinL_DP%\JobManagerCmdTools.exe
 Call Echo "JobManagerCmdTools from.........: %BinPublic_ClientServer_DP%"
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%BinPublic_ClientServer_DP%" "%BinL_DP%" "JobManagerCmdTools.*">nul 2>nul


 REM -- #NEW:08.02.2017/J.Fes Check if Update ORA Client ---------
if /I "%JobMgr_JobInitial_DoUpdORABinL%" neq "YES" goto :JobMgr_JobInitial_DoUpdORABinL_NO

 rem  -- OraClient  to:[%BinL_DP%\OraClient] ----
 set OraClient_DP=%BinL_DP%\OraClient
 set OraClient_S_DP=%BinPublic_DP%\OraClient\64Bit
 if exist "%BinPublic_Custom_DP%\OraClient" set OraClient_S_DP=%BinPublic_Custom_DP%\OraClient

 Call Echo "Oracle Client .dlls from........: %OraClient_S_DP%"
 robocopy %robocopy_opt% /S /NP /NJS /NJH /NDL /NFL "%OraClient_S_DP%" "%OraClient_DP%\64Bit">nul 2>nul

:JobMgr_JobInitial_DoUpdORABinL_NO
:JobMgr_JobInitial_DoUpdBinL_NO

 REM -- Option: Control software starten ---------------------------------------
 if /I "%JobMgr_start_PLMJobManagerWatchDog%" neq "YES" goto :JumbOver
   pushd "%BinL_DP%"
   call "ProgStart_If_NotRuning.cmd" "PLMJobManagerWatchDog" "%PLMJobManagerWatchDogL_DPNE%"
   popd
:JumbOver

 rem -- #Doc: Check Start: TaskMgr.exe #LUp: 10.02.2021
 if /I "%JobMgr_start_TaskMgr%" neq "YES" goto :JumbOver
  pushd "%BinL_DP%"
  call "ProgStart_If_NotRuning.cmd" "TaskMgr" "taskmgr.exe"
  popd
:JumbOver

 rem -- #Doc: Check Start: Sysinternals procexp64.exe #New:29.06.2023/J.Fes
 if /I "%JobMgr_start_ProcExp%" neq "YES" goto :JumbOver
  robocopy /R:5 /W:1 /S /NP /NJS /NJH /NDL /NFL "%BinPublic_DP%\Sysinternals" "%BinL_DP%" procexp64.exe >nul 2>nul
  pushd "%BinL_DP%"
  call "ProgStart_If_NotRuning.cmd" "procexp64" "%BinL_DP%\procexp64.exe"
  popd
:JumbOver

 REM #New: 10.08.2022/J.Fes
 set JobMgrProcessIcon_DPNE=%CmdCurRoot_DP%\zzProcess.ico
 if exist "%JobMgrProcessIcon_DPNE%" call "%JobMgrCMDHelper_L%" -Quiet -SetConsoleIcon_DPNE "%JobMgrProcessIcon_DPNE%"


if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
 call Echo "---------------------------------------------------------------------------"
 Call Echo "#Debug Start Explorer in JobRoot: %CmdCurRoot_DP%"
 start "" Explorer "%CmdCurRoot_DP%"
 timeout /T:2
 call Echo "---------------------------------------------------------------------------"
 call Echo "#Debug End of ..................: %~0"
 pause
:JumbOverDebug

