@Echo off

REM ----------------------------------------------------------------------------
REM #Description: Script for purge fccCashe and reorg FCC_CacheLocation dir
REM #New: 07.02.2017 /J.Fes first version
REM ----------------------------------------------------------------------------

setlocal

rem --#toDo: setup default "#TcSiteId#"
set TcSiteId=

 rem --#Doc: Check if P1 = TcSiteId is given by command line
 if "%~1"        neq "" set TcSiteId=%~1
 if "%~2"        neq "" set ProcessMode=%~2
 if "%TcSiteId%" neq "" goto :Start

 rem #Doc: script section below is for check if Edit is done
 Echo ---------------------------------------------------------------------------
 Echo befor use please setup:
 Echo %0
 Echo after Return Edit of stript starts with Notepad
 pause
 start "Edit '%~0'" Notepad "%~0"
 exit
 Echo ---------------------------------------------------------------------------


:Start
 rem --#Doc: set path
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 @cd /d "%temp%"
 Echo ---------------------------------------------------------------------------
 call %CmdCurRoot_DP%\fccPurge.cmd "%TcSiteId%" "%ProcessMode%"

 Echo ---------------------------------------------------------------------------
 Call :fccXMLReorg
 Echo ---------------------------------------------------------------------------
 Echo fcc performe -kill on \\%ComputerName%
 call fccstat -kill
 Echo fcc performe -restart on \\%ComputerName%
 call fccstat -restart
 Echo ---------------------------------------------------------------------------
 Echo fcc status after restart on \\%ComputerName%
 call fccstat -config
 call fccstat -x
 Echo fcc fcc.xml config file.........: %FCC_D_DPNE%
 Echo TC_FCC_CacheLocation is now.....: %TC_FCC_CacheLocation_DP%
 if /I "%ProcessMode%" neq "BATCH" start "" Explorer.exe "%TC_FCC_CacheLocation_DP%\%username%"
 Echo ---------------------------------------------------------------------------
 Echo fcc purge and reconfig..........: DONE %Date% %time%
 Echo ---------------------------------------------------------------------------
 if /I "%ProcessMode%" neq "BATCH" pause

 goto :end

rem ----------- SUB ROUTINES ---------------------------------------------------
:fccXMLReorg
 set BinPublic_DP=%CmdCurRoot_DP%\..\..\..\..\03-BinPublic
 set FCC_S_DPNE=%CmdCurRoot_DP%\fcc_%TcSiteId%.xml

 if not exist "%FCC_S_DPNE%" (
   Echo !!!-- ERROR Check settings --!!!
   Echo missing fcc.xml tempalte........: "%FCC_S_DPNE%"
   if /I "%ProcessMode%" neq "BATCH"  pause
   goto :eof
 )

 set FCC_Backup_DPNE=%CmdCurRoot_DP%\fcc_%computername%_backup.xml
 set FCC_T_DPNE=%CmdCurRoot_DP%\fcc_%computername%_temp.xml
 rem FMS_HOMEC:\CPD\PROD2T\tccs
 set FCC_D_DPNE=%FMS_HOME%\fcc.xml
 if not exist "%FCC_Backup_DPNE%" copy "%FCC_D_DPNE%" "%FCC_Backup_DPNE%"

 rem -- #Doc: define FCC_CacheLocation see also
 rem          see also \fcc.xml property name="FCC_CacheLocation" value="$TC_FCC_CacheLocation_DP|/tmp/FCCCache" overridable="true"
 if exist E:\ (
   set TC_FCC_CacheLocation_DP=E:\FCCCache_%TcSiteId%
   goto :next
 )
 if exist D:\ (
   set TC_FCC_CacheLocation_DP=D:\FCCCache_%TcSiteId%
   goto :next
 )
 set TC_FCC_CacheLocation_DP=C:\FCCCache_%TcSiteId%
 if not exist "%TC_FCC_CacheLocation_DP%" md "%TC_FCC_CacheLocation_DP%"

:next
 rem replace $TC_FCC_CacheLocation_DP
 set toRun="%BinPublic_DP%\SearchReplaceInTextFile.exe"
 set toRun=%toRun% /FileSource_DPNE "%FCC_S_DPNE%"
 set toRun=%toRun% /FileDest_DPNE "%FCC_T_DPNE%"
 call %toRun% /SearchStr "$TC_FCC_CacheLocation_DP" /ReplaceStr "%TC_FCC_CacheLocation_DP%"
 Echo TC_FCC_CacheLocation............: %TC_FCC_CacheLocation_DP%
 set toRun=copy "%FCC_T_DPNE%" "%FCC_D_DPNE%"
 Echo Update fcc.xml..................: via %toRun%
 %toRun%
 goto :eof


rem ----------------------------------------------------------------------------
:end
endlocal
