@Echo off

REM ----------------------------------------------------------------------------
REM #Description: Script for purge fccCashe
REM #New: 21.09.2016 /J.Fes first version
REM #LUp: 07.02.2017 /J.Fes update to new version of TcPrompt_Custom.cmd
REM ----------------------------------------------------------------------------

CHCP 1252


rem --#toDo: setup default "#TcSiteId#"
set TcSiteId=TCIDXXX

rem --#Doc: Check if P1 = TcSiteId is given by command line
if "%~1"        neq "" set TcSiteId=%~1
if "%~2"        neq "" set ProcessMode=%~2
if "%TcSiteId%" neq "" goto :Start


:Start
 rem --#Doc: set path
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%
 set path=%CmdCurRoot_DP%;%CmdCurRoot_DP%\..\_CustomDefaults\TcPrompt;%CmdCurRoot_DP%\..\_JobMgrDefaults;%path%

 call ColorSet "ExtractLi"

 @cd /d "%temp%"
 set TCPrompt_Custom_Opt=TCOnly
 Echo ---------------------------------------------------------------------------
 Echo before get tc prompt for %TcSiteId%
REM  Dir  "%CmdCurRoot_DP%\..\_CustomDefaults\TcPrompt\TcPrompt_Custom.cmd"
 Call "%CmdCurRoot_DP%\..\_CustomDefaults\TcPrompt\TcPrompt_Custom.cmd" "%TcSiteId%"
 Echo ---------------------------------------------------------------------------
 Echo after get tc prompt for %TcSiteId%

 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%
 set PLMEasy_BIN_DP=%CmdCurRoot_DP%\bin

 call ColorSet "IsExecuting"

 set path=%PLMEasy_BIN_DP%;%path%
 set tcpb_auto_checkin_exe=%PLMEasy_BIN_DP%\tcpb_auto_checkin.exe
 call cmdUti_DateTimeNowGet.cmd

 set DoCheckInIsActiv=NO

 if /I "%DoCheckInIsActiv%" neq "YES" (
  set Log_DP=%CmdCurRoot_DP%\Log-%$DateTimeNowFileExt%-DoCiNo
  set CiActionTxt=CI will NOT be done because '-Dryrun' Is Used
 ) ELSE (
  set Log_DP=%CmdCurRoot_DP%\Log-%$DateTimeNowFileExt%-DoCiYes
  set CiActionTxt=CI will be done and is active
 )

 if not exist "%Log_DP%" md  "%Log_DP%"
 set TC_TMP_DIR=%Log_DP%
 set TC_KEEP_SYSTEM_LOG=TRUE


:RedoCI
 rem set toRun="%tcpb_auto_checkin_exe%" -u=infodba -p=infodba -g=dba -all -dryrun -types="UGPART,UGMASTER" -from_date="12-Dec-2021" -log="%Log1_DPNE%"
 REM  set toRun="%tcpb_auto_checkin_exe%" -u=infodba -p=infodba -g=dba -group="" -types="UGPART,UGMASTER,BOMView Revision" -dryrun -log="%Log1_DPNE%"
 rem #Doc: 07.12.2022/J.Fes/as defined by PartUpdate Team now using setting:
 set BMF_BYPASS_ALL_EXTENSION_RULES=ON
 set BYPASS_RULES=ON
 rem #Doc: 11.12.2022/J.Fes add New
 set AM_BYPASS=ON
 REM -group= 1D8;1D4;200.1D1   refile_userX$Xsmac
 rem Call :tcpb_auto_checkin_Execute "CustomGr01" "01-Jan-2000"  "13-Jun-2023"
 rem Call :tcpb_auto_checkin_Execute "CustomGr02" "01-Jan-2000"  "31-May-2023"
 Call :tcpb_auto_checkin_Execute "CustomGr02" "01-Jan-2000"  "31-May-2023"
 rem Call :tcpb_auto_checkin_Execute "200.1D1" "01-Jan-2000"  "13-Jun-2023"

REM  Timeout /T 5
REM  exit
REM  goto :RedoCI
REM  if /I "%ProcessMode%" neq "BATCH" pause
 call ColorSet "End"
 Pause
 Exit

 goto :eof

 rem ---------------------------------------------------------------------------
:tcpb_auto_checkin_Execute
 rem Exa:
 set CiGroup_N=%~1
 set CiFromDate=%~2
 set CiToDate=%~3

 set titleTxt=CI:[Action:%CiActionTxt%][GR:%CiGroup_N%][-from_date=%CiFromDate%][-to_date=%CiToDate%]
 title %titleTxt%

 call cmdUti_DateTimeNowGet.cmd
 set Log1_DPNE=%Log_DP%\Group-%CiGroup_N%_1-CiReportList_%$DateTimeNowFileExt%.txt
 set Log2_DPNE=%Log_DP%\Group-%CiGroup_N%_2-CiDetails_%$DateTimeNowFileExt%.txt


 Echo ---------------------------------------------------------------------------
 Echo Start CI........................: %Date% %time:~0,5%
 Echo CI-Action Info..................: %CiActionTxt%
 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ---
 Echo CiGroup_N.......................: %CiGroup_N%
 Echo CiFromDate......................: %CiFromDate%
 Echo CiToDate........................: %CiToDate%
 Echo CI Is Activ.....................: %DoCheckInIsActiv%

 set toRun="%tcpb_auto_checkin_exe%"
 set toRun=%toRun% -u="refile_user1" -p="MyPW"
 set toRun=%toRun% -g=dba

 if /I "%DoCheckInIsActiv%" neq "YES" Call :ToRunAddParam "-dryrun"
 rem Call :ToRunAddParam "-all"
 rem Call :ToRunAddParam "-types="BOMView Revision,UGPART,UGMASTER""
REM  Call :ToRunAddParam "-types=''BOMView Revision''"
REM  Call :ToRunAddParam "-types=''UGPART,UGMASTER''"
 Call :ToRunAddParam "-cfg=''%CmdCurRoot_DP%\NX_tcpb_auto_checkin.ini''"
 Call :ToRunAddParam "-group=''%CiGroup_N%''"
 Call :ToRunAddParam "-from_date=%CiFromDate%"
 Call :ToRunAddParam "-to_date=%CiToDate%"
 Call :ToRunAddParam "-log=''%Log1_DPNE%''"

 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ---
 Echo see LOG1 tcpb_auto_checkin......: %Log1_DPNE%
 Echo see Log2 CMD output.............: %Log2_DPNE%
 Echo toRun...........................: %toRun%
 pause
 start "" Explorer "%Log_DP%"
 Call RunLogged.exe "%Log2_DPNE%" %toRun%
 Echo ---------------------------------------------------------------------------

goto :eof

:ToRunAddParam
  set $P1=%1
  set $P1=%$P1:"=%
  set $P1=%$P1:''="%
  Echo toRun add parameter.............: %$P1%
  set toRun=%toRun% %$P1%

goto :eof

