@Echo off

 rem ---------------------------------------------------------------------------
 rem JobManagerV3 Script to Purge TC Dataset's (c) addPLM
 rem
 rem Aenderungs Info:
 rem Date        User      Description:
 rem 12.08.2015  J.Fes     Ersterstellung
 rem 06.12.2023  J.Fes     use default Startup
 rem ---------------------------------------------------------------------------

@Echo off
 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2

 Call Echo "**************************************************************************"
 Call Echo "* PLMJobMgr Script for purge TC Dataset Versions                         *"
 Call Echo "* Based on Version: 06.12.2023 (c)addPLM GmbH                            *"
 Call Echo "**************************************************************************"

 REM -- define incudes
 set JobMgr_10-JobScriptsInc_01=_JobMgrDefaults
 set JobMgr_10-JobScriptsInc_02=_CustomDefaults\TcPrompt

 REM -- #Doc: 07.07.2016/J.Fes Use to process 'SO SiteObjects' as 'RO ReplicaObjects'
 rem if not defined JobMgr_NxPuUse_for_SO_RO set JobMgr_NxPuUse_for_SO_RO=YES

 REM -- #Doc: disable TC_SHARED_MEMORY_DIR
 set TC_SHARED_MEMORY_DIR_Disable=true

 REM -- #Doc: Inits all Basics of Job
 rem Call "%~dp0_JobInitial.cmd" "TCPurgeDatasets" "YES" "YES" "YES" "NO" "NO"
 Call "%~dp0_JobInitial.cmd" "Job:[#JobName#][#TcSiteId#][%Date% %time:~0,5%][\\%ComputerName%]" "YES" "YES" "YES" "NO" "NO"

 REM -- set TC Prompt for Custom
 set TCPrompt_Custom_Opt=TCOnly

REM  set titleTxt=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
REM  title %titleTxt%

 if exist "%TCPrompt_Custom_DPNE%" Call "%TCPrompt_Custom_DPNE%"
 set tcpbRoot_S_DP=%JobScriptTemplateMinus1_DP%\tcpbbin
 rem Dir "%tcpbRoot_S_DP%\*.*"

 if "%JobMgr_TCPromptGet_ResCode%" equ "0" Call "%CmdCurRoot_DP%\TCPurgeDatasets_2Execute.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"

 REM -- #Doc: ends the Job
 Call "%~dp0_JobFinish.cmd"


