@Echo off
 REM ===========================================================================
 REM JobMgr Script for Customer (c)addPLM 2006..2017
 REM Date/Time  Name   Details:
 REM 22.08.2017 J.Fes  date of template version
 REM 17.05.2019 S.Gueth updated for TCPBDataImport
 REM ===========================================================================

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=dba

 Call Echo "**************************************************************************"
 Call Echo "* Excuting Script for PLMJobManager                                      *"
 Call Echo "* Based on template Version: 01.10.2024 (c)addPLM GmbH                   *"
 Call Echo "**************************************************************************"

 REM -- define incudes #New: 05.07.2016/J.Fes
 set JobMgr_10-JobScriptsInc_01=_JobMgrDefaults
 set JobMgr_10-JobScriptsInc_02=_CustomDefaults\TcPrompt

 REM -- #Doc: Inits all Basics of Job
 Call "%~dp0_JobInitial.cmd" "TCPBDataImport" "YES" "NO" "YES" "YES"

 rem -- TC Prompt for Custom
 rem set TCPrompt_Custom_Opt=NX110

 set titleTxt=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%
 set TCPrompt_Custom_Opt=TCPromptOnly
 if exist "%TCPrompt_Custom_DPNE%" Call "%TCPrompt_Custom_DPNE%"
 set tcpbRoot_S_DP=%JobScriptTemplateMinus1_DP%\tcpbbin
 set Path=%tcpbRoot_S_DP%;%path%
 if "%JobMgr_TCPromptGet_ResCode%" equ "0" Call "%CmdCurRoot_DP%\TCPBDataImport_ExecuteProcess.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "%JobMgr_TcGroup%"

goto :End

REM ============================================================================
:End
 REM -- #Doc: ends the Job and cleans JobDir
 Timeout /T 5
 Call "%~dp0_JobFinish.cmd"

