@Echo off
 REM ===========================================================================
 REM JobMgr Script for Customer (c)addPLM 2006..2019
 REM Date/Time  Name   Details:
 REM 22.08.2017 J.Fes  date of template version
 REM 11.12. S.Gueth updated for TCNamedRefFilesExtractToFileSystem
 REM ===========================================================================

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2

 Call Echo "**************************************************************************"
 Call Echo "* Excuting Script for PLMJobManager                                      *"
 Call Echo "* Based on template Version: 08.02.2017 (c)addPLM GmbH                   *"
 Call Echo "**************************************************************************"

 REM -- define incudes #New: 05.07.2016/J.Fes
 set JobMgr_10-JobScriptsInc_01=_JobMgrDefaults
 set JobMgr_10-JobScriptsInc_02=_CustomDefaults\TcPrompt

 rem -- #Doc: 07.07.2016/J.Fes Use to refile 'SO SiteObjects' as 'RO ReplicaObjects'
 rem if not defined JobMgr_RfUse_for_SO_RO set JobMgr_RfUse_for_SO_RO=YES

 REM -- #Doc: Inits all Basics of Job
 Call "%~dp0_JobInitial.cmd" "TCNamedRefFilesExtractToFileSystem" "YES" "NO" "YES" "YES"

 rem -- TC Prompt for Custom
 rem set TCPrompt_Custom_Opt=NX110

 set titleTxt=Job:[%JobName%][%TcSiteId%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleTxt%

 rem 11.12.2020 S.Gueth: TCPrompt not needed for this Job
 rem if exist "%TCPrompt_Custom_DPNE%" Call "%TCPrompt_Custom_DPNE%"
 rem if "%JobMgr_TCPromptGet_ResCode%" equ "0" Call "%CmdCurRoot_DP%\TCNamedRefFilesExtractToFileSystem_ExecuteProcess.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"

 Call "%CmdCurRoot_DP%\TCNamedRefFilesExtractToFileSystem_ExecuteProcess.cmd" "%JobMgr_TcUser%" "%JobMgr_TcPW%" "dba"

 if /i "%JobMgr_Test%" neq "ON" goto :JumbOver
  Banner Test:End
  Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
  Call Echo "#TestMode.......................: End of Test"
  Call Echo "JobName.........................: %JobName%"
  pause
:JumbOver

  rem #New: 14/11/2014/J.Fes
  Call Echo "----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----"
  Call Echo "CleanUp.........................: %CmdCurRoot_DP%\startup\.."
  rd /S /Q "%CmdCurRoot_DP%\startup"
  Call Echo "CleanUp.........................: %CmdCurRoot_DP%\Resources\.."
  rd /S /Q "%CmdCurRoot_DP%\Resources"
  del /S /Q "%CmdCurRoot_DP%\*.fscproxylog"
  del /S /Q "%CmdCurRoot_DP%\*.prt"

  rem #New:24/11/2014 J.Fes preventing sending big logfies to JobServer
  call robocopy "%CmdCurRoot_DP%" "%CmdCurRoot_DP%\..\_JobLogNotSendToJobServer\%JobName%" "*.*log*" /Move /S /MIN:3072000 /R:1 /W:1
  rem #New:7/21/2017 J.Fes Cleanup dir JobLogNotSendToJobServer
  call "%BinPublic_DP%\delage32.exe" "%CmdCurRoot_DP%\..\_JobLogNotSendToJobServer\*.*" 2 /modified /recurse /rd /includeRHS
goto :end

REM ============================================================================
:end
 cd /d "%tempOrig_DP%"
 Call Echo "--------------------------------------------------------------------------"
 Call Echo "Info: all files in...............: %temp%"
 Call Echo "Info: will be zipt by JobClient..: and send to JobServer"
 EXIT /B 0


