@echo off

rem -------------------------------------------------------------------------
rem ******************* Wichtige Steuerparameter ****************************
rem PingToHost: P1  Adresse auf der Gegenseite die mit Ping gerufen wird
rem PLMPerf_PingCustom_DP: Ordner in dem die Protokolldateien erstellt werden
rem RedoInterval_TimeSec:  Wartezeit bis zur nchsten Messreihe
rem time_limit: maximal tolerierte Zeit aus dem Mittelwert von 10 Ping
rem lost_limit: maximal tolerierte Anzahl verlorener Pakete
rem address1/2: Adressen fr net send wenn eines der Limits berschritten wird
rem -------------------------------------------------------------------------
set PingToHost=TCDB_CustomServerName
if "%~1" neq "" set PingToHost=%~1

set PLMPerf_PingCustom_DP=%PLMPerf_Root_DP%\90-Data\PingStatistic
if "%~2" neq "" set PLMPerf_PingCustom_DP=%~2

rem --- Rootpfade setzen NEW 02.07.2013 19:48 J.Fes
set CmdCurRoot_DP=%~dp0
set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%
set CmdCur_DPNE=%0
set path=%CmdCurRoot_DP%;%Path%


if not exist "%PLMPerf_PingCustom_DP%" md "%PLMPerf_PingCustom_DP%"
set PingMessTxt_DPNE=%temp%\PingMess_%PingToHost%_%Random%.txt
Echo PingMessTxt_DPNE:%PingMessTxt_DPNE%
REM Wartezeit, 50 fr 10 x Ping, 40 fr 20 x Ping 21.08.2012 13:19 / J.Fes von 40 auf 60 gesetzt
set RedoIntervalDefault_TimeSec=120
set RedoInterval_TimeSec=%RedoIntervalDefault_TimeSec%
set time_limit=50
set lost_limit=2




:start

 rem set PingStatistikFile_NE=ping_statistik_From#%ComputerName%-To#%PingToHost%_At#%DATE_JAHR%%DATE_MONAT%%DATE_TAG%.txt
 call "%CmdCurRoot_DP%\GETUTCDateTime.cmd"
 set PingStatistikFile_NE=ping_statistik_From#%ComputerName%-To#%PingToHost%_At#%Year%%Month%%Day%.txt
 set PingStatistikFile_DPNE=%PLMPerf_PingCustom_DP%\%PingStatistikFile_NE%

 if not exist "%PingStatistikFile_DPNE%" (
  echo ***** Ping-Statistik: from:[%ComputerName%] to:[%PingToHost%]****** >>"%PingStatistikFile_DPNE%"
  rem Spaltenueberschriften eintragen
  echo Datum;Uhrzeit;Sender;Empfnger;gesendet;empfangen;verloren;Minimum;Maximum;Mittelwert>>"%PingStatistikFile_DPNE%"
 )

:PingStatisticRun

 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 rem from:[%ComputerName%]to:[%PingToHost%]
 set TitleTxt=PingStatistic Redo:[%RedoInterval_TimeSec%] %PingStatistikFile_NE%
 title %TitleTxt%
 Echo --------------------------------------------------------------------------
 Echo Runing................................: %TitleTxt%
 Echo From Host.............................: %ComputerName% -^> to Host: %PingToHost%
 Echo File Dir..............................: %PLMPerf_PingCustom_DP%
 Echo File Name.............................: %PingStatistikFile_NE%

 call :send_ping
 call :Wait "%RedoInterval_TimeSec%"
goto :PingStatisticRun

goto :eof


rem ----------------------------------------------------------------------------
:send_ping
  call :ColorSet IsExecuting

  if exist "%PingMessTxt_DPNE%" del "%PingMessTxt_DPNE%"
  PING %PingToHost% -n 20 -l 32 >> "%PingMessTxt_DPNE%"

  FOR /F "skip=15 tokens=1-15" %%i IN (%PingMessTxt_DPNE%) DO if /i "%%i"=="Packets:" call :pakete %%l %%o %%r
  FOR /F "skip=15 tokens=1-15" %%i IN (%PingMessTxt_DPNE%) DO if /i "%%i"=="Minimum" call :zeiten %%k %%n %%q

  if exist "%PingMessTxt_DPNE%" del "%PingMessTxt_DPNE%"

  call "%CmdCurRoot_DP%\GETUTCDateTime.cmd"
  set date_kurz=%Day%.%Month%.%Year%
  set time_zeit=%Hour%:%Minute%:%Second%

  rem Eintrag in Protokolldatei
  ECHO %date_kurz%;%time_zeit%;%computername%;%PingToHost%;%tab1%;%tab2%; >> %PingStatistikFile_DPNE%

  rem Ausgabe Uhrzeit, verlorene Pakete, Maximum, Mittelwert, Balkenanzeige
  set peak=#
  FOR /L %%i IN (2,1,%p_med%) DO call :balken
  set wert=%p_med%     $
  echo Result...: %time_zeit%  Loss:%p_los% Maximum:%p_max%   Average:%wert:~0,6%  %peak%

  call :ColorSet IsIdel
  rem Unterbrechung bei 23 Uhr
  rem if /i "%Hour%" == "23" goto :gutenacht

  rem call %CmdCurRoot_DP%\GETTIME.CMD
  call "%CmdCurRoot_DP%\GETUTCDateTime.cmd"
  set time_sekunden=%Second%
  set /a RedoInterval_TimeSec=%RedoIntervalDefault_TimeSec%-%time_sekunden%
goto :eof



rem ----------------------------------------------------------------------------
:gutenacht
 rem Aussetzen der Messungen von 23 Uhr bis 0 Uhr, also 1 Stunde
 echo.
 echo. Ping-Statistik im Schlafmodus bis 0 Uhr...
  call :Wait "60*60"
 rem zuerst neue Protokolldatei anfangen
goto :start

 rem ----------------------------------------------------------------------------
:Wait
 setlocal
  set /a WaitTime=%~1
  Echo wait now %WaitTime% [sec] %Date% %time:~0,5%
  ping localhost -n %WaitTime%>nul 2>nul
 endlocal
goto :eof

rem ----------------------------------------------------------------------------
:pakete
 set p_sen=%1
 set p_rec=%2
 set p_los=%3
 set tab1=%p_sen%;%p_rec%;%p_los%
goto :eof

rem ----------------------------------------------------------------------------
:zeiten
 set input=%1
 call :ms_weg
 set p_min=%output%
 set input=%2
 call :ms_weg
 set p_max=%output%
 set input=%3
 call :ms_weg
 set p_med=%output%
 set tab2=%p_min%;%p_max%;%p_med%
goto :eof

rem ----------------------------------------------------------------------------
:ms_weg
 if /i "%input:~1,2%" == "ms" set output=%input:~0,1%
 if /i "%input:~2,2%" == "ms" set output=%input:~0,2%
 if /i "%input:~3,2%" == "ms" set output=%input:~0,3%
 if /i "%input:~4,2%" == "ms" set output=%input:~0,4%
goto :eof


rem ----------------------------------------------------------------------------
:balken
 set peak=%peak%#
goto :eof

rem ============================================================================
:ColorSet
 rem -- Farben nach Status setzen
 rem Gelb Schwarz
 if /I "%1"=="IsExecuting" set JobColorLast=E0
 rem Blaugrn Schwarz
 if /I "%1"=="IsIdel"      set JobColorLast=30
 rem Hellgrau Schwarz
 if /I "%1"=="End"         set JobColorLast=70
 if /I "%1"=="Ende"        set JobColorLast=70
 rem Gruen Schwarz
 if /I "%1"=="Ok"          set JobColorLast=A0
 rem Rot Schwarz
 if /I "%1"=="Err"         set JobColorLast=C0

 rem jetzt die Farbe setzen
 if not "%JobColorLast%"=="" color %JobColorLast%
 goto :eof

